/* 
 * rb.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include <stdio.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sgtty.h>
#include <signal.h>

struct sgttyb buf, nbuf;
int uaio;

static int child;
null()
{
}

done()
{
  stty(uaio, &buf);
  kill(child, SIGKILL);
  while (wait(0) != child) ;
  exit(0);
}

brek()
{
  int i;
  ioctl(uaio, TIOCSBRK, NULL);
  for (i = 0; i < 8000; i++) ;
  ioctl(uaio, TIOCCBRK, NULL);
}

char buffer[BUFSIZ];

doit(in, out)
int in, out;
{
  int nBytes;
  while ((nBytes = read(in, buffer, BUFSIZ)) > 0) {
    if (write(out, buffer, nBytes) < 0) break;
  }
}

main()
{
  int nread, last, last2, i;
  char buffer[1024], *c;
  uaio = open("/dev/ttya", O_RDWR);
  gtty(uaio, &buf);
  nbuf = buf;
  nbuf.sg_flags |= RAW|ANYP;
  nbuf.sg_flags &= ~ECHO;
  stty(uaio, &nbuf);
  child = fork();
  if (child < 0) {
    perror("Runec: fork");
    exit(1);
  }
  if (child > 0) {
    signal(2, done);
    signal(3, brek);
    while (fgets(buffer, 1024, stdin) != NULL) {
      if (!strcmp(buffer, "break\n")) {
	brek();
      } else if (!strcmp(buffer, "quit\n")) {
	done();
      } else {
	write(uaio, buffer, strlen(buffer)-1);
	write(uaio, "\r", 1);
      }
    }
    kill(child, SIGKILL);
    while (wait(0) != child) ;
  } else{
    signal(2, null);
    signal(3, null);
    do {
      nread = read(uaio, buffer, 1024);
      buffer[nread] = '\0';
      for (c = buffer; *c; c++) {
	if (*c != '\r') putchar(*c);
      }
      fflush(stdout);
    } while (1);
    exit(1);
  }
}
