
/*  C O P Y R I G H T   N O T I C E :                                     */
/* Copyright 1986 Eric Jul and Norm Hutchinson.	 May not be used for any  */
/* purpose without written permission from the authors.			  */

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <a.out.h>

main(argc, argv)
int argc;
char **argv;
{
  char *filename = argv[1];
  int inf, nsyms;
  struct exec header;
  struct nlist *syms, *p;
  inf = open(filename, O_RDWR, 0);
  if (inf == NULL) panic("Can't open file");
  if (read(inf, &header, sizeof(header)) != sizeof(header)) 
    panic("Can't read file");
#define CHECK(S) if (!(S)) panic("S");
  CHECK(header.a_text != 0);
/*  CHECK(header.a_data == 0); */
  CHECK(header.a_drsize == 0);
  CHECK(header.a_trsize == 0);
  header.a_data += header.a_text;
  header.a_drsize += header.a_trsize;
  header.a_text = 0;
  header.a_trsize = 0;
  if (lseek(inf, 0L, 0) < 0) panic("Can't seek");
  if (write(inf, &header, sizeof(header)) != sizeof(header)) panic("Can't write");
  if (lseek(inf, N_SYMOFF(header), 0) < 0) panic("Can't seek to symbols");
  syms = (struct nlist *) malloc(header.a_syms);
  nsyms = header.a_syms / sizeof(struct nlist);
  if (read(inf, syms, header.a_syms) != header.a_syms) panic("Can't read syms");
  for (p = syms; p < syms+nsyms; p++) {
    if ((p->n_type & N_TYPE) == N_TEXT) {
      p->n_type = N_DATA;
      if (p->n_value >= 0x4000) p->n_value -= 0x4000;
    } else if (p->n_type & N_EXT) {
      p->n_type &= (~N_EXT);
    }
  }
  if (lseek(inf, N_SYMOFF(header), 0) < 0) panic("Can't seek to symbols");
  if (write(inf, syms, header.a_syms) != header.a_syms) panic("Can't write syms");  
  close(inf);
  exit (0);
}

panic(s)
char *s;
{
  fprintf(stderr, "%s\n", s);
  exit(1);
}
