/* 
 * ethernet.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */


#ifndef ethernet_h
#define ethernet_h

#define ENET_MIN_DATA	46
#define ENET_MAX_DATA	1500

/* Address types */
typedef struct {
    unsigned short	high;
    unsigned short	mid;
    unsigned short	low;
} ETHhost, ethAd_t;

/* Header definitions */

#define ETHHOSTLEN sizeof(ETHhost)

# define ETH_SETPROMISCUOUS	(ETH_CTL*MAXOPS + 0)

#define ETH_AD_SZ		sizeof(ETHhost)

#define ETH_ADS_EQUAL(A,B)	((A).high==(B).high\
					&&(A).mid==(B).mid\
					&&(A).low==(B).low)

#define ZERO_ETH_AD(ad)		{ad.high=ad.mid=ad.low=0;}

#define	BCAST_ETH_AD		{0xffff,0xffff,0xffff};

/*
 * Ethernet "types"
 *
 * Ether-speak for protocol numbers is "types."
 * Unfortunately, ether "types" are unsigned shorts,
 * while xkernel PROTLs are ints.
 */

typedef unsigned short				ETHtype, ethType_t;

/*
 * Ethernet packet headers
 */
typedef struct {
	ETHhost			destEthAd;
	ETHhost			srcEthAd;
	ethType_t		ethType;	/* higher level protocol */
} ethHdr_t;


typedef struct {
  ETHtype		type;
  ETHhost		host;
} ETHaddr;

/*
 * range of legal data sizes
 */

#define MIN_ETH_DATA_SZ		64
#define	MAX_ETH_DATA_SZ		1500

typedef struct {
	ethHdr_t	ethPktHdr;
	unsigned char	ethPktData[MAX_ETH_DATA_SZ];
} ethPkt_t;

#define MAX_ETH_PKT_SZ		sizeof( ethPkt_t )

#endif ethernet_h
