/* 
 * ms_trap.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "process.h"
#include "memory.h"

Ms_CallUserRoutine(as, r, nargs, argsize, putargs, doneargs, a, b, c, d)
Aspace *as;
Pfi r, putargs, doneargs;
int nargs, argsize;
int a, b, c, d;
{
  int AfterCallUser();
  int totalsize, res;
  register char *endofstack, *startofstack, *usp = (char *)Ms_FetchUSP();
  Aspace *saveaspace;
  int x = Ms_Spl7();

  /* Figure arg size */
  TRACE3(user, 2, "Call user %x, %d args (%d bytes)", r, nargs, argsize);
  totalsize = argsize + nargs * sizeof(char *) + sizeof(char *);
  if (totalsize > (4 * PAGE_SIZE) - 1024) {
    printf("Total arg size = %d\n", totalsize);
    printf("CallUser: Maximum arg size (%d) exceeded\n", 
      4 * PAGE_SIZE - 1024);
    Kabort("DIE");
  }
  /* Extend the stack */
  if (totalsize >= ((int)usp & (PAGE_SIZE - 1))) {
    if (!ExtendStack((long)(usp - totalsize), 0)) {
      TRACE1(user, 1, "Cannot extend the stack to %x", usp - totalsize);
      return -1;
    }
  }
  startofstack = usp;
  endofstack = usp -= totalsize;
  TRACE2(user, 2, "Stack start = %x, end = %x", startofstack, endofstack);
  TRACE1(user, 2, "Usp set to = %x", usp);
  TRACE1(user, 2, "Isp is %x", FetchSP());
  TRACE2(user, 2, "Return addr %x set to %x", endofstack, AfterCallUser);
  *((int *)endofstack)++ = (int) AfterCallUser;

  TRACE1(user, 2, "Setting aspace to %x", as);
  saveaspace = Active->aspace;
  Ms_SetAddressableAspace(as);
  Active->aspace = as;

  /* Call back to set the arguments */
  (*putargs)(endofstack, endofstack + nargs * sizeof(char *), a, b, c, d);
  TRACE1(user, 2, "Setting usp to = %x", usp);
  SetUSP((long)usp);
  Active->ps.regs.r.usp = (Unspec) usp;
  /*
   * Do the call
   */
  res = startUserAt(r);
  /*
   * Clean up afterwards.
   */
  if (doneargs) {
    (*doneargs)(endofstack, endofstack + nargs * sizeof(char *), a, b, c, d);
  }

  /* reset the user stack pointer.  Pop the arguments */
  SetUSP((long)startofstack);
  Active->ps.regs.r.usp = (Unspec) startofstack;

  Active->aspace = saveaspace;
  Ms_SetAddressableAspace(Active->aspace);
  Ms_Splx(x);
  return res;
}

