/* 
 * ms_misc.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "process.h"
#include "memory.h"

#ifdef __STDC__
static inline void UpdateProcessRegs(p)
Process *p;
{
  asm("moveml	#0xffff, %0" : : "m" (p->ps.regs.r.d0));
  p->ps.regs.r.usp = (Unspec) Ms_FetchUSP();
}
#endif

vbreakpoint()		/* called only when debugging kernel */
{
  UpdateProcessRegs(Active);
  PrintProcessRegs(Active);
  breakpoint();
}

#if EV_ONCE != 0x1
Change the reference to EV_ONCE in ms_process_s.S
#endif

/*
#if Process_ps_regs_r_d0 != 0x18 || Process_ps_regs_r_usp !=0x58
fix the offsets in ../lib/xkernel.il
#endif
*/

#define MAXFRAMES 30

StackDump(fFp)
unsigned *fFp;
{
  /* currentFp must be first, to catch the fp */
  unsigned *currentFp;
  unsigned *returnPc;
  unsigned *stackTop, stackStart, stackSize;
  int i, nparams, thisFrame = 0;
  unsigned *currentPc = 0;

  if (fFp) {
    currentFp = fFp;
  } else {
    currentFp = (unsigned *) &currentFp + 1;
  }
  stackStart = ((int) currentFp) + 0x4000;
  stackSize = 0x5000;
  stackTop = (unsigned *) (stackStart - stackSize);
  printf("\r\nStackDump:\r\n");
  while (currentFp != 0 && ++thisFrame <= MAXFRAMES) {
    if ( (currentFp < stackTop) || (currentFp > (unsigned *) stackStart)) {
      printf("Invalid frame pointer (%x).\r\n", currentFp);
      return;
    }
    returnPc = (unsigned *) (*(currentFp + 1));
    printf("    %x (", currentPc);
    nparams = GetNumberOfParams((unsigned short *)returnPc);
    for (i = 0; i < nparams; i++) {
      printf("%x", *(currentFp + 2 + i));
      if (i < (nparams - 1)) {
	printf(", ");
      }
    }
    printf(")\n");
    if ( (unsigned *) *currentFp < currentFp ) {
      printf("Stack trash beyond this point (%x)\r\n", *currentFp);
      return;
    }
    currentFp = (unsigned *) (*currentFp);
    currentPc = returnPc;
  }
}

#define ADDQL4		0x588f	/* instruction to add 4 to stack pointer */
#define ADDQL8		0x508f	/* instruction to add 8 to stack pointer */
#define ADDQW4		0x584f
#define ADDQW8		0x504f
#define ADDL		0xdffc 	/* instruction to add contents of next long to
				    stack pointer */
#define ADDW		0xdefc 	/* instruction to add contents of next word to
				    stack pointer */
#define LEA		0x4fef	/* a faster version of ADDW */

#define MAX_NUM_ARGS 10

int GetNumberOfParams( returnpc )
unsigned short *returnpc;
{
  /* Return the number of parameters in the call to abort, and the address
   * of the first (topmost, lowest addressed) parameter.
   */
  unsigned short instruction;
  unsigned short *addr;
  int count;
  int nparams;

  instruction = *returnpc;

  /* The instruction at the return address tells (at least in our compiler's
   * calling convention) how much to add to the stack pointer upon return
   * from the call.  If we divide that number by the size of each stack
   * entry, we get the number of parameters.  This same trick is used in
   * the debugger's stackdump.
   */

  addr = returnpc + 1;
  switch( instruction )
    {
      case ADDQL4:
      case ADDQW4:
	  return( 1 );
      case ADDQL8:  
      case ADDQW8:
	  return( 2 );
      case LEA    :
      case ADDW   :  
	  count = (int) *addr;
	  break;
      case ADDL   :  
	  count = (int) *((unsigned *)addr);
	  break;
      default     :  
	  return( 0 );
    }
  nparams = count / 4;
  return (nparams > MAX_NUM_ARGS ? 0 : nparams);
}
