h40101
s 00471/00000/00000
d D 1.1 91/01/10 11:11:21 llp 1 0
c date and time created 91/01/10 11:11:21 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * ms_exception.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */


#include "ms_exception.h"
#include "system.h"
#include "process.h"
#include "memory.h"

/* Imports */
extern int asmEKTrap(), asmEUTrap();

/* Forward declarations */
extern short *KPrintException();
static short ExceptionType;

dummy()
{
  printf("Dummy exception handler\n");
}
extern Asm_dummy();

/*********************************************************
* Machine specific (Ms_) routines; called from init.c
*********************************************************/

Ms_InitExceptions()
{
  extern callException(), BusError();

#ifdef USEDUMMY
  int i;
  for (i = 0; i < 1024; i+=4) {
    setexvec(Asm_dummy, i);
  }
#endif

/* Most exception vectors go to the same place because the 68010
 *  puts the vector number on the stack for us.  We use a different
 *  routine to handle address (?) and bus errors so we can save the
 *  longer exception stack frames these generate.  */

  setexvec(BusError,BUSERROR);
  setexvec(BusError,ADDRERROR);
#ifdef NOTUSINGKDBX
  setexvec(callException,ILLINST);
#endif
  setexvec(callException,ZERODIV);
  setexvec(callException,CHKINST);
  setexvec(callException,TRAPVINST);
  setexvec(callException,PRIVVIOL);
  setexvec(callException,TRACETRAP);
  setexvec(callException,EMU1010);
  setexvec(callException,EMU1111);
  setexvec(callException,FORMATERR);
  setexvec(callException,UNINITINT);
  setexvec(callException,SPURINT);
  setexvec(callException,INT1);
  setexvec(callException,INT2);
  setexvec(callException,INT3);

  setexvec(callException,TRAP0);
/* TRAP1 is used for breakpoints on some PROM monitor versions */
  setexvec(callException,TRAP2);
  setexvec(callException,TRAP3);
  setexvec(callException,TRAP4);
  setexvec(callException,TRAP5);
  setexvec(callException,TRAP6);
  setexvec(callException,TRAP7);
  setexvec(callException,TRAP8);
  setexvec(callException,TRAP9);
  setexvec(callException,TRAP10);
  setexvec(callException,TRAP11);
  setexvec(callException,TRAP12);
  setexvec(callException,TRAP13);
/* TRAP14 is the Sun return-to-monitor trap */
  setexvec(callException,TRAP15);  /* Sun-1.5/2 workstations have no EMTs */

/* Initialize the kernel entry traps. */

  setexvec(asmEUTrap,TRAP0);
  setexvec(asmEKTrap,TRAP1);
}

/*********************************************************
* Internal routines: handle various exceptions
*********************************************************/

extern AfterCallUser();

Pfi OKReturnAddresses[] = {
  AfterCallUser,
  DestroyProcess,
  0
};

/*ARGSUSED*/
HandleBusError(
#ifdef SAVEEMALL
d0, d1, d2, d3, d4, d5, d6, d7, a0, a1, a2, a3, a4, a5, a6, a7,
#else
d0, d1, a0, a1,
#endif
frame)
ExceptionStackFrame frame;
/*
 * If it wants to return to the excepting process, it returns 1.  This
 * routine is only going to work on 68020's.
 */
{
  register int *i, faultaddr = frame.x20.frame.f3.faultaddr;
  BusErrorRegister cause;

  cause.u = GetBusErrorReg();
  if (!(frame.x20.sr & SUPERVISOR_STATE) && cause.f.protection) {
    /* User mode error, maybe return to the kernel */
    for (i = (int *)OKReturnAddresses; *i; i++) {
      if (faultaddr == ROUNDDOWN(*i, 4)) {
	/* OK user error, try to continue as the kernel */
	TRACE1(user, 5, "Return to the kernel at %x", *i);
	frame.x20.sr |= 0x2000;
	return(TRUE);
      }
    }
  }
  if (cause.f.invalid) {
    if (ExtendStack((long)faultaddr, (int)(frame.x20.sr & SUPERVISOR_STATE)))
      return(TRUE);
  }
  return(FALSE);
}

ExtendStack(addr, kernelP)
register long addr;
int kernelP;
{
  register Process *active = Active;
  long sl, sb;
  register unsigned long va;
  PageMapEntry pte;

  TRACE2(buserror, 5, "Extending stack to %X for %s", addr,
    kernelP ? "kernel" : "user");
  if (kernelP) {
    sl = active->ps.stackBase.u - MAXKERNELSTACK;
    sb = active->ps.stackBase.u;
  } else {
    sb = active->ps.stackBase.u - MAXKERNELSTACK - PAGE_SIZE;
    sl = active->ps.stackLimit.u + PAGE_SIZE;
  }
  if (!BETWEEN(sl, addr, sb)) {
    if (BETWEEN(sl - PAGE_SIZE, addr, sl)) {
      TRACE1(buserror, 1, "Process %x out of stack (probably)", active->pid);
    } else {
      TRACE2(buserror, 1, "Process %x bad access to %x", active->pid, addr);
    }
    return(FALSE);
  }
#ifdef undef
  pte.u = GetPageMap(addr);
  if (pte.f.valid && (kernelP || (pte.f.protection & SUPER_ONLY) == 0)) {
    /* the stack is already extended */
    TRACE2(buserror, 3, "Process %x stack already extends to %x", active->pid,
      addr);
    return(TRUE);
  }
#endif
  /* Extend the stack to the page including this access */
  TRACE2(buserror, 1, "Extending the stack of process %x down to %x",
    active->pid, downtopage(addr));
  for (va = downtopage(addr); va < sb; va += PAGE_SIZE) {
    pte.u = GetPageMap(va);
    TRACE2(buserror, 3, "Checking page at %X, pte = %X", va, pte.u);
    if (!pte.f.valid) {
      TRACE1(buserror, 3, "Allocating stack page at %x", va);
      if (AllocatePage((unsigned)va, kernelP)) {
	TRACE0(buserror, 1, "Allocate page failed");
	return(FALSE);
      }
    }
  }
  return(TRUE);
}

HandleException( active, frame )
register Process *active;
ExceptionStackFrame frame;
/*
 * Kernel exception handler.
 *
 * This function sees the exception information automatically pushed
 * on the stack by the processor as its arguments.
 */
{
  ExceptionInfo REQ, *req = &REQ;
  static int DYING = 0;
  ExceptionType = frame.x20.format.vector;

  req->type = ExceptionType;
  if( ExceptionType == ADDRERROR || ExceptionType == BUSERROR ) {
    req->code = frame.x20.frame.f3.sw.word;
    req->accaddr = frame.x20.frame.f3.faultaddr;
    /* Figuring out which instruction caused the fault is much too
     * crazy in the pipelined world of the 68020. For now just
     * return a zero.
     */
    req->instruction = 0;
    req->status = frame.x20.sr;
    req->errpc = frame.x20.pc;
  } else {
    req->status = frame.x20.sr;
    req->errpc = frame.x20.pc;
    req->code = req->accaddr = req->instruction = 0;
  }
  /* Diagnose cause of bus error -- see memory.c */
  if (ExceptionType == BUSERROR) req->buserrortype = DiagnoseBusError(req->accaddr);
  if( (frame.x20.sr & SUPERVISOR_STATE) && (ExceptionType != TRACETRAP) ) {
    /* Fatal kernel error */
    if (DYING) breakpoint();
    KPrintException( active, req );
    DYING = 1;
    CheckOutMemory();
    Kabort( "Exception in kernel" );
  } else {
    /* Fatal user error */
    KPrintException( active, req );
    StackDump((unsigned *)active->ps.regs.r.a6);
    printf("User process terminated\n");
    Kabort("Temporary abort on user error");
    DestroyProcess();
  }
}

int DiagnoseBusError(accaddr)
unsigned long accaddr;
/*
 * Diagnose the cause of a bus error.
 */
{
  BusErrorRegister cause;

  if (accaddr >= CONTEXT_SIZE) {
    /* Garbage address -- these processors have
     * only 28 bit addressing */
    return (OUT_OF_RANGE);
  }

  cause.u = GetBusErrorReg();

  if (cause.f.invalid) return (PAGE_INVALID);
  if (cause.f.protection) return (PROTECTION);
  if (cause.f.timeout) return (BUS_TIMEOUT);
  if (cause.f.VMEbus) return (VMEBERR);
  if (cause.f.FPAbus) return (FPABERR);
  if (cause.f.FPAenable) return (FPAENERR);
  if (cause.f.watchdog) return (WATCHDOG);

  printf("Unknown bus error. Register = %x\n", cause.u);
  breakpoint();
  /*NOTREACHED*/
}

#define MaxLookAhead 10
#define ABORT_INSTR	0x4afc
#define BKPT_INSTR	0x484f

short *KPrintException( pd, req )
register Process *pd;
ExceptionInfo *req;
/* Kernel exception handling routine.  Prints out some information
 * about the process incurring the exception and returns the pc at
 * which the exception occurred.
 */
{
  register short *i;

  /* Print information about the state of the process */
  printf("\r\n");

  i = (short *) req->errpc;

  switch( req->type ) {
    case ZERODIV:
      printf("Divide by zero" );
      break;

    case CHKINST:
      printf("Check instruction" );
      break;

    case TRAPVINST:
      printf("Overflow" );
      break;

    case TRACETRAP:
      printf("Trace bit on" );
      break;

    case PRIVVIOL:
      printf("Privileged instruction" );
      req->instruction = *i;
      break;

    case ILLINST:
    case EMU1010:
    case EMU1111:
      /* Load instruction */
      req->instruction = *i;

      if( req->instruction == ABORT_INSTR )
	printf("Abort instruction" );
      else if ( req->instruction == BKPT_INSTR )
	printf("Illegal instruction--Breakpoint?" );
      else
	printf("Illegal instruction" );
      break;

    case ADDRERROR:
    case BUSERROR:
      /* Check if error was on instruction fetch */
      if (!InstructionFetch(req->code)) {
	i = (short *) req->errpc;
      }
      if( req->type == BUSERROR ) {
	switch (req->buserrortype) {
	  case OUT_OF_RANGE:
	    printf( "Address out of range");
	    break;
	  case SPURIOUS:
	    printf( "Spurious bus error");
	    break;
	  case SYSTEM_SPACE:
	    printf("Access to system space");
	    break;
	  case PROTECTION:
	    printf("Memory protection violation");
	    break;
	  case PAGE_INVALID:
	    printf("Access to invalid page");
	    break;
	  case SEG_INVALID:
	    printf("Access to invalid segment");
	    break;
	  case MB_TIMEOUT:
	    printf("Multibus access timeout");
	    break;
	  case PARITY:
	    printf("Memory parity error");
	    break;
	  case BUS_TIMEOUT:
	    printf("System bus timeout ");
	    break;
	  case VMEBERR:
	    printf("VME bus error");
	    break;
	  case FPABERR:
	    printf("FPA bus error");
	    break;
	  case FPAENERR:
	    printf("FPA enable error");
	    break;
	  case WATCHDOG:
	    printf("Watchdog or user reset");
	    break;
	  default:
	    printf("unknown bus error (%d)", req->buserrortype);
	    break;
	}
      } else {
	printf("Odd address access" );
      }

      if (InstructionFetch(req->code)) {
	printf( " on instruction fetch from");
	req->instruction = 0;
      } else {
	if (ReadAccess(req->code))
	  printf(" on read from");
	else
	  printf(" on write to");
      }

      printf( " address %x", req->accaddr );
      break;

    case TRAP0:
    case TRAP1:	case TRAP2:	case TRAP3:
    case TRAP4:	case TRAP5:	case TRAP6:
    case TRAP7:	case TRAP8:	case TRAP9:
    case TRAP10:	case TRAP11:	case TRAP12:
    case TRAP13:	case TRAP14:	case TRAP15:
      printf("Unexpected trap #%d", (req->type - TRAP0)/sizeof(long) );
      break;

    case SPURINT:
      printf("Spurious interrupt");
      break;

    case INT1:	case INT2:	case INT3:
    case INT4:	case INT5:	case INT6:
    case INT7:
      printf("Unexpected level %d interrupt",
	( req->type - ( INT1 + sizeof(long) ) / sizeof(long) ) );
      break;

    case FORMATERR:
      printf("Format error");
      break;
    case SUSPENDED:
      printf("Forced exception");
      break;

    default:
      printf("Unknown exception %x", req->type);
      break;
  }

  printf( " in process %x [ 0x%x ]\r\n",pd->pid, pd );
  PrintProcessRegs(pd);
  if (req->instruction != 0 ) printf("Instruction  " );
  printf(" Program counter    Status register\r\n" );
  if (req->instruction != 0 ) printf("    %x     ", req->instruction );
  printf("      %x              %x\r\n", i, req->status );
  return(i);
}

PrintProcessRegs(pd)
register Process *pd;
{
  printf("d0       d1       d2       d3       d4       d5       d6       d7\n");
  printf("%X %X %X %X %X %X %X %X\n", pd->ps.regs.r.d0, pd->ps.regs.r.d1,
    pd->ps.regs.r.d2, pd->ps.regs.r.d3, pd->ps.regs.r.d4, pd->ps.regs.r.d5,
    pd->ps.regs.r.d6, pd->ps.regs.r.d7);
  printf("a0       a1       a2       a3       a4       a5       a6       isp      usp\n");
  printf("%X %X %X %X %X %X %X %X %X\n", pd->ps.regs.r.a0, pd->ps.regs.r.a1,
    pd->ps.regs.r.a2, pd->ps.regs.r.a3, pd->ps.regs.r.a4, pd->ps.regs.r.a5,
    pd->ps.regs.r.a6, pd->ps.regs.r.a7, pd->ps.regs.r.usp);
}

int InstructionFetch(code)
unsigned short code;
{
  StatusWord stat;

  stat.s20.word = code;
  return (stat.s20.field.fnc == FC_USER_PROGRAM ||
	  stat.s20.field.fnc == FC_SUPER_PROGRAM);
}

int ReadAccess(code)
unsigned short code;
{
  StatusWord stat;

  stat.s20.word = code;
  return (stat.s20.field.rw == 1); /* MC68020: 1 = read */
}

EUTrap(n)
int n;
{
  int FetchFP();
  TRACE1(user, 0, "Attempt to execute a UNIX trap #%d", n);
  StackDump((unsigned *)FetchFP());
  TRACE0(user, 0, "Process terminated");
}
E 1
