h33918
s 00719/00000/00000
d D 1.1 91/01/10 11:26:43 llp 1 0
c date and time created 91/01/10 11:26:43 by llp
e
u
U
f e 0
t
T
I 1
#
# %W%  3/14/89
#
#   Configuration options: 
#
#	MACHINE		"sun" for Sun simulator, "vax" for Vax simulator
#	HOWTOCOMPILE	either DEBUG or OPTIMIZE

MACHINE = sun
HOWTOCOMPILE = DEBUG

# Put the list of protocols here
PROTOCOLS = eth arp ip icmp 

OPTIMIZECFLAGS = -O
OPTIMIZECPPFLAGS = -DNDEBUG -DMSGOPT

DEBUGCFLAGS = -g
DEBUGCPPFLAGS = 

HOW = $(HOWTOCOMPILE)$(MACHINE)

CPPFLAGS = -DXSIMUL \
	-I. -I../share -I../simul -I../protocols -I../mi \
	 $($(HOWTOCOMPILE)CPPFLAGS)

CFLAGS =  $($(HOWTOCOMPILE)CFLAGS) $(CPPFLAGS)
CCO = ../bin/CCO_${MACHINE}
CSO = ../bin/CSO_${MACHINE}
CCS = ../bin/CCS_${MACHINE}
# PCDEFINITIONS BEGIN HERE
# Don't edit these lines, compose uses them
PCDOTOS = ../protocols/${HOW}/sim_ether.o \
../protocols/${HOW}/arp.o \
../protocols/${HOW}/ip.o \
../protocols/${HOW}/icmp.o \

PCDOTHS = eth.h arp.h ip.h icmp.h 
PCDOTCS = ../protocols/sim_ether.c \
../protocols/arp.c \
../protocols/ip.c \
../protocols/icmp.c \

PCDOTSS = 
# PCDEFINITIONS END HERE

SIMULOBJ = \
	../simul/${HOW}/init.o \
	../simul/${HOW}/machine.o \
	../simul/${HOW}/process.o \
	../simul/${HOW}/utils.o

SHAREOBJ = \
	../share/${HOW}/alloc.o \
	../share/${HOW}/debug.o \
	../share/${HOW}/event.o \
	../share/${HOW}/idmap.o \
	../share/${HOW}/message.o \
	../share/${HOW}/nmessage.o \
	../share/${HOW}/upi.o

USEROBJ = \
	${HOW}/z_u_body.o

PRIVOBJ = \
	${HOW}/localinit.o \
	${HOW}/protocols.o


OBJ =	\
	${SIMULOBJ} \
	${SHAREOBJ} \
	${PRIVOBJ} \
	${PCDOTOS} \
	${USEROBJ}

SHARESRC = \
	../share/alloc.c \
	../share/debug.c \
	../share/event.c \
	../share/idmap.c \
	../share/message.c \
	../share/nmessage.c \
	../share/upi.c

SIMULSRC = \
	../simul/init.c \
	../simul/machine.c \
	../simul/process.c \
	../simul/utils.c

PRIVSRC = \
	localinit.c \
	protocols.c

SRC = \
	${SHARESRC} \
	${SIMULSRC} \
	${PRIVSRC} \
	${PCDOTCS}

SIMULINC = \
	../simul/process.h

SHAREINC = \
	../share/debug.h \
	../share/system.h

INC = \
	${SIMULINC} \
	${SHAREINC} \
	${PCDOTHS}


all:	install

# PCRULES BEGIN HERE
# Don't edit these lines, compose uses them
../protocols/${HOW}/sim_ether.o:	../protocols/sim_ether.c
	@${CCO} ../protocols/sim_ether ../protocols/${HOW}/sim_ether $(CFLAGS)
../protocols/${HOW}/arp.o:	../protocols/arp.c
	@${CCO} ../protocols/arp ../protocols/${HOW}/arp $(CFLAGS)
../protocols/${HOW}/ip.o:	../protocols/ip.c
	@${CCO} ../protocols/ip ../protocols/${HOW}/ip $(CFLAGS)
../protocols/${HOW}/icmp.o:	../protocols/icmp.c
	@${CCO} ../protocols/icmp ../protocols/${HOW}/icmp $(CFLAGS)
# PCRULES END HERE

../simul/${HOW}/init.o:	../simul/init.c
	@$(CCO) ../simul/init ../simul/${HOW}/init $(CFLAGS)
../simul/${HOW}/machine.o:	../simul/machine.c
	@$(CCO) ../simul/machine ../simul/${HOW}/machine $(CFLAGS)
../simul/${HOW}/process.o:	../simul/process.c
	@$(CCO) ../simul/process ../simul/${HOW}/process $(CFLAGS)
../simul/${HOW}/utils.o:	../simul/utils.c
	@$(CCO) ../simul/utils ../simul/${HOW}/utils $(CFLAGS)

OTHERSCCS = Makefile consts.c \
	../lib/consts.awk ../lib/cscope.awk ../lib/number.awk \
	../lib/prop.awk ../lib/sizes.awk

.SCCS_GET:;
.S.o:;	@${CSO} $* `dirname $*`/${HOW}/`basename $*` $(CPPFLAGS)

.c.o:;	@${CCO} $* `dirname $*`/${HOW}/`basename $*` $(CFLAGS)

.c.s:;	@${CCS} $* $(CFLAGS)

.c.xx:;	@echo cc -E $*.c; \
	cc -E $(CPPFLAGS) $*.c > $*.xx

install:	xkernel

xkernel:	$(OBJ)
	@echo linking xkernel ...
	@cc -n -o xkernel $(OBJ)

compose: graph.comp
	../bin/compose_${MACHINE} <graph.comp
	cp -p Makefile Makefile.bak
	sed -f protocols.sed <Makefile | sed -e '/^@/s/^/	/' >Maketemp
	cp Maketemp Makefile
	rm Maketemp protocols.sed

User/user:	User/*.c
	cd User ; make user

${HOW}/z_u_body.o:	User/user ../bin/fixDoto_${MACHINE}
	rm -f ${HOW}/z_u_body.o
	ln -s ../User/user ${HOW}/z_u_body.o

${HOW}/localinit.o:	localinit.c
	@${CCO} localinit ${HOW}/localinit ${CFLAGS}

${HOW}/protocols.o:	protocols.c
	@${CCO} protocols ${HOW}/protocols ${CFLAGS}

dotodirs:
	-if [ ! -d ../share/DEBUG$(MACHINE) ] ; then umask 2; mkdir ../share/DEBUG$(MACHINE) ; fi;
	-if [ ! -d ../share/OPTIMIZE$(MACHINE) ] ; then umask 2; mkdir ../share/OPTIMIZE$(MACHINE) ; fi
	-if [ ! -d ../simul/DEBUG$(MACHINE) ] ; then umask 2; mkdir ../simul/DEBUG$(MACHINE) ; fi
	-if [ ! -d ../simul/OPTIMIZE$(MACHINE) ] ; then umask 2; mkdir ../simul/OPTIMIZE$(MACHINE) ; fi
	-if [ ! -d ../protocols/DEBUG$(MACHINE) ] ; then umask 2; mkdir ../protocols/DEBUG$(MACHINE) ; fi
	-if [ ! -d ../protocols/OPTIMIZE$(MACHINE) ] ; then umask 2; mkdir ../protocols/OPTIMIZE$(MACHINE) ; fi
	-if [ ! -d DEBUG$(MACHINE) ] ; then umask 2; mkdir DEBUG$(MACHINE) ; fi
	-if [ ! -d OPTIMIZE$(MACHINE) ] ; then umask 2; mkdir OPTIMIZE$(MACHINE) ; fi
	-for dir in $(PCDOTOS) ; do \
	    XX=`echo $$dir | sed -e '/\//s,/[^/]*$$,,'` ; \
	    if [ ! -d $$XX ] ; then umask 2 ; mkdir $$XX ; fi ; \
	 done

setup:	dotodirs
	cp ../simul/localinit.c . ; chmod +w localinit.c
	-mkdir User
	cp ../simul/User/Makefile User/Makefile

source sources:
	@echo $(SRC)

obj:
	@echo $(OBJ)

includes include:
	@echo $(INC)

othersccs:
	@echo $(OTHERSCCS)

routines.sizes:	$(ASM) ../lib/sizes.awk
	@echo Searching for the sizes of routines ...
	@awk -f ../lib/sizes.awk $(ASM) | sort > routines.sizes

cscope.out:	$(SRC) $(INC)
	@echo Running cscope ...
	@export TERM; TERM=vt100; \
	    export TERMCAP ; TERMCAP=/etc/termcap; \
	    cscope $(SRC) $(INC) < /dev/null > /dev/null 2>&1

cscope.dep:	cscope.out ../lib/cscope.awk
	awk -f ../lib/cscope.awk cscope.out | sort -u > cscope.dep

cscope.tsort:	cscope.dep
	tsort cscope.dep > cscope.tsort

allnames.dep:	xkernel
	@echo looking through xkernel's namelist
	@nm xkernel | \
	    sed -n -e '/ T _/s/^.*T _//p' \
	        -e '/ T /s/^.*T //p' \
		-e '/ t _/s/^.*t _//p' | \
	    sort > allnames.dep

all.sizes:	routines.sizes ../lib/extras.sizes
	sort routines.sizes ../lib/extras.sizes > all.sizes

sizes:	all.sort

all.prop all.sort:	all.sizes cscope.tsort cscope.dep number.awk prop.awk
	awk -f ../lib/number.awk cscope.tsort > temp1
	sort temp1 > temp2
	join temp2 cscope.dep > temp3
	sort -nr +1 -2 temp3 > temp4
	awk -f ../lib/prop.awk all.sizes stage=children temp4 > all.prop
	sort -nr +1 -2 all.prop > all.sort
	rm temp[1-4]

routines.list:	all.sizes
	sed -e 's/ .*$$//' all.sizes > routines.list

missing:	routines.list allnames.dep
	-diff -b allnames.dep routines.list

lint:
	@echo "Running lint"
	@lint -hbxuzn ${CPPFLAGS} ${SRC} | \
		egrep -v 'possible pointer alignment problem|questionable conversion of function pointer'

sccsversion:	 $(SRC) $(INC) $(OTHERSCCS)
	findnewsccs `make sources includes othersccs`
	sccs delta $?
	sccs edit $?
	touch sccsversion

sccsrelease:	$(SRC) $(INC) $(OTHERSCCS) sccsversion
	sccs unedit $(SRC) $(INC) $(OTHERSCCS)
	XXX=`cat sccsrelease` ; YYY=`expr $$XXX + 1`; echo $$YYY > sccsrelease
	sccs edit -r`cat sccsrelease` $(SRC) $(INC) $(OTHERSCCS)

map:	xkernel
	nm -n xkernel | ../bin/loadmap > map

tags:	$(SRC) $(INC)
	@ctags -tw $(SRC) $(INC)

cleanjunk:
	@echo Removing dotss ...
	@rm -f  *.c2 *.ccom *.cpp *.bak *.ckp *.ss all.* cscope.dep \
	    cscope.out cscope.tsort routines.sizes routines.list \
	    allnames.dep ${ASM}

clean:	cleanjunk
	@echo Removing dotos ...
	@rm -f $(OBJ)
	cd User; make clean

G = xkernel
GREP = egrep
grep:
	-@$(GREP) -n -e "$G" $(INC) $(SRC) ../lib/xkernel.il

depend:	${SRC}
	@rm -f makedepsed
	@-for name in $(SRC) ; do \
	    xxx=`basename $$name .c`; \
	    yyy=`dirname $$name`; \
	    echo "s+^$$xxx.o:+$$yyy/\$${HOW}/$$xxx.o:+" >> makedepsed ; \
	 done
	@cc -M $(CFLAGS) $(SRC) | sed -f makedepsed > makedep
	@rm -f makedepsed
	@echo '$$r makedep' > eddep
	@echo '/^# DO NOT DELETE THIS LINE/+1,$$d' >>eddep
	@echo '$$r makedep' >>eddep
	@echo 'w' >>eddep
	@cp Makefile Makefile.bak
	@ex - Makefile < eddep
	@rm eddep makedep

../share/${HOW}/debug.o:	../share/debug.c
	@${CCO} ../share/debug ../share/${HOW}/debug $(CFLAGS)
../share/${HOW}/idmap.o:	../share/idmap.c
	@${CCO} ../share/idmap ../share/${HOW}/idmap $(CFLAGS)
../share/${HOW}/event.o:	../share/event.c
	@${CCO} ../share/event ../share/${HOW}/event $(CFLAGS)
../share/${HOW}/message.o:	../share/message.c
	@${CCO} ../share/message ../share/${HOW}/message $(CFLAGS)
../share/${HOW}/nmessage.o:	../share/nmessage.c
	@${CCO} ../share/nmessage ../share/${HOW}/nmessage $(CFLAGS)
../share/${HOW}/alloc.o:	../share/alloc.c
	@${CCO} ../share/alloc ../share/${HOW}/alloc $(CFLAGS)
../share/${HOW}/upi.o:	../share/upi.c
	@${CCO} ../share/upi ../share/${HOW}/upi $(CFLAGS)

# DO NOT DELETE THIS LINE -- make depend uses it
../share/${HOW}/alloc.o: ../share/alloc.c
../share/${HOW}/debug.o: ../share/debug.c
../share/${HOW}/debug.o: ../share/debug.h
../share/${HOW}/event.o: ../share/event.c
../share/${HOW}/event.o: ../share/debug.h
../share/${HOW}/event.o: ../share/upi.h
../share/${HOW}/event.o: /usr/include/sys/types.h
../share/${HOW}/event.o: /usr/include/sys/sysmacros.h
../share/${HOW}/event.o: /usr/include/sys/file.h
../share/${HOW}/event.o: /usr/include/sys/fcntlcom.h
../share/${HOW}/event.o: /usr/include/sys/time.h
../share/${HOW}/event.o: /usr/include/time.h
../share/${HOW}/event.o: /usr/include/sys/wait.h
../share/${HOW}/event.o: /usr/include/sys/ioctl.h
../share/${HOW}/event.o: /usr/include/sys/ttychars.h
../share/${HOW}/event.o: /usr/include/sys/ttydev.h
../share/${HOW}/event.o: /usr/include/sys/ttold.h
../share/${HOW}/event.o: /usr/include/sys/ioccom.h
../share/${HOW}/event.o: /usr/include/sys/ttycom.h
../share/${HOW}/event.o: /usr/include/sys/filio.h
../share/${HOW}/event.o: /usr/include/sys/ioccom.h
../share/${HOW}/event.o: /usr/include/sys/sockio.h
../share/${HOW}/event.o: /usr/include/sys/ioccom.h
../share/${HOW}/event.o: /usr/include/sys/socket.h
../share/${HOW}/event.o: /usr/include/netinet/in.h
../share/${HOW}/event.o: /usr/include/netdb.h
../share/${HOW}/event.o: /usr/include/stdio.h
../share/${HOW}/event.o: /usr/include/syslog.h
../share/${HOW}/event.o: /usr/include/errno.h
../share/${HOW}/event.o: /usr/include/sys/errno.h
../share/${HOW}/event.o: /usr/include/signal.h
../share/${HOW}/event.o: /usr/include/vm/faultcode.h
../share/${HOW}/event.o: ../share/message.h
../share/${HOW}/event.o: ../share/nmessage.h
../share/${HOW}/event.o: ../share/assert.h
../share/${HOW}/event.o: ../share/system.h
../share/${HOW}/event.o: ../share/debug.h
../share/${HOW}/event.o: /usr/include/sys/time.h
../share/${HOW}/message.o: ../share/message.c
../share/${HOW}/message.o: ../share/system.h
../share/${HOW}/message.o: ../share/debug.h
../share/${HOW}/message.o: ../share/message.h
../share/${HOW}/message.o: ../share/nmessage.h
../share/${HOW}/message.o: ../share/assert.h
../share/${HOW}/message.o: /usr/include/stdio.h
../share/${HOW}/message.o: ../share/meta.h
../share/${HOW}/nmessage.o: ../share/nmessage.c
../share/${HOW}/nmessage.o: ../share/system.h
../share/${HOW}/nmessage.o: ../share/debug.h
../share/${HOW}/nmessage.o: ../share/nmessage.h
../share/${HOW}/nmessage.o: ../share/assert.h
../share/${HOW}/nmessage.o: /usr/include/stdio.h
../share/${HOW}/nmessage.o: ../share/assert.h
../share/${HOW}/upi.o: ../share/upi.c
../share/${HOW}/upi.o: ../share/upi.h
../share/${HOW}/upi.o: /usr/include/sys/types.h
../share/${HOW}/upi.o: /usr/include/sys/sysmacros.h
../share/${HOW}/upi.o: /usr/include/sys/file.h
../share/${HOW}/upi.o: /usr/include/sys/fcntlcom.h
../share/${HOW}/upi.o: /usr/include/sys/time.h
../share/${HOW}/upi.o: /usr/include/time.h
../share/${HOW}/upi.o: /usr/include/sys/wait.h
../share/${HOW}/upi.o: /usr/include/sys/ioctl.h
../share/${HOW}/upi.o: /usr/include/sys/ttychars.h
../share/${HOW}/upi.o: /usr/include/sys/ttydev.h
../share/${HOW}/upi.o: /usr/include/sys/ttold.h
../share/${HOW}/upi.o: /usr/include/sys/ioccom.h
../share/${HOW}/upi.o: /usr/include/sys/ttycom.h
../share/${HOW}/upi.o: /usr/include/sys/filio.h
../share/${HOW}/upi.o: /usr/include/sys/ioccom.h
../share/${HOW}/upi.o: /usr/include/sys/sockio.h
../share/${HOW}/upi.o: /usr/include/sys/ioccom.h
../share/${HOW}/upi.o: /usr/include/sys/socket.h
../share/${HOW}/upi.o: /usr/include/netinet/in.h
../share/${HOW}/upi.o: /usr/include/netdb.h
../share/${HOW}/upi.o: /usr/include/stdio.h
../share/${HOW}/upi.o: /usr/include/syslog.h
../share/${HOW}/upi.o: /usr/include/errno.h
../share/${HOW}/upi.o: /usr/include/sys/errno.h
../share/${HOW}/upi.o: /usr/include/signal.h
../share/${HOW}/upi.o: /usr/include/vm/faultcode.h
../share/${HOW}/upi.o: ../share/message.h
../share/${HOW}/upi.o: ../share/nmessage.h
../share/${HOW}/upi.o: ../share/assert.h
../share/${HOW}/upi.o: ../share/system.h
../share/${HOW}/upi.o: ../share/debug.h
../share/${HOW}/upi.o: ../simul/process.h
../simul/${HOW}/init.o: ../simul/init.c
../simul/${HOW}/init.o: ../simul/process.h
../simul/${HOW}/init.o: ../share/upi.h
../simul/${HOW}/init.o: /usr/include/sys/types.h
../simul/${HOW}/init.o: /usr/include/sys/sysmacros.h
../simul/${HOW}/init.o: /usr/include/sys/file.h
../simul/${HOW}/init.o: /usr/include/sys/fcntlcom.h
../simul/${HOW}/init.o: /usr/include/sys/time.h
../simul/${HOW}/init.o: /usr/include/time.h
../simul/${HOW}/init.o: /usr/include/sys/wait.h
../simul/${HOW}/init.o: /usr/include/sys/ioctl.h
../simul/${HOW}/init.o: /usr/include/sys/ttychars.h
../simul/${HOW}/init.o: /usr/include/sys/ttydev.h
../simul/${HOW}/init.o: /usr/include/sys/ttold.h
../simul/${HOW}/init.o: /usr/include/sys/ioccom.h
../simul/${HOW}/init.o: /usr/include/sys/ttycom.h
../simul/${HOW}/init.o: /usr/include/sys/filio.h
../simul/${HOW}/init.o: /usr/include/sys/ioccom.h
../simul/${HOW}/init.o: /usr/include/sys/sockio.h
../simul/${HOW}/init.o: /usr/include/sys/ioccom.h
../simul/${HOW}/init.o: /usr/include/sys/socket.h
../simul/${HOW}/init.o: /usr/include/netinet/in.h
../simul/${HOW}/init.o: /usr/include/netdb.h
../simul/${HOW}/init.o: /usr/include/stdio.h
../simul/${HOW}/init.o: /usr/include/syslog.h
../simul/${HOW}/init.o: /usr/include/errno.h
../simul/${HOW}/init.o: /usr/include/sys/errno.h
../simul/${HOW}/init.o: /usr/include/signal.h
../simul/${HOW}/init.o: /usr/include/vm/faultcode.h
../simul/${HOW}/init.o: ../share/message.h
../simul/${HOW}/init.o: ../share/nmessage.h
../simul/${HOW}/init.o: ../share/assert.h
../simul/${HOW}/init.o: ../share/debug.h
../simul/${HOW}/init.o: ./protocols.h
../simul/${HOW}/init.o: ../share/system.h
../simul/${HOW}/init.o: ../share/debug.h
../simul/${HOW}/machine.o: ../simul/machine.c
../simul/${HOW}/machine.o: ../share/debug.h
../simul/${HOW}/machine.o: /usr/include/sys/types.h
../simul/${HOW}/machine.o: /usr/include/sys/sysmacros.h
../simul/${HOW}/machine.o: /usr/include/sys/file.h
../simul/${HOW}/machine.o: /usr/include/sys/fcntlcom.h
../simul/${HOW}/machine.o: /usr/include/sys/time.h
../simul/${HOW}/machine.o: /usr/include/time.h
../simul/${HOW}/machine.o: /usr/include/sys/wait.h
../simul/${HOW}/machine.o: /usr/include/sys/ioctl.h
../simul/${HOW}/machine.o: /usr/include/sys/ttychars.h
../simul/${HOW}/machine.o: /usr/include/sys/ttydev.h
../simul/${HOW}/machine.o: /usr/include/sys/ttold.h
../simul/${HOW}/machine.o: /usr/include/sys/ioccom.h
../simul/${HOW}/machine.o: /usr/include/sys/ttycom.h
../simul/${HOW}/machine.o: /usr/include/sys/filio.h
../simul/${HOW}/machine.o: /usr/include/sys/ioccom.h
../simul/${HOW}/machine.o: /usr/include/sys/sockio.h
../simul/${HOW}/machine.o: /usr/include/sys/ioccom.h
../simul/${HOW}/machine.o: /usr/include/sys/socket.h
../simul/${HOW}/machine.o: /usr/include/netinet/in.h
../simul/${HOW}/machine.o: /usr/include/netdb.h
../simul/${HOW}/machine.o: /usr/include/stdio.h
../simul/${HOW}/machine.o: /usr/include/syslog.h
../simul/${HOW}/machine.o: /usr/include/errno.h
../simul/${HOW}/machine.o: /usr/include/sys/errno.h
../simul/${HOW}/machine.o: /usr/include/signal.h
../simul/${HOW}/machine.o: /usr/include/vm/faultcode.h
../simul/${HOW}/process.o: ../simul/process.c
../simul/${HOW}/process.o: /usr/include/signal.h
../simul/${HOW}/process.o: /usr/include/vm/faultcode.h
../simul/${HOW}/process.o: ../share/assert.h
../simul/${HOW}/process.o: /usr/include/stdio.h
../simul/${HOW}/process.o: ../simul/process.h
../simul/${HOW}/process.o: ../share/debug.h
../simul/${HOW}/process.o: ../share/system.h
../simul/${HOW}/process.o: ../share/debug.h
../simul/${HOW}/utils.o: ../simul/utils.c
../simul/${HOW}/utils.o: /usr/include/stdio.h
./${HOW}/localinit.o: localinit.c
./${HOW}/localinit.o: ../share/debug.h
./${HOW}/localinit.o: ./protocols.h
./${HOW}/protocols.o: protocols.c
./${HOW}/protocols.o: ../share/upi.h
./${HOW}/protocols.o: /usr/include/sys/types.h
./${HOW}/protocols.o: /usr/include/sys/sysmacros.h
./${HOW}/protocols.o: /usr/include/sys/file.h
./${HOW}/protocols.o: /usr/include/sys/fcntlcom.h
./${HOW}/protocols.o: /usr/include/sys/time.h
./${HOW}/protocols.o: /usr/include/time.h
./${HOW}/protocols.o: /usr/include/sys/wait.h
./${HOW}/protocols.o: /usr/include/sys/ioctl.h
./${HOW}/protocols.o: /usr/include/sys/ttychars.h
./${HOW}/protocols.o: /usr/include/sys/ttydev.h
./${HOW}/protocols.o: /usr/include/sys/ttold.h
./${HOW}/protocols.o: /usr/include/sys/ioccom.h
./${HOW}/protocols.o: /usr/include/sys/ttycom.h
./${HOW}/protocols.o: /usr/include/sys/filio.h
./${HOW}/protocols.o: /usr/include/sys/ioccom.h
./${HOW}/protocols.o: /usr/include/sys/sockio.h
./${HOW}/protocols.o: /usr/include/sys/ioccom.h
./${HOW}/protocols.o: /usr/include/sys/socket.h
./${HOW}/protocols.o: /usr/include/netinet/in.h
./${HOW}/protocols.o: /usr/include/netdb.h
./${HOW}/protocols.o: /usr/include/stdio.h
./${HOW}/protocols.o: /usr/include/syslog.h
./${HOW}/protocols.o: /usr/include/errno.h
./${HOW}/protocols.o: /usr/include/sys/errno.h
./${HOW}/protocols.o: /usr/include/signal.h
./${HOW}/protocols.o: /usr/include/vm/faultcode.h
./${HOW}/protocols.o: ../share/message.h
./${HOW}/protocols.o: ../share/nmessage.h
./${HOW}/protocols.o: ../share/assert.h
./${HOW}/protocols.o: ./protocols.h
../protocols/${HOW}/sim_ether.o: ../protocols/sim_ether.c
../protocols/${HOW}/sim_ether.o: ../share/upi.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/types.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/sysmacros.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/file.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/fcntlcom.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/time.h
../protocols/${HOW}/sim_ether.o: /usr/include/time.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/wait.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/ioctl.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/ttychars.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/ttydev.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/ttold.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/ttycom.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/filio.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/sockio.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/socket.h
../protocols/${HOW}/sim_ether.o: /usr/include/netinet/in.h
../protocols/${HOW}/sim_ether.o: /usr/include/netdb.h
../protocols/${HOW}/sim_ether.o: /usr/include/stdio.h
../protocols/${HOW}/sim_ether.o: /usr/include/syslog.h
../protocols/${HOW}/sim_ether.o: /usr/include/errno.h
../protocols/${HOW}/sim_ether.o: /usr/include/sys/errno.h
../protocols/${HOW}/sim_ether.o: /usr/include/signal.h
../protocols/${HOW}/sim_ether.o: /usr/include/vm/faultcode.h
../protocols/${HOW}/sim_ether.o: ../share/message.h
../protocols/${HOW}/sim_ether.o: ../share/nmessage.h
../protocols/${HOW}/sim_ether.o: ../share/assert.h
../protocols/${HOW}/sim_ether.o: ../share/system.h
../protocols/${HOW}/sim_ether.o: ../share/debug.h
../protocols/${HOW}/sim_ether.o: ../protocols/sim_ether.h
../protocols/${HOW}/sim_ether.o: ../protocols/sim_ether_i.h
../protocols/${HOW}/arp.o: ../protocols/arp.c
../protocols/${HOW}/arp.o: ../share/xkernel.h
../protocols/${HOW}/arp.o: ../share/upi.h
../protocols/${HOW}/arp.o: /usr/include/sys/types.h
../protocols/${HOW}/arp.o: /usr/include/sys/sysmacros.h
../protocols/${HOW}/arp.o: /usr/include/sys/file.h
../protocols/${HOW}/arp.o: /usr/include/sys/fcntlcom.h
../protocols/${HOW}/arp.o: /usr/include/sys/time.h
../protocols/${HOW}/arp.o: /usr/include/time.h
../protocols/${HOW}/arp.o: /usr/include/sys/wait.h
../protocols/${HOW}/arp.o: /usr/include/sys/ioctl.h
../protocols/${HOW}/arp.o: /usr/include/sys/ttychars.h
../protocols/${HOW}/arp.o: /usr/include/sys/ttydev.h
../protocols/${HOW}/arp.o: /usr/include/sys/ttold.h
../protocols/${HOW}/arp.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/arp.o: /usr/include/sys/ttycom.h
../protocols/${HOW}/arp.o: /usr/include/sys/filio.h
../protocols/${HOW}/arp.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/arp.o: /usr/include/sys/sockio.h
../protocols/${HOW}/arp.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/arp.o: /usr/include/sys/socket.h
../protocols/${HOW}/arp.o: /usr/include/netinet/in.h
../protocols/${HOW}/arp.o: /usr/include/netdb.h
../protocols/${HOW}/arp.o: /usr/include/stdio.h
../protocols/${HOW}/arp.o: /usr/include/syslog.h
../protocols/${HOW}/arp.o: /usr/include/errno.h
../protocols/${HOW}/arp.o: /usr/include/sys/errno.h
../protocols/${HOW}/arp.o: /usr/include/signal.h
../protocols/${HOW}/arp.o: /usr/include/vm/faultcode.h
../protocols/${HOW}/arp.o: ../share/message.h
../protocols/${HOW}/arp.o: ../share/nmessage.h
../protocols/${HOW}/arp.o: ../share/assert.h
../protocols/${HOW}/arp.o: ../share/system.h
../protocols/${HOW}/arp.o: ../share/debug.h
../protocols/${HOW}/arp.o: ../share/debug.h
../protocols/${HOW}/arp.o: ../simul/process.h
../protocols/${HOW}/arp.o: ../share/assert.h
../protocols/${HOW}/arp.o: ./eth.h
../protocols/${HOW}/arp.o: ../protocols/ip.h
../protocols/${HOW}/arp.o: ../protocols/arp.h
../protocols/${HOW}/arp.o: ../protocols/arp_internal.h
../protocols/${HOW}/ip.o: ../protocols/ip.c
../protocols/${HOW}/ip.o: ../share/assert.h
../protocols/${HOW}/ip.o: /usr/include/stdio.h
../protocols/${HOW}/ip.o: ../protocols/site.h
../protocols/${HOW}/ip.o: ../share/upi.h
../protocols/${HOW}/ip.o: /usr/include/sys/types.h
../protocols/${HOW}/ip.o: /usr/include/sys/sysmacros.h
../protocols/${HOW}/ip.o: /usr/include/sys/file.h
../protocols/${HOW}/ip.o: /usr/include/sys/fcntlcom.h
../protocols/${HOW}/ip.o: /usr/include/sys/time.h
../protocols/${HOW}/ip.o: /usr/include/time.h
../protocols/${HOW}/ip.o: /usr/include/sys/wait.h
../protocols/${HOW}/ip.o: /usr/include/sys/ioctl.h
../protocols/${HOW}/ip.o: /usr/include/sys/ttychars.h
../protocols/${HOW}/ip.o: /usr/include/sys/ttydev.h
../protocols/${HOW}/ip.o: /usr/include/sys/ttold.h
../protocols/${HOW}/ip.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/ip.o: /usr/include/sys/ttycom.h
../protocols/${HOW}/ip.o: /usr/include/sys/filio.h
../protocols/${HOW}/ip.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/ip.o: /usr/include/sys/sockio.h
../protocols/${HOW}/ip.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/ip.o: /usr/include/sys/socket.h
../protocols/${HOW}/ip.o: /usr/include/netinet/in.h
../protocols/${HOW}/ip.o: /usr/include/netdb.h
../protocols/${HOW}/ip.o: /usr/include/stdio.h
../protocols/${HOW}/ip.o: /usr/include/syslog.h
../protocols/${HOW}/ip.o: /usr/include/errno.h
../protocols/${HOW}/ip.o: /usr/include/sys/errno.h
../protocols/${HOW}/ip.o: /usr/include/signal.h
../protocols/${HOW}/ip.o: /usr/include/vm/faultcode.h
../protocols/${HOW}/ip.o: ../share/message.h
../protocols/${HOW}/ip.o: ../share/nmessage.h
../protocols/${HOW}/ip.o: ./eth.h
../protocols/${HOW}/ip.o: ../protocols/ip.h
../protocols/${HOW}/ip.o: ../protocols/ip_internal.h
../protocols/${HOW}/ip.o: ../protocols/icmp.h
../protocols/${HOW}/ip.o: ../protocols/arp.h
../protocols/${HOW}/ip.o: ../simul/process.h
../protocols/${HOW}/ip.o: ../share/debug.h
../protocols/${HOW}/icmp.o: ../protocols/icmp.c
../protocols/${HOW}/icmp.o: ../share/xkernel.h
../protocols/${HOW}/icmp.o: ../share/upi.h
../protocols/${HOW}/icmp.o: /usr/include/sys/types.h
../protocols/${HOW}/icmp.o: /usr/include/sys/sysmacros.h
../protocols/${HOW}/icmp.o: /usr/include/sys/file.h
../protocols/${HOW}/icmp.o: /usr/include/sys/fcntlcom.h
../protocols/${HOW}/icmp.o: /usr/include/sys/time.h
../protocols/${HOW}/icmp.o: /usr/include/time.h
../protocols/${HOW}/icmp.o: /usr/include/sys/wait.h
../protocols/${HOW}/icmp.o: /usr/include/sys/ioctl.h
../protocols/${HOW}/icmp.o: /usr/include/sys/ttychars.h
../protocols/${HOW}/icmp.o: /usr/include/sys/ttydev.h
../protocols/${HOW}/icmp.o: /usr/include/sys/ttold.h
../protocols/${HOW}/icmp.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/icmp.o: /usr/include/sys/ttycom.h
../protocols/${HOW}/icmp.o: /usr/include/sys/filio.h
../protocols/${HOW}/icmp.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/icmp.o: /usr/include/sys/sockio.h
../protocols/${HOW}/icmp.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/icmp.o: /usr/include/sys/socket.h
../protocols/${HOW}/icmp.o: /usr/include/netinet/in.h
../protocols/${HOW}/icmp.o: /usr/include/netdb.h
../protocols/${HOW}/icmp.o: /usr/include/stdio.h
../protocols/${HOW}/icmp.o: /usr/include/syslog.h
../protocols/${HOW}/icmp.o: /usr/include/errno.h
../protocols/${HOW}/icmp.o: /usr/include/sys/errno.h
../protocols/${HOW}/icmp.o: /usr/include/signal.h
../protocols/${HOW}/icmp.o: /usr/include/vm/faultcode.h
../protocols/${HOW}/icmp.o: ../share/message.h
../protocols/${HOW}/icmp.o: ../share/nmessage.h
../protocols/${HOW}/icmp.o: ../share/assert.h
../protocols/${HOW}/icmp.o: ../share/system.h
../protocols/${HOW}/icmp.o: ../share/debug.h
../protocols/${HOW}/icmp.o: ../share/debug.h
../protocols/${HOW}/icmp.o: ../simul/process.h
../protocols/${HOW}/icmp.o: ../share/assert.h
../protocols/${HOW}/icmp.o: ../protocols/ip.h
../protocols/${HOW}/icmp.o: ../protocols/ip_internal.h
../protocols/${HOW}/icmp.o: ../protocols/icmp.h
../protocols/${HOW}/icmp.o: ../protocols/icmp_internal.h
../protocols/${HOW}/unixudp.o: ../protocols/unixudp.c
../protocols/${HOW}/unixudp.o: /usr/include/errno.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/errno.h
../protocols/${HOW}/unixudp.o: ../share/xkernel.h
../protocols/${HOW}/unixudp.o: ../share/upi.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/types.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/sysmacros.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/file.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/fcntlcom.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/time.h
../protocols/${HOW}/unixudp.o: /usr/include/time.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/wait.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/ioctl.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/ttychars.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/ttydev.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/ttold.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/ttycom.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/filio.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/sockio.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/ioccom.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/socket.h
../protocols/${HOW}/unixudp.o: /usr/include/netinet/in.h
../protocols/${HOW}/unixudp.o: /usr/include/netdb.h
../protocols/${HOW}/unixudp.o: /usr/include/stdio.h
../protocols/${HOW}/unixudp.o: /usr/include/syslog.h
../protocols/${HOW}/unixudp.o: /usr/include/errno.h
../protocols/${HOW}/unixudp.o: /usr/include/sys/errno.h
../protocols/${HOW}/unixudp.o: /usr/include/signal.h
../protocols/${HOW}/unixudp.o: /usr/include/vm/faultcode.h
../protocols/${HOW}/unixudp.o: ../share/message.h
../protocols/${HOW}/unixudp.o: ../share/nmessage.h
../protocols/${HOW}/unixudp.o: ../share/assert.h
../protocols/${HOW}/unixudp.o: ../share/system.h
../protocols/${HOW}/unixudp.o: ../share/debug.h
../protocols/${HOW}/unixudp.o: ../share/debug.h
../protocols/${HOW}/unixudp.o: ../simul/process.h
../protocols/${HOW}/unixudp.o: ../share/assert.h
../protocols/${HOW}/unixudp.o: ../protocols/ip.h
../protocols/${HOW}/unixudp.o: ../protocols/unixudp.h
../protocols/${HOW}/unixudp.o: ../protocols/unixudp_i.h
E 1
