/* 
 * assert.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef assert_h
#define assert_h
#ifdef XSIMUL
#ifndef FILE
#include <stdio.h>
#endif
#define PRINT(A,B,C) fprintf(stderr, (A), (B), (C))
#define assertMessage "Assertion failed: file %s, line %d\n"
#else
#ifdef USER
#define assertMessage "Assertion failed: file %s, line %d\n"
#define PRINT(A,B,C) printf((A), (B), (C))
#define abort() xexit()
#else
#define abort() Kabort("abort")
#define PRINT(A,B,C) printf((A), (B), (C))
extern char assertMessage[];
#endif
#endif

# ifdef lint
   extern int assert__x_;
#  define assert(ex) (assert__x_ = (ex), assert__x_ = assert__x_ )
#  define _assert(ex)(assert__x_ = (ex), assert__x_ = assert__x_ )
# else
#  ifndef NDEBUG
#   define _assert(ex) ((ex) ? 1 : (PRINT(assertMessage, __FILE__, __LINE__), abort()))
#   define assert(ex)  ((ex) ? 1 : (PRINT(assertMessage, __FILE__, __LINE__), abort()))
#  else
#   define _assert(ex) 1
#   define assert(ex) 1
#  endif
# endif
#endif
