h23473
s 00050/00046/00510
d D 1.5 91/01/10 11:13:55 llp 5 4
c Prepared for 3.1 Distribution
e
s 00001/00001/00555
d D 1.4 90/12/03 15:44:29 norm 4 3
c Fixed the reference in msgf_clone_stack to point to new
e
s 00003/00003/00553
d D 1.3 89/11/07 10:21:22 norm 3 2
c Fixed a bug in make_allstack
e
s 00016/00000/00540
d D 1.2 89/11/03 13:06:39 norm 2 1
c Implemented msg_foreach to traverse a message
e
s 00540/00000/00000
d D 1.1 89/10/24 13:46:33 norm 1 0
c date and time created 89/10/24 13:46:33 by norm
e
u
U
f e 0
t
T
I 1
D 5
/*
 * %W%  %G%
E 5
I 5
/* 
 * message.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 5
 */

#include "system.h"
#include "message.h"
#include "meta.h"

D 5
MSG NULL_MSG = {0, 0, 0};
E 5
I 5
Msg NULL_MSG = {0, 0, 0};
E 5
int tracemsg =0;

/* msgf_overwrite : called when programmer knows he is going
   to over write data on stack. Basically when a message is
   pushed back down when comming up from below or when a
   saved message is retransmitted. (although if you know that
   data pushed on will be identical to existing data this is
   no problem.) In any case if you are the only person looking
   at the message msgf_overwrite is a noop.

*/

D 5
MSG msgf_overwrite(m)
    MSG m;
E 5
I 5
Msg msgf_overwrite(m)
    Msg m;
E 5
{
D 5
  MSG NEW;
E 5
I 5
  Msg NEW;
E 5
  int slen;

  if (m.stack->ref.ref == 1)
    return m;

  slen = msg_stack_len(m);

  /* make new stack */
  msg_make_allstack(NEW, MSG_SSIZE * 2, (char *) 0, 0);

  /* convert old stack to message */
  nmsg_makecontig(NEW.data, slen, msg_top(m, slen), (REF *) m.stack);

  /* join old stack with existing data */
  nmsg_save(m.data, m.data);
  NEW.data = nmsg_join(NEW.data, m.data);

  /* free old message */
  msg_free(m);

  return (NEW);
}

/* ran out of stack space */
char *msg_push_overflow(m_ptr, len)
D 5
    MSG *m_ptr;
E 5
I 5
    Msg *m_ptr;
E 5
    int len;
{
  int slen;
D 5
  MSG NEW;
  MSG old_m;
E 5
I 5
  Msg NEW;
  Msg old_m;
E 5

  
  TRACE1(msg,1,"msg_push_overflow: called len = %d!",len);

  /* undo push */
  m_ptr->top = m_ptr->top - len;

  /* find stack length */
  slen = msg_stack_len(*m_ptr);

  /* make new stack */
  msg_make_allstack(NEW, MSG_SSIZE * 2, (char *) 0, 0);

  /* convert old stack to message */
  nmsg_makecontig(NEW.data, slen, msg_top(*m_ptr, slen), (REF *) m_ptr->stack);

  /* join old stack with existing data */
  nmsg_save(m_ptr->data, m_ptr->data);
  NEW.data = nmsg_join(NEW.data, m_ptr->data);

  /* free old stack message */
  old_m = *m_ptr;
  msg_free(old_m);

  /* set new message */
  *m_ptr = NEW;

  /* redo push */
  m_ptr->top = m_ptr->top + len;

  /* return top */
  return (m_ptr->stack->base - m_ptr->top);
}


/* stack underflow  */
msg_pop_underflow(m_ptr, len)
D 5
    MSG *m_ptr;
E 5
I 5
    Msg *m_ptr;
E 5
    int len;
{
  int new_size, slen, dlen, data_needed, new_cur_size;
D 5
  MSG temp, temp2;
E 5
I 5
  Msg temp, temp2;
E 5

  TRACE1(msg,1,"msg_pop_undeflow: called! len = %d",len);

  /* undo pop */
  m_ptr->top = m_ptr->top + len;

  temp = *m_ptr;
  slen = msg_stack_len(temp);
  dlen = msg_data_len(temp);

  if (msg_len(temp) < len) {
    printf("msg_pop_underflow: message to small \n");
    return (-1);
  }
  /* allocate new stack */
  if ((len < META_HDR_LEN) && (dlen > META_HDR_LEN)) {
    data_needed = META_HDR_LEN;
  } else {
    data_needed = ((4 * len) < dlen ? 4 * len : dlen);
  }
  new_cur_size = data_needed + slen;
  new_size = temp.stack->size + new_cur_size;

  /* create new message containing only header */
  msg_make_allstack(temp2, new_size, (char *) 0, 0);

  /* copy data into new stack */
  msg_peek(temp, 0, new_cur_size, msg_push(temp2, new_cur_size));

  /* shorten old data and attach it to new message */
  nmsg_save(temp.data, temp.data);
  temp2.data = nmsg_truncateleft(temp.data, data_needed);

  /* free old message */
  msg_free(temp);

  /* put new message in correct place */
  *m_ptr = temp2;

  /* redo pop  */
  m_ptr->top = m_ptr->top - len;
  return (0);
}


char *msg_top_underflow(m_ptr, len)
D 5
    MSG *m_ptr;
E 5
I 5
    Msg *m_ptr;
E 5
    int len;
{
D 5
  MSG temp;
E 5
I 5
  Msg temp;
E 5

  temp = *m_ptr;
  msg_pop(temp, len);
  msg_push(temp, len);
  *m_ptr = temp;
  return temp.stack->base - temp.top;
}


/* look into a stack message */
msgf_peek(m, offset, len, b)
D 5
    MSG m;
E 5
I 5
    Msg m;
E 5
    int offset, len;
    char *b;
{
  int slen, mlen, copied;

  slen = msg_stack_len(m);
  mlen = msg_len(m);
  if (mlen < len + offset) {
    printf("msg_peek: message to small \n");
    return (-1);
  }
  if (slen) {
    if (offset < slen) {
      copied = ((len > (slen - offset)) ? slen - offset : len);
      bcopy(msg_top(m, slen) + offset, b, copied);
      if (copied == len)
	return (0);
      b = b + copied;
      len = len - copied;
      offset = 0;
    } else {
      offset = offset - slen;
    }
  }
  if (len) {
    nmsg_peek(m.data, offset, len, b);
  }
  return (0);
}


D 5
MSG msg_truncateleft(m, len)
    MSG m;
E 5
I 5
Msg msg_truncateleft(m, len)
    Msg m;
E 5
    int len;
{
  int slen, mlen;
D 5
  MSG temp;
E 5
I 5
  Msg temp;
E 5

  mlen = msg_len(m);
  slen = msg_stack_len(m);

  if (mlen < len) {
    printf("msg_truncateleft: message to small\n");
    temp.top = 0;
    temp.stack = 0;
    return (temp);
  }
  if (m.stack->ref.ref != 1) {
    msg_clone_stack(m, temp);
    msg_free(m);
  } else {
    temp = m;
  }
  if (slen) {
    if (slen >= len) {
      /* just pop */
      msg_pop(temp, len);
      len = 0;
    } else {
      /* pop off entire stack */
      msg_pop(temp, slen);
      len = len - slen;
    }
  }
  if (len) {
    temp.data = nmsg_truncateleft(temp.data, len);
  }
  return (temp);
}

D 5
MSG msg_truncateright(m, where)
    MSG m;
E 5
I 5
Msg msg_truncateright(m, where)
    Msg m;
E 5
    int where;
{
  int slen, mlen;
D 5
  MSG temp;
E 5
I 5
  Msg temp;
E 5

  mlen = msg_len(m);
  slen = msg_stack_len(m);

  if (mlen < where) {
    printf("msg_truncateright: message to small\n");
    temp.top = 0;
    temp.stack = (STACK) 0;
    temp.data = (NMSG) 0;
    return (temp);
  }
  if ((m.stack->ref.ref != 1) && (where < slen)) {
    msg_clone_stack(m, temp);
    msg_free(m);
  } else {
    temp = m;
  }

  if (where > slen) {
    temp.data = nmsg_truncateright(temp.data, where - slen);
  } else {
    nmsg_free(temp.data);
    temp.data = 0;
    temp.stack->size = temp.stack->size - (slen - where);
    temp.stack->base = temp.stack->base - (slen - where);
    temp.top = temp.top - (slen - where);
    if (temp.top < -1)
      Kabort("msg_truncateright: killed top!\n");
  }
  return (temp);
}


msg_real_join(target, m1, m2)
D 5
    MSG *target, m1, m2;
E 5
I 5
    Msg *target, m1, m2;
E 5
{
D 5
  MSG new;
E 5
I 5
  Msg new;
E 5
  NMSG stack_copy;
  int s2len;


  msg_save(new, m1);
  nmsg_save(m2.data, m2.data);
  s2len = msg_stack_len(m2);
  if (s2len != 0) {
    nmsg_makecontig(stack_copy, s2len, msg_top(m2, s2len), (REF *) ((m2).stack));
    new.data = nmsg_join(new.data, stack_copy);
  }
  new.data = nmsg_join(new.data, m2.data);
  msg_free(m1);
  msg_free(m2);
  *target = new;
}

msg_display(m, i)
D 5
    MSG m;
E 5
I 5
    Msg m;
E 5
    int i;
{
  printf("Stack Message:\n");
  printf("top = %d\n", m.top);
  printf("stack = %d\n", m.stack);
  printf("data = %d\n", m.data);
  if (m.stack == 0) {
    printf("null stack\n");
    return;
  }
  printf("size = %d\n", m.stack->size);
  printf("base = %x\n", m.stack->base);
  printf("ref.ref = %d\n", m.stack->ref.ref);
  printf("ref.ptr = %d\n", m.stack->ref.ptr);
  printf("stack = %x\n", m.stack->stack);
  printf("cur stack size = %d\n", msg_stack_len(m));
  printf("msg len = %d\n", msg_len(m));
  if (m.data)
    nmsg_display(m.data, i);
}


/* break a message into two parts */
/* note this join is backwards from nmsg join
   r contains the message to be broken and
   m gets the remainder
   this is so the header ends up on the correct message
*/
msg_real_break(m, r, where, stack_size)
D 5
    MSG *r, *m;
E 5
I 5
    Msg *r, *m;
E 5
    int where, stack_size;
{
  int slen;
D 5
  MSG new_m;
  MSG old_m;
  MSG new_r;
E 5
I 5
  Msg new_m;
  Msg old_m;
  Msg new_r;
E 5
  NMSG stacktail;
  int taillen;

  old_m = *m;
  slen = msg_stack_len(old_m);

  if (stack_size == 0) {
    msg_make_allstack(new_r, old_m.stack->size, (char *) 0, 0);
  } else {
    msg_make_allstack(new_r, stack_size, (char *) 0, 0);
  }


  msg_make_allstack(new_m, old_m.stack->size, msg_top(old_m, where), where);
  taillen = slen - where;
  msg_pop(old_m, where);
  nmsg_makecontig(stacktail, taillen, msg_top(old_m, taillen), (REF *) (old_m.stack));
  new_r.data = nmsg_join(stacktail, old_m.data);
  old_m = *m;
  msg_free(old_m);
  *m = new_m;
  *r = new_r;
}


D 5
MSG msgf_make_exist(S, D, L, R)
E 5
I 5
Msg msgf_make_exist(S, D, L, R)
E 5
    int S, L;
    char *D;
    REF *R;
{
D 5
  MSG M;
E 5
I 5
  Msg M;
E 5

  if ((S % 4) != 0) {
    Kabort("msg_make_exist: stack sizes must be divisable by 4!");
  }
  (M).top = -1;
  (M).stack = (STACK) malloc((unsigned) (sizeof(STACK_HDR) + S - 8));
  (M).stack->ref.ref = 1;
  (M).stack->ref.ptr = (char *) (M).stack;
  (M).stack->ref.xfree = free;
  (M).stack->last_op = MSG_CREATE;
  (M).stack->size = (S);
  (M).stack->base = (M).stack->stack + (S) - 1;
  nmsg_makecontig((M).data, L, D, R);
  return (M);
}

D 5
MSG msgf_make_new(S, D, L)
E 5
I 5
Msg msgf_make_new(S, D, L)
E 5
    int S, L;
    char *D;
{
D 5
  MSG M;
E 5
I 5
  Msg M;
E 5
  REF *r;

  if ((S % 4) != 0) {
    Kabort("msg_make_new: stack sizes must be divisable by 4!");
  }
  (M).top = -1;
  (M).stack = (STACK) malloc((unsigned) (sizeof(STACK_HDR) + S - 8));
  (M).stack->ref.ref = 1;
  (M).stack->ref.ptr = (char *) (M).stack;
  (M).stack->ref.xfree = free;
  (M).stack->last_op = MSG_CREATE;
  (M).stack->size = (S);
  (M).stack->base = (M).stack->stack + (S) - 1;
  nmsg_makeref(r, D);
  r->ref--;
  nmsg_makecontig((M).data, L, D, r);
  return (M);
}

D 5
MSG msgf_make_allstack(S, D, L)
E 5
I 5
Msg msgf_make_allstack(S, D, L)
E 5
    int S, L;
    char *D;
{
D 5
  MSG M;
E 5
I 5
  Msg M;
E 5
D 3

E 3
I 3
  int R = (L + 3) & ~0x3;
E 3
  if ((S % 4) != 0) {
    Kabort("msg_make_allstack: stack sizes must be divisable by 4!");
  }
  (M).top = -1;
D 3
  (M).stack = (STACK) malloc((unsigned) (sizeof(STACK_HDR) + (S) - 8 + (L)));
E 3
I 3
  (M).stack = (STACK) malloc((unsigned) (sizeof(STACK_HDR) + (S) - 8 + R));
E 3
  (M).stack->ref.ref = 1;
  (M).stack->ref.ptr = (char *) (M.stack);
  (M).stack->ref.xfree = free;
  (M).stack->last_op = MSG_CREATE;
D 3
  (M).stack->size = (S) + (L);
E 3
I 3
  (M).stack->size = (S) + (R);
E 3
  (M).stack->base = (M).stack->stack + (S) + (L) - 1;
  if (L != 0)
    bcopy(D, msg_push(M, L), L);
  (M).data = 0;
  return (M);
}

/* free a message */
msgf_free(m)
D 5
    MSG m;
E 5
I 5
    Msg m;
E 5
{
  if ((m).data)
    nmsg_free((m).data);
  if ((m.stack) && (--((m).stack->ref.ref) == 0)) {
    (m).stack->ref.xfree((m).stack->ref.ptr);
  }
  return (0);
}

/* make room for a header on a message */
char *msgf_push(m, len)
D 5
    MSG *m;
E 5
I 5
    Msg *m;
E 5
    int len;
{
  char *temp;

  if ((m->top = m->top + len) < m->stack->size) {
    temp = m->stack->base - m->top;
  } else {
    temp = msg_push_overflow(m, len);
  }
  return temp;
}

/* pop header off stack */
int msgf_pop(m, len)
D 5
    MSG *m;
E 5
I 5
    Msg *m;
E 5
    int len;
{
  int temp;

  if ((m->top = m->top - len) >= -1) {
    temp = 0;
  } else {
    temp = msg_pop_underflow(m, len);
  }
  return (temp);
}


/* get top of stack */
char *msgf_top(m, len)
D 5
    MSG *m;
E 5
I 5
    Msg *m;
E 5
    int len;
{
  char *temp;

  if ((m->top - len) >= -1) {
    temp = m->stack->base - m->top;
  } else {
    temp = msg_top_underflow(m, len);
  }
  return temp;
}



D 5
MSG msgf_clone_stack(m)
    MSG m;
E 5
I 5
Msg msgf_clone_stack(m)
    Msg m;
E 5
{
D 5
  MSG new;
E 5
I 5
  Msg new;
E 5

  (new).top = (m).top;
  nmsg_save((new).data, (m).data);
  (new).stack = (STACK) malloc((unsigned) (sizeof(STACK_HDR) + (m).stack->size - 8));
  bcopy((char *) (m).stack, (char *) (new).stack, sizeof(STACK_HDR) + (m).stack->size - 8);
  (new).stack->ref.ref = 1;
D 4
  (new).stack->ref.ptr = (char *) (m).stack;
E 4
I 4
  (new).stack->ref.ptr = (char *) (new).stack;
E 4
  (new).stack->ref.xfree = free;
  return (new);
}

void msgf_break(M, R, WHERE, SIZE)
D 5
    MSG *R, *M;
E 5
I 5
    Msg *R, *M;
E 5
    int WHERE, SIZE;
{
  NMSG HHHH;

  if ((WHERE) < msg_stack_len(*M)) {
    msg_real_break(M, R, WHERE, SIZE);
  } else {
    if (SIZE == 0) {
      *R = msgf_make_allstack(M->stack->size, (char *) 0, 0);
    } else {
      *R = msgf_make_allstack(SIZE, (char *) 0, 0);
    }
    HHHH = M->data;
    nmsg_break(&(M->data), &HHHH, (WHERE) - msg_stack_len(*M));
    R->data = HHHH;
  }
}

D 5
MSG msgf_join(M1, M2)
    MSG M1, M2;
E 5
I 5
Msg msgf_join(M1, M2)
    Msg M1, M2;
E 5
{
D 5
  MSG TTTT;
  MSG NEW;
E 5
I 5
  Msg TTTT;
  Msg NEW;
E 5

  if (msg_isnull(M1)) {
    (NEW) = (M2);
  } else if (msg_isnull(M2)) {
    (NEW) = (M1);
  } else if (msg_stack_len(M2) != 0) {
    msg_real_join(&(NEW), M1, M2);
  } else {
    TTTT = (NEW);
    msg_save(TTTT, M1);
    nmsg_save((M2).data, (M2).data);
    (TTTT).data = nmsg_join((TTTT).data, (M2).data);
    msg_free(M1);
    msg_free(M2);
    (NEW) = TTTT;
  }
  return (NEW);
}
I 2

/* look into a stack message */
msg_foreach(m, f, arg1, arg2)
D 5
    MSG m;
E 5
I 5
    Msg m;
E 5
    int (*f)();
    int *arg1, *arg2;
{
  int slen = msg_stack_len(m);
  if (slen) {
    f(msg_top(m, slen), slen, arg1, arg2);
  }
  if (m.data) {
    nmsg_foreach(m.data, f, arg1, arg2);
  }
}

E 2
E 1
