h59076
s 00113/00000/00000
d D 1.1 91/01/10 11:14:49 llp 1 0
c date and time created 91/01/10 11:14:49 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * idmap_templ.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
 * We need the definitions of:
 *	KEYSIZE
 *	HASH
 *	COMPBYTES
 *	COPYBYTES
 */

static Bind BINDNAME (table, ext, intern)
Map	table;
register char	*ext;
int	intern;
{
  Bind     elem_posn, new_elem, *table_posn;

  register char *o_ext;

  table_posn = &table->table[HASH(ext, table->nEntries)];
  elem_posn = *table_posn;
  while (elem_posn != 0) {
    o_ext = elem_posn->externalid;
    if (COMPBYTES(o_ext, ext)) {
      if (elem_posn->internalid == intern) {
	return(elem_posn);
      } else {
	x_errno = INCONSISTENT_BIND;
	return(ERR_BIND);
      }
    } else {
      elem_posn = elem_posn->next;
    }
  }
  GETMAPELEM(table, new_elem);
  COPYBYTES(new_elem->externalid, ext);
  new_elem->internalid = intern;
  new_elem->next = *table_posn;
  table->cache = new_elem;
  *table_posn = new_elem;
  return new_elem;
}

static RESOLVENAME (table, ext)
Map	table;
register char	*ext;
{
  register Bind elem_posn;
  register char *o_ext;

  if (elem_posn = table->cache) {
    o_ext = elem_posn->externalid;
    if (COMPBYTES(o_ext, ext)) {
      return(elem_posn->internalid);
    }
  }
  elem_posn = table->table[HASH(ext, table->nEntries)];
  while (elem_posn != 0) {
    o_ext = elem_posn->externalid;
    if (COMPBYTES(o_ext, ext)) {
      table->cache = elem_posn;
      return elem_posn->internalid;
    } else {
      elem_posn = elem_posn->next;
    }
  }
  x_errno = CANNOT_RESOLVE;
  return(-1);
}

static UNBINDNAME (table, ext, intern)
Map	table;
register char	*ext;
int	intern;
{
  Bind     elem_posn, *prev_elem;
  register char *o_ext;

  prev_elem = &table->table[HASH(ext, table->nEntries)];
  elem_posn = *prev_elem;
  table->cache = 0;
  while (elem_posn != 0) {
    o_ext = elem_posn->externalid;
    if (COMPBYTES(o_ext, ext)) {
      if (elem_posn->internalid == intern || intern == -1) {
	*prev_elem = elem_posn->next;
	FREEIT(table, elem_posn);
	return 0;
      } else {
	x_errno = CANNOT_UNBIND;
	return -1;
      }
    } else {
      prev_elem = &(elem_posn->next);
      elem_posn = elem_posn->next;
    }
  }
  x_errno = CANNOT_UNBIND;
  return -1;
}
#undef BINDNAME
#undef RESOLVENAME
#undef UNBINDNAME
#undef KEYSIZE
#undef HASH
#undef COMPBYTES
#undef COPYBYTES
E 1
