h10193
s 00313/00000/00000
d D 1.1 91/01/10 11:14:46 llp 1 0
c date and time created 91/01/10 11:14:46 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * idmap.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "idmap.h"
#include "idmap_internal.h"
#include "upi.h"

/* Create and return a new map containing a table with nEntries entries */
/* mapping keys of size keySize to integers */

static struct {
  int (*resolve)();
  Bind(*bind)();
  int (*unbind)();
} map_functions[48];
  
static int  mgenericresolve();
static Bind mgenericbind();
static int  mgenericunbind();

Map map_create(nEntries, keySize)
int nEntries, keySize;
{
  register Map m;
  m = (Map)malloc(sizeof(*m));
  m->nEntries = nEntries;
  m->keySize = keySize;
  m->cache = 0;
  m->freelist = 0;
  m->table = (MapElement **)calloc(nEntries, sizeof(MapElement *));
  if (map_functions[keySize].resolve != 0) {
    m->resolve = map_functions[keySize].resolve;
    m->bind    = map_functions[keySize].bind   ;
    m->unbind  = map_functions[keySize].unbind ;
  } else {
    m->resolve = mgenericresolve;
    m->bind    = mgenericbind   ;
    m->unbind  = mgenericunbind ;
  }    
  return m;
}

void map_close(m)
Map m;
{
  free((char *)m->table);
  free((char *)m);
}

static int generichash(key, tableSize, keySize)
char *key;
int tableSize, keySize;
{
  int howmanylongs = keySize / 4, i;
  unsigned int hash = 0;

  for (i = 0; i < howmanylongs; i++) {
    hash = (hash << 2) ^ (* (unsigned long *)key);
    key += 4;
  }
  if (keySize % 4 == 2) {
    hash = (hash << 2) ^ (* (unsigned short *)key);
    key += 2;
  }
  if (keySize & 1) {
    hash = (hash << 2) ^ (* (unsigned char *)key);
  }
  return hash % tableSize;
}

#define KEYSIZE generic
#define BINDNAME mgenericbind
#define RESOLVENAME mgenericresolve
#define UNBINDNAME mgenericunbind
#define HASH(K, T) generichash(K, T, table->keySize)
#define COMPBYTES(s1, s2) (!bcmp(s1, s2, table->keySize))
#define COPYBYTES(s1, s2) bcopy(s2, s1, table->keySize)

#include "idmap_templ.c"

#define KEYSIZE 2
#define BINDNAME m2bind
#define RESOLVENAME m2resolve
#define UNBINDNAME m2unbind
#define HASH(K, T)        (*(unsigned short *)(K) % (T))
#define COMPBYTES(s1, s2) (*(short *)(s1) == (*(short *)(s2)))
#define COPYBYTES(s1, s2) { *(short *)(s1) = (*(short *)(s2));}

#include "idmap_templ.c"

#define KEYSIZE 4
#define BINDNAME m4bind
#define RESOLVENAME m4resolve
#define UNBINDNAME m4unbind
#define HASH(K, T)        (*(unsigned  *)(K) % (T))
#define COMPBYTES(s1, s2) (*(int *)(s1) == (*(int *)(s2)))
#define COPYBYTES(s1, s2) { *(int *)(s1) = (*(int *)(s2));}

#include "idmap_templ.c"

#define KEYSIZE 6
#define BINDNAME m6bind
#define RESOLVENAME m6resolve
#define UNBINDNAME m6unbind
#define HASH(K, T) ((((*(unsigned *)(K)) ^ (*((unsigned short *)(K) + 2))) % *(unsigned *)(T)))
#define COMPBYTES(s1, s2) (*(int *)(s1) == (*(int *)(s2)) && \
	(*((short *)(s1)+2)) == (*((short *)(s2)+2)))
#define COPYBYTES(s1, s2) { *(int *)(s1) = (*(int *)(s2)); \
	*((short *)(s1)+2) = *((short *)(s2)+2); }

#include "idmap_templ.c"

#define KEYSIZE 8
#define BINDNAME m8bind
#define RESOLVENAME m8resolve
#define UNBINDNAME m8unbind
#define HASH(K, T) ((((*(unsigned *)(K)) ^ (*((unsigned *)(K) + 1))) % *(unsigned *)(T)))

#define COMPBYTES(s1, s2) (*(int *)(s1) == (*(int *)(s2)) && \
	(*((int *)(s1)+1)) == (*((int *)(s2)+1)))

#define COPYBYTES(s1, s2) { *(int *)(s1) = (*(int *)(s2)); \
	*((int *)(s1)+1) = *((int *)(s2)+1); }

#include "idmap_templ.c"

#define KEYSIZE 10
#define BINDNAME m10bind
#define RESOLVENAME m10resolve
#define UNBINDNAME m10unbind
#define HASH(K, T) ((((*(unsigned *)(K)) ^ (*((unsigned *)(K) + 1)) ^ (*((unsigned short *)(K) + 4))) % *(unsigned *)(T)))

#define COMPBYTES(s1, s2) (*(int *)(s1) == (*(int *)(s2)) && \
	(*((int *)(s1)+1)) == (*((int *)(s2)+1)) && \
	(*((short *)(s1)+4)) == (*((short *)(s2)+4)))

#define COPYBYTES(s1, s2) { *(int *)(s1) = (*(int *)(s2)); \
	*((int *)(s1)+1) = *((int *)(s2)+1); \
	*((short *)(s1)+4) = *((short *)(s2)+4); }

#include "idmap_templ.c"

#define KEYSIZE 12
#define BINDNAME m12bind
#define RESOLVENAME m12resolve
#define UNBINDNAME m12unbind
#define HASH(K, T) ((((*(unsigned *)(K)) ^ (*((unsigned *)(K) + 1)) ^ (*((unsigned *)(K) + 2))) % *(unsigned *)(T)))

#define COMPBYTES(s1, s2) (*(int *)(s1) == (*(int *)(s2)) && \
	(*((int *)(s1)+1)) == (*((int *)(s2)+1)) && \
	(*((int *)(s1)+2)) == (*((int *)(s2)+2)))

#define COPYBYTES(s1, s2) { *(int *)(s1) = (*(int *)(s2)); \
	*((int *)(s1)+1) = *((int *)(s2)+1); \
	*((int *)(s1)+2) = *((int *)(s2)+2); }

#include "idmap_templ.c"

#define KEYSIZE 16
#define BINDNAME m16bind
#define RESOLVENAME m16resolve
#define UNBINDNAME m16unbind
#define HASH(K, T) ((((*(unsigned *)(K)) ^ (*((unsigned *)(K) + 1)) ^ (*((unsigned *)(K) + 2)) ^ (*((unsigned *)(K) + 3))) % *(unsigned *)(T)))

#define COMPBYTES(s1, s2) (*(int *)(s1) == (*(int *)(s2)) && \
	(*((int *)(s1)+1)) == (*((int *)(s2)+1)) && \
	(*((int *)(s1)+2)) == (*((int *)(s2)+2)) && \
	(*((int *)(s1)+3)) == (*((int *)(s2)+3)))

#define COPYBYTES(s1, s2) { *(int *)(s1) = (*(int *)(s2)); \
	*((int *)(s1)+1) = *((int *)(s2)+1); \
	*((int *)(s1)+2) = *((int *)(s2)+2); \
	*((int *)(s1)+3) = *((int *)(s2)+3); }

#include "idmap_templ.c"

#define KEYSIZE 24
#define BINDNAME m24bind
#define RESOLVENAME m24resolve
#define UNBINDNAME m24unbind
#define HASH(K, T) ((((*(unsigned *)(K)) ^ (*((unsigned *)(K) + 1)) ^ (*((unsigned *)(K) + 2)) ^ (*((unsigned *)(K) + 3)) ^ (*((unsigned *)(K) + 4)) ^ (*((unsigned *)(K) + 5))) % *(unsigned *)(T)))

#define COMPBYTES(s1, s2) (*(int *)(s1) == (*(int *)(s2)) && \
	(*((int *)(s1)+1)) == (*((int *)(s2)+1)) && \
	(*((int *)(s1)+2)) == (*((int *)(s2)+2)) && \
	(*((int *)(s1)+3)) == (*((int *)(s2)+3)) && \
	(*((int *)(s1)+4)) == (*((int *)(s2)+4)) && \
	(*((int *)(s1)+5)) == (*((int *)(s2)+5)))

#define COPYBYTES(s1, s2) { *(int *)(s1) = (*(int *)(s2)); \
	*((int *)(s1)+1) = *((int *)(s2)+1); \
	*((int *)(s1)+2) = *((int *)(s2)+2); \
	*((int *)(s1)+3) = *((int *)(s2)+3); \
	*((int *)(s1)+4) = *((int *)(s2)+4); \
	*((int *)(s1)+5) = *((int *)(s2)+5); }

#include "idmap_templ.c"

#define KEYSIZE 28
#define BINDNAME m28bind
#define RESOLVENAME m28resolve
#define UNBINDNAME m28unbind
#define HASH(K, T) ((((*(unsigned *)(K)) ^ (*((unsigned *)(K) + 1)) \
        ^ (*((unsigned *)(K) + 2)) ^ (*((unsigned *)(K) + 3)) \
        ^ (*((unsigned *)(K) + 4)) ^ (*((unsigned *)(K) + 5)) \
        ^ (*((unsigned *)(K) + 6))) % *(unsigned *)(T)))

#define COMPBYTES(s1, s2) (*(int *)(s1) == (*(int *)(s2)) && \
	(*((int *)(s1)+1)) == (*((int *)(s2)+1)) && \
	(*((int *)(s1)+2)) == (*((int *)(s2)+2)) && \
	(*((int *)(s1)+3)) == (*((int *)(s2)+3)) && \
	(*((int *)(s1)+4)) == (*((int *)(s2)+4)) && \
	(*((int *)(s1)+5)) == (*((int *)(s2)+5)) && \
	(*((int *)(s1)+6)) == (*((int *)(s2)+6))) 

#define COPYBYTES(s1, s2) { *(int *)(s1) = (*(int *)(s2)); \
	*((int *)(s1)+1) = *((int *)(s2)+1); \
	*((int *)(s1)+2) = *((int *)(s2)+2); \
	*((int *)(s1)+3) = *((int *)(s2)+3); \
	*((int *)(s1)+4) = *((int *)(s2)+4); \
	*((int *)(s1)+5) = *((int *)(s2)+5); \
	*((int *)(s1)+6) = *((int *)(s2)+6); }

#include "idmap_templ.c"

#define KEYSIZE 32
#define BINDNAME m32bind
#define RESOLVENAME m32resolve
#define UNBINDNAME m32unbind
#define HASH(K, T) ((((*(unsigned *)(K)) ^ (*((unsigned *)(K) + 1)) \
        ^ (*((unsigned *)(K) + 2)) ^ (*((unsigned *)(K) + 3)) \
        ^ (*((unsigned *)(K) + 4)) ^ (*((unsigned *)(K) + 5)) \
        ^ (*((unsigned *)(K) + 6)) ^ (*((unsigned *)(K) + 7))) \
        % *(unsigned *)(T)))

#define COMPBYTES(s1, s2) (*(int *)(s1) == (*(int *)(s2)) && \
	(*((int *)(s1)+1)) == (*((int *)(s2)+1)) && \
	(*((int *)(s1)+2)) == (*((int *)(s2)+2)) && \
	(*((int *)(s1)+3)) == (*((int *)(s2)+3)) && \
	(*((int *)(s1)+4)) == (*((int *)(s2)+4)) && \
	(*((int *)(s1)+5)) == (*((int *)(s2)+5)) && \
	(*((int *)(s1)+6)) == (*((int *)(s2)+6)) && \
	(*((int *)(s1)+7)) == (*((int *)(s2)+7))) 

#define COPYBYTES(s1, s2) { *(int *)(s1) = (*(int *)(s2)); \
	*((int *)(s1)+1) = *((int *)(s2)+1); \
	*((int *)(s1)+2) = *((int *)(s2)+2); \
	*((int *)(s1)+3) = *((int *)(s2)+3); \
	*((int *)(s1)+4) = *((int *)(s2)+4); \
	*((int *)(s1)+5) = *((int *)(s2)+5); \
	*((int *)(s1)+6) = *((int *)(s2)+6); \
	*((int *)(s1)+7) = *((int *)(s2)+7); }

#include "idmap_templ.c"

map_init()
{
#define KEYSIZE 2
#define BINDNAME m2bind
#define RESOLVENAME m2resolve
#define UNBINDNAME m2unbind
#include "idmap_init.c"
#define KEYSIZE 4
#define BINDNAME m4bind
#define RESOLVENAME m4resolve
#define UNBINDNAME m4unbind
#include "idmap_init.c"
#define KEYSIZE 6
#define BINDNAME m6bind
#define RESOLVENAME m6resolve
#define UNBINDNAME m6unbind
#include "idmap_init.c"
#define KEYSIZE 8
#define BINDNAME m8bind
#define RESOLVENAME m8resolve
#define UNBINDNAME m8unbind
#include "idmap_init.c"
#define KEYSIZE 10
#define BINDNAME m10bind
#define RESOLVENAME m10resolve
#define UNBINDNAME m10unbind
#include "idmap_init.c"
#define KEYSIZE 12
#define BINDNAME m12bind
#define RESOLVENAME m12resolve
#define UNBINDNAME m12unbind
#include "idmap_init.c"
#define KEYSIZE 16
#define BINDNAME m16bind
#define RESOLVENAME m16resolve
#define UNBINDNAME m16unbind
#include "idmap_init.c"
#define KEYSIZE 24
#define BINDNAME m24bind
#define RESOLVENAME m24resolve
#define UNBINDNAME m24unbind
#include "idmap_init.c"
#define KEYSIZE 28
#define BINDNAME m28bind
#define RESOLVENAME m28resolve
#define UNBINDNAME m28unbind
#include "idmap_init.c"
#define KEYSIZE 32
#define BINDNAME m32bind
#define RESOLVENAME m32resolve
#define UNBINDNAME m32unbind
#include "idmap_init.c"
}
E 1
