/* 
 * tcp.h
 *
 * Derived from:
 *
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 * Modified for x-kernel v3.1	12/10/90
 * Modifications Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef tcp_h
#define tcp_h

#define	TCPADLEN (sizeof(TCPaddr))

typedef unsigned short TCPport;

typedef struct tcpaddr {
  TCPport	port;
  IPhost	host;
} TCPaddr;

extern tcp_getproc(); 

#define TCP_PUSH		(TCP_CTL*MAXOPS + 0)
#define TCP_GETSTATEINFO	(TCP_CTL*MAXOPS + 1)
#define TCP_DUMPSTATEINFO	(TCP_CTL*MAXOPS + 2)

#endif
