h29869
s 00006/00046/00292
d D 1.2 91/01/10 12:12:04 llp 2 1
c Prepared for 3.1 Distribution
e
s 00338/00000/00000
d D 1.1 90/11/16 13:05:54 menze 1 0
c date and time created 90/11/16 13:05:54 by menze
e
u
U
f e 0
t
T
I 1
D 2

E 2
/*
 * spc_internal.h
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */


D 2


E 2
#define drop_msg(msg)	msg_free(msg);return(SUCCESS)

D 2




E 2
/*
 * SPChdr
 */
typedef struct spc_hdr {

	/* the message type and some true flags */
	u_short		flags;

/* encoding of the "flags" field of the SPC header */
/* message types */
#define REQUEST			((u_short) 0x0100)
#define REPLY			((u_short) 0x0800)
#define PARTIAL_NAK		((u_short) 0x0200)
#define EXPLICIT_ACK	((u_short) 0x0400)
/* true flags */
#define ACK_DEMANDED	((u_short) 0x0001)
#define LAST_FRAG		((u_short) 0x0002)
#define SRVR_ERR		((u_short) 0x0008)
#define FOR_SRVR		((u_short) 0x0010)

	/* host ids (in Sprite: assigned locally, but could follow Internet) */
	/* Sprite says these are unsinged, but we'll call them IPhost */
	IPhost		clnt_host;
	IPhost		srvr_host;

	/* the client channel on the client host */
	u_short		chan;

	/* for now, 3 channels from a client host to any given server host */
#define FIRST_CHAN_NUM	1
#define LAST_CHAN_NUM	3

	/* in msgs from server, this is id of server *process*. */
	/* in msgs from client, this is value of this field in last msg */
	/* received from a server, a hint. */
	/* - this probably doesn't make sense for the xkernel, */
	/* but must conform to protocol */
	u_short		srvr_prcss;

#define UNKNOWN_SRVR_PRCSS	((u_short) 0)
#define THE_UNIQUE_SRVR_PRCSS	((u_short) 1)

	/* sequence number is same for all msgs pertaining to same RPC */
	unsigned	seq_num;

#define INITL_SRVR_SEQ_NUM	((unsigned) 0)
#define INITL_CLNT_SEQ_NUM	((unsigned) 0)	/* gets incr before first req */

	/* zero if msg is not fragmented, otherwise number of frags in msg */ 
	u_short		num_frags;

#define NOT_FRAGMENTED	((short) 0)
#define	MAX_NUM_FRAGS	16

	/* In request or reply msgs, */
	/* I'th fragment is identified by setting I'th bit, */
	/* (this field is zero if the msg is not fragmented. */
	/* In partial naks, this field contains the summary bitmask */
	/* which indicated which fragments the receiver has. */
	u_short		frag_mask;

#define NO_FRAG_MASK	((u_short) 0)

	/* "This field contains the ID of the remote service procedure */
	/* to execute.  In REPLY messages this field contains an error code */
	/* if the [SRVR_ERR] flag is set." */
	/* NOT ANY MORE - NOW IT'S A SERVER ID (WHATEVER THAT IS) */
	SrvrId	srvrId;

#define THE_UNIQUE_SERVICE_PROC	((SrvrId) 0)
#define NO_SRVR_ERR				((SrvrId) 1)

	/* timestamp to detect client rebooting */
	unsigned	boot_id;

#define UNKNOWN_BOOT_ID	((unsigned) 0)
#define BOGUS_BOOT_ID	((unsigned) 1)

	/* how much data is in the two data parts of the msg */
	u_short		data1_sz;
	u_short		data2_sz;


	/* "relative positions of the data areas in the complete msg. */
	/* For non-fragmented msgs these fields are zero." */
	u_short		data1_offset;
	u_short		data2_offset;

#define NO_DATA_OFFSET	((u_short) 0)

} SPChdr;

#define	SPC_HDR_LEN		sizeof( SPChdr )
#define SPC_HDR_SZ		sizeof( SPChdr )


#define	MAX_SPC_DATA_SZ	((short) 1496-128)	/* Sprite fudges this a little */


D 2





E 2
/*
 * CSTATE
 */
typedef struct chan_state {

	/* familiar stuff */
	SPChdr		hdr_template;
	XObj		under_sessn;
	Bind		binding;

	IPhost		remote_host;

	/* during call, client end of a channel points back to the using sessn */
	XObj		calling_sessn;

	/* uniquely ID a call */
	unsigned	remote_boot_id;		/* ignore for now */
	unsigned	curr_seq_num;

	/* buffer for last request or reply sent from a sessn */
D 2
	MSG			sent_frag[MAX_NUM_FRAGS];
E 2
I 2
	Msg			sent_frag[MAX_NUM_FRAGS];
E 2
	short		num_sent_frags;
	SPChdr*		sent_hdr_ptr;
	u_short		sent_frag_mask;

#define	NON_FRAG_MSG_IX		0		/* a non-fragmented msg gets this index */
#define	MSG_ALREADY_FREED	17	

	/* buffer for incoming fragments */
D 2
	MSG			rcvd_frag[MAX_NUM_FRAGS];
E 2
I 2
	Msg			rcvd_frag[MAX_NUM_FRAGS];
E 2
	u_short		rcvd_frag_mask;			/* what rcvd so far */
	u_short		prev_rcvd_frag_mask;	/* what rcvd previous time checked */
	u_short		num_rcvd_frags;

#define EMPTY_FRAG_MASK		0				/* haven't rcvd any frags yet */
#define	STILL_MISSING_FRAGS	(-1)			/* don't have all frags yet */

	/* buffer for peeking at headers of incoming msgs */
	char		rcvd_hdr_peek_buf[SPC_HDR_SZ];

	/* call phase remembers state of call from perspective of one end */
	u_short		call_phase;

#define CLNT_AWAITING_REPLY			1
#define CLNT_COLLECTING_FRAGS		2
#define CLNT_QUIESCENT				3

#define SRVR_AWAITING_REQUEST		11
#define SRVR_COLLECTING_FRAGS		12
#define SRVR_SERVICE_PROC_RUNNING	13

	/* client has to pass a reply from pop to push */
D 2
	MSG			reply_data_msg;		/* buffer to pass the reply data */
E 2
I 2
	Msg			reply_data_msg;		/* buffer to pass the reply data */
E 2
	Semaphore	reply_sem;			/* signal that a reply has arrived */

#define INITL_REPLY_SEM_CNT	0

	/* only client does timeouts (so far); 	*/
	/*	these are reinitialized for each call */
	EVENT		timeout_event;	/* for canceling timeout events */
	/* timeout_interval may be changed over a series of ACKs and timeouts */
	int			timeout_interval;
	int			timeout_cnt;

#define INITL_TIMEOUT_CNT			0
#define MAX_CLNT_TIMEOUTS			5		/* I made this up */
#define INITL_CLNT_TIMEOUT_INTERVAL	300	/* milliseconds.  I made this up */

	/* link for making list of CSTATES */
	struct chan_state*	next_cstate_ptr;

} CSTATE;

D 2

E 2
#define ERR_CSTATE_PTR	((CSTATE*) (-1))


D 2




E 2
/*
 * CSTATE_HEAD
 */
typedef struct cstate_head {
	Semaphore	avail_sem;
	CSTATE*		first_cstate_ptr;
	Bind		binding;
} CSTATE_HEAD;

#define	INITL_AVAIL_SEM_CNT		0

D 2







E 2
/*
 * SPCstate
 * should there be client and server versions?
 */
typedef struct spc_state {
	BOOLEAN		is_clnt;
	Semaphore	mutex;			/* srvr allows only one request at a time */
	IPhost		remote_host;	/* just used by clnt? */
	SrvrId	srvrId;	/* just used by clnt? */
	CSTATE*		cstate_ptr;		/* just used by srvr? */
} SPCstate;


D 2






E 2
/*
 * CLNT_KEY
 */
typedef	struct clnt_key {
	IPhost		srvr_host;
	SrvrId	srvrId;
} CLNT_KEY;


D 2

E 2
/*
 * CHAN_KEY
 */
typedef	struct chan_key {
	IPhost	remote_host;
	u_short	chan;
} CHAN_KEY;


D 2

E 2
typedef u_short SRVR_KEY;


/*
 * map sizes
 */
#define CLNT_MAP_SZ			25
#define SRVR_MAP_SZ			25
#define CLNT_CHAN_MAP_SZ	50
#define SRVR_CHAN_MAP_SZ	50
#define AVAIL_CHAN_MAP_SZ	10


D 2

E 2
/*
 * size of msg stack beyond the SPC header
 * Must be enough for all underlying protocol stacks.
 */
#define	SPC_ADDL_STK_SZ		128


D 2

E 2
/*
 * msg_break macro which hides the awkward semantics
 */
#define OLD_MSG_BREAK(frag,rest,where_break,new_stk_sz)		\
		{\
D 2
			MSG		x;\
E 2
I 2
			Msg		x;\
E 2
			x = (rest);\
			msg_break( x, (rest), (where_break), (new_stk_sz) );\
			(frag) = x;\
		}


D 2

#define NULL_MSG_PTR	((MSG*)NULL)  /* doesn't have anything to do with SPC */
E 2
I 2
#define NULL_MSG_PTR	((Msg*)NULL)  /* doesn't have anything to do with SPC */
E 2
			

D 2



E 2
/*
 * declarations of globals
 */

extern	unsigned char	Spc_protl_num;
extern	XObj		SPC_SELF;
extern	IPhost		Local_host;
extern	unsigned	Local_boot_id;
extern	Map		Clnt_map;
extern	Map		Clnt_chan_map, Srvr_chan_map;
extern	Map		Srvr_map;
extern	Map		Avail_chan_map;
extern	int		spc_retrans;
extern	int		spc_total;
extern	int		spc_miss;
D 2


E 2


/*
 * declarations of global functions
 */

extern	CSTATE*	select_chan();
extern	void	free_chan();
extern	void	ensure_chans_to_srvr();
extern	void	spc_clnt_timeout();
extern	void	send_ack();
extern	void	send_partial_nak();
extern	void	reply_no_srvr();
extern	void	resend_msg();
extern	void	dump_hdr();
extern	void	abort_call();

/* #include "pad.h" */

#undef KLUDGEADDRS 
E 1
