h14164
s 00475/00564/00130
d D 1.2 91/01/10 12:11:59 llp 2 1
c Prepared for 3.1 Distribution
e
s 00694/00000/00000
d D 1.1 90/11/16 13:05:53 menze 1 0
c date and time created 90/11/16 13:05:53 by menze
e
u
U
f e 0
t
T
I 1
D 2

E 2
/* 
 * spc_clnt_chan.c
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

D 2

E 2
#include "xkernel.h"
#include "ip.h"
#include "rpcTypes.h"
#include "spc.h"
#include "spc_internal.h"

D 2

E 2
extern void	clnt_chan_timeout();

D 2







E 2
/*
 * SPC_CHAN_OPEN
 */
D 2
CSTATE*
spc_chan_open( srvr_host, chan_num )
IPhost		srvr_host;
u_short		chan_num;
{
IPaddr		localIpAd;
IPaddr		remoteIpAd;
CHAN_KEY	chan_key;
CSTATE*		cstate_ptr;
Part		vip_participants[3];
E 2

D 2

	TRACE0(spcp,4,"spc_chan_open");

	/* create and initialize a channel state */
	cstate_ptr = (CSTATE*) malloc( sizeof( CSTATE ) );
	cstate_ptr->remote_host = srvr_host;
	cstate_ptr->call_phase = CLNT_QUIESCENT;
	cstate_ptr->remote_boot_id = UNKNOWN_BOOT_ID;
	cstate_ptr->curr_seq_num = INITL_CLNT_SEQ_NUM;
	InitSemaphore( &(cstate_ptr->reply_sem), INITL_REPLY_SEM_CNT );
	cstate_ptr->num_sent_frags = MSG_ALREADY_FREED;

	/* save a SPC header template in the channel state */
	cstate_ptr->hdr_template.flags = FOR_SRVR | REQUEST;		/*default*/
	cstate_ptr->hdr_template.clnt_host = Local_host;			/*always*/
	cstate_ptr->hdr_template.srvr_host = srvr_host;				/*always*/
	cstate_ptr->hdr_template.chan = chan_num;					/*always*/
	cstate_ptr->hdr_template.srvr_prcss = UNKNOWN_SRVR_PRCSS;	/*initially*/
	/* seq_num is uninitialized */
	cstate_ptr->hdr_template.num_frags = NOT_FRAGMENTED;		/*default*/
	cstate_ptr->hdr_template.frag_mask = NO_FRAG_MASK;			/*default*/
	/* srvrId is uninitialized */
	cstate_ptr->hdr_template.boot_id = Local_boot_id;			/*always*/
	/* data1_sz is uninitialized */
	cstate_ptr->hdr_template.data2_sz = 0;						/*default*/
	cstate_ptr->hdr_template.data1_offset = NO_DATA_OFFSET;  	/*default*/
	cstate_ptr->hdr_template.data2_offset = NO_DATA_OFFSET;  	/*default*/

	/* open a VIP sessn to be used by this SPC sessn */
	localIpAd.host = Local_host;
	localIpAd.protocolnum = Spc_protl_num;
	remoteIpAd.host = srvr_host;
	remoteIpAd.protocolnum = Spc_protl_num;
	vip_participants[0].address = (char*) &localIpAd;
	vip_participants[0].length = sizeof( IPaddr );
	vip_participants[1].address = (char*) &remoteIpAd;
	vip_participants[1].length = sizeof( IPaddr );
	vip_participants[2].address = NULL;
	vip_participants[2].length = 0;
	cstate_ptr->under_sessn = x_open( SPC_SELF, SPC_SELF->down[0], vip_participants );
    TRACE1(spcp,1,"cstate->under_sessn=%x",cstate_ptr->under_sessn);
	if( cstate_ptr->under_sessn == ERR_XOBJ ){
		TRACE1(spcp,0,"spc_chan_open: cannot open IP session (x_errno=%d)",
																x_errno);
		x_destroysession( cstate_ptr->under_sessn );
		return( ERR_CSTATE_PTR );
	}

	/* add this channel to the Clnt_chan_map */
	/* assumes no channel with this key has been mapped */
	chan_key.remote_host = srvr_host;
	chan_key.chan = chan_num;
	cstate_ptr->binding = (Bind)
			map_bind( Clnt_chan_map, (char*) &chan_key, (int) cstate_ptr );

	return( cstate_ptr );

E 2
I 2
CSTATE*  spc_chan_open( srvr_host, chan_num )
     IPhost	srvr_host;
     u_short	chan_num;
{
  IPaddr	localIpAd;
  IPaddr	remoteIpAd;
  CHAN_KEY	chan_key;
  CSTATE*	cstate_ptr;
  Part		vip_participants[3];
  
  TRACE0(spcp,4,"spc_chan_open");
  
  /* create and initialize a channel state */
  cstate_ptr = (CSTATE*) malloc( sizeof( CSTATE ) );
  cstate_ptr->remote_host = srvr_host;
  cstate_ptr->call_phase = CLNT_QUIESCENT;
  cstate_ptr->remote_boot_id = UNKNOWN_BOOT_ID;
  cstate_ptr->curr_seq_num = INITL_CLNT_SEQ_NUM;
  InitSemaphore( &(cstate_ptr->reply_sem), INITL_REPLY_SEM_CNT );
  cstate_ptr->num_sent_frags = MSG_ALREADY_FREED;
  
  /* save a SPC header template in the channel state */
  cstate_ptr->hdr_template.flags = FOR_SRVR | REQUEST;	/*default*/
  cstate_ptr->hdr_template.clnt_host = Local_host;	/*always*/
  cstate_ptr->hdr_template.srvr_host = srvr_host;	/*always*/
  cstate_ptr->hdr_template.chan = chan_num;		/*always*/
  cstate_ptr->hdr_template.srvr_prcss = UNKNOWN_SRVR_PRCSS;/*initially*/
  /* seq_num is uninitialized */
  cstate_ptr->hdr_template.num_frags = NOT_FRAGMENTED;	/*default*/
  cstate_ptr->hdr_template.frag_mask = NO_FRAG_MASK;	/*default*/
  /* srvrId is uninitialized */
  cstate_ptr->hdr_template.boot_id = Local_boot_id;	/*always*/
  /* data1_sz is uninitialized */
  cstate_ptr->hdr_template.data2_sz = 0;		/*default*/
  cstate_ptr->hdr_template.data1_offset = NO_DATA_OFFSET; /*default*/
  cstate_ptr->hdr_template.data2_offset = NO_DATA_OFFSET; /*default*/
  
  /* open a VIP sessn to be used by this SPC sessn */
  localIpAd.host = Local_host;
  localIpAd.protocolnum = Spc_protl_num;
  remoteIpAd.host = srvr_host;
  remoteIpAd.protocolnum = Spc_protl_num;
  vip_participants[0].address = (char*) &localIpAd;
  vip_participants[0].length = sizeof( IPaddr );
  vip_participants[1].address = (char*) &remoteIpAd;
  vip_participants[1].length = sizeof( IPaddr );
  vip_participants[2].address = NULL;
  vip_participants[2].length = 0;
  cstate_ptr->under_sessn = x_open( SPC_SELF, SPC_SELF->down[0], 
				   vip_participants );
  TRACE1(spcp,1,"cstate->under_sessn=%x",cstate_ptr->under_sessn);
  if( cstate_ptr->under_sessn == ERR_XOBJ ){
    TRACE1(spcp,0,"spc_chan_open: cannot open IP session (x_errno=%d)",
	   x_errno);
    x_destroysession( cstate_ptr->under_sessn );
    return( ERR_CSTATE_PTR );
  }
  
  /* add this channel to the Clnt_chan_map */
  /* assumes no channel with this key has been mapped */
  chan_key.remote_host = srvr_host;
  chan_key.chan = chan_num;
  cstate_ptr->binding = (Bind)
    map_bind( Clnt_chan_map, (char*) &chan_key, (int) cstate_ptr );
  return( cstate_ptr );
E 2
} /* end spc_chan_open */


D 2






E 2
/*
 * SPC_CLNT_CHAN_DEMUX
 *
 * The client version of SPC demux.
 * Client SPCs always do opens, never do openenables,
 * so if there isn't already a session, forget it.
 */
I 2

E 2
spc_clnt_chan_demux( ip_sessn, spc_msg, hdr_ptr )
D 2
XObj	ip_sessn;
MSG		spc_msg;
SPChdr*	hdr_ptr;
E 2
I 2
     XObj	ip_sessn;
     Msg	spc_msg;
     SPChdr*	hdr_ptr;
E 2
{
D 2
CSTATE*		cstate_ptr;
CHAN_KEY	chan_key;


	TRACE0(spcp,4,"spc_clnt_chan_demux");


	/* debugging: drop specified messages */
	{	
		static	rcvd_msg_cnt = 0;

		/* NOTE: the rcvd_msg_cnt is different from sequence numbers */
		if( FALSE /*6 == rcvd_msg_cnt*/ ){
			TRACE1(spcp,1,"spc_clnt_chan_demux: DROPPING MSG #%d",rcvd_msg_cnt);
			rcvd_msg_cnt++;
			drop_msg( spc_msg );
		}else{
			TRACE1(spcp,1,"spc_clnt_chan_demux: allowing msg #%d",rcvd_msg_cnt);
			rcvd_msg_cnt++;
		}
	}

	/* see if there is a channel state for this msg */
	chan_key.remote_host = hdr_ptr->srvr_host;
	chan_key.chan = hdr_ptr->chan;
	cstate_ptr = (CSTATE*) map_resolve( Clnt_chan_map, (char*) &chan_key );
	if( cstate_ptr == ERR_CSTATE_PTR ){

		/* don't have a channel with that number to that host; drop the msg */
		TRACE1(spcp,0,"spc_clnt_chan_demux: dropping msg from bad channel %d",
														hdr_ptr->chan);
		drop_msg( spc_msg );

	}else{

		/* the channel is recognized */
		return( spc_clnt_chan_pop( cstate_ptr, spc_msg, hdr_ptr ) );
	}

E 2
I 2
  CSTATE*	cstate_ptr;
  CHAN_KEY	chan_key;
  
  TRACE0(spcp,4,"spc_clnt_chan_demux");
  
  /* debugging: drop specified messages */
  {	
    static	rcvd_msg_cnt = 0;
    
    /* NOTE: the rcvd_msg_cnt is different from sequence numbers */
    if( FALSE /*6 == rcvd_msg_cnt*/ ){
      TRACE1(spcp,1,"spc_clnt_chan_demux: DROPPING MSG #%d",rcvd_msg_cnt);
      rcvd_msg_cnt++;
      drop_msg( spc_msg );
    }else{
      TRACE1(spcp,1,"spc_clnt_chan_demux: allowing msg #%d",rcvd_msg_cnt);
      rcvd_msg_cnt++;
    }
  }
  
  /* see if there is a channel state for this msg */
  chan_key.remote_host = hdr_ptr->srvr_host;
  chan_key.chan = hdr_ptr->chan;
  cstate_ptr = (CSTATE*) map_resolve( Clnt_chan_map, (char*) &chan_key );
  if( cstate_ptr == ERR_CSTATE_PTR ){
    /* don't have a channel with that number to that host; drop the msg */
    TRACE1(spcp,0,"spc_clnt_chan_demux: dropping msg from bad channel %d",
	   hdr_ptr->chan);
    drop_msg( spc_msg );
    
  } else {
    /* the channel is recognized */
    return( spc_clnt_chan_pop( cstate_ptr, spc_msg, hdr_ptr ) );
  }
E 2
} /* end spc_clnt_chan_demux */


D 2




E 2
/*
 * SPC_CLNT_CHAN_POP
 *
 * If there is any msg to be demuxed on up,
 * it instead gets left for the caller who was blocked in spc_clnt_chan_push.
 */
I 2

E 2
spc_clnt_chan_pop( cstate_ptr, spc_msg, hdr_ptr )
D 2
CSTATE*	cstate_ptr;
MSG		spc_msg;
SPChdr* hdr_ptr;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	spc_msg;
     SPChdr*	hdr_ptr;
E 2
{
D 2

	TRACE0(spcp,3,"spc_clnt_chan_pop: dumping hdr of incoming msg:");
	dump_hdr( hdr_ptr, 3 );

	/* Check whether this msg wants an explicit ACK.
	 * Srvrs in our system never ask for ACK, but SPRITE's do
	 * (except, as side effect of sharing resend_non_frag_msg routine
	 * with clnt, srvr inadvertently asks for ACK - so what?).
	 */
	if( hdr_ptr->flags & ACK_DEMANDED ){
		TRACE0(spcp,1,"spc_clnt_chan_pop: ignoring demand for ACK");
	}

	/* check whether the msg timely - not interested if it isn't */
	if( hdr_ptr->seq_num != cstate_ptr->curr_seq_num ){
		/* drop this msg from the past or future */
		TRACE1(spcp,1,"spc_clnt_chan_pop: incoming msg has invalid seq_num: %d",
											hdr_ptr->seq_num);
		TRACE1(spcp,1,"spc_clnt_chan_pop: expected seq num %d",
											cstate_ptr->curr_seq_num );
		drop_msg( spc_msg );
	}

	/* handle based on state of client end of channel */
	if( cstate_ptr->call_phase == CLNT_AWAITING_REPLY ){
		return( clnt_awaiting_reply_pop( cstate_ptr, spc_msg, hdr_ptr ) );

	}else if( cstate_ptr->call_phase == CLNT_COLLECTING_FRAGS ){
		return( clnt_collecting_frags_pop( cstate_ptr, spc_msg, hdr_ptr ) );

	}else{		/* call_phase == CLNT_QUIESCENT */
		return( clnt_quiescent_pop( cstate_ptr, spc_msg, hdr_ptr ) );
	}

E 2
I 2
  TRACE0(spcp,3,"spc_clnt_chan_pop: dumping hdr of incoming msg:");
  dump_hdr( hdr_ptr, 3 );
  
  /* Check whether this msg wants an explicit ACK.
   * Srvrs in our system never ask for ACK, but SPRITE's do
   * (except, as side effect of sharing resend_non_frag_msg routine
   * with clnt, srvr inadvertently asks for ACK - so what?).
   */
  if( hdr_ptr->flags & ACK_DEMANDED ){
    TRACE0(spcp,1,"spc_clnt_chan_pop: ignoring demand for ACK");
  }
  
  /* check whether the msg timely - not interested if it isn't */
  if( hdr_ptr->seq_num != cstate_ptr->curr_seq_num ){
    /* drop this msg from the past or future */
    TRACE1(spcp,1,"spc_clnt_chan_pop: incoming msg has invalid seq_num: %d",
	   hdr_ptr->seq_num);
    TRACE1(spcp,1,"spc_clnt_chan_pop: expected seq num %d",
	   cstate_ptr->curr_seq_num );
    drop_msg( spc_msg );
  }
  
  /* handle based on state of client end of channel */
  if( cstate_ptr->call_phase == CLNT_AWAITING_REPLY ){
    return( clnt_awaiting_reply_pop( cstate_ptr, spc_msg, hdr_ptr ) );
  } else if( cstate_ptr->call_phase == CLNT_COLLECTING_FRAGS ){
    return( clnt_collecting_frags_pop( cstate_ptr, spc_msg, hdr_ptr ) );
    
  } else {		/* call_phase == CLNT_QUIESCENT */
    return( clnt_quiescent_pop( cstate_ptr, spc_msg, hdr_ptr ) );
  }
E 2
} /* end spc_clnt_chan_pop */


D 2



E 2
/*
 * SPC_CLNT_CHAN_PUSH
 *
 * This push is really a call, i.e. it waits for a reply
 * and returns a msg if successful.
 */
I 2

E 2
spc_clnt_chan_push( cstate_ptr, higher_level_msg, srvrId, reply_msg_ptr )
D 2
CSTATE*		cstate_ptr;
MSG			higher_level_msg;
SrvrId	srvrId;
MSG*		reply_msg_ptr;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	higher_level_msg;
     SrvrId	srvrId;
     Msg*	reply_msg_ptr;
E 2
{
D 2
int			ret_val;


	TRACE0(spcp,4,"spc_clnt_chan_push");

	/* make state transition */
	cstate_ptr->call_phase = CLNT_AWAITING_REPLY;
	cstate_ptr->curr_seq_num++;

	/* call push appropriate to whether need to fragment */
	if( msg_len( higher_level_msg ) > MAX_SPC_DATA_SZ ){
		ret_val = chan_push_frags( cstate_ptr, higher_level_msg, srvrId );
	}else{
		ret_val = chan_push_whole( cstate_ptr, higher_level_msg, srvrId );
	}
	if( ret_val < 0 ){
		return( ret_val );
	}

	/* schedule a timeout event */
	cstate_ptr->timeout_cnt = INITL_TIMEOUT_CNT;
	cstate_ptr->timeout_interval = INITL_CLNT_TIMEOUT_INTERVAL;
	cstate_ptr->timeout_event =
		event_register( clnt_chan_timeout, (int) cstate_ptr,
			cstate_ptr->timeout_interval,
				EV_ONCE | EV_CREATEPROCESS );

	/* block until the reply arrives */
	TRACE0(spcp,4,"spc_clnt_chan_push: blocking to wait for reply");
	P( &(cstate_ptr->reply_sem) );

	/* if get here, a reply has arrived */
	TRACE0(spcp,2,"spc_clnt_chan_push: got reply");
	*reply_msg_ptr = cstate_ptr->reply_data_msg;
	return( SUCCESS );

E 2
I 2
  int	ret_val;
  
  TRACE0(spcp,4,"spc_clnt_chan_push");
  
  /* make state transition */
  cstate_ptr->call_phase = CLNT_AWAITING_REPLY;
  cstate_ptr->curr_seq_num++;
  
  /* call push appropriate to whether need to fragment */
  if( msg_len( higher_level_msg ) > MAX_SPC_DATA_SZ ){
    ret_val = chan_push_frags( cstate_ptr, higher_level_msg, srvrId );
  } else {
    ret_val = chan_push_whole( cstate_ptr, higher_level_msg, srvrId );
  }
  if( ret_val < 0 ){
    return( ret_val );
  }
  
  /* schedule a timeout event */
  cstate_ptr->timeout_cnt = INITL_TIMEOUT_CNT;
  cstate_ptr->timeout_interval = INITL_CLNT_TIMEOUT_INTERVAL;
  cstate_ptr->timeout_event =
    event_register( clnt_chan_timeout, (int) cstate_ptr,
		   cstate_ptr->timeout_interval,
		   EV_ONCE | EV_CREATEPROCESS );
  
  /* block until the reply arrives */
  TRACE0(spcp,4,"spc_clnt_chan_push: blocking to wait for reply");
  P( &(cstate_ptr->reply_sem) );
  
  /* if get here, a reply has arrived */
  TRACE0(spcp,2,"spc_clnt_chan_push: got reply");
  *reply_msg_ptr = cstate_ptr->reply_data_msg;
  return( SUCCESS );
E 2
} /* end spc_clnt_chan_push */


D 2




E 2
/*
 * CLNT_CHAN_TIMEOUT
 *
 * The input argument must be an integer because
 * this routine is invoked by the Event Manager,
 * but the argument is really a CSTATE*.
 */
D 2
void
clnt_chan_timeout( cstate_ptr_int )
int	cstate_ptr_int;
E 2
I 2

void clnt_chan_timeout( cstate_ptr_int )
     int	cstate_ptr_int;
E 2
{
D 2
CSTATE*		cstate_ptr;
E 2
I 2
  CSTATE*	cstate_ptr;
  
  TRACE0(spcp,2,"spc_clnt_chan_TIMEOUT");
  cstate_ptr = (CSTATE*) cstate_ptr_int;
  
  /*
   * respond based on the phase of the current call
   */
  
  if( cstate_ptr->call_phase == CLNT_QUIESCENT ){
    
    /* this timeout was nullified between the time the timeout went off
     * and the time this timeout handler got to run.
     */
    return;
    
  } else if( cstate_ptr->call_phase == CLNT_COLLECTING_FRAGS ){
    
    /* received some but not all frags of reply */
    if(cstate_ptr->rcvd_frag_mask == cstate_ptr->prev_rcvd_frag_mask){
      
      /* haven't received any additional fragments since last timeout */
      (cstate_ptr->timeout_cnt)++;
      TRACE1(spcp,1,"clnt_chan_TIMEOUT: timeout_cnt=%d",
	     cstate_ptr->timeout_cnt );
      
      /* check if this was the last chance */
      if( cstate_ptr->timeout_cnt == MAX_CLNT_TIMEOUTS ){
	/* Server (host or procedure) is considered dead */
	TRACE0(spcp,1,"clnt_chan_timeout: TOO MANY TIMEOUTS; FAIL");
	abort_call( cstate_ptr );
	return;
      }
      /* else, server gets more chances */
      
      send_partial_nak( cstate_ptr );
      
    } else {		/* rcvd_frag_mask != prev_rcvd_frag_mask */
      /* received at least one frag since last time */
      /* remember new frag mask for next timeout */
      cstate_ptr->prev_rcvd_frag_mask = cstate_ptr->rcvd_frag_mask;
    }
    
    /* reschedule timeout */
    cstate_ptr->timeout_event =
      event_register( clnt_chan_timeout, (int) cstate_ptr,
		     cstate_ptr->timeout_interval,
		     EV_ONCE | EV_CREATEPROCESS );
    return;
E 2

D 2

	TRACE0(spcp,2,"spc_clnt_chan_TIMEOUT");
	cstate_ptr = (CSTATE*) cstate_ptr_int;


	/*
	 * respond based on the phase of the current call
	 */

	if( cstate_ptr->call_phase == CLNT_QUIESCENT ){

		/* this timeout was nullified between the time the timeout went off
		 * and the time this timeout handler got to run.
		 */
		return;


	}else if( cstate_ptr->call_phase == CLNT_COLLECTING_FRAGS ){

		/* received some but not all frags of reply */

		if(cstate_ptr->rcvd_frag_mask == cstate_ptr->prev_rcvd_frag_mask){

			/* haven't received any additional fragments since last timeout */
			(cstate_ptr->timeout_cnt)++;
			TRACE1(spcp,1,"clnt_chan_TIMEOUT: timeout_cnt=%d",
													cstate_ptr->timeout_cnt );

			/* check if this was the last chance */
			if( cstate_ptr->timeout_cnt == MAX_CLNT_TIMEOUTS ){
				/* Server (host or procedure) is considered dead */
				TRACE0(spcp,1,"clnt_chan_timeout: TOO MANY TIMEOUTS; FAIL");
				abort_call( cstate_ptr );
				return;
			}
			/* else, server gets more chances */

			send_partial_nak( cstate_ptr );

		}else{		/* rcvd_frag_mask != prev_rcvd_frag_mask */

			/* received at least one frag since last time */

			/* remember new frag mask for next timeout */
			cstate_ptr->prev_rcvd_frag_mask = cstate_ptr->rcvd_frag_mask;
		}

		/* reschedule timeout */
		cstate_ptr->timeout_event =
			event_register( clnt_chan_timeout, (int) cstate_ptr,
				cstate_ptr->timeout_interval, EV_ONCE | EV_CREATEPROCESS );

		return;


	}else{		/* call_phase == CLNT_AWAITING_REPLY */

		/* made a request but didn't get any reply */

		(cstate_ptr->timeout_cnt)++;
		TRACE1(spcp,1,"spc_clnt_chan_TIMEOUT: timeout_cnt=%d",
												cstate_ptr->timeout_cnt );

		if( cstate_ptr->timeout_cnt > MAX_CLNT_TIMEOUTS ){
			/* srvr (host or procedure) is considered dead */
			TRACE0(spcp,1,"clnt_chan_timeout: too many timeouts; fail");
			abort_call( cstate_ptr );
			return;
		}
		/* else, haven't given up on server yet */

		TRACE0(spcp,2,"clnt_chan_timeout: resending request");
		resend_msg( cstate_ptr );
	
		/* schedule a next timeout event */
		cstate_ptr->timeout_event = event_register( clnt_chan_timeout,
				(int) cstate_ptr, cstate_ptr->timeout_interval,
					EV_ONCE | EV_CREATEPROCESS );

		return;
	}

E 2
I 2
  } else {	/* call_phase == CLNT_AWAITING_REPLY */
    /* made a request but didn't get any reply */
    
    (cstate_ptr->timeout_cnt)++;
    TRACE1(spcp,1,"spc_clnt_chan_TIMEOUT: timeout_cnt=%d",
	   cstate_ptr->timeout_cnt );
    if( cstate_ptr->timeout_cnt > MAX_CLNT_TIMEOUTS ){
      /* srvr (host or procedure) is considered dead */
      TRACE0(spcp,1,"clnt_chan_timeout: too many timeouts; fail");
      abort_call( cstate_ptr );
      return;
    }
    /* else, haven't given up on server yet */
    
    TRACE0(spcp,2,"clnt_chan_timeout: resending request");
    resend_msg( cstate_ptr );
    
    /* schedule a next timeout event */
    cstate_ptr->timeout_event = event_register(clnt_chan_timeout,
					       (int) cstate_ptr,
					       cstate_ptr->timeout_interval,
					       EV_ONCE | EV_CREATEPROCESS );
    return;
  }
E 2
} /* end clnt_chan_timeout */


D 2






E 2
/*
 * SELECT_CHAN
 */
D 2
CSTATE*
select_chan( sessn )
XObj	sessn;
{
CSTATE_HEAD*	avail_cstate_head_ptr;
CSTATE*			cstate_ptr;
E 2

D 2

	/* get an unoccupied channel to the server host */
	avail_cstate_head_ptr = (CSTATE_HEAD*) map_resolve( Avail_chan_map,
						(char*) &(((SPCstate*) sessn->state)->remote_host) );
	P( &(avail_cstate_head_ptr->avail_sem) );
	cstate_ptr = avail_cstate_head_ptr->first_cstate_ptr;
	avail_cstate_head_ptr->first_cstate_ptr = cstate_ptr->next_cstate_ptr;

	/* make the channel point at the sessn */
	cstate_ptr->calling_sessn = sessn;

	return( cstate_ptr );

E 2
I 2
CSTATE*  select_chan( sessn )
     XObj	sessn;
{
  CSTATE_HEAD*	avail_cstate_head_ptr;
  CSTATE*	cstate_ptr;
  
  /* get an unoccupied channel to the server host */
  avail_cstate_head_ptr = (CSTATE_HEAD*) map_resolve( Avail_chan_map,
		     (char*) &(((SPCstate*) sessn->state)->remote_host) );
  P( &(avail_cstate_head_ptr->avail_sem) );
  cstate_ptr = avail_cstate_head_ptr->first_cstate_ptr;
  avail_cstate_head_ptr->first_cstate_ptr = cstate_ptr->next_cstate_ptr;
  
  /* make the channel point at the sessn */
  cstate_ptr->calling_sessn = sessn;
  
  return( cstate_ptr );
E 2
} /* end select_chan */


D 2



E 2
/*
 * FREE_CHAN
 */
D 2
void
free_chan( cstate_ptr )
CSTATE*		cstate_ptr;
{
CSTATE_HEAD*	avail_cstate_head_ptr;
E 2

D 2

	/* disassociate the channel from the sessn */
	cstate_ptr->calling_sessn = NULL;

	/* return the cstate to the list of unoccupied channels to its remote host*/
	avail_cstate_head_ptr = (CSTATE_HEAD*)
			map_resolve( Avail_chan_map, (char*) &(cstate_ptr->remote_host) );
	cstate_ptr->next_cstate_ptr = avail_cstate_head_ptr->first_cstate_ptr;
	avail_cstate_head_ptr->first_cstate_ptr = cstate_ptr;
	V( &(avail_cstate_head_ptr->avail_sem) );

E 2
I 2
void free_chan( cstate_ptr )
     CSTATE*	cstate_ptr;
{
  CSTATE_HEAD*	avail_cstate_head_ptr;
  
  /* disassociate the channel from the sessn */
  cstate_ptr->calling_sessn = NULL;
  
  /* return the cstate to the list of unoccupied channels to its remote host*/
  avail_cstate_head_ptr = (CSTATE_HEAD*)
    map_resolve( Avail_chan_map, (char*) &(cstate_ptr->remote_host) );
  cstate_ptr->next_cstate_ptr = avail_cstate_head_ptr->first_cstate_ptr;
  avail_cstate_head_ptr->first_cstate_ptr = cstate_ptr;
  V( &(avail_cstate_head_ptr->avail_sem) );
  
E 2
} /* end free_chan */


D 2




E 2
/*
 * ENSURE_CHANS_TO_SRVR
 */
D 2
void
ensure_chans_to_srvr( srvr_host )
IPhost	srvr_host;
{
CSTATE_HEAD*	cstate_head_ptr;
u_short			chan_num;
CSTATE*			cstate_ptr;
E 2

D 2

	if( ERR == map_resolve( Avail_chan_map, (char*) &srvr_host ) ){

		/* there are not yet any channels to the server host */

		/* make and map a head for the linked list of channel states */
		cstate_head_ptr = (CSTATE_HEAD*) malloc( sizeof( CSTATE_HEAD ) );
		cstate_head_ptr->binding = (Bind) map_bind( Avail_chan_map,
					(char*) &srvr_host, (int) cstate_head_ptr );
		cstate_head_ptr->first_cstate_ptr = (CSTATE*) NULL;
		InitSemaphore( &(cstate_head_ptr->avail_sem), INITL_AVAIL_SEM_CNT );

		/* make channel states and put them in the list */
		for( chan_num = FIRST_CHAN_NUM; chan_num <= LAST_CHAN_NUM; chan_num++ ){
			cstate_ptr = spc_chan_open( srvr_host, chan_num );
			cstate_ptr->next_cstate_ptr = cstate_head_ptr->first_cstate_ptr;
			cstate_head_ptr->first_cstate_ptr = cstate_ptr;
			V( &(cstate_head_ptr->avail_sem) );
		}
	}
E 2
I 2
void ensure_chans_to_srvr( srvr_host )
     IPhost	srvr_host;
{
  CSTATE_HEAD*	cstate_head_ptr;
  u_short	chan_num;
  CSTATE*	cstate_ptr;
  
  if( ERR == map_resolve( Avail_chan_map, (char*) &srvr_host ) ){
    
    /* there are not yet any channels to the server host */
    
    /* make and map a head for the linked list of channel states */
    cstate_head_ptr = (CSTATE_HEAD*) malloc( sizeof( CSTATE_HEAD ) );
    cstate_head_ptr->binding = (Bind) map_bind( Avail_chan_map,
					       (char*) &srvr_host,
					       (int) cstate_head_ptr );
    cstate_head_ptr->first_cstate_ptr = (CSTATE*) NULL;
    InitSemaphore( &(cstate_head_ptr->avail_sem), INITL_AVAIL_SEM_CNT );
    
    /* make channel states and put them in the list */
    for( chan_num = FIRST_CHAN_NUM; chan_num <= LAST_CHAN_NUM; chan_num++ ){
      cstate_ptr = spc_chan_open( srvr_host, chan_num );
      cstate_ptr->next_cstate_ptr = cstate_head_ptr->first_cstate_ptr;
      cstate_head_ptr->first_cstate_ptr = cstate_ptr;
      V( &(cstate_head_ptr->avail_sem) );
    }
  }
E 2
} /* end ensure_chans_to_srvr */


D 2






E 2
/*
 * ABORT_CALL
 *
 * Serious problem: if the server has received any trace of this call,
 * the server will never give up on the current sequence number,
 * so this channel is dead.  What does Sprite do?
 */
D 2
void
abort_call( cstate_ptr )
CSTATE*		cstate_ptr;
{
E 2

D 2
	TRACE0(spcp,1,"abort_call");

	/* make state transition */
	cstate_ptr->call_phase = CLNT_QUIESCENT;
	free_sent_msg( cstate_ptr );

	/* clean up any frags of reply which may have been received */
	TRACE0(spcp,1,"abort_call: don't know how free frags of reply");

	/* unblock caller with an error reply msg */
	cstate_ptr->reply_data_msg = NULL_MSG /*ERR_MSG*/;
	V( &(cstate_ptr->reply_sem) );

E 2
I 2
void  abort_call( cstate_ptr )
     CSTATE*	cstate_ptr;
{
  TRACE0(spcp,1,"abort_call");
  
  /* make state transition */
  cstate_ptr->call_phase = CLNT_QUIESCENT;
  free_sent_msg( cstate_ptr );
  
  /* clean up any frags of reply which may have been received */
  TRACE0(spcp,1,"abort_call: don't know how free frags of reply");
  
  /* unblock caller with an error reply msg */
  cstate_ptr->reply_data_msg = NULL_MSG /*ERR_MSG*/;
  V( &(cstate_ptr->reply_sem) );
  
E 2
} /* end abort_call */


D 2




E 2
/*
 * CLNT_QUIESCENT_POP
 */
I 2

E 2
clnt_quiescent_pop( cstate_ptr, spc_msg, hdr_ptr )
D 2
CSTATE*	cstate_ptr;
MSG		spc_msg;
SPChdr* hdr_ptr;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	spc_msg;
     SPChdr* 	hdr_ptr;
E 2
{
D 2

	TRACE1(spcp,2,"clnt_quiescent_pop: received msg (flags=%x)",
														hdr_ptr->flags);

	/* not interested in a damn thing from server */
	drop_msg( spc_msg );

E 2
I 2
  TRACE1(spcp,2,"clnt_quiescent_pop: received msg (flags=%x)",
	 hdr_ptr->flags);
  
  /* not interested in a damn thing from server */
  drop_msg( spc_msg );
  
E 2
} /* end clnt_quiescent_pop */


D 2




E 2
/*
 * CLNT_COLLECTING_FRAGS_POP
 */
I 2

E 2
clnt_collecting_frags_pop( cstate_ptr, spc_msg, hdr_ptr )
D 2
CSTATE*	cstate_ptr;
MSG		spc_msg;
SPChdr* hdr_ptr;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	spc_msg;
     SPChdr*	hdr_ptr;
E 2
{
D 2

	TRACE0(spcp,4,"clnt_collecting_frags_pop");

	/* only appropiate type for msg is REPLY */
	if( !(hdr_ptr->flags & REPLY) ){
		TRACE1(spcp,2,"clnt_collecting_frags_pop: msg not a REPLY (flags=%x)",
															hdr_ptr->flags);
		drop_msg( spc_msg );
	}

	/* verify that msg is only a fragment */
	if( hdr_ptr->num_frags == NOT_FRAGMENTED ){
		/* this should never happen */
		TRACE1(spcp,1,"clnt_collecting_frags_pop: msg not a frag! (flags=%x)",
															hdr_ptr->flags);
		drop_msg( spc_msg );
	}

	/* okay: msg is a fragment of a reply, collect it */
	if( rcv_frag( cstate_ptr, &spc_msg, &hdr_ptr ) == STILL_MISSING_FRAGS ){
		return( SUCCESS );
	}

	/* if get here, that fragment completed the reply */
	return( rcv_reply( cstate_ptr, spc_msg, hdr_ptr ) );

E 2
I 2
  TRACE0(spcp,4,"clnt_collecting_frags_pop");
  
  /* only appropiate type for msg is REPLY */
  if( !(hdr_ptr->flags & REPLY) ){
    TRACE1(spcp,2,"clnt_collecting_frags_pop: msg not a REPLY (flags=%x)",
	   hdr_ptr->flags);
    drop_msg( spc_msg );
  }
  
  /* verify that msg is only a fragment */
  if( hdr_ptr->num_frags == NOT_FRAGMENTED ){
    /* this should never happen */
    TRACE1(spcp,1,"clnt_collecting_frags_pop: msg not a frag! (flags=%x)",
	   hdr_ptr->flags);
    drop_msg( spc_msg );
  }
  
  /* okay: msg is a fragment of a reply, collect it */
  if( rcv_frag( cstate_ptr, &spc_msg, &hdr_ptr ) == STILL_MISSING_FRAGS ){
    return( SUCCESS );
  }
  
  /* if get here, that fragment completed the reply */
  return( rcv_reply( cstate_ptr, spc_msg, hdr_ptr ) );
  
E 2
} /* end clnt_collecting_frags_pop */


D 2




E 2
/*
 * CLNT_AWAITING_REPLY_POP
 */
I 2

E 2
clnt_awaiting_reply_pop( cstate_ptr, spc_msg, hdr_ptr )
D 2
CSTATE*	cstate_ptr;
MSG		spc_msg;
SPChdr* hdr_ptr;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	spc_msg;
     SPChdr*	hdr_ptr;
E 2
{
D 2

	TRACE0(spcp,4,"clnt_awaiting_reply_pop");

	/*
	 * determine type of msg: reply, explicit ack, partial nak
	 */

	if( hdr_ptr->flags & REPLY ){

		TRACE0(spcp,3,"clnt_awaiting_reply_pop: incoming msg is a reply");

		/* check whether the msg is only a fragment */
		if( hdr_ptr->num_frags != NOT_FRAGMENTED ){

			/* msg is only a fragment of the reply */

			/* make state transition */
			cstate_ptr->call_phase = CLNT_COLLECTING_FRAGS;
			cstate_ptr->num_rcvd_frags = 0;
			cstate_ptr->rcvd_frag_mask = EMPTY_FRAG_MASK;

			/* collect this frag; reply can't be complete so ignore return */
			rcv_frag( cstate_ptr, &spc_msg, &hdr_ptr );
			return( SUCCESS );
		}

		/* else, this is a whole, unfragmented reply */
		return( rcv_reply( cstate_ptr, spc_msg, hdr_ptr ) );


	}else if( hdr_ptr->flags & EXPLICIT_ACK ){

		/* msg is an explicit ack */
		TRACE0(spcp,3,"clnt_awaiting_reply_pop: msg is an explicit ACK");

		free_sent_msg( cstate_ptr );

		/* double the timeout interval, and reschedule the timeout */
		event_register( clnt_chan_timeout, (int) cstate_ptr,
			cstate_ptr->timeout_interval, EV_REMOVE );
		cstate_ptr->timeout_interval *= 2;
		event_register( clnt_chan_timeout, (int) cstate_ptr,
			cstate_ptr->timeout_interval, EV_ONCE | EV_CREATEPROCESS );

		drop_msg( spc_msg );


	}else if( hdr_ptr->flags & PARTIAL_NAK ){

		TRACE1(spcp,2,"clnt_awaiting_reply_pop: got partial nak %x",
														hdr_ptr->frag_mask);

		/* save the partial nak info, but don't do anything till timeout */
		cstate_ptr->sent_frag_mask |= hdr_ptr->frag_mask;
		drop_msg( spc_msg );


	}else{

		/* don't recognize the type of this msg */
		TRACE1(spcp,1,"clnt_awaiting_reply_pop: unknown msg type, flags=%s",
														hdr_ptr->flags);
		drop_msg( spc_msg );
	}

E 2
I 2
  TRACE0(spcp,4,"clnt_awaiting_reply_pop");
  
  /*
   * determine type of msg: reply, explicit ack, partial nak
   */
  
  if( hdr_ptr->flags & REPLY ){
    
    TRACE0(spcp,3,"clnt_awaiting_reply_pop: incoming msg is a reply");
    
    /* check whether the msg is only a fragment */
    if( hdr_ptr->num_frags != NOT_FRAGMENTED ){
      
      /* msg is only a fragment of the reply */
      
      /* make state transition */
      cstate_ptr->call_phase = CLNT_COLLECTING_FRAGS;
      cstate_ptr->num_rcvd_frags = 0;
      cstate_ptr->rcvd_frag_mask = EMPTY_FRAG_MASK;
      
      /* collect this frag; reply can't be complete so ignore return */
      rcv_frag( cstate_ptr, &spc_msg, &hdr_ptr );
      return( SUCCESS );
    }
    
    /* else, this is a whole, unfragmented reply */
    return( rcv_reply( cstate_ptr, spc_msg, hdr_ptr ) );
    
    
  } else if( hdr_ptr->flags & EXPLICIT_ACK ){
    
    /* msg is an explicit ack */
    TRACE0(spcp,3,"clnt_awaiting_reply_pop: msg is an explicit ACK");
    
    free_sent_msg( cstate_ptr );
    
    /* double the timeout interval, and reschedule the timeout */
    event_register( clnt_chan_timeout, (int) cstate_ptr,
		   cstate_ptr->timeout_interval, EV_REMOVE );
    cstate_ptr->timeout_interval *= 2;
    event_register( clnt_chan_timeout, (int) cstate_ptr,
		   cstate_ptr->timeout_interval, EV_ONCE | EV_CREATEPROCESS );
    
    drop_msg( spc_msg );
    
  } else if( hdr_ptr->flags & PARTIAL_NAK ){
    
    TRACE1(spcp,2,"clnt_awaiting_reply_pop: got partial nak %x",
	   hdr_ptr->frag_mask);
    
    /* save the partial nak info, but don't do anything till timeout */
    cstate_ptr->sent_frag_mask |= hdr_ptr->frag_mask;
    drop_msg( spc_msg );
    
  } else {
    
    /* don't recognize the type of this msg */
    TRACE1(spcp,1,"clnt_awaiting_reply_pop: unknown msg type, flags=%s",
	   hdr_ptr->flags);
    drop_msg( spc_msg );
  }
E 2
} /* end clnt_awaiting_reply_pop */


D 2




E 2
/*
 * RCV_REPLY
 */
I 2

E 2
rcv_reply( cstate_ptr, reply_msg, hdr_ptr )
D 2
CSTATE*		cstate_ptr;
MSG			reply_msg;
SPChdr*		hdr_ptr;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	reply_msg;
     SPChdr*	hdr_ptr;
E 2
{
D 2

	TRACE0(spcp,3,"rcv_reply");

	/* reply means this call is history;
	 * make transition to next state/call_phase
	 */
	cstate_ptr->call_phase = CLNT_QUIESCENT;

	/* clean up the fall-back stuff */
	free_sent_msg( cstate_ptr );

	/* cancel the timeout */
	event_register( clnt_chan_timeout, (int) cstate_ptr,
					cstate_ptr->timeout_interval, EV_REMOVE );

	/* stash the reply data in the state for caller in spc_clnt_chan_push */
	if( hdr_ptr->flags & SRVR_ERR ){
		/* there was a service procedure error */
		TRACE0(spcp,2,"clnt_awaiting_reply_pop: service procedure erred");
		/*cstate_ptr->reply_data_msg = (MSG) hdr_ptr->srvrId;*/
		cstate_ptr->reply_data_msg = NULL_MSG;
		msg_free( reply_msg );
	}else{
		/* the reply is good */
		if ((!reply_msg.data) || (reply_msg.data->tag != NM_Contig)) {
			spc_miss++;
		}
		cstate_ptr->reply_data_msg = msg_truncateleft( reply_msg, SPC_HDR_LEN );
		TRACE2(spcp,5,"rcv_reply: msg sz = %d, spc data sz = %d",
					msg_len( cstate_ptr->reply_data_msg ), hdr_ptr->data1_sz );
		
	}

	/* alert caller blocked in spc_clnt_chan_push that his reply arrived */
	TRACE0(spcp,4,"clnt_awaiting_reply_pop: V'ing reply_sem");
	V( &(cstate_ptr->reply_sem) );

	/* do NOT call higher level demux, just hit the showers */
	return( SUCCESS );

E 2
I 2
  TRACE0(spcp,3,"rcv_reply");
  
  /* reply means this call is history;
   * make transition to next state/call_phase
   */
  cstate_ptr->call_phase = CLNT_QUIESCENT;
  
  /* clean up the fall-back stuff */
  free_sent_msg( cstate_ptr );
  
  /* cancel the timeout */
  event_register( clnt_chan_timeout, (int) cstate_ptr,
		 cstate_ptr->timeout_interval, EV_REMOVE );
  
  /* stash the reply data in the state for caller in spc_clnt_chan_push */
  if( hdr_ptr->flags & SRVR_ERR ){
    /* there was a service procedure error */
    TRACE0(spcp,2,"clnt_awaiting_reply_pop: service procedure erred");
    /*cstate_ptr->reply_data_msg = (Msg) hdr_ptr->srvrId;*/
    cstate_ptr->reply_data_msg = NULL_MSG;
    msg_free( reply_msg );
  } else {
    /* the reply is good */
    if ((!reply_msg.data) || (reply_msg.data->tag != NM_Contig)) {
      spc_miss++;
    }
    cstate_ptr->reply_data_msg = msg_truncateleft( reply_msg, SPC_HDR_LEN );
    TRACE2(spcp,5,"rcv_reply: msg sz = %d, spc data sz = %d",
	   msg_len( cstate_ptr->reply_data_msg ), hdr_ptr->data1_sz );
  }
  
  /* alert caller blocked in spc_clnt_chan_push that his reply arrived */
  TRACE0(spcp,4,"clnt_awaiting_reply_pop: V'ing reply_sem");
  V( &(cstate_ptr->reply_sem) );
  
  /* do NOT call higher level demux, just hit the showers */
  return( SUCCESS );
  
E 2
} /* end rcv_reply */
E 1
