h11021
s 00301/00355/00088
d D 1.2 91/01/10 12:11:50 llp 2 1
c Prepared for 3.1 Distribution
e
s 00443/00000/00000
d D 1.1 90/11/16 13:05:50 menze 1 0
c date and time created 90/11/16 13:05:50 by menze
e
u
U
f e 0
t
T
I 1
/* 
 * spc_chan.c
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

D 2

E 2
#include "xkernel.h"
#include "ip.h"
#include "rpcTypes.h"
#include "spc.h"
#include "spc_internal.h"


D 2








E 2
/*
 * CHAN_PUSH_WHOLE
 */
I 2

E 2
chan_push_whole( cstate_ptr, msg, srvrId )
D 2
CSTATE*		cstate_ptr;
MSG			msg;
SrvrId	srvrId;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	msg;
     SrvrId	srvrId;
E 2
{
D 2
SPChdr*		hdr_ptr;
int			data_sz;


	TRACE0(spcp,4,"chan_push_whole");

	/* put an SPC header on the front of this msg */
	data_sz = msg_len( msg );
	hdr_ptr = (SPChdr*) msg_push( msg, SPC_HDR_SZ );
	*hdr_ptr = cstate_ptr->hdr_template;
	hdr_ptr->seq_num = cstate_ptr->curr_seq_num;
	hdr_ptr->srvrId = srvrId;
	hdr_ptr->data1_sz = data_sz;
	
	/* save a copy of the msg */
	msg_save( cstate_ptr->sent_frag[NON_FRAG_MSG_IX], msg );
	cstate_ptr->sent_hdr_ptr = hdr_ptr;
	cstate_ptr->num_sent_frags = NOT_FRAGMENTED;

	TRACE0(spcp,5,"chan_push_whole: pushing msg down under_sessn");
	return( x_push( cstate_ptr->under_sessn, msg, NULL_MSG_PTR ) );

E 2
I 2
  SPChdr*	hdr_ptr;
  int		data_sz;
  
  TRACE0(spcp,4,"chan_push_whole");
  
  /* put an SPC header on the front of this msg */
  data_sz = msg_len( msg );
  hdr_ptr = (SPChdr*) msg_push( msg, SPC_HDR_SZ );
  *hdr_ptr = cstate_ptr->hdr_template;
  hdr_ptr->seq_num = cstate_ptr->curr_seq_num;
  hdr_ptr->srvrId = srvrId;
  hdr_ptr->data1_sz = data_sz;
  
  /* save a copy of the msg */
  msg_save( cstate_ptr->sent_frag[NON_FRAG_MSG_IX], msg );
  cstate_ptr->sent_hdr_ptr = hdr_ptr;
  cstate_ptr->num_sent_frags = NOT_FRAGMENTED;
  
  TRACE0(spcp,5,"chan_push_whole: pushing msg down under_sessn");
  return( x_push( cstate_ptr->under_sessn, msg, NULL_MSG_PTR ) );
  
E 2
} /* end chan_push_whole */


D 2




E 2
/*
 * CHAN_PUSH_FRAGS
 */
I 2

E 2
chan_push_frags( cstate_ptr, spc_data_msg, srvrId )
D 2
CSTATE*		cstate_ptr;
MSG			spc_data_msg;
SrvrId	srvrId;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	spc_data_msg;
     SrvrId	srvrId;
E 2
{
D 2
u_short		num_frags;
SPChdr		frag_hdr_template;
SPChdr*		frag_hdr_ptr;
u_short		frag_num;
u_short		frag_mask;
u_short		frag_data_offset;
MSG			frag_msg;
int			data_sz;


	TRACE0(spcp,4,"chan_push_frags");

	/* determine the number of fragments */
  	num_frags = ( (msg_len( spc_data_msg ) - 1) / MAX_SPC_DATA_SZ) + 1;
  	TRACE1(spcp,3,"chan_push_frags: number of frags = %d",num_frags);
	if( num_frags > MAX_NUM_FRAGS ){
		TRACE1(spcp,1,"chan_push_frags: msg too big (%d)",
											msg_len( spc_data_msg ));
		return( ERR );
	}

	/* make a more specified copy of the SPC header template */
	frag_hdr_template = cstate_ptr->hdr_template;
	frag_hdr_template.seq_num = cstate_ptr->curr_seq_num;
	frag_hdr_template.srvrId = srvrId;
	frag_hdr_template.num_frags = num_frags;
	frag_hdr_template.data1_sz = MAX_SPC_DATA_SZ;

	/* do all the fragments except the last */
	for(	frag_num = 0, frag_mask = 0x0001, frag_data_offset = 0;
			frag_num < num_frags - 1;
			frag_num++, frag_mask <<= 1, frag_data_offset += MAX_SPC_DATA_SZ ){

		/* break off the next fragment of SPC data */
		OLD_MSG_BREAK( frag_msg, spc_data_msg, MAX_SPC_DATA_SZ+msg_stack_len(spc_data_msg),SPC_ADDL_STK_SZ );
			
		/* put an spc header on the fragment */
		frag_hdr_ptr = (SPChdr*) msg_push( frag_msg, SPC_HDR_SZ );
		*frag_hdr_ptr = frag_hdr_template;
		frag_hdr_ptr->frag_mask = frag_mask;
		frag_hdr_ptr->data1_offset = frag_data_offset;

		/* save a copy of this fragment */
		msg_save( cstate_ptr->sent_frag[frag_num], frag_msg );

		/* push the msg for this fragment */
		TRACE0(spcp,5,"chan_push_frags: pushing msg down under_sessn");
		x_push( cstate_ptr->under_sessn, frag_msg, NULL_MSG_PTR );
	}

	/* now do the last fragment, which is everything left in spc_data_msg */

	/* fill in the header */
	data_sz = msg_len( spc_data_msg );
	frag_hdr_ptr = (SPChdr*) msg_push( spc_data_msg, SPC_HDR_SZ );
	*frag_hdr_ptr = frag_hdr_template;
	frag_hdr_ptr->frag_mask = frag_mask;
	frag_hdr_ptr->data1_offset = frag_data_offset;
	frag_hdr_ptr->flags |= LAST_FRAG;					/* diff for last frag */
	frag_hdr_ptr->data1_sz = data_sz;	/* diff for last frag */
	
	/* save the msg for this fragment */
	msg_save( cstate_ptr->sent_frag[frag_num], spc_data_msg );

	/* push the msg for this fragment */
	TRACE0(spcp,5,"chan_push_frags: pushing last frag down under_sessn");
	x_push( cstate_ptr->under_sessn, spc_data_msg, NULL_MSG_PTR );

	/* prepare for possible resending - already have the frag msgs */
	cstate_ptr->num_sent_frags = num_frags;
	cstate_ptr->sent_frag_mask = EMPTY_FRAG_MASK;

	return( SUCCESS );

E 2
I 2
  u_short	num_frags;
  SPChdr	frag_hdr_template;
  SPChdr*	frag_hdr_ptr;
  u_short	frag_num;
  u_short	frag_mask;
  u_short	frag_data_offset;
  Msg		frag_msg;
  int		data_sz;
  
  TRACE0(spcp,4,"chan_push_frags");
  
  /* determine the number of fragments */
  num_frags = ( (msg_len( spc_data_msg ) - 1) / MAX_SPC_DATA_SZ) + 1;
  TRACE1(spcp,3,"chan_push_frags: number of frags = %d",num_frags);
  if( num_frags > MAX_NUM_FRAGS ){
    TRACE1(spcp,1,"chan_push_frags: msg too big (%d)",
	   msg_len( spc_data_msg ));
    return( ERR );
  }
  
  /* make a more specified copy of the SPC header template */
  frag_hdr_template = cstate_ptr->hdr_template;
  frag_hdr_template.seq_num = cstate_ptr->curr_seq_num;
  frag_hdr_template.srvrId = srvrId;
  frag_hdr_template.num_frags = num_frags;
  frag_hdr_template.data1_sz = MAX_SPC_DATA_SZ;
  
  /* do all the fragments except the last */
  for(	frag_num = 0, frag_mask = 0x0001, frag_data_offset = 0;
      frag_num < num_frags - 1;
      frag_num++, frag_mask <<= 1, frag_data_offset += MAX_SPC_DATA_SZ ){
    
    /* break off the next fragment of SPC data */
    OLD_MSG_BREAK( frag_msg, spc_data_msg, 
		  MAX_SPC_DATA_SZ+msg_stack_len(spc_data_msg),
		  SPC_ADDL_STK_SZ );
    
    /* put an spc header on the fragment */
    frag_hdr_ptr = (SPChdr*) msg_push( frag_msg, SPC_HDR_SZ );
    *frag_hdr_ptr = frag_hdr_template;
    frag_hdr_ptr->frag_mask = frag_mask;
    frag_hdr_ptr->data1_offset = frag_data_offset;
    
    /* save a copy of this fragment */
    msg_save( cstate_ptr->sent_frag[frag_num], frag_msg );
    
    /* push the msg for this fragment */
    TRACE0(spcp,5,"chan_push_frags: pushing msg down under_sessn");
    x_push( cstate_ptr->under_sessn, frag_msg, NULL_MSG_PTR );
  }
  
  /* now do the last fragment, which is everything left in spc_data_msg */
  
  /* fill in the header */
  data_sz = msg_len( spc_data_msg );
  frag_hdr_ptr = (SPChdr*) msg_push( spc_data_msg, SPC_HDR_SZ );
  *frag_hdr_ptr = frag_hdr_template;
  frag_hdr_ptr->frag_mask = frag_mask;
  frag_hdr_ptr->data1_offset = frag_data_offset;
  frag_hdr_ptr->flags |= LAST_FRAG;	/* diff for last frag */
  frag_hdr_ptr->data1_sz = data_sz;	/* diff for last frag */
  
  /* save the msg for this fragment */
  msg_save( cstate_ptr->sent_frag[frag_num], spc_data_msg );
  
  /* push the msg for this fragment */
  TRACE0(spcp,5,"chan_push_frags: pushing last frag down under_sessn");
  x_push( cstate_ptr->under_sessn, spc_data_msg, NULL_MSG_PTR );
  
  /* prepare for possible resending - already have the frag msgs */
  cstate_ptr->num_sent_frags = num_frags;
  cstate_ptr->sent_frag_mask = EMPTY_FRAG_MASK;
  
  return( SUCCESS );
  
E 2
} /* end chan_push_frags */


D 2






E 2
/*
 * RESEND_MSG_FRAGS
 */
D 2
void
resend_msg_frags( cstate_ptr )
CSTATE*		cstate_ptr;
{
int			frag_num;
u_short		frag_select_mask;
E 2

D 2

	TRACE1(spcp,2,"resend_msg_frags: sent_frag_mask=%x",
													cstate_ptr->sent_frag_mask);

	/* for each frag in the sent super-msg ... */
	for( 				frag_num = 0, frag_select_mask = 0x0001;
						frag_num < cstate_ptr->num_sent_frags;
						frag_num++, frag_select_mask <<= 1 ){

		/* check whether this frag has been acked */
		if( !(cstate_ptr->sent_frag_mask & frag_select_mask) ){
			MSG temp;

			/* this frag is unacked; resend it */
			TRACE1(spcp,5,"resend_msg_frags: resending frag w/ mask %x",
															frag_select_mask);
			msg_save( temp,
					  cstate_ptr->sent_frag[frag_num] );
			x_push( cstate_ptr->under_sessn, temp,
														NULL_MSG_PTR );
		}
	}
	return;

E 2
I 2
void  resend_msg_frags( cstate_ptr )
     CSTATE*	cstate_ptr;
{
  int		frag_num;
  u_short	frag_select_mask;
  
  TRACE1(spcp,2,"resend_msg_frags: sent_frag_mask=%x",
	 cstate_ptr->sent_frag_mask);
  
  /* for each frag in the sent super-msg ... */
  for( 				frag_num = 0, frag_select_mask = 0x0001;
      frag_num < cstate_ptr->num_sent_frags;
      frag_num++, frag_select_mask <<= 1 ){
    
    /* check whether this frag has been acked */
    if( !(cstate_ptr->sent_frag_mask & frag_select_mask) ){
      Msg temp;
      
      /* this frag is unacked; resend it */
      TRACE1(spcp,5,"resend_msg_frags: resending frag w/ mask %x",
	     frag_select_mask);
      msg_save( temp,
	       cstate_ptr->sent_frag[frag_num] );
      x_push( cstate_ptr->under_sessn, temp,
	     NULL_MSG_PTR );
    }
  }
  return;
  
E 2
} /* end resend_msg_frags */


D 2




E 2
/*
 * RESEND_NON_FRAG_MSG
 */
D 2
void
resend_non_frag_msg( cstate_ptr )
CSTATE*		cstate_ptr;
{
	MSG temp;
E 2

D 2
	/* ensure that ACK_DEMANDED is set on any resends (of a non-frag msg) */
	if( cstate_ptr->timeout_cnt = 1 ){
		cstate_ptr->sent_hdr_ptr->flags |= ACK_DEMANDED;
	}


	msg_save( temp, cstate_ptr->sent_frag[NON_FRAG_MSG_IX] );
	
	x_push( cstate_ptr->under_sessn, temp,
												NULL_MSG_PTR );
	return;

E 2
I 2
void  resend_non_frag_msg( cstate_ptr )
     CSTATE*	cstate_ptr;
{
  Msg	 temp;
  
  /* ensure that ACK_DEMANDED is set on any resends (of a non-frag msg) */
  if( cstate_ptr->timeout_cnt = 1 ){
    cstate_ptr->sent_hdr_ptr->flags |= ACK_DEMANDED;
  }
  
  msg_save( temp, cstate_ptr->sent_frag[NON_FRAG_MSG_IX] );
  
  x_push( cstate_ptr->under_sessn, temp,
	 NULL_MSG_PTR );
  return;
  
E 2
} /* end resend_non_frag_msg */


D 2




E 2
/*
 * RESEND_MSG
 */
D 2
void
resend_msg( cstate_ptr )
CSTATE*		cstate_ptr;
{
E 2

D 2
	TRACE1(spcp,3,"resend_msg: num_sent_frags=%d",cstate_ptr->num_sent_frags);

	if( cstate_ptr->num_sent_frags == MSG_ALREADY_FREED ){
		return;

	}else if( cstate_ptr->num_sent_frags == NOT_FRAGMENTED ){
		resend_non_frag_msg( cstate_ptr );

	}else{
		resend_msg_frags( cstate_ptr );
	}

	return;

E 2
I 2
void  resend_msg( cstate_ptr )
     CSTATE*	cstate_ptr;
{
  TRACE1(spcp,3,"resend_msg: num_sent_frags=%d",cstate_ptr->num_sent_frags);
  
  if( cstate_ptr->num_sent_frags == MSG_ALREADY_FREED ){
    return;
    
  }else if( cstate_ptr->num_sent_frags == NOT_FRAGMENTED ){
    resend_non_frag_msg( cstate_ptr );
    
  }else{
    resend_msg_frags( cstate_ptr );
  }
  
  return;
  
E 2
} /* end resend_msg */


D 2





E 2
/*
 * RCV_FRAG
 */
I 2

E 2
rcv_frag( cstate_ptr, frag_msg_ptr, hdr_ptr_ptr )
D 2
CSTATE*		cstate_ptr;
MSG*		frag_msg_ptr;		/* in and out param */
SPChdr**	hdr_ptr_ptr;		/* in and out param */
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg*	frag_msg_ptr;		/* in and out param */
     SPChdr**	hdr_ptr_ptr;		/* in and out param */
E 2
{
D 2
SPChdr*		hdr_ptr;
MSG			accum_msg;
u_short		frag_num;


	TRACE0(spcp,4,"rcv_frag");

	hdr_ptr = *hdr_ptr_ptr;		/* for readability */

	/* if get duplicate fragment, throw it away, and NAK */
	if( hdr_ptr->frag_mask & cstate_ptr->rcvd_frag_mask ){
		TRACE1(spcp,3,"rcv_frag: already have frag %x",hdr_ptr->frag_mask);
		send_partial_nak( cstate_ptr );
		msg_free( *frag_msg_ptr );
		return( STILL_MISSING_FRAGS );
	}

	/* this is a new frag, add it to collection */
	cstate_ptr->rcvd_frag[ mask_to_num( hdr_ptr->frag_mask ) ] = *frag_msg_ptr;
	cstate_ptr->rcvd_frag_mask |= hdr_ptr->frag_mask;
	cstate_ptr->num_rcvd_frags++;

	/* check whether this fragment completes the super-msg */
	if( cstate_ptr->num_rcvd_frags == hdr_ptr->num_frags ){

		TRACE0(spcp,3,"rcv_frag: this frag completes the super-msg");

		/* have all the fragments, put them together (only first keeps hdr) */
		accum_msg = cstate_ptr->rcvd_frag[0];
		for( frag_num = 1; frag_num < cstate_ptr->num_rcvd_frags; frag_num++ ){
			msg_pop( cstate_ptr->rcvd_frag[frag_num], SPC_HDR_SZ );
			msg_join( accum_msg, accum_msg, cstate_ptr->rcvd_frag[frag_num] );
		}

		/* fix up the "out" parameters - hdr will be that of the first frag */
		*frag_msg_ptr = accum_msg;
		*hdr_ptr_ptr = (SPChdr*) msg_top( accum_msg, SPC_HDR_SZ );
		return( SUCCESS );

	}else{		/* super-msg is not complete */

		/* if this was LAST_FRAG, then NAK */
		if( hdr_ptr->flags & LAST_FRAG ){
			TRACE0(spcp,3,"rcv_frag: got LAST_FRAG, but not all");
			send_partial_nak( cstate_ptr );
		}

		return( STILL_MISSING_FRAGS );
	}

E 2
I 2
  SPChdr*	hdr_ptr;
  Msg		accum_msg;
  u_short	frag_num;
  
  TRACE0(spcp,4,"rcv_frag");
  
  hdr_ptr = *hdr_ptr_ptr;		/* for readability */
  
  /* if get duplicate fragment, throw it away, and NAK */
  if( hdr_ptr->frag_mask & cstate_ptr->rcvd_frag_mask ){
    TRACE1(spcp,3,"rcv_frag: already have frag %x",hdr_ptr->frag_mask);
    send_partial_nak( cstate_ptr );
    msg_free( *frag_msg_ptr );
    return( STILL_MISSING_FRAGS );
  }
  
  /* this is a new frag, add it to collection */
  cstate_ptr->rcvd_frag[ mask_to_num( hdr_ptr->frag_mask ) ] = *frag_msg_ptr;
  cstate_ptr->rcvd_frag_mask |= hdr_ptr->frag_mask;
  cstate_ptr->num_rcvd_frags++;
  
  /* check whether this fragment completes the super-msg */
  if( cstate_ptr->num_rcvd_frags == hdr_ptr->num_frags ){
    
    TRACE0(spcp,3,"rcv_frag: this frag completes the super-msg");
    
    /* have all the fragments, put them together (only first keeps hdr) */
    accum_msg = cstate_ptr->rcvd_frag[0];
    for( frag_num = 1; frag_num < cstate_ptr->num_rcvd_frags; frag_num++ ){
      msg_pop( cstate_ptr->rcvd_frag[frag_num], SPC_HDR_SZ );
      msg_join( accum_msg, accum_msg, cstate_ptr->rcvd_frag[frag_num] );
    }
    
    /* fix up the "out" parameters - hdr will be that of the first frag */
    *frag_msg_ptr = accum_msg;
    *hdr_ptr_ptr = (SPChdr*) msg_top( accum_msg, SPC_HDR_SZ );
    return( SUCCESS );
    
  }else{		/* super-msg is not complete */
    
    /* if this was LAST_FRAG, then NAK */
    if( hdr_ptr->flags & LAST_FRAG ){
      TRACE0(spcp,3,"rcv_frag: got LAST_FRAG, but not all");
      send_partial_nak( cstate_ptr );
    }
    
    return( STILL_MISSING_FRAGS );
  }
  
E 2
} /* end rcv_frag */


D 2




E 2
/*
 * SEND_PARTIAL_NAK
 */
D 2
void
send_partial_nak( cstate_ptr )
CSTATE*	cstate_ptr;
{
MSG			nak_msg;
SPChdr*		hdr_ptr;
E 2

D 2

	TRACE0(spcp,3,"send_partial_nak");


	/* make a msg consisting only of a header */
	msg_make_allstack( nak_msg, SPC_ADDL_STK_SZ,
							(char*) &(cstate_ptr->hdr_template), SPC_HDR_SZ );
	hdr_ptr = (SPChdr*) msg_top( nak_msg, SPC_HDR_SZ );
	/* don't disturb the FOR_SRVR bit */
	hdr_ptr->flags |= PARTIAL_NAK;
	hdr_ptr->flags &= ~(REQUEST | REPLY);
	hdr_ptr->frag_mask = cstate_ptr->rcvd_frag_mask;
	hdr_ptr->seq_num = cstate_ptr->curr_seq_num;
	hdr_ptr->data1_sz = 0;

	x_push( cstate_ptr->under_sessn, nak_msg, NULL_MSG_PTR );

E 2
I 2
void  send_partial_nak( cstate_ptr )
     CSTATE*	cstate_ptr;
{
  Msg		nak_msg;
  SPChdr*	hdr_ptr;
  
  TRACE0(spcp,3,"send_partial_nak");
  
  
  /* make a msg consisting only of a header */
  msg_make_allstack( nak_msg, SPC_ADDL_STK_SZ,
		    (char*) &(cstate_ptr->hdr_template), SPC_HDR_SZ );
  hdr_ptr = (SPChdr*) msg_top( nak_msg, SPC_HDR_SZ );
  /* don't disturb the FOR_SRVR bit */
  hdr_ptr->flags |= PARTIAL_NAK;
  hdr_ptr->flags &= ~(REQUEST | REPLY);
  hdr_ptr->frag_mask = cstate_ptr->rcvd_frag_mask;
  hdr_ptr->seq_num = cstate_ptr->curr_seq_num;
  hdr_ptr->data1_sz = 0;
  
  x_push( cstate_ptr->under_sessn, nak_msg, NULL_MSG_PTR );
  
E 2
} /* end send_partial_nak */


D 2




E 2
/*
 * SEND_ACK
 */
D 2
void
send_ack( cstate_ptr )
CSTATE*	cstate_ptr;
{
MSG			ack_msg;
SPChdr*		hdr_ptr;
E 2

D 2

	TRACE0(spcp,3,"send_ack");

	/* make a msg consisting only of a header */
	msg_make_allstack( ack_msg, SPC_ADDL_STK_SZ,
							(char*) &(cstate_ptr->hdr_template), SPC_HDR_SZ );
	hdr_ptr = (SPChdr*) msg_top( ack_msg, SPC_HDR_SZ );
	/* don't disturb the FOR_SERVER bit */
	hdr_ptr->flags |= EXPLICIT_ACK;
	hdr_ptr->flags &= ~(REQUEST | REPLY);
	hdr_ptr->seq_num = cstate_ptr->curr_seq_num;
	hdr_ptr->data1_sz = 0;

	x_push( cstate_ptr->under_sessn, ack_msg, NULL_MSG_PTR );

E 2
I 2
void  send_ack( cstate_ptr )
     CSTATE*	cstate_ptr;
{
  Msg		ack_msg;
  SPChdr*	hdr_ptr;
  
  TRACE0(spcp,3,"send_ack");
  
  /* make a msg consisting only of a header */
  msg_make_allstack( ack_msg, SPC_ADDL_STK_SZ,
		    (char*) &(cstate_ptr->hdr_template), SPC_HDR_SZ );
  hdr_ptr = (SPChdr*) msg_top( ack_msg, SPC_HDR_SZ );
  /* don't disturb the FOR_SERVER bit */
  hdr_ptr->flags |= EXPLICIT_ACK;
  hdr_ptr->flags &= ~(REQUEST | REPLY);
  hdr_ptr->seq_num = cstate_ptr->curr_seq_num;
  hdr_ptr->data1_sz = 0;
  
  x_push( cstate_ptr->under_sessn, ack_msg, NULL_MSG_PTR );
  
E 2
} /* end send_ack */


D 2





E 2
/*
 * MASK_TO_NUM
 *
 * Is there a library routine for this?
 */
I 2

E 2
mask_to_num( orig_mask )
D 2
u_short		orig_mask;
E 2
I 2
     u_short	orig_mask;
E 2
{
D 2
u_short		compare_mask;
int			num;


	compare_mask = 0x0001;
	num = 0;

	while( compare_mask != orig_mask ){
		compare_mask <<= 1;
		num++;
	}

	return( num );

E 2
I 2
  u_short	compare_mask;
  int		num;
  
  compare_mask = 0x0001;
  num = 0;
  
  while( compare_mask != orig_mask ){
    compare_mask <<= 1;
    num++;
  }
  
  return( num );
  
E 2
} /* end mask_to_num */


D 2





E 2
/*
 * FREE_SENT_MSG
 */
D 2
void
free_sent_msg( cstate_ptr )
CSTATE*		cstate_ptr;
{
int			frag_num;
E 2

D 2

	TRACE0(spcp,4,"free_sent_msg");

	if( cstate_ptr->num_sent_frags == MSG_ALREADY_FREED ){
		return;

	}else if( cstate_ptr->num_sent_frags == NOT_FRAGMENTED ){
		msg_free( cstate_ptr->sent_frag[NON_FRAG_MSG_IX] );

	}else{

		/* sent msg was fragmented; free the frags */
		for( frag_num = 0; frag_num < cstate_ptr->num_sent_frags; frag_num++ ){
			msg_free( cstate_ptr->sent_frag[frag_num] );
		}
	}		

	cstate_ptr->num_sent_frags = MSG_ALREADY_FREED;
	return;

E 2
I 2
void  free_sent_msg( cstate_ptr )
     CSTATE*	cstate_ptr;
{
  int		frag_num;
  
  TRACE0(spcp,4,"free_sent_msg");
  
  if( cstate_ptr->num_sent_frags == MSG_ALREADY_FREED ){
    return;
    
  }else if( cstate_ptr->num_sent_frags == NOT_FRAGMENTED ){
    msg_free( cstate_ptr->sent_frag[NON_FRAG_MSG_IX] );
    
  }else{
    
    /* sent msg was fragmented; free the frags */
    for( frag_num = 0; frag_num < cstate_ptr->num_sent_frags; frag_num++ ){
      msg_free( cstate_ptr->sent_frag[frag_num] );
    }
  }		
  
  cstate_ptr->num_sent_frags = MSG_ALREADY_FREED;
  return;
  
E 2
} /* end free_sent_msg */
E 1
