h37438
s 00101/00144/00168
d D 1.2 91/01/10 12:11:46 llp 2 1
c Prepared for 3.1 Distribution
e
s 00312/00000/00000
d D 1.1 90/11/16 13:05:48 menze 1 0
c date and time created 90/11/16 13:05:48 by menze
e
u
U
f e 0
t
T
I 1
/* 
 * spc.c
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
E 2
 *
D 2
 *
E 2
 * Contains:
 *	spc_init
 *	spc_demux
 *	spc_push
 *	dump_hdr
 *
 *
 * Contains dummies:
 *	spc_opendone		- This work gets done in spc_srvr_demux.
 *	spc_pop			- There isn't an spc_pop; instead popping code
 *					gets called directly by demux code.
 *	spc_close		- not implemented (yet)
 *	spc_controlprotl	- not implemented yet
 *	spc_controlsessn	- not implemented yet
 *
 *
 * Does NOT contain:
 *	spc_open		- It's in spc_clnt, since only clients call it.
 *	spc_openenable		- It's in spc_srvr, since only servers call it.
 */

D 2

E 2
#include "xkernel.h"
#include "ip.h"
#include "rpcTypes.h"
#include "spc.h"
#include "spc_internal.h"

D 2


E 2
int tracespcp=0;

extern XObj spc_open();
extern int spc_openenable();

D 2


E 2
/*
 * global data for SPC
 */

unsigned char	Spc_protl_num;	
I 2
IPhost		Local_host;
unsigned	Local_boot_id =	BOGUS_BOOT_ID;
E 2

D 2
IPhost			Local_host;

unsigned		Local_boot_id = 	BOGUS_BOOT_ID;

Map		Clnt_map;			/* srvr_host+srvrId	=> sessn */
Map		Clnt_chan_map;		/* chan+remote_host	=> cstate */
Map		Srvr_chan_map;		/* chan+remote_host	=> cstate */
Map		Srvr_map;			/* srvrId => sessn */
E 2
I 2
Map		Clnt_map;		/* srvr_host+srvrId => sessn */
Map		Clnt_chan_map;		/* chan+remote_host => cstate */
Map		Srvr_chan_map;		/* chan+remote_host => cstate */
Map		Srvr_map;		/* srvrId => sessn */
E 2
Map		Avail_chan_map;		/* remote_host => cstate list*/

int spc_miss=0;

XObj SPC_SELF=0;
XObj IP=0;

D 2




E 2
static spc_instantiateprotl(self)
D 2
XObj self;
E 2
I 2
     XObj self;
E 2
{
D 2

E 2
  TRACE0(spcp,1,"spc instantiateprotl");
  SPC_SELF = self;
  IP = x_getprotlbyname("ip");
  Spc_protl_num = 45;	
D 2
  
E 2
}


/*
 * SPC_INIT
 */
static spc_init(self)
D 2
XObj self;
E 2
I 2
     XObj self;
E 2
{
D 2
IPaddr	localIpAddr;
Part	vip_participants[ 2 ];


	TRACE0(spcp,4,"spc_init");

	/* create the maps used by SPC */
	Clnt_map = map_create( CLNT_MAP_SZ, sizeof(CLNT_KEY));
	Clnt_chan_map = map_create( CLNT_CHAN_MAP_SZ, sizeof(CHAN_KEY));
	Srvr_chan_map = map_create( SRVR_CHAN_MAP_SZ, sizeof(CHAN_KEY));
	Srvr_map = map_create( SRVR_MAP_SZ, sizeof(SRVR_KEY));
	Avail_chan_map = map_create( AVAIL_CHAN_MAP_SZ, 4 );

	/* get id (IPhost) of local host */
	x_controlprotl( IP, MYADDR, (char*) &Local_host, IPADLEN );

	/* tell IP that SPC is willing to accept msgs (this is for servers) */
	localIpAddr.host = Local_host;
	localIpAddr.protocolnum = Spc_protl_num;
	vip_participants[0].address = (char*) &localIpAddr;
	vip_participants[0].length = sizeof( IPaddr );
	vip_participants[1].address = NULL;
	vip_participants[1].length = 0;
	x_openenable( SPC_SELF, SPC_SELF->down[0], vip_participants );

	return( SUCCESS );

E 2
I 2
  IPaddr	localIpAddr;
  Part	vip_participants[ 2 ];
  
  TRACE0(spcp,4,"spc_init");
  /* create the maps used by SPC */
  Clnt_map = map_create( CLNT_MAP_SZ, sizeof(CLNT_KEY));
  Clnt_chan_map = map_create( CLNT_CHAN_MAP_SZ, sizeof(CHAN_KEY));
  Srvr_chan_map = map_create( SRVR_CHAN_MAP_SZ, sizeof(CHAN_KEY));
  Srvr_map = map_create( SRVR_MAP_SZ, sizeof(SRVR_KEY));
  Avail_chan_map = map_create( AVAIL_CHAN_MAP_SZ, 4 );
  
  /* get id (IPhost) of local host */
  x_controlprotl( IP, GETMYADDR, (char*) &Local_host, IPADLEN );
  
  /* tell IP that SPC is willing to accept msgs (this is for servers) */
  localIpAddr.host = Local_host;
  localIpAddr.protocolnum = Spc_protl_num;
  vip_participants[0].address = (char*) &localIpAddr;
  vip_participants[0].length = sizeof( IPaddr );
  vip_participants[1].address = NULL;
  vip_participants[1].length = 0;
  x_openenable( SPC_SELF, SPC_SELF->down[0], vip_participants );
  
  return( SUCCESS );
E 2
} /* end spc_init */


D 2



E 2
/*
 * SPC_PUSH
 *
 * Determine whether this is a client sessn or a server sessn,
 * and invoke the corresponding version of push.
 */
I 2

E 2
spc_push( sessn, higher_level_msg, reply_msg_ptr )
D 2
XObj	sessn;
MSG		higher_level_msg;
MSG*	reply_msg_ptr;
E 2
I 2
     XObj	sessn;
     Msg		higher_level_msg;
     Msg*	reply_msg_ptr;
E 2
{
D 2

	TRACE0(spcp,4,"spc_push");

	if( ((SPCstate*) sessn->state)->is_clnt ){
		if( reply_msg_ptr == (MSG*) NULL ){
			return( ERR );
		}else{
			return(spc_clnt_push( sessn, higher_level_msg, reply_msg_ptr ));
		}
	}else{
		return( spc_srvr_push( sessn, higher_level_msg ) );
	}

E 2
I 2
  TRACE0(spcp,4,"spc_push");
  
  if( ((SPCstate*) sessn->state)->is_clnt ){
    if( reply_msg_ptr == (Msg*) NULL ){
      return( ERR );
    }else{
      return(spc_clnt_push( sessn, higher_level_msg, reply_msg_ptr ));
    }
  }else{
    return( spc_srvr_push( sessn, higher_level_msg ) );
  }
E 2
} /* end spc_push */


D 2





E 2
/*
 * SPC_DEMUX
 *
 * Determine whether this msg is for a server, or a client,
 * and invoke the corresponding version of demux.
 */
I 2

E 2
spc_demux( self, ip_sessn, spc_msg )
D 2
XObj	self;
XObj	ip_sessn;
MSG		spc_msg;
E 2
I 2
     XObj	self;
     XObj	ip_sessn;
     Msg	spc_msg;
E 2
{
D 2
SPChdr*	hdr_ptr;


	TRACE0(spcp,3,"received a message in spc_demux\n");
	hdr_ptr = (SPChdr*) msg_top( spc_msg, SPC_HDR_SZ );
	if( hdr_ptr->flags & FOR_SRVR ){
		return( spc_srvr_chan_demux( ip_sessn, spc_msg, hdr_ptr ) );
	}else{
		return( spc_clnt_chan_demux( ip_sessn, spc_msg, hdr_ptr ) );
	}

E 2
I 2
  SPChdr*	hdr_ptr;
  
  TRACE0(spcp,3,"received a message in spc_demux\n");
  hdr_ptr = (SPChdr*) msg_top( spc_msg, SPC_HDR_SZ );
  if( hdr_ptr->flags & FOR_SRVR ){
    return( spc_srvr_chan_demux( ip_sessn, spc_msg, hdr_ptr ) );
  }else{
    return( spc_clnt_chan_demux( ip_sessn, spc_msg, hdr_ptr ) );
  }
E 2
} /* end spc_demux */


D 2




E 2
/*
 * SPC_CLOSE
 *
 * This closes a sessn; what about channels?
 */
I 2

E 2
spc_close( sessn )
D 2
XObj	sessn;
E 2
I 2
     XObj	sessn;
E 2
{
D 2

	TRACE1(spcp,1,"spc_close: session %x", sessn );

	if( --(sessn->rcnt) == 0 ){

		/* no-one refers to this sessn, so tear it down */
		map_unbindbinding( Clnt_map, sessn->binding );
		x_destroysession( sessn );
	}

	return( SUCCESS );

E 2
I 2
  TRACE1(spcp,1,"spc_close: session %x", sessn );
  
  if( --(sessn->rcnt) == 0 ){
    /* no-one refers to this sessn, so tear it down */
    map_unbindbinding( Clnt_map, sessn->binding );
    x_destroysession( sessn );
  }
  return( SUCCESS );
E 2
} /* end spc_close */


D 2



E 2
/*
 * SPC_CONTROLPROTL
 *
 *
 */
I 2

E 2
spc_controlprotl(self, opcode, buf_ptr, buf_len )
D 2
XObj 	self;
int	opcode;
char*	buf_ptr;
int	buf_len;
E 2
I 2
     XObj 	self;
     int	opcode;
     char*	buf_ptr;
     int	buf_len;
E 2
{
D 2

E 2
} /* end spc_controlsessn */


D 2



E 2
/*
 * SPC_CONTROLSESSN
 *
 * NOT IMPLEMENTED (YET).
 */
I 2

E 2
spc_controlsessn( sessn, opcode, buf_ptr, buf_len )
D 2
XObj	sessn;
int	opcode;
char*	buf_ptr;
int	buf_len;
E 2
I 2
     XObj	sessn;
     int	opcode;
     char*	buf_ptr;
     int	buf_len;
E 2
{
} /* end spc_controlprotl */


D 2



E 2
/*
 * SPC_POP
 */
I 2

E 2
spc_pop( spc_sessn, down_s, spc_msg )
D 2
XObj	spc_sessn;
XObj    down_s;
MSG	spc_msg;
E 2
I 2
     XObj	spc_sessn;
     XObj    down_s;
     Msg	spc_msg;
E 2
{
}


D 2



E 2
/*
 * SPC_OPENDONE
 */
spc_opendone( sessn, participants )
D 2
XObj	sessn;
Part*	participants;
E 2
I 2
     XObj	sessn;
     Part*	participants;
E 2
{
}


D 2



E 2
/*
 * DUMP_HDR
 */
D 2
void
dump_hdr( hdr_ptr, trace_level )
SPChdr*	hdr_ptr;
int		trace_level;
E 2
I 2

void dump_hdr( hdr_ptr, trace_level )
     SPChdr*	hdr_ptr;
     int	trace_level;
E 2
{
D 2
	TRACE5(spcp,trace_level,
		"seq_num=%d   chan=%d   flags=%x   srvrId=%d   data1_sz=%d",
						hdr_ptr->seq_num, hdr_ptr->chan, hdr_ptr->flags,
						hdr_ptr->srvrId, hdr_ptr->data1_sz );
E 2
I 2
  TRACE5(spcp,trace_level,
	 "seq_num=%d   chan=%d   flags=%x   srvrId=%d   data1_sz=%d",
	 hdr_ptr->seq_num, hdr_ptr->chan, hdr_ptr->flags,
	 hdr_ptr->srvrId, hdr_ptr->data1_sz );
E 2
}

/* fill in a protocol or session object with correct stuff */
I 2

E 2
spc_getproc(p,type)
D 2
XObj p;
XobjType type;
E 2
I 2
     XObj p;
     XObjType type;
E 2
{
  if (type == Protocol) {
    p->instantiateprotl = spc_instantiateprotl;
    p->init = spc_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = spc_controlprotl;
  } else {
    p->push = spc_push;
    p->pop = spc_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->close = spc_close;
    p->control = spc_controlsessn;
  }
  p->demux = spc_demux;
  p->open = (Pfi) spc_open;
  p->openenable = spc_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->getproc = spc_getproc;
}
E 1
