/* 
 * sim_ether.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "ethernet.h"
#include "sim_ether.h"
#include "sim_ether_i.h"

/* global data of ethernet protocol */

static	ETHhost	myetheraddr;
static	Map	activeMap;
static	Map	passiveMap;
static  XObj    ETH;
/* interfaces to/from machine */

int	readether2demux();
extern	char	*init_ether();

static char NETNUM[16];

ETHhost BCAST;

static int ether_port;
static	int	_e;

int traceethp;


/*********************************************
*
* Ethernet Device
*
*********************************************/

char *init_ether(ih)
     Pfi	ih;
{
  struct  sockaddr_in	addr;
  struct  hostent *h;
  struct  in_addr *in;
  int	on = 1;
  char *n, *inet_ntoa(), *strcpy();
  char	name[100];
  int	namelen=100;
  static char	myetheraddr[7];
  char **rp;

  TRACE0(ethp, 3, "init_ether");

#ifdef XSIMUL
  for (rp = rom; *rp; rp += 3) {
    if (!strcmp(*rp, "eth")) {
      ether_port = atoi(rp[1]);
      break;
    }
  }
#endif
  TRACE1(ethp, 3, "init_ether: listening on port %d", ether_port);
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = INADDR_ANY;
  addr.sin_port = htons((unsigned short)ether_port);
  if ((_e = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
    TRACE0(ethp, 1, "init_ether: cannot open socket");
    exit(1);
  }	
  setsockopt(_e, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof (on));
#ifdef SO_BROADCAST
  setsockopt(_e, SOL_SOCKET, SO_BROADCAST, (char *)&on, sizeof (on));
#endif
  if (bind(_e, (struct sockaddr *)&addr, sizeof(addr))) {
    TRACE0(ethp, 1, "init_ether: cannot bind socket");
    exit(1);
  }
  installSignalHandler(_e, ih);
  if (fcntl(_e,F_SETFL,(FASYNC | FNDELAY)) == -1)
    perror("fcntl async");
  if (fcntl(_e,F_SETOWN,getpid()) == -1)
    perror("fcntl setown");
  gethostname(name,namelen);
  h = gethostbyname(name);
  in = (struct in_addr *) h->h_addr;
  strcpy(NETNUM, inet_ntoa(*in));
  for (n = NETNUM + strlen(NETNUM) - 1; *n != '.'; n--) {
    *n = '\0';
  }
#ifdef vax
  sprintf(myetheraddr,"%2d%4d", ((*(unsigned *)in >>24) & 0xff), ether_port);
#else
  sprintf(myetheraddr,"%2d%4d", (*(unsigned *)in & 0xff), ether_port);
#endif vax
  if (*myetheraddr == ' ')
    *myetheraddr = '0';
  TRACE1(ethp, 2, "init_ether: ethernet started with address :%s:",
	 myetheraddr);
  bcopy(myetheraddr, (char *)&BCAST, EADLEN);
  bcopy("00", (char *)&BCAST, 2);
  return myetheraddr;
}

write_ether(msg,len)
     char	*msg;
     int	len;
{
  extern unsigned long inet_addr();
  struct  sockaddr_in	addr;
  char	dest[7];	/* simulated destination ETH address */
  char	dest_host[20];	/* real destination IP address */
  int	dest_port;	/* UDP port simulating ETH on dest host */
  int	hostid;
  
  TRACE0(ethp, 5, "write_ether");

  bcopy(msg,dest,6);
  *(dest+7) = '\0';
  TRACE1(ethp, 5, "write_ether: destination: %s", dest);
  /*
   * destination IP host and the appropriate UDP port are extracted from
   * the simulated ETH address ("dest")
   */
  sscanf(dest+2,"%4d",&dest_port);
  sscanf(dest,"%2d",&hostid);
  sprintf(dest_host,"%s%d",NETNUM,hostid);
  bzero((char *)&addr, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = inet_addr(dest_host);
  addr.sin_port = htons((unsigned short)dest_port);
  TRACE3(ethp, 5, "write_ether: sending %d bytes to <%d,%s>",
	 len, dest_port, dest_host);
  if (sendto(_e, msg, len, 0, (struct sockaddr *)&addr,
	     sizeof(struct sockaddr)) != len) {
    TRACE0(ethp, 3, "write_ether: error in sendto");
    perror("sendto");
    exit(1);
  }
  TRACE0(ethp, 5, "End of write_ether");
}


read_ether(msg,len)
     char	*msg;
     int	len;
{
  struct  sockaddr_in	from;
  int	size,n;
  
  TRACE0(ethp, 5, "read_ether");

  size = sizeof(from);
  if ((n = recvfrom(_e, msg, len, 0, (struct sockaddr *)&from, &size)) < 0)
    return -1;
  TRACE3(ethp, 5, "read_ether: receiving %d bytes from <%d,%s>",
	 n, ntohs(from.sin_port),inet_ntoa(from.sin_addr.s_addr));
  return n;
}


eth_init(self)
     XObj self;
{
  TRACE0(ethp, 3, "eth_init");

  ETH = self;
  bcopy(init_ether(readether2demux),(char *)&myetheraddr,EADLEN);
  activeMap = map_create(100, sizeof(ActiveID));
  passiveMap = map_create(50, sizeof(PassiveID));
}


Sessn eth_open(self, hlp, p)
     XObj	self, hlp;
     Part	*p;
{
  Sessn   s;
  struct  eheader *e_hdr;
  ETHaddr localAddr, remoteAddr;
  ActiveID activeKey;
  
  TRACE0(ethp, 3, "eth_open");

  assert(self == ETH);
  if (!p) {
    x_errno = BAD_ADDR;
    return ERR_SESSN;
  }
  localAddr = get_part(p, 0, ETHaddr);
  remoteAddr = get_part(p, 1, ETHaddr);
  TRACE4(ethp, 4, "eth_open: destination address = %4x.%4x.%4x:%4x",
	 remoteAddr.host.high, remoteAddr.host.mid, remoteAddr.host.low,
	 remoteAddr.type);
  activeKey = remoteAddr;
  if ((s=(Sessn)map_resolve(activeMap, (char *)&activeKey)) != ERR_SESSN) {
    s->rcnt++;
    return s;
  }
  s = x_createsession(hlp, ETH, 0);
  s->binding = map_bind(activeMap, (char *)&activeKey, (int)s);
  e_hdr = (struct eheader *) malloc(sizeof(struct eheader));
  e_hdr->e_src = myetheraddr;
  e_hdr->e_dest = remoteAddr.host;
  e_hdr->e_ptype = htons(remoteAddr.type);
  s->rcnt = 1;
  s->state = (char *) e_hdr;
  TRACE1(ethp, 3, "eth_open: returning %x\n", s);
  return s;
}


eth_openenable(self, hlp, p)
     XObj	self, hlp;
     Part	*p;
{
  PassiveID  passiveKey;
  ETHaddr    localaddr;
  
  TRACE0(ethp, 3, "eth_openenable");

  assert(self == ETH);
  assert(x_is_protocol(self));
  assert(x_is_protocol(hlp));
  localaddr = get_part(p, 0, ETHaddr);
  TRACE2(ethp, 4, "eth_openenable: hlp=%d, protlNum=%x", hlp, localaddr.type);
  passiveKey = localaddr.type;
  if (map_bind(passiveMap, (char *) &passiveKey, (int) hlp) == ERR_BIND &&
      x_errno==INCONSISTENT_BIND) {
      x_errno = ALREADY_OPEN;
      return -1;
  }
  return 0;
}


eth_close(s)
     Sessn	s;
{
  if (--s->rcnt > 0)
    return 0;
  map_unbindbinding(activeMap, s->binding);
  x_destroysession(s);
  return 0;
}


/*ARGSUSED*/
eth_push(s, msg, rmsg)
     Sessn	s;
     Msg	msg, *rmsg;
{
  struct eheader *hdr;
  
  TRACE0(ethp, 5, "eth_push\n");
  
  hdr = (struct eheader *)msg_push(msg, sizeof(struct eheader));
  *hdr = *(struct eheader *)s->state;
  push2writeether(msg);
  return 0;
}


eth_demux(self, s, msg)
     XObj self;
     Sessn	s;
     Msg	msg;
{
  struct  eheader  *hdr;
  Part  Part[3];
  XObj	hlp;
  Sessn	eth_s;
  ETHaddr remoteAddr, localAddr;
  ActiveID activeKey;
  PassiveID passiveKey;
  
  TRACE0(ethp, 4, "in ether demux");

  assert(self == 0);
  
  if ((hdr = (struct eheader *)msg_top(msg, EHLEN)) == (struct eheader *)-1) {
      TRACE0(ethp, 3, "eth_demux: incoming message too small!");
      return -1;
  }
  hdr->e_ptype = ntohs((unsigned short)hdr->e_ptype);
  activeKey.type = hdr->e_ptype;
  activeKey.host = hdr->e_src;
  TRACE4(ethp, 6, "eth_demux: <host, id> = <%4x.%4x.%4x, 0x%x>",
	 activeKey.host.high, activeKey.host.mid, activeKey.host.low,
	 activeKey.type);
  if ((eth_s=(Sessn)map_resolve(activeMap, (char *)&activeKey)) != ERR_SESSN) {
      TRACE0(ethp, 5, "eth_demux: found active session");
      return x_pop(eth_s, s, msg);
  }
  passiveKey = hdr->e_ptype;
  if ((hlp=(XObj)map_resolve(passiveMap, (char *)&passiveKey)) != ERR_XOBJ) {
    TRACE0(ethp, 5, "eth_demux: found openenable");
    remoteAddr.host = hdr->e_src;
    remoteAddr.type = localAddr.type = hdr->e_ptype;
    localAddr.host = myetheraddr;
    init_partlist(Part, 2, ETHaddr);
    set_part(Part, 0, localAddr);
    set_part(Part, 1, remoteAddr);
    eth_s = x_opendone(hlp, ETH, Part);
    return x_pop(eth_s, s, msg);
  }
  TRACE0(ethp, 5,
	 "eth_demux: No active session or openenable.  Dropping msg");
  return 0;
}


/*ARGSUSED*/
eth_pop(s, delivery_s, msg)
     Sessn	s, delivery_s;
     Msg	msg;
{
  TRACE0(ethp, 5, "eth_pop");

  msg_pop(msg, sizeof(struct eheader));
  return x_demux(s, msg);
}


/*ARGSUSED*/
eth_controlsessn(s, opcode, buf, len)
     Sessn	s;
     int	opcode;
     char	*buf;
     int	len;
{
  struct eheader *sstate;

  TRACE1(ethp, 5, "eth_controlsessn (opcode = %d)", opcode);

  sstate = (struct eheader *)s->state;
  switch (opcode) {
  case GETMYADDR:
    if (len<EADLEN) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    }
    else {
      bcopy((char *)&myetheraddr, buf, EADLEN);
      return EADLEN;
    }
  case GETPEERADDR:
    if (len<EADLEN) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    }
    else {
      bcopy((char *)&sstate->e_dest, buf, EADLEN);
      return EADLEN;
    }
  case GETPROTO:
    if (len < sizeof(u_short)) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    }
    else {
      *(u_short *) buf = sstate->e_ptype;
      return sizeof(u_short);
    }
  case GETMAXPACKET:
    if(len<sizeof(int)) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    } else {
      *(int *)buf = EDLEN;
      return sizeof(int);
    }
  default:
    TRACE0(ethp, 1, "eth_controlsessn: invalid opcode");
    x_errno = INVALID_OPCODE;
    return -1;
  }
}


eth_controlprotl(self, opcode, buf, len)
     XObj	self;
     int	opcode;
     char	*buf;
     int	len;
{
  TRACE1(ethp, 5, "eth_controlprotl (opcode = %d)", opcode);

  assert(self == ETH);
  switch (opcode) {
  case GETMYADDR:
    if (len<EADLEN) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    }
    else {
      bcopy((char *)&myetheraddr, buf, EADLEN);
      return EADLEN;
    }
  case GETMAXPACKET:
    if(len<sizeof(int)) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    } else {
      *(int *)buf = EDLEN;
      return sizeof(int);
    }
  default:
    x_errno = INVALID_OPCODE;
    return -1;
  }
}


/***************************************
/*  Special function needed because we
/*  sit right on top of the device;
/*  in effect, the device driver
/***************************************/
  
readether2demux()
{
  Msg	msg;
  int	buflen;
  static char buf[EMAXPAK+sizeof(struct eheader)];
  
  TRACE0(ethp, 7, "readether2demux");

  while ((buflen = read_ether(buf, EMAXPAK)) != -1) {
    msg_make_allstack(msg, 16, buf, buflen);
    CreateProcess(eth_demux, 0, 5, 2 + (sizeof(Msg)+3) / 4, NULL, NULL, msg);
  }
  return 0;
}


push2writeether(packet)
     Msg	packet;
{
  int	len;
  char	buffer[EMAXPAK];
  
  TRACE0(ethp, 7, "push2writeether");

  len = msg_len(packet);
  msg_externalize(packet, buffer);
  write_ether(buffer, len);
  return 0;
}

eth_getproc(p,type)
     XObj p;
     XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = noop;
    p->init = eth_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = eth_controlprotl;
  } else {
    p->push = eth_push;
    p->pop = eth_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->control = eth_controlsessn;
    p->close = eth_close;
  }
  p->open = (Pfi) eth_open;
  p->openenable = eth_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = eth_demux;
  p->getproc = eth_getproc;
}

