/*
 * pmap3.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include <rpc/rpc.h>
#include "xkernel.h"
#include "ip.h"
#include "udp.h"
#include "sun_rpc.h"
#include "pmap.h"
#include "pmap_internal.h"

int *pmapproc_getport();

static XObj SELF=0;
#define SUNRPC SELF->down[0]
#define PMAP3 SELF
int tracepmap3p = 0;

static pmap3_instantiateprotl(self) 
XObj self;
{
  TRACE0(pmap3p, 1, "PMAP3 instanciateprotl");

  if (SELF) {
    Kabort("SUN Portmapper 3: can't instanciate twice");
  }
  SELF = self;
  return 0;
}


static pmap3_init(self)
XObj self;
{

  Part part[2];
  SUNRPCaddr server;
  IPhost myipaddr;


  if (x_controlprotl(SUNRPC, GETMYADDR, (char *)&myipaddr, 
		     sizeof myipaddr) < 0) {
    printf("Can't find my IP addr\n");
    return(-1);
  }


  /* create address */
  server.prog = PMAP_PROG;
  server.vers = PMAP_VERS;
  server.proc = PMAPPROC_GETPORT;
  server.prot = 17;
  server.host.port = PMAP_PORT; 
  server.host.host = myipaddr;;
 
  init_partlist(part, 1, SUNRPCaddr); 
  set_part(part, 0, server);
  x_openenable(PMAP3, SUNRPC, part);
  return(0);
}


static pmap3_demux(self,s, msg)
XObj	self,s;
Msg msg;
{
  char *buf;
  int len;
  char buf2[100];
  int len2;
  PMAP_ARGS args;
  int *results;
  Msg msg2;
  TRACE2(pmap3p,1,"pmap3_demux: msg = %d msg_len = %d",msg,msg_len(msg));  

  /* externalize message */
  len = msg_len(msg);
  buf = (char *) malloc(len + 2);
  msg_externalize(msg,buf);

  TRACE0(pmap3p,7,"pmap3_demux: msg externalized");  

  /* check authentication */


  /* decode arguments */
  if (decode_xdr(xdr_pmap,buf,len,&args) == -1) {;
    TRACE0(pmap3p,7,"pmap3_demux: can't decode args");  
    x_controlsessn(s, SUNRPC_SVCGARBAGEARGS,0,0);
    return(-1);
  }
  TRACE0(pmap3p,7,"pmap3_demux: args decoded ");  
  

  /* call procedure */ 
  results = pmapproc_getport(&args);
  TRACE0(pmap3p,7,"pmap3_demux: procedure called  ");  
  

  /* xdr results */
  if (results != 0) { 
    if ((len2 = encode_xdr(xdr_int,buf2,100,results)) == -1) {;
      x_controlsessn(s, SUNRPC_SVCGARBAGEARGS,0,0);
      free(results);
      return(-1);
    } else {
      free(results);
    }
  } else {
    x_controlsessn(s, SUNRPC_SVCSYSTEMERR,0,0);
    return(-1);
  }

  TRACE0(pmap3p,7,"pmap3_demux: results xdred  ");  
  /* set authentication */

  IFTRACE(pmap3p,7) {
  printf("server_demux: len2 = %d buf2 = %d\n",len2,buf2);
  print_xdr(buf2,len);
  }

  /* internalize message */
  msg_make_allstack(msg2,256,buf2,len2);
  
  TRACE0(pmap3p,7,"pmap3_demux: msg internalized");  
  /* reply to call */
  x_push(s,msg2,(Msg *) 0);
  free(buf);
  return(0);
}

static pmap3_opendone(self,s,part)
XObj s,self;
Part part;
{
  TRACE0(pmap3p,7,"--->pmap3_opendone");
}
static int * pmapproc_getport(args)
PMAP_ARGS *args;
{
  PMAP_EXT_ID ext_id;
  int *reply;
  int temp;


  TRACE0(pmap3p,1,"pmap_getport: entered\n");
  IFTRACE(pmap3p,1) print_pmap(args);

  ext_id.prog = args->prog;
  ext_id.vers = args->vers;
  ext_id.prot = args->prot;

  reply = (int *) malloc(sizeof(int));
  *reply = map_resolve(port_map,&ext_id);
  if (*reply == -1) {
    TRACE0(pmap3p,3,"pmap_getargs: can't find program\n");
    *reply = 0;
  }

  TRACE1(pmap3p,1,"pmap_getport: port = %d\n",*reply);
  return(reply);
}


pmap3_getproc(p,type)
XObj p;
XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = pmap3_instantiateprotl;
    p->init = pmap3_init;
  } else {
    p->instantiateprotl = noop;
    p->init = noop;
  }
  p->close = noop;
  p->control = noop;
  p->push = noop; 
  p->pop = noop;
  p->open = (Pfi) noop;
  p->openenable = noop;
  p->opendone = pmap3_opendone;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = pmap3_demux;
  p->getproc = pmap3_getproc;
}

