/* 
 * blast.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef blast_h
#define blast_h

/* Protocol number which IP uses to identify BLAST */
#define BLAST_IP_PROT 100 

/* Protocol number ("type") which ETH uses to identify BLAST */
#define BLAST_ETH_TYPE 0x1234

#define BLASTADLEN  sizeof(BLASTaddr)

#define MAX_FRAG_LEN 1440
#define MAX_DGM 16*1024  	/* Largest supported datagram */


/* timeout calculations: timeout = CONST (msec) * number_of_fragments */

#define REC_CONST 50	
#define SEND_CONST 100

#define BLAST_MAX_TRIES(m) (((m)/MAX_FRAG_LEN) + 1) 
#define BLAST_REC_DELAY(m) (((m)/MAX_FRAG_LEN)*REC_CONST)
#define BLAST_SEND_DELAY(m) (((m)/MAX_FRAG_LEN)*SEND_CONST)

/* Default number of concurrent outstanding messages allowed
 * (per protocol instantiation)
 */
#define OUTSTANDING_MESSAGES 64

#define BLAST_SETOUTSTANDINGMSGS (BLAST_CTL*MAXOPS + 0)
#define BLAST_GETOUTSTANDINGMSGS (BLAST_CTL*MAXOPS + 1)

typedef struct blastaddr {
	IPhost  host;
	int	prot;
} BLASTaddr;
 

#define FULLMASK 0xffff

extern int traceblastp;

#endif blast_h
