h10230
s 00016/00000/00092
d D 1.3 91/02/11 18:09:05 menze 3 2
c blast now asks the llp for the appropriate fragmentation size
e
s 00005/00003/00087
d D 1.2 91/01/10 11:44:42 llp 2 1
c Prepared for 3.1 Distribution
e
s 00090/00000/00000
d D 1.1 90/11/16 10:52:54 menze 1 0
c date and time created 90/11/16 10:52:54 by menze
e
u
U
f e 0
t
T
I 1
/* 
 * blast_internal.h
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

D 2
#pragma once
E 2
I 2
#ifndef blast_internal_h
#define blast_internal_h
E 2
 
#define BLASTHLEN  sizeof(BLAST_HDR) 
#define BLASTEXTIDLEN sizeof(EXT_ID);

#define BLAST_SEND 1
#define BLAST_NACK 2
#define BLAST_RETRANSMIT 3
 
#define BLAST_OK 2
#define BLAST_FAIL 2
#define MAX_FRAGS 16
I 3

#define MAX_FRAG_LEN (pstate->fragmentSize)
#define MAX_DGM (16*MAX_FRAG_LEN)  	/* Largest supported datagram */

/* timeout calculations: timeout = CONST (msec) * number_of_fragments */

#define REC_CONST 50	
#define SEND_CONST 100

#define BLAST_MAX_TRIES(m) (((m)/MAX_FRAG_LEN) + 1) 
#define BLAST_REC_DELAY(m) (((m)/MAX_FRAG_LEN)*REC_CONST)
#define BLAST_SEND_DELAY(m) (((m)/MAX_FRAG_LEN)*SEND_CONST)

#define FULLMASK 0xffff
E 3
 
typedef struct  {
	unsigned int op;
	IPhost	rec;
	IPhost	send;
	unsigned int prot_id;
	unsigned int seq;
        unsigned short num_frag;
	unsigned short mask;
	unsigned int len;
} BLAST_HDR;

typedef struct {
        unsigned int seq;
	BLAST_HDR send_hdr;
	BLAST_HDR rec_hdr;
D 2
	MSG frags[MAX_FRAGS+1];
E 2
I 2
	Msg frags[MAX_FRAGS+1];
E 2
	unsigned short mask;
	unsigned short old_mask;
	unsigned int wait;
        Bind binding;

        int *state;
        int event;
        int nack_sent;
} MSG_STATE;

typedef struct {
        unsigned int prot_id;
        int client;
        BLAST_HDR short_hdr;
	BLAST_HDR cur_hdr;
        Map send_map;
        Map rec_map;
        MSG_STATE *rec_cache;
        MSG_STATE *send_cache;
  	XObj down_s;
	IPhost send;
	IPhost rec;
	BLASTaddr myBLASTaddr;
	BLASTaddr peerBLASTaddr;
	XObj self;
I 3
	Semaphore recMapAccess;
E 3
} BLAST_STATE;

typedef struct {
	Map active_map;
	Map passive_map;
	IPaddr myIPaddr;
	ETHaddr myETHaddr;
	int max_seq;
	Semaphore access;
	Semaphore outstanding_messages;
	int max_outstanding_messages;
I 3
	int fragmentSize;
E 3
} PSTATE;

typedef struct {
	IPhost send;
 	IPhost rec;
        unsigned int prot_id;
} ActiveID;

typedef BLASTaddr PassiveID;
	

#ifndef SPRITE_FLUSH
#define SPRITE_FLUSH
#define flush_msg(m) { if (!msg_isnull(m)) {msg_free(m); msg_clear(m);}}
#define flush_event(e) { if (e) {event_removeevent(e); e=0;}}
#endif

I 2
#endif
E 2
E 1
