h62382
s 00139/00000/00000
d D 1.1 91/01/10 11:10:12 llp 1 0
c date and time created 91/01/10 11:10:12 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * init.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "process.h"
#include "memory.h"
#include "trap.h"
#include "clock.h"
#include "ms_romvec.h"
#include "ms_exception.h"

#define HLP 	0
#define DEV	1

int XInitialized = 0;

extern void	InitProtocols();
int	InitRest();
int	callUserMain();

#define EXTRABSSSTUFF (100 * 1024)

InitKernel()
{
  extern int start;
  extern char edata, end;
  bzero(&edata, &end - &edata);
  localInit();
  TRACE0(memoryinit, 1, "IXK screen");
  InitScreen();
  TRACE0(memoryinit, 1, "IXK exceptions");
  Ms_InitExceptions();
  TRACE0(memoryinit, 1, "IXK memory");
  InitMemory();
  TRACE0(memoryinit, 1, "IXK processes");
  InitProcesses();
  TRACE0(memoryinit, 1, "IXK clock");
  InitClock();
  TRACE0(memoryinit, 1, "IXK protocols");
  InitProtocols(DEV);
  CreateKernelProcess(InitRest, 6, 0);
  XInitialized = 1;
  Idle();		/* Now function as the idle process */
}

void ExecUser(argc, argv)
int argc;
char **argv;
/*
 * Initialize the user code in user space.
 */
{
  extern char BeginUser, EndUser;
  unsigned realUserSize = (unsigned) (&EndUser - &BeginUser);
  unsigned userSize = realUserSize + EXTRABSSSTUFF;
  Aspace *as, *CreateAspace(), *oldas;

  int x = spl7();
  as = CreateAspace();
  TRACE1(user, 1, "User assigned address space %x", as);
  TRACE2(user, 1, "User size is %x, %d pages", userSize,
    (userSize + PAGE_SIZE - 1)/PAGE_SIZE);
  SetAspaceSize(as, (char *)(ASPACE_START + userSize));

  oldas = GetAddressableAspace();
  TRACE1(memoryinit, 5, "execUser: oldas is %x",oldas);
  SetAddressableAspace(as);
  bcopy(&BeginUser, (char *)ASPACE_START, (int)realUserSize);
  bzero((char *)(ASPACE_START + realUserSize), (int)(userSize - realUserSize));
  CreateProcess(as, callUserMain, 0, 20, 1, 2, argc, argv);
  SetAddressableAspace(oldas);
  splx(x);
}

callUserMainPutArgs(args, buffer, ac, av)
register int *args;
register char *buffer;
int ac;
char **av;
{
  int i, len;
  char **argv, *arg;

  TRACE2(user, 3, "call main args = %X buffer = %X", args, buffer);
  argv = (char **) buffer;
  buffer += ((ac + 1) * sizeof(int));
  *args++ = ac;
  *args = (int)argv;
  for (i = 0; i < ac; i++) {
    arg = av[i];
    len = strlen(arg) + 1;
    bcopy(arg, buffer, len);
    TRACE3(user, 4, "setting argv[%d] at %X to %X", i, &argv[i], buffer);
    argv[i] = buffer;
    buffer += len;
  }
  argv[i] = NULL;
}

callUserMain(argc, argv)
int argc;
char **argv;
{
  int callUserMainPutArgs(), i, total = 0;
 
  IFTRACE(user, 1) printf("Calling user main [%d] (", argc);
  for (i = 0; i < min(argc, 8) && argv[i]; i++) {
    IFTRACE(user, 1) printf("%s%s", i > 0 ? "," : "", argv[i]);
    total += strlen(argv[i]) + 1;
  }
  total = ((total + 3) & ~3);
  IFTRACE(user, 1) printf(")\n");
  CallUserRoutine(GetAddressableAspace(), (Pfi)ASPACE_START, 2,
    total + 8 * sizeof(int), callUserMainPutArgs, (Pfi)0, argc, (int)argv, 0, 0);
}
  
InitUser()
{
  char **argv;
  int argc;
  argv = (char **)malloc(8 * sizeof(char *));
  argc = Ms_FetchBootArgs(argv);
  ExecUser(argc, argv);
}


InitRest()
{
  TRACE1(memoryinit, 5, "InitRest: sr = %x", getsr());
  TRACE1(memoryinit, 5, "InitRest: sr = %x", getsr());
  InitProtocols(HLP);
  InitUser();
}


E 1
