h10822
s 00009/00001/00087
d D 1.2 91/01/10 11:04:40 llp 2 1
c Prepared for 3.1 Distribution
e
s 00088/00000/00000
d D 1.1 90/12/08 23:42:02 menze 1 0
c date and time created 90/12/08 23:42:02 by menze
e
u
U
f e 0
t
T
I 2
/* 
 * mapnet.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

E 2
I 1
#include "ethernet.h"
#include "ip.h"
#include "arp.h"
#include "dns.h"

D 2
static PROTL ARP, DNS;
E 2
I 2
static Protl ARP, DNS;
E 2

IPhost ethtoip(e)
ETHhost e;
{
  ETHhost buf;
  IPhost ans;
  buf = e;
  if (!ARP) ARP = xgetprotlbyname("arp");
  if (xcontrolprotl(ARP, RRESOLVE, (char *)&buf, sizeof buf) < 0) {
    ans.a = ans.b = ans.c = ans.d = 0;
  } else {
    ans = *(IPhost *)&buf;
  }
  return ans;
}

void iptoname(i, s)
IPhost i;
char *s;
{
  struct resolve_result res;
  if (!DNS) DNS = xgetprotlbyname("dns");

  sprintf(res.name, "%d.%d.%d.%d", i.a, i.b, i.c, i.d);
  xcontrolprotl(DNS, RRESOLVE, (char *)&res, sizeof res);
  strcpy(s, res.name);
}

void ethtoname(e, s)
ETHhost e;
char *s;
{
  IPhost i;
  i = ethtoip(e);
  iptoname(i, s);
}

ETHhost iptoeth(iaddr)
IPhost iaddr;
{
  union {
    IPhost ipaddr;
    ETHhost  eaddr;
  } either;
  ETHhost ans;

  either.ipaddr = iaddr;
  if (!ARP) ARP = xgetprotlbyname("arp");
  if (xcontrolprotl(ARP, RESOLVE, (char *)&either, sizeof either) < 0) {
    ans.high = ans.mid = ans.low = 0;
  } else {
    ans = either.eaddr;
  } 
  return ans;
}

IPhost nametoip(s)
char *s;
{
  struct resolve_result res;
  IPhost ans;
  if (!DNS) DNS = xgetprotlbyname("dns");

  strcpy(res.name, s);
  if (xcontrolprotl(DNS, RESOLVE, (char *)&res, sizeof res) < 0) {
    ans.a = ans.b = ans.c = ans.d = 0;
  } else {
    ans = res.addr[0];
  }
  return ans;
}

ETHhost nametoeth(s)
char *s;
{
  IPhost ipaddr;
  ETHhost eaddr;

  ipaddr = nametoip(s);
  eaddr = iptoeth(ipaddr);
  return eaddr;
}
E 1
