h01648
s 00278/00000/00000
d D 1.1 91/01/10 11:03:07 llp 1 0
c date and time created 91/01/10 11:03:07 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * z8530scc_internal.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef z8530scc
#define z8530scc

#ifndef upi_h
#include "upi.h"
#endif

#ifndef process_h
#include "process.h"
#endif

#define PARITY_NONE	0
#define PARITY_ODD	1
#define PARITY_EVEN	2

#define STOP_BITS_15	0	/* 1.5 stop bits */
#define STOP_BITS_1	1	/* 1 stop bit */
#define STOP_BITS_2	2	/* 2 stop bits */

/* Registers as they appear to the Sun-2 processor */
typedef struct {
  unsigned char control;
  unsigned char filler1;
  unsigned char data;
  unsigned char filler2;
} SccChannel;

typedef struct {
  SccChannel b;
  SccChannel a;
} SccChip;

#define SCC_CLOCK_RATE	4915200	/* Hz */

/* These structures are used by the driver to remember such things as
 *  the last values written to each write register (where this is
 *  important), and the parameters (data rate, parity, character width,
 *  etc.) that have been requested for this channel.
 */ 
typedef struct _scs {
  struct _scs *link;		/* Next channel at this interrupt level */
  SccChannel *channel;		/* Hardware address of channel */
  int ab;			/* Indicates if channel A or B */
  int index;
  short charWidth;		/* 5, 6, 7, or 8 */
  short parity;			/* ODD, EVEN, or NONE */
  short dtr;			/* DTR RS232 output: 0 or 1 */
  short rts;			/* RTS RS232 output: 0 or 1 */
  short brk;			/* BREAK in progress? 0 or 1 */
  short stopBits;
  unsigned dataRate;
  Msg outputMsg;
  int outputCount;
  Semaphore mutex;
} SccChannelStatus;

#define SCC_CHANNEL_A	0
#define SCC_CHANNEL_B	1



/* Bit definitions */
/* WR0: Command register */
#define SccNoOperation		0x00
#define SccResetRxCrcChecker	0x40
#define SccResetTxCrcGenerator	0x80
#define SccResetTxUnderrunEom	0xC0

#define SccResetExtStatInt	0x10
#define SccSendAbort		0x18
#define SccEnableIntNextRx	0x20
#define SccResetTxIntPending	0x28
#define SccErrorReset		0x30
#define SccResetHighestIus	0x38

/* WR1: Transmit/Receive Interrupt and Data Transfer Mode Definition */
#define SccWaitDmaRequestEnable	0x80
#define SccDmaRequestFunction	0x40
#define SccWaitDmaRequestOnRcv	0x20

#define SccRxIntDisable		0x00
#define	SccRxIntFirstChar	0x08
#define SccRxIntAllChars	0x10
#define SccRxIntSpecialOnly	0x18

#define SccParityIsSpecial	0x04
#define SccTxIntEnable		0x02
#define SccExtIntEnable		0x01

/* WR2: Interrupt Vector */

/* WR3: Receive Parameters and Control */
#define SccRx5BitsPerChar	0x00
#define SccRx6BitsPerChar	0x80
#define SccRx7BitsPerChar	0x40
#define SccRx8BitsPerChar	0xC0
#define SccRxBitsPerChar(n)	("\0\200\100\300"[(n)-5])	/* yucch */
#define SccAutoEnables		0x20
#define SccEnterHuntMode	0x10
#define SccRxCrcEnable		0x08
#define SccAddressSearchMode	0x04
#define SccSyncCharLoadInhibit	0x02
#define SccRxEnable		0x01

/* WR4: Transmit/Receiver Miscellaneous Parameters and Modes */
#define SccX1Clock		0x00
#define SccX16Clock		0x40
#define SccX32Clock		0x80
#define SccX64Clock		0xC0

#define Scc8BitSync		0x00
#define Scc16BitSync		0x10
#define SccSdlcMode		0x20
#define SccExternalSyncMode	0x30

#define SccSyncModesEnable	0x00
#define Scc15StopBits		0x08	/* 1.5 stop bits */
#define Scc1StopBit		0x04
#define Scc2StopBits		0x0C
#define SccStopBits(n)		("\10\4\14"[n])	/* This macro converts from */
						/*  the publically known */
						/*  STOP_BITS_* constants to */
						/*  the SCC bit patterns */
#define SccNoParity		0x00
#define SccParityOdd		0x01
#define SccParityEven		0x03
#define SccParity(n)		("\0\1\3"[n])	/* This macro converts from */
						/*  the publically known */
						/*  PARITY_* constants to */
						/*  the SCC bit patterns */

/* WR5: Transmit Parameter and Controls */
#define SccDtr			0x80

#define SccTx5BitsPerChar	0x00
#define SccTx6BitsPerChar	0x40
#define SccTx7BitsPerChar	0x20
#define SccTx8BitsPerChar	0x60
#define SccTxBitsPerChar(n)	("\0\100\040\140"[(n)-5])

#define SccSendBreak		0x10
#define SccTxEnable		0x08
#define SccCrc16		0x04
#define SccRts			0x02
#define SccTxCrcEnable		0x01

/* WR6: Sync Characters or SDLC Address Field */

/* WR7: Sync Character or SDLC Flag */

/* WR8: Transmit Buffer */

/* WR9: Master Interrupt Control */
#define SccNoReset		0x00
#define SccChannelResetA	0x40
#define SccChannelResetB	0x80
#define SccForceHardwareReset	0xC0

#define SccStatusHigh		0x10
#define SccMasterIntEnable	0x08
#define SccDisableLowerChain	0x04
#define SccNoVector		0x02
#define SccVectorIncludesStatus	0x01

/* WR10: Miscellaneous Transmitter/Receiver Control Bits */
#define SccCrcPreset		0x80

#define SccNrz			0x00
#define SccNrzi			0x20
#define SccFm1			0x40
#define SccFm0			0x60

#define SccGoActiveOnPoll	0x10
#define SccMarkIdle		0x08
#define SccAbortOnUnderrun	0x04
#define SccLoopMode		0x02
#define Scc6BitSync		0x01

/* WR11: Clock Mode Control */
#define SccRTxCXtal		0x80

#define SccRxClockRTxC		0x00
#define SccRxClockTRxC		0x20
#define SccRxClockBrGen		0x40
#define SccRxClockDpll		0x60

#define SccTxClockRTxC		0x00
#define SccTxClockTRxC		0x08
#define SccTxClockBrGen		0x10
#define SccTxClockDpll		0x18

#define SccTRxCOutput		0x04

#define SccTRxCOutputXtal	0x00
#define SccTRxCOutputTxClock	0x01
#define SccTRxCOutputBrGen	0x02
#define SccTRxCOutputDpll	0x03

/* WR12: Lower Byte of Baud Rate Generator Time Constant */

/* WR13: Upper Byte of Baud Rate Generator Time Constant */

/* WR14: Miscellaneous Control Bits */
#define SccEnterSearchMode	0x20
#define SccResetMissingClock	0x40
#define SccDisableDpll		0x60
#define SccSetSourceBrGen	0x80
#define SccSetSourceRTxC	0xA0
#define SccSetFmMode		0xC0
#define SccSetNrziMode		0xE0

#define SccLocalLoopback	0x10
#define SccAutoEcho		0x08
#define SccRequestFunction	0x04
#define SccBrGenSourcePclk	0x02
#define SccBrGenEnable		0x01

/* WR15: External/Status Interrupt Control */
#define SccBreakAbortIE		0x80
#define SccTxUnderrunEomIE	0x40
#define SccCtsIE		0x20
#define SccSyncHuntIE		0x10
#define SccDcdIE		0x08
#define SccZeroCountIE		0x02

/* RR0: Transmit/Receive Buffer Status and External Status */
#define SccBreakAbort		0x80
#define SccTxUnderrunEom	0x40
#define SccCts			0x20
#define SccSyncHunt		0x10
#define SccDcd			0x08
#define SccTxBufferEmpty	0x04
#define SccZeroCount		0x02
#define SccRxCharacterAvailable 0x01

/* RR1: Special Receive Condition Status Bits and Residue Codes */
#define SccEndOfFrame		0x80
#define SccCrcOrFramingError	0x40
#define SccRxOverrunError	0x20
#define SccParityError		0x10
#define SccResidueCode0		0x08
#define SccResidueCode1		0x04
#define SccResidueCode2		0x02
#define SccAllSent		0x01

/* RR2: Interrupt Vector */

/* RR3: Interrupt Pending (channel A only) */
#define SccARxIntPending	0x20
#define SccATxIntPending	0x10
#define SccAExtStatIntPending	0x08
#define SccBRxIntPending	0x04
#define SccBTxIntPending	0x02
#define SccBExtStatIntPending	0x01

/* RR8: Receive Data Register */

/* RR10: Miscellaneous Status Bits */
#define SccOneClockMissing	0x80
#define SccTwoClocksMissing	0x40		/* call the police! */
#define SccLoopSending		0x10
#define SccOnLoop		0x02

/* RR12: Lower Byte of Baud Rate Generator Time Constant (same as WR12) */

/* RR13: Upper Byte of Baud Rate Generator Time Constant (same as WR13) */

/* RR15: External/Status Interrupt Enable Bits (same as WR15) */

#endif z8530scc
E 1
