/* 
 * intelEthRcv.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */


/*
 * Rcv Unit control commands
 */
#define	RU_START		1
#define	RU_SUSPEND		3


/*
 * Rcv Unit status
 */
#define RUS_IDLE 			0
#define RUS_SUSPENDED 		1
#define RUS_NORESOURCES 	2
#define RUS_READY 			4


/*
 * Receive Frame Descriptor
 */
typedef struct {
  u_char shortFrame:1;		/* short frame */
  u_char noEof:1;		/* no EOF (bitstuffing mode only) */
         u_char:6;		/* unused */
  u_char used:1;		/* RFD has been used, holds a frame */
  u_char rcvInProgress:1;	/* reception in progress */
  u_char rcvSuccessful:1;	/* reception was successful */
         u_char:1;		/* unused */
  u_char crcErr:1;		/* crc error */
  u_char alignErr:1;		/* alignment error */
  u_char noBufs:1;		/* out of buffer space */
  u_char dmaOverrun:1;		/* DMA overrun */
         u_char:8;		/* unused */
  u_char lastAvailRfd:1;	/* logical end of list of free RFDs */
  u_char suspendWhenDone:1;	/* suspend when done */
         u_char:6;		/* unused */
  ieOffset_t nextRfdOffset;	/* offset of next rcv frame desc */
  ieOffset_t rbdHeadOffset;	/* offset of rcv buffer desc */
  ETHhost destEthAd;
  ETHhost srcEthAd;
  u_short ethPktType;
}      rcvFrameDesc_t;


/*
 * Receive Buffer Descriptor
 */
typedef struct {
  u_char byteCntLoByte:8;	/* written by device */
  u_char lastBufOfFrame:1;	/* written by device */
  u_char used:1;		/* written by device */
  u_char byteCntHiByte:6;	/* written by device */
  ieOffset_t nextRbdOffset;
  ieAd_t bufPtr;
  u_char bufSzLoByte:8;
  u_char lastAvailRbd:1;
         u_char:1;		/* unused */
  u_char bufSzHiByte:6;		/* higher 6 bits of size */

  /* EXTRA FIELD, NOT PART OF RBD AS KNOWN TO DEVICE */
  Msg msg;			/* (pointer to) msg containing the buf */
}      rcvBufDesc_t;

