h34414
s 00070/00098/00220
d D 1.3 91/01/10 10:52:27 llp 3 2
c Prepared for 3.1 Distribution
e
s 00025/00001/00293
d D 1.2 90/11/30 14:04:43 menze 2 1
c Added some diagnostic functions (surrounded by #ifdefs)
e
s 00294/00000/00000
d D 1.1 90/11/30 13:52:57 menze 1 0
c date and time created 90/11/30 13:52:57 by menze
e
u
U
f e 0
t
T
I 1
D 3
/*
E 3
I 3
/* 
E 3
 * intelEth.c
 *
D 3
 * Ethernet driver code specific to the Intel ethernet controller.
 * Code pertaining particularly to the controller's Command Unit
 * or Receive Unit is found in intelEthCmd.c or intelEthRcv.c.
E 3
I 3
 * x-kernel v3.1	12/10/90
E 3
 *
D 3
 * Mark Abbott, Spring 89
E 3
I 3
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 3
 */

#ifndef NDEBUG
int nCUNoCommandsPending, nCUCommandsPending, nCUStarts, nCUContinues, nCULeavingActives, nCUXmits;

#endif

D 3
#include "process.h"
/* #include "exceptions.h" */
#include "debug.h"
#include "assert.h"
#include "xType.h"
E 3
I 3
#include "xkernel.h"
E 3
#include "eth.h"
#include "intelEthType.h"
#include "intelEthRcv.h"
#include "intelEthCmd.h"
#include "intelEth.h"

D 3


E 3
I 2
int printXmitSem();

E 2
volatile intermInitRoot_t IntermInitRoot;

D 3






E 3
SetPromiscusous()
{
  configIeDev(1);
}

I 3

E 3
/*
 * ethCtlrInit
 */
I 3

E 3
ethCtlrInit(localEthAd)
D 3
    ethAd_t localEthAd;
E 3
I 3
     ethAd_t localEthAd;
E 3
{
D 3

E 3
I 3
  
E 3
  TRACE0(ie, 5, "ethCtlrInit");
D 3

E 3
I 3
  
E 3
  /* establish the handler for interrupts from the ie device */
  setexvec(handleIeIntrAsm, IE_INTR_NUM);
D 3

E 3
I 3
  
E 3
  /* set up memory to be used for communication between ie dev and host */
  initMemSharing();
  TRACE0(ie, 5, "done setting up memory for the device");
D 3

E 3
I 3
  
E 3
  /* reset the device, so it shares the correct memory */
  resetIeDev();
  TRACE0(ie, 5, "done reseting the device");
D 3

E 3
I 3
  
E 3
  /*
   * ready the hardware and data structures for issuing action commands,
   * which include: configuring the device, setting the local ether address,
   * and transmitting data.
   */
  initCmd();
  TRACE0(ie, 5, "done setting up device for action commands");
D 3

E 3
I 3
  
E 3
  /* configure the device the way we want it */
  configIeDev(0);
  TRACE0(ie, 5, "done configuring the device");
D 3

E 3
I 3
  
E 3
  /* tell the device what address to use as its own */
  informIeDevLocalEthAd(localEthAd);
  TRACE0(ie, 5, "done telling device what address to use");
D 3

E 3
I 3
  
E 3
  /* ready the hardware and data structures for receiving ether packets */
  initRcv();
  TRACE0(ie, 5, "ready to receive packets");
D 3

E 3
I 3
  
E 3
I 2
  /* TEMP */
#ifdef ETH_OPT_TRACE
  event_register(printXmitSem,0,1000,EV_REPEAT);
#endif
#ifdef BLORT
  intelStatus(0);
  event_register(intelStatus,0,30000,EV_REPEAT);
#endif
E 2
}				/* end ethCtlrInit */


I 2
extern boolean CuKnownNotActive;
E 2

I 2
printXmitSem(i)
D 3
    int i;
E 3
I 3
     int i;
E 3
{
D 3
    printf("Xmit semaphore: %d\n", FreeCmdCntSem.count);
    printf("Cmd unit status: %d\n", SCB.cmdUnitStatus);
    printf("CUKNA: %d\n", CuKnownNotActive);
E 3
I 3
  printf("Xmit semaphore: %d\n", FreeCmdCntSem.count);
  printf("Cmd unit status: %d\n", SCB.cmdUnitStatus);
  printf("CUKNA: %d\n", CuKnownNotActive);
E 3
}     
E 2


D 3


I 2

E 3
E 2
/*
 * initMemSharing
 */
I 3

E 3
initMemSharing()
{
  extern unsigned long AllocateMemory();
D 3

E 3
I 3
  
E 3
  /* allocate the memory shared for communication between ie dev and cpu */
  assert(sizeof(ieSharedMem_t) <= 64 * 1024);
  AllocateMemory((unsigned) IeSharedMemPtr, sizeof(ieSharedMem_t));
  bzero((char *) IeSharedMemPtr, sizeof(ieSharedMem_t));
D 3

E 3
I 3
  
E 3
}				/* end initMemSharing */


D 3






E 3
/*
 * resetIeDev
 */
I 3

E 3
resetIeDev()
{
  int delay;
D 3


E 3
I 3
  
  
E 3
  TRACE0(ie, 5, "resetIeDev");
D 3

E 3
I 3
  
E 3
  while (TRUE) {
D 3
/* printf("1"); */
    /* ??? */
E 3
    IE_CTL_REG = IE_CTL_REG_LOOPBACK;
    /* replace these constants with something meaningful */
D 3
    for (delay = 0; delay < (SECS400 / 19980); delay++);	/* kill ? time */
/* printf("2");*/
E 3
I 3
    for (delay = 0; delay < (SECS400 / 19980); delay++); /* kill ? time */
E 3
    IE_CTL_REG = 0;
D 3

E 3
I 3
    
E 3
    /* tell the ie dev where to find the memory to be shared */
    InitRoot.busKind = 0;
    InitRoot.intermInitRootAd = IE_AD_FROM_AD(&IntermInitRoot);
    IntermInitRoot.initInProgress = TRUE;
    IntermInitRoot.ieSharedMemAd = IE_AD_FROM_AD(IeSharedMemPtr);
    /* sys control blk is at begining of shared memory */
    IntermInitRoot.scbOffset = 0;
D 3
/* printf("3"); */
E 3
    ALERT_IE_DEV();
D 3
/*  printf("4"); */
E 3
    /* see if it worked (??) */
    for (delay = 0; IntermInitRoot.initInProgress && (delay < SECS400);
	 delay++);
D 3
    for (delay = 0; delay < (SECS400 / 19980); delay++);	/* kill ? time */
E 3
I 3
    for (delay = 0; delay < (SECS400 / 19980); delay++); /* kill ? time */
E 3
    for (delay = 0; !SCB.cuLeftActiveState && (delay < SECS400); delay++);
#if 0
D 3
    while (!(IE_CTL_REG & IE_CTL_REG_INTR_PEND));	/* wait for interrupt */
E 3
I 3
    while (!(IE_CTL_REG & IE_CTL_REG_INTR_PEND)); /* wait for interrupt */
E 3
#else
D 3
    for (delay = 0; !(IE_CTL_REG & IE_CTL_REG_INTR_PEND) && (delay < SECS400); delay++) ;	/* wait for interrupt */
E 3
I 3
    for (delay = 0; !(IE_CTL_REG & IE_CTL_REG_INTR_PEND) && (delay < SECS400);
	 delay++) ;	/* wait for interrupt */
E 3
#endif
D 3
/* printf("7"); */
E 3
    if (SCB.cmdUnitStatus == CU_STATUS_IDLE) {
      return;			/*****HERE'S THE LOOP TERMINATION*****/
    }
    TRACE0(ethp, 1, "command unit not idle after reset");
    /* and try again ... */
  }
D 3

E 3
}				/* end resetIeDev */


D 2
intelStatus()
E 2
I 2
intelStatus(foo)
     int foo;
E 2
{
  int x = spl7();
  int i;
I 2
  cmd_t *cptr;
E 2
D 3

E 3
I 3
  
E 3
  rcvFrameDesc_t *rfd;
  extern rcvFrameDesc_t *RcvFrameDescHeadPtr;
D 3

E 3
I 3
  
E 3
  printf("IE status: ");
  if (SCB.frameRcvd)
    printf("frame received ");
  if (SCB.cmdDone)
    printf("command done ");
  if (SCB.cuLeftActiveState)
    printf("cu left active ");
  if (SCB.ruNotReady)
    printf("ru not ready ");
  printf("RUS: ");
  switch (SCB.rcvUnitStatus) {
D 3
   case RUS_IDLE:
     printf("idle ");
     break;
   case RUS_SUSPENDED:
     printf("suspended ");
     break;
   case RUS_NORESOURCES:
     printf("no resources ");
     break;
   case RUS_READY:
     printf("ready ");
     break;
   default:
     printf("Not used");
     break;
E 3
I 3
  case RUS_IDLE:
    printf("idle ");
    break;
  case RUS_SUSPENDED:
    printf("suspended ");
    break;
  case RUS_NORESOURCES:
    printf("no resources ");
    break;
  case RUS_READY:
    printf("ready ");
    break;
  default:
    printf("Not used");
    break;
E 3
  }
  printf("CUS: ");
  switch (SCB.cmdUnitStatus) {
D 3
   case CU_STATUS_IDLE:
     printf("idle");
     break;
   case CU_STATUS_SUSPEND:
     printf("suspended ");
     break;
   case CU_STATUS_ACTIVE:
     printf("active ");
     break;
   default:
     printf("Not used ");
     break;
E 3
I 3
  case CU_STATUS_IDLE:
    printf("idle");
    break;
  case CU_STATUS_SUSPEND:
    printf("suspended ");
    break;
  case CU_STATUS_ACTIVE:
    printf("active ");
    break;
  default:
    printf("Not used ");
    break;
E 3
  }
  {
    for (i = 0, rfd = RcvFrameDescHeadPtr;
	 rfd && rfd->used;
D 3
       i++, rfd = (rcvFrameDesc_t *) AD_FROM_IE_OFFSET(rfd->nextRfdOffset));
E 3
I 3
	 i++, rfd = (rcvFrameDesc_t *) AD_FROM_IE_OFFSET(rfd->nextRfdOffset));
E 3
    printf(" %d packets pending\n", i);
  }
  splx(x);
}


D 3




E 3
/*
 * handleIeIntr
 *
 * Old code implies that multiple interrupt conditions can coexist.
 */
I 3

E 3
handleIeIntr()
{
  boolean foundIntrKind;
D 3


E 3
I 3
  
  
E 3
#ifndef NDEBUG
  IFTRACE(ie, 2) putchar('i');
#endif
  TRACE0(ie, 5, "handleIeIntr");
D 3

E 3
I 3
  
E 3
  foundIntrKind = FALSE;
D 3

E 3
I 3
  
E 3
  if (SCB.frameRcvd) {
    foundIntrKind = TRUE;
    handleRcvdFrame();
  }
D 3

E 3
I 3
  
E 3
  if (SCB.cuLeftActiveState) {
    foundIntrKind = TRUE;
    handleCuLeavingActiveState();
  }
  if (SCB.ruNotReady) {
    foundIntrKind = TRUE;
    /* should not happen, probably means exhausted receive buffering */
    TRACE0(ie, 1, "handleIeIntr: RCV UNIT LEFT READY STATE!");
    freeRcvBufs();
    initRcv();
    SCB.ackRuNotReady = TRUE;
    SCB.rcvUnitCtlCmd = RU_START;
    ALERT_IE_DEV();
  }
  if (SCB.cmdDone) {
#ifndef NDEBUG
    IFTRACE(ie, 2) putchar('c');
#endif
    SCB.ackCmdDone = TRUE;
    foundIntrKind = TRUE;
    ALERT_IE_DEV();
  }
  if (!foundIntrKind) {
    /* should not happen, but does routinely! */
I 2
#ifdef ETH_OPT_TRACE
D 3
      putchar('&');
E 3
I 3
    putchar('&');
E 3
#endif
E 2
    TRACE0(ie, 5, "handleIeIntr: couldn't identify interrupt!");
#ifndef NDEBUG
    IFTRACE(ie, 2) putchar('z');
#endif
    SCB.ackCmdDone = TRUE;
    SCB.ackFrameRcvd = TRUE;
    SCB.ackCuLeftActiveState = TRUE;
    SCB.ackRuNotReady = TRUE;
    ALERT_IE_DEV();
  }
}				/* end handleIeIntr */

#ifndef NDEBUG
intelEthStats()
{
  printf("nCUNoCommandsPending = %d\n", nCUNoCommandsPending);
  printf("nCUCommandsPending = %d\n", nCUCommandsPending);
  printf("nCUStarts = %d\n", nCUStarts);
  printf("nCUContinues = %d\n", nCUContinues);
  printf("nCULeavingActives = %d\n", nCULeavingActives);
  printf("nCUXmits = %d\n", nCUXmits);
}

#endif
E 1
