.*------------------------------------------------------------------------------
.* iODBC/CLI for mSQL (OS/2)
.* (c) 1996 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------
:userdoc.
:title.iODBC/CLI for mSQL (OS/2)

.*------------------------------------------------------------------------------
.* 'Info'
.*------------------------------------------------------------------------------
:h1 id=info clear.Info
:lines align=left.
:hp4.intrinsic Open Data Base Connection (iODBC) for mSQL (OS/2):ehp4.
:hp4.Call-Level Interface (CLI) for mSQL (OS/2):ehp4.
* standardization of database access *
:elines.
:artwork name='iodbc_0.bmp' align=center.
:lines align=center.
:hp8.All programs included in this package are provided "as is", without
any warranty! Try them on your own risk.
:ehp8.
:elines.
:p.This documentation is based on various documentations and own expiriences.
:p.(c) 1996 by Dirk Ohme - all rights reserved

:note.
All files (except iODBC) are copyrighted by Dirk Ohme, all other are under
GNU-law. You are allowed to use the CLI and all related stuff in
non-commerical environments without any fee. If you want to use the CLI
within a commerical environment, please contact the author. If you want to
use iODBC within a commercial environment, see the GNU law.
The archive may be distributed freely, but only as one package that
mustn't be modified to the original distribution!

.*------------------------------------------------------------------------------
.* 'Introduction and Files'
.*------------------------------------------------------------------------------
:h1 id=introduction clear.Introduction and Files
:p.The :hp4.C:ehp4.all :hp4.L:ehp4.evel :hp4.I:ehp4.nterface is an C-API for
writing portable database applications. It is meant to be database independent.
The sources are drawn a bit from ODBC (Open DataBase Connection - a firm
specific standard by the Microsoft Corporation based on X/Open's CLI) and CLI
specified by the ISO/ANSI comitee and X/Open.

:p.The CLI consists of two directories, which may vary depending on the
distribution path&colon.
:lm margin=5.:ul.
:li.the version bundled with mSQL and W3-mSQL for OS/2 resides in
:hp4.\iODBC\CLI\:ehp4. (CLI library), :hp4.\iODBC\iODBC-x.xx:ehp4. (iODBC
driver manager) and :hp4.\iODBC\SAMPLES\:ehp4. (CLI &amp. iODBC sample
sources).
:li.the Unix version comes as a stand-alone package having all library
related stuff in one directory and under there another directory
:hp4./samples/:ehp4. with the CLI sample sources.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.* 'How to use the CLI'
.*------------------------------------------------------------------------------
:h1 id=how_to_use clear.How to use the CLI
:p.Within your programs, you have to include a file named :hp4.sqlcli_.h:ehp4..
This is normally done by insertion of a statement like this&colon.
:xmp.
         #include <sqlcli_.h>
:exmp.
:p.Make sure that this file is located to a directory normally being searched
for include files by the compiler or specify the directory containing this
file directly at compiler call (this is done by
:hp2./I:ehp2.:hp1.directory:ehp1. for the IBM C compilers or by
:hp2.-I:ehp2.:hp1.directory:ehp1. for Unix style C compilers, e.g.
:hp1.gcc:ehp1., there :hp1.directory:ehp1. is the desired directory).

:note.
All environement dependend header files (i.e. :hp1.msql.h:ehp1. for
:hp2.mSQL:ehp2.) have to be put to a directory, for which the same conditions
exists (included during compilation per default or per parameter switch).

:p.To use the CLI properly there is a predefined path showing when to call
which routine. The next picture describes a CLI session.

:artwork name='iodbc_1.bmp' align=center.

:lm margin=5.:ul.
:li.First, there has to be an allocation of environment space
(see :link reftype=hd refid=cli_SQLAllocEnv.SQLAllocEnv():elink.).
:li.Then, a database context has to be set up
(see :link reftype=hd refid=cli_SQLAllocConnect.SQLAllocConnect():elink.).
:li.In order to do transactions there must be a database connection established
(done either by :link reftype=hd refid=cli_SQLConnect.SQLConnect():elink.
or :link reftype=hd refid=cli_SQLDriverConnect.SQLDriverConnect():elink.).
:li.Transactions take place (see below).
:li.After the last transaction, the connection to the database has to be closed
(see :link reftype=hd refid=cli_SQLDisconnect.SQLDisconnect():elink.).
:li.Then the database context has to be freed
(see :link reftype=hd refid=cli_SQLFreeConnect.SQLFreeConnect():elink.).
:li.The last (CLI) operation is to free the environment space
(see :link reftype=hd refid=cli_SQLFreeEnv.SQLFreeEnv():elink.).
:eul.:lm margin=1.

:p.Transactions could be done in various ways. A transaction can store or
manipulate data (:hp1.INSERT:ehp1., :hp1.UPDATE:ehp1., :hp1.DELETE:ehp1., ...),
retrieve data (:hp1.SELECT:ehp1., ...) or do anything else (manipulation on
table structure, access control to data, creation of views, ...). The next
picture contains an overview on transaction operation&colon.

:artwork name='iodbc_2.bmp' align=center.

:lm margin=5.:ul.
:li.Before any transaction a statement buffer has to be allocated
(see :link reftype=hd refid=cli_SQLAllocStmt.SQLAllocStmt():elink.).
:li.A transaction statement then can be prepared and then being executed
(see :link reftype=hd refid=cli_SQLPrepare.SQLPrepare():elink.,
:link reftype=hd refid=cli_SQLExecute.SQLExecute():elink.) or run directly
(see :link reftype=hd refid=cli_SQLExecDirect.SQLExecDirect():elink.). On
both paths certain parameters of the statment could be bound to variables
(see :link reftype=hd refid=cli_SQLBindParam.SQLBindParam():elink.).
:li.Depending on the transaction type, there are those possibilities&colon.
:eul.:lm margin=1.
:lm margin=10.:ul.
:li.On :hp2.Data Retrival:ehp2. the number of resulting columns has to be
gathered (see :link reftype=hd
refid=cli_SQLNumResultCols.SQLResultCols():elink.), the columns bound to
variables
(see :link reftype=hd refid=cli_SQLBindCol.SQLBindCol():elink.) and all
result rows processed (see :link reftype=hd
refid=cli_SQLFetch.SQLFetch():elink.). Optionally additional columns
informations can be retrieved
(see :link reftype=hd refid=cli_SQLDescribeCol.SQLDescribeCol():elink.
or :link reftype=hd refid=cli_SQLColAttributes.SQLColAttributes():elink.)
and column values asked (see :link reftype=hd
refid=cli_SQLGetData.SQLGetData():elink.).
:li.On :hp2.Data Manipulation:ehp2. only the number of rows being affected
can be retrieved (see :link reftype=hd
refid=cli_SQLRowCount.SQLRowCount():elink.).
:li.On :hp2.any other transaction type:ehp2. there are no special returns.
:eul.:lm margin=1.
:lm margin=5.:ul.
:li.When the last transaction is done, the statement buffer has to be freed
first (see :link reftype=hd refid=cli_SQLFreeStmt.SQLFreeStmt():elink.).
:li.All transactions then have to be commited or withdrawn by a
:link reftype=hd refid=cli_SQLTransact.SQLTransact():elink. call.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.* 'Definitions and Common Data Types'
.*------------------------------------------------------------------------------
:h1 id=definitions clear.Definitions and Common Data Types
:p.This section contains the definitions used within the Call-Level
Interface as there set in :hp1.sqlcli_.h:ehp1.. For better understanding,
notice, that (under OS/2!)&colon.
:lm margin=5.:ul.
:li. a :hp1.character:ehp1. has a size of 8 bits,
:li. a :hp1.word:ehp1. has a size of 16 bits,
:li. a :hp1.short integer:ehp1. has a size of 16 bits,
:li. a :hp1.double word:ehp1. has a size of 32 bits,
:li. a :hp1.long integer:ehp1. has a size of 32 bits.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'Data Qualifier FAR, NEAR'
.*------------------------------------------------------------------------------
:h2 id=data_qualifier_far clear.Data Qualifier FAR, NEAR
:xmp.
  FAR
  NEAR
:exmp.
:p.The purpose of this qualifiers is to specify if a pointer is used
within this data segment (:hp1.NEAR:ehp1.) or not (:hp1.FAR:ehp1.). Under
OS/2 2.x or above it is not necessary to use this.
:note.
This is implemented for migration of software from platforms, where the
determination of :hp1.FAR:ehp1. and :hp1.NEAR:ehp1. pointers is necessary.

.*------------------------------------------------------------------------------
.*   'Data Type BOOL'
.*------------------------------------------------------------------------------
:h2 id=data_type_bool clear.Data Type BOOL
:xmp.
  BOOL                   { FALSE, TRUE }
:exmp.
:p.This defines a boolean data type with it's two possible values
:lm margin=5.:ul.
:li.:hp4.FALSE:ehp4.
:li.:hp4.TRUE:ehp4.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'Data Type CHAR, UCHAR'
.*------------------------------------------------------------------------------
:h2 id=data_type_char clear.Data Type CHAR, UCHAR
:xmp.
  CHAR                   - signed char
  UCHAR                  - unsigned char
:exmp.
:p.This defines a data type for storing signed / unsigned integer values,
i.e. characters.

.*------------------------------------------------------------------------------
.*   'Data Type DWORD, SDWORD, UDWORD'
.*------------------------------------------------------------------------------
:h2 id=data_type_dword clear.Data Type DWORD, SDWORD, UDWORD
:xmp.
  DWORD                  - double word
  SDWORD                 - signed double word
  UDWORD                 - unsigned double word
:exmp.
:p.This defines a data type for storing signed / unsigned double words.

.*------------------------------------------------------------------------------
.*   'Data Type HANDLE'
.*------------------------------------------------------------------------------
:h2 id=data_type_handle clear.Data Type HANDLE
:xmp.
  HANDLE                 - (unqualified) handle
:exmp.
:p.The purpose of this data type is to store a unqualified handle to
"anything".

.*------------------------------------------------------------------------------
.*   'Data Type HWND'
.*------------------------------------------------------------------------------
:h2 id=data_type_hwnd clear.Data Type HWND
:xmp.
  HWND                   - handle (for) window
:exmp.
:p.The purpose of this data type is to store a handle for window manipulation.

.*------------------------------------------------------------------------------
.*   'Data Type LONG, ULONG'
.*------------------------------------------------------------------------------
:h2 id=data_type_long clear.Data Type LONG, ULONG
:xmp.
  LONG                   - signed long integer
  ULONG                  - unsigned long integer
:exmp.
:p.This defines a data type for storing signed / unsigned long integer
values.

.*------------------------------------------------------------------------------
.*   'Data Type PTR'
.*------------------------------------------------------------------------------
:h2 id=data_type_ptr clear.Data Type PTR
:xmp.
  PTR                    - (unqualified) pointer
:exmp.
:p.This data type is intended to be used for unqualified pointer
specification. It is comparable with the ANSI-C data type :hp1.void *:ehp1..

.*------------------------------------------------------------------------------
.*   'Data Type RETCODE'
.*------------------------------------------------------------------------------
:h2 id=data_type_retcode clear.Data Type RETCODE
:xmp.
  RETCODE                - (unqualified) program return code
:exmp.
:p.This data type is intended to be used to specify an unqualified
program return code, i.e. a return code of "something".

.*------------------------------------------------------------------------------
.*   'Data Type SHORT, USHORT'
.*------------------------------------------------------------------------------
:h2 id=data_type_short clear.Data Type SHORT, USHORT
:xmp.
  SHORT                  - signed short integer
  USHORT                 - unsigned short integer
:exmp.
:p.This defines a data type for storing signed / unsigned short integer
values.

.*------------------------------------------------------------------------------
.*   'Data Type WORD, SWORD, UWORD'
.*------------------------------------------------------------------------------
:h2 id=data_type_word clear.Data Type WORD, SWORD, UWORD
:xmp.
  WORD                   - word
  SWORD                  - signed word
  UWORD                  - unsigned word
:exmp.
:p.This defines a data type for storing signed / unsigned words.

.*------------------------------------------------------------------------------
.*   'Data Type UINT'
.*------------------------------------------------------------------------------
:h2 id=data_type_uint clear.Data Type INT
:xmp.
  UINT                   - unsigned integer
:exmp.
:p.This defines a data type for storing unsigned integer values.

.*------------------------------------------------------------------------------
.*   'Function Qualifier PASCAL'
.*------------------------------------------------------------------------------
:h2 id=function_qualifier_pascal clear.Function Qualifier PASCAL
:xmp.
  PASCAL
:exmp.
:p.The intention of this function qualifier is to distinguish between
function with "C" and "PASCAL" parameter/calling convention. For
example&colon.
:xmp.
  void funcProto(int a, int b );       /* C calling convention      */
  void PASCAL funcProto(int a, int b); /* PASCAL calling convention */
:exmp.
:lm margin=5.:ul.
:li. "C" calling stores first :hp1.b:ehp1., then :hp1.a:ehp1. to the head
:li. "PASCAL" calling stores first :hp1.a:ehp1., then :hp1.b:ehp1. to the head
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'Function Qualifier SQL_API'
.*------------------------------------------------------------------------------
:h2 id=function_qualifier_sql_api clear.Function Qualifier SQL_API
:xmp.
  SQL_API
:exmp.
:p.This qualifier is used for specification of a public call-level
interface routine (procedure).

.*------------------------------------------------------------------------------
.*   'Function Qualifier SQL_LOCAL_API'
.*------------------------------------------------------------------------------
:h2 id=function_qualifier_sql_local_api clear.Function Qualifier SQL_LOCAL_API
:xmp.
  SQL_LOCAL_API
:exmp.
:p.This qualifier is used for specification of a non-public (private)
call-level interface routine (procedure).

.*------------------------------------------------------------------------------
.*   'Function Macro MAX, MIN'
.*------------------------------------------------------------------------------
:h2 id=function_macro_max_min clear.Function Macro MAX, MIN
:xmp.
  MAX(x,y)               ((x > y) ? x : y)
  MIN(x,y)               ((x < y) ? x : y)
:exmp.
:p.These macros can be used for checking two numbers (numerical values)
against. :hp1.MAX:ehp1. returns the greater number, :hp1.MIN:ehp1. the
minor number of the two given ones.

.*------------------------------------------------------------------------------
.* 'SQL Data Types'
.*------------------------------------------------------------------------------
:h1 id=sql_data_types clear.SQL Data Types
:p.Accessing the database through the Call-Level Interface requires an
abstraction of the data types. The 'C' programming language and the structured
query language (SQL) have different names and types for certain data objects.
So there are data types defined in the header file :hp1.sqlcli_.h:ehp1. for
interactions between 'C' code and SQL database.

:p.First there are the following definitions (constants)&colon.
:table cols='25 54'.
:row.:c.SQL_DATE_LEN              :c.maximum length of date strings
:row.:c.SQL_MAX_ID_LENGTH         :c.maximum length of identifiers
:row.:c.SQL_MAX_MESSAGE_LENGTH    :c.maximum length of messages
:row.:c.SQL_SQLSTATE_SIZE         :c.maximum length of status codes
:row.:c.SQL_TIME_LEN              :c.maximum length of time strings
:row.:c.SQL_TIMESTAMP_LEN         :c.maxmimum length of a timestamp
:row.:c.SQLPOINTER                :c.:link reftype=hd refid=data_type_ptr.PTR:elink.
:row.:c.SQLRETURN                 :c.:link reftype=hd refid=data_type_retcode.RETCODE:elink. :link reftype=hd refid=function_qualifier_sql_api.SQL_API:elink.
:row.:c.SQLUINTEGER               :c.:link reftype=hd refid=data_type_uint.UINT:elink.
:row.:c.SQLUSMALLINT              :c.:link reftype=hd refid=data_type_short.USHORT:elink.
:etable.

:p.And now the SQL data types&colon.
:table cols='19 21 17 21'.
:row.:c.***SQL native***:c.identifier:c.'C'           :c.***comment***
:row.:c.SQLBINARY  :c.SQL_C_BINARY:c.unsigned char    :c.bit field of 8 bits
:row.:c.SQLBIT     :c.SQL_C_BIT   :c.:link reftype=hd refid=data_type_bool.BOOL:elink.:c.
:row.:c.SQLBLOBLOCATOR:c.SQL_C_BLOB_LOCATOR:c.long    :c.reference
:row.:c.SQLCHAR    :c.SQL_C_CHAR  :c.unsigned char    :c.
:row.:c.SQLCLOBLOCATOR:c.SQL_C_CLOB_LOCATOR:c.long    :c.reference
:row.:c.SQLDATE    :c.-           :c.unsigned char    :c.pointer to string
:row.:c.SQLDBCHAR  :c.SQL_C_DBCHAR:c.unsigned char    :c.character
:row.:c.SQLDBCLOBLOCATOR:c.SQL_C_DBCLOB_LOCATOR:c.long:c.reference
:row.:c.SQLDECIMAL :c.-           :c.unsigned char    :c.pointer to string
:row.:c.SQLDOUBLE  :c.SQL_C_DOUBLE:c.double           :c.
:row.:c.SQLINTEGER :c.SQL_C_LONG  :c.long             :c.
:row.:c.SQLFLOAT   :c.SQL_C_FLOAT :c.float            :c.
:row.:c.SQLNUMERIC :c.-           :c.unsigned char    :c.pointer to string
:row.:c.SQLREAL    :c.SQL_C_REAL  :c.float            :c.
:row.:c.SQLSCHAR   :c.SQL_C_TINYINT:c.signed char     :c.
:row.:c.SQLSHORT   :c.SQL_C_SHORT :c.short            :c.
:row.:c.SQLSMALLINT:c.SQL_C_SHORT :c.short            :c.
:row.:c.SQLTIME    :c.-           :c.unsigned char    :c.pointer to string
:row.:c.SQLTIMESTAMP:c.-          :c.unsigned char    :c.pointer to string
:row.:c.SQLTINYINT :c.SQL_C_TINYINT:c.signed char     :c.
:row.
:row.:c.***SQL native***:c.identifier:c.sub-entries   :c.***comment***
:row.:c.SQLDATE    :c.SQL_C_DATE  :c.DATE_STRUCT      :c.date structure
:row.:c.           :c.            :c.:hp1.year:ehp1.  :c.:hp1.year:ehp1.
:row.:c.           :c.            :c.:hp1.month:ehp1. :c.:hp1.month:ehp1.
:row.:c.           :c.            :c.:hp1.day:ehp1.   :c.:hp1.day:ehp1.
:row.:c.SQLTIME    :c.SQL_C_TIME  :c.TIME_STRUCT      :c.time structure
:row.:c.           :c.            :c.:hp1.hour:ehp1.  :c.:hp1.hour:ehp1.
:row.:c.           :c.            :c.:hp1.minute:ehp1.:c.:hp1.minute:ehp1.
:row.:c.           :c.            :c.:hp1.second:ehp1.:c.:hp1.second:ehp1.
:row.:c.SQLTIMESTAMP:c.SQL_C_TIMESTAMP:c.TIMESTAMP_STRUCT:c.time stamp
:row.:c.           :c.            :c.:hp1.year:ehp1.  :c.:hp1.year:ehp1.
:row.:c.           :c.            :c.:hp1.month:ehp1. :c.:hp1.month:ehp1.
:row.:c.           :c.            :c.:hp1.day:ehp1.   :c.:hp1.day:ehp1.
:row.:c.           :c.            :c.:hp1.hour:ehp1.  :c.:hp1.hour:ehp1.
:row.:c.           :c.            :c.:hp1.minute:ehp1.:c.:hp1.minute:ehp1.
:row.:c.           :c.            :c.:hp1.second:ehp1.:c.:hp1.second:ehp1.
:row.:c.           :c.            :c.:hp1.fraction:ehp1.:c.:hp1.???:ehp1.
:row.
:row.:c.***SQL***  :c.Handle/Pointer:c.'C'            :c.***comment***
:row.:c.SQLHDBC    :c.HDBC, LPDBC :c.DBC              :c.CLI database context
:row.:c.SQLHDESC   :c.HDESC, LPDESC:c.DESC            :c.CLI descriptor
:row.:c.SQLHENV    :c.HENV, LPENV :c.ENV              :c.CLI environment
:row.:c.SQLHSTMT   :c.HSTMT, LPSTMT:c.STMT            :c.CLI statement
:etable.

:note.
.br
:hp1.BLOB:ehp1. stands for :hp1.binary large object block:ehp1..
.br
:hp1.CLOB:ehp1. stands for :hp1.character large object block:ehp1..

.*------------------------------------------------------------------------------
.* 'CLI Function Calls'
.*------------------------------------------------------------------------------
:h1 id=cli_function_calls clear.CLI Function Calls
:p.The following chapters and pages deal with the functions provided by this
package. For a better overview have a look at the lists.

:p.:hp2.Catalogue (Tables, Columns, etc.):ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLColumnPrivileges.SQLColumnPrivileges:elink.
:li.:link reftype=hd refid=cli_SQLColumns.SQLColumns:elink.
:li.:link reftype=hd refid=cli_SQLForeignKeys.SQLForeignKeys:elink.
:li.:link reftype=hd refid=cli_SQLPrimaryKeys.SQLPrimaryKeys:elink.
:li.:link reftype=hd refid=cli_SQLProcedureColumns.SQLProcedureColumns:elink.
:li.:link reftype=hd refid=cli_SQLProcedures.SQLProcedures:elink.
:li.:link reftype=hd refid=cli_SQLSpecialColumns.SQLSpecialColumns:elink.
:li.:link reftype=hd refid=cli_SQLStatistics.SQLStatistics:elink.
:li.:link reftype=hd refid=cli_SQLTablePrivileges.SQLTablePrivileges:elink.
:li.:link reftype=hd refid=cli_SQLTables.SQLTables:elink.
:eul.:lm margin=1.

:p.:hp2.Connection to Database:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLAllocConnect.SQLAllocConnect:elink.
:li.:link reftype=hd refid=cli_SQLAllocEnv.SQLAllocEnv:elink.
:li.:link reftype=hd refid=cli_SQLBrowseConnect.SQLBrowseConnect:elink.
:li.:link reftype=hd refid=cli_SQLConnect.SQLConnect:elink.
:li.:link reftype=hd refid=cli_SQLDisconnect.SQLDisconnect:elink.
:li.:link reftype=hd refid=cli_SQLDriverConnect.SQLDriverConnect:elink.
:li.:link reftype=hd refid=cli_SQLFreeConnect.SQLFreeConnect:elink.
:li.:link reftype=hd refid=cli_SQLFreeEnv.SQLFreeEnv:elink.
:eul.:lm margin=1.

:p.:hp2.Execution of SQL Statements:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLCancel.SQLCancel:elink.
:li.:link reftype=hd refid=cli_SQLExecDirect.SQLExecDirect:elink.
:li.:link reftype=hd refid=cli_SQLExecute.SQLExecute:elink.
:li.:link reftype=hd refid=cli_SQLNativeSql.SQLNativeSql:elink.
:li.:link reftype=hd refid=cli_SQLParamData.SQLParamData:elink.
:li.:link reftype=hd refid=cli_SQLPutData.SQLPutData:elink.
:eul.:lm margin=1.

:p.:hp2.Information about CLI:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLGetInfo.SQLGetInfo:elink.
:li.:link reftype=hd refid=cli_SQLGetTypeInfo.SQLGetTypeInfo:elink.
:eul.:lm margin=1.

:p.:hp2.Options:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLGetConnectOption.SQLGetConnectOption:elink.
:li.:link reftype=hd refid=cli_SQLGetStmtOption.SQLGetStmtOption:elink.
:li.:link reftype=hd refid=cli_SQLSetConnectOption.SQLSetConnectOption:elink.
:li.:link reftype=hd refid=cli_SQLSetStmtOption.SQLSetStmtOption:elink.
:eul.:lm margin=1.

:p.:hp2.Preparation of SQL Statements:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLAllocStmt.SQLAllocStmt:elink.
:li.:link reftype=hd refid=cli_SQLDescribeParam.SQLDescribeParam:elink.
:li.:link reftype=hd refid=cli_SQLFreeStmt.SQLFreeStmt:elink.
:li.:link reftype=hd refid=cli_SQLGetCursorName.SQLGetCursorName:elink.
:li.:link reftype=hd refid=cli_SQLNumParams.SQLNumParams:elink.
:li.:link reftype=hd refid=cli_SQLParamOptions.SQLParamOptions:elink.
:li.:link reftype=hd refid=cli_SQLPrepare.SQLPrepare:elink.
:li.:link reftype=hd refid=cli_SQLSetCursorName.SQLSetCursorName:elink.
:li.:link reftype=hd refid=cli_SQLSetParam.SQLSetParam:elink.
:li.:link reftype=hd refid=cli_SQLSetScrollOptions.SQLSetScrollOptions:elink.
:eul.:lm margin=1.

:p.:hp2.Results of a SQL Statement:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLBindCol.SQLBindCol:elink.
:li.:link reftype=hd refid=cli_SQLColAttributes.SQLColAttributes:elink.
:li.:link reftype=hd refid=cli_SQLDescribeCol.SQLDescribeCol:elink.
:li.:link reftype=hd refid=cli_SQLError.SQLError:elink.
:li.:link reftype=hd refid=cli_SQLExtendedFetch.SQLExtendedFetch:elink.
:li.:link reftype=hd refid=cli_SQLFetch.SQLFetch:elink.
:li.:link reftype=hd refid=cli_SQLGetData.SQLGetData:elink.
:li.:link reftype=hd refid=cli_SQLMoreResults.SQLMoreResults:elink.
:li.:link reftype=hd refid=cli_SQLNumResultCols.SQLNumResultCols:elink.
:li.:link reftype=hd refid=cli_SQLRowCount.SQLRowCount:elink.
:li.:link reftype=hd refid=cli_SQLSetPos.SQLSetPos:elink.
:eul.:lm margin=1.

:p.:hp2.Transaction Handling:ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLTransact.SQLTransact:elink.
:eul.:lm margin=1.

:p.:hp2.Other calls (portability, compatibility):ehp2.
:lm margin=5.:ul.
:li.:link reftype=hd refid=cli_SQLAllocHandle.SQLAllocHandle:elink.
:li.:link reftype=hd refid=cli_SQLBindParam.SQLBindParam:elink.
:li.:link reftype=hd refid=cli_SQLCloseCursor.SQLCloseCursor:elink.
:li.:link reftype=hd refid=cli_SQLCopyDesc.SQLCopyDesc:elink.
:li.:link reftype=hd refid=cli_SQLEndTran.SQLEndTran:elink.
:li.:link reftype=hd refid=cli_SQLFreeHandle.SQLFreeHandle:elink.
:li.:link reftype=hd refid=cli_SQLGetCol.SQLGetCol:elink.
:li.:link reftype=hd refid=cli_SQLGetConnectAttr.SQLGetConnectAttr:elink.
:li.:link reftype=hd refid=cli_SQLGetDescField.SQLGetDescField:elink.
:li.:link reftype=hd refid=cli_SQLGetDescRec.SQLGetDescRec:elink.
:li.:link reftype=hd refid=cli_SQLGetDiagField.SQLGetDiagField:elink.
:li.:link reftype=hd refid=cli_SQLGetDiagRec.SQLGetDiagRec:elink.
:li.:link reftype=hd refid=cli_SQLGetEnvAttr.SQLGetEnvAttr:elink.
:li.:link reftype=hd refid=cli_SQLGetStmtAttr.SQLGetStmtAttr:elink.
:li.:link reftype=hd refid=cli_SQLLanguages.SQLLanguages:elink.
:li.:link reftype=hd refid=cli_SQLReleaseEnv.SQLReleaseEnv:elink.
:li.:link reftype=hd refid=cli_SQLServerInfo.SQLServerInfo:elink.
:li.:link reftype=hd refid=cli_SQLSetDescField.SQLSetDescField:elink.
:li.:link reftype=hd refid=cli_SQLSetDescRec.SQLSetDescRec:elink.
:li.:link reftype=hd refid=cli_SQLSetEnvAttr.SQLSetEnvAttr:elink.
:li.:link reftype=hd refid=cli_SQLSetStmtAttr.SQLSetStmtAttr:elink.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'SQLAllocConnect'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLAllocConnect clear.SQLAllocConnect
:xmp.
  RETCODE SQL_API SQLAllocConnect(
                               LPENV               lpenv,
                               HDBC FAR           *phdbc
                                 );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpenv:ehp1. - handle to CLI environment block
:li.:hp1.phdbc:ehp1. - pointer to handle for database context block
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1001  :c.memory allocation error
:row.:c.                     :c.S1009  :c.invalid pointer :hp1.phdbc:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid pointer :hp1.lpenv:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.context successfully allocated
:etable.

:p.The call provides the allocation of a database context structure, that is
used for database connection and transactions. It takes the handle returned
by :hp1.:link reftype=hd refid=cli_SQLAllocEnv.SQLAllocEnv():elink.:ehp1. as
input parameter.

.*------------------------------------------------------------------------------
.*   'SQLAllocEnv'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLAllocEnv clear.SQLAllocEnv
:xmp.
  RETCODE SQL_API SQLAllocEnv( SQLHENV FAR   *phenv
                             );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.phenv:ehp1. - pointer to handle for environment block
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.-      :c.internal error (memory problems?)
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid pointer :hp1.phenv:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.environment successfully allocated
:etable.

:p.This function has to be called at start of the program in order to create a
environment where the CLI could work. :hp1.phenv:ehp1. has to point to the
variable used as handle to the environment block.

:note.
There is no error message (see :hp2.SQLError:ehp2.) available.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLAllocHandle clear.SQLAllocHandle
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLAllocStmt'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLAllocStmt clear.SQLAllocStmt
:xmp.
  RETCODE SQL_API SQLAllocStmt(
          LPDBC   lpdbc,
          HSTMT FAR *phstmt);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpdbc:ehp1. - handle for database context
:li.:hp1.phstmt:ehp1. - pointer to variable storing statement handle
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1001  :c.memory allocation failure
:row.:c.                     :c.S1009  :c.invalid pointer :hp1.phstmt:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpdbc:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.statment handle created successfully
:etable.

:p.Allocation of a statement handle, which is used for database interactions
(queries, insertions, deletes, etc.). This function requires an open database
context handle. After the last interaction and before freeing the database
context, all allocated statement handles have to be closed via
:link reftype=hd refid=cli_SQLFreeStmt.SQLFreeStmt():elink..

.*------------------------------------------------------------------------------
.*   'SQLBindCol'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLBindCol clear.SQLBindCol
:xmp.
RETCODE SQL_API SQLBindCol(
        LPSTMT  lpstmt,
        UWORD   icol,
        SWORD   fCType,
        PTR     rgbValue,
        SDWORD  cbValueMax,
        SDWORD FAR *pcbValue);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.icol:ehp1. - column to be bound (starting with :hp4.1:ehp4.)
:li.:hp1.fCType:ehp1. - type of data (:hp4.SQL_C_...:ehp4.)
:li.:hp1.rgbValue:ehp1. - pointer to variable to be used for storage
:li.:hp1.cbValueMax:ehp1. - maximum length of data to be transfered
:li.:hp1.pcbValue:ehp1. - pointer to variable with length of data to be copied
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.07005  :c.column :hp1.icol:ehp1. not available
:row.:c.                     :c.S1003  :c.unsupported C data type in :hp1.fCType:ehp1.
:row.:c.                     :c.S1002  :c.invalid column number :hp1.icol:ehp1.
:row.:c.                     :c.S1010  :c.no query has been done or no results
:row.:c.                     :c.S1090  :c.result greater than allowed in :hp1.cbValueMax:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.After execution of a query via :link reftype=hd
refid=cli_SQLExecute.SQLExecute():elink. or :link reftype=hd
refid=cli_SQLExecDirect.SQLExecDirect():elink. the results must be bound to
variables before a :link reftype=hd refid=cli_SQLFetch.SQLFetch():elink. call
for getting values can take place. This function bind a variable to a field or
column of the resulting table.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLBindParam clear.SQLBindParam
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLBrowseConnect clear.SQLBrowseConnect
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLCancel'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLCancel clear.SQLCancel
:xmp.
RETCODE SQL_API SQLCancel(
        LPSTMT  lpstmt);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.This function allows canceling of a database operation (INSERT, DELETE,
UPDATE), needing more input data. Such a situation may occur when
:link reftype=hd refid=cli_SQLExecute.SQLExecute():elink. or
:link reftype=hd refid=cli_SQLExecDirect.SQLExecDirect():elink. returns a
status :hp4.SQL_NEED_DATA:ehp4.. Then this function can be called to cancel
the execution of the command in order to specify all missing data and re-do
the operation.

:note.
This function is a dummy function at the current state. mSQL does not support
such things. It may support this in a later version.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLCloseCursor clear.SQLCloseCursor
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLColAttributes'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLColAttributes clear.SQLColAttributes
:xmp.
RETCODE SQL_API SQLColAttributes(
        LPSTMT      lpstmt,
        UWORD       icol,
        UWORD       fDescType,
        UCHAR FAR  *rgbDesc,
        SWORD       cbDescMax,
        SWORD FAR  *pcbDesc,
        SDWORD FAR *pfDesc );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.icol:ehp1. - number of column to be queried (starting with :hp4.1:ehp4.)
:li.:hp1.fDescType:ehp1. - type of information to be queried, numerical or
boolean results are stored in :hp1.pfDesc:ehp1., result string in :hp1.rgbDesc:ehp1..
:lm margin=10.:ul.
:li.:hp4.SQL_COLUMN_AUTO_INCREMENT:ehp4. - check whether a column refers to an
auto increment data type or not. Returns :hp4.FALSE:ehp4. in :hp1.pfDesc:ehp1.
for all data types.
:li.:hp4.SQL_COLUMN_CASE_SENSITIVE:ehp4. - column can case sensitive on
character fields, :hp4.FALSE:ehp4. is returned on numerical fields.
:li.:hp4.SQL_COLUMN_CATALOG_NAME:ehp4. - return catalog name in :hp1.rgbDesc:ehp1.
for the column. Under mSQL returns always an empty string, since there are no
catalogs.
:li.:hp4.SQL_COLUMN_QUALIFIER_NAME:ehp4. - same as :hp4.SQL_COLUMN_CATALOG_NAME:ehp4..
:li.:hp4.SQL_COLUMN_COUNT:ehp4. - :hp1.pfDesc:ehp1. contains the number of
resulting columns.
:li.:hp4.SQL_DISPLAY_SIZE:ehp4. - returns display size for column in :hp1.pfDesc:ehp1.
:li.:hp4.SQL_COLUMN_DISTINCT_TYPE:ehp4. - implemented for compatibility with
IBM's DB2/2. In this implementation returns always an empty string.
:li.:hp4.SQL_COLUMN_LABEL:ehp4. - returns the label of the column in
:hp1.rgbDesc:ehp1..
:li.:hp4.SQL_COLUMN_LENGTH:ehp4. - returns the length of a column in :hp1.pfDesc:ehp1..
:li.:hp4.SQL_COLUMN_MONEY:ehp4. - :hp4.TRUE:ehp4. on columns dealing with cash.
In this implementation, this sub-routine returns always :hp4.FALSE:ehp4..
:li.:hp4.SQL_COLUMN_NAME:ehp4. - in this implementation, same as
:hp4.SQL_COLUMN_LABEL:ehp4..
:li.:hp4.SQL_COLUMN_NULLABLE:ehp4. - returns boolean expression whether a
column can store a NULL value or not (defined as :hp1.NOT NULL:ehp1.).
:li.:hp4.SQL_COLUMN_PRECISION:ehp4. - on numerical columns (fields) the
precision in digits, on character columns the maximum number of bytes.
:li.:hp4.SQL_COLUMN_SCALE:ehp4. - scaling of a column. In the implementation,
returns always :hp4.0:ehp4..
:li.:hp4.SQL_COLUMN_SCHEMA_NAME:ehp4. - returns the table name, in this
implementation returns always an empty string.
:li.:hp4.SQL_COLUMN_OWNER_NAME:ehp4. - same as :hp4.SQL_COLUMN_SCHEMA_NAME:ehp4..
:li.:hp4.SQL_COLUMN_SEARCHABLE:ehp4. - returns on of these
:lm margin=15.:ul.
:li.:hp9.SQL_UNSEARCHABLE:ehp9. - column can't be used with a WHERE clause
:li.:hp9.SQL_LIKE_ONLY:ehp9. - column can be used within WHERE on LIKE operations
:li.:hp9.SQL_ALL_EXCEPT_LIKE:ehp9. - column can be used within WHERE except on LIKE operations
:li.:hp9.SQL_SEARCHABLE:ehp9. - no restrictions in use
:lm margin=10.:eul.
.br
In this implementation for numerical data types :hp9.SQL_ALL_EXCEPT_LIKE:ehp9.
and for character data types :hp9.SQL_SEARCHABLE:ehp9. will be returned.
:li.:hp4.SQL_COLUMN_TABLE_NAME:ehp4. - returns table name, in this implementation
returns always an empty string
:li.:hp4.SQL_COLUMN_TYPE:ehp4. - returns the data type of the column as
numerical value (e.g. :hp1.SQL_CHAR:ehp1.).
:li.:hp4.SQL_COLUMN_TYPE_NAME:ehp4. - returns the data type of the column as string.
The string equals the data type name at column definition in a CREATE TABLE
statement (e.g. "char" for character fields).
:li.:hp4.SQL_COLUMN_UNSIGNED:ehp4. - returns whether a column contains unsigned
data or not. In this implementation :hp4.TRUE:ehp4. on all character columns
and :hp4.FALSE:ehp4. on numerical fields.
:li.:hp4.SQL_COLUMN_UPDATABLE:ehp4. - returns one of these
:lm margin=15.:ul.
:li.:hp9.SQL_ATTR_READWRITE_UNKNOWN:ehp9. - column is updateable
:li.:hp9.SQL_ATTR_READONLY:ehp9. - column can't be updated
:lm margin=10.:eul.
.br
In this implementation all columns are updateable.
:lm margin=5.:eul.
:li.:hp1.rgbDesc:ehp1. - pointer to string buffer for storing the result
:li.:hp1.cbDescMax:ehp1. - maximum length of string buffer :hp1.rgbDesc:ehp1.
:li.:hp1.pcbDesc:ehp1. - pointer to variable storing the length of the result string
:li.:hp1.pfDesc:ehp1. - on non-string results (integer number results) the
result is stored in the variable referenced by this pointer
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.07005  :c.no result available for sub-function
:row.:c.                     :c.40003  :c.communication to database server failed
:row.:c.                     :c.S1002  :c.invalid column number :hp1.icol:ehp1.
:row.:c.                     :c.S1010  :c.there are no results of a query to be examined
:row.:c.                     :c.S1090  :c.invalid pointer :hp1.rgbDesc:ehp1. or :hp1.pfDesc:ehp1. or length :hp1.cbDescMax:ehp1.
:row.:c.                     :c.S1091  :c.invalid sub-function :hp1.fDescType:ehp1.
:row.:c.                     :c.S1C00  :c.CLI can't resolve database server's answer
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS_WITH_INFO:c.01004  :c.result string :hp1.rgbDesc:ehp1. has been truncated
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.This function returns various informations about the result columns of a
database query. Keep in mind, that each call of this function can return only
one answer. An alternative may be :link reftype=hd
refid=cli_SQLDescribeCol.SQLDescribeCol():elink..

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLColumnPrivileges clear.SQLColumnPrivileges
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLColumns clear.SQLColumns
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLConnect'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLConnect clear.SQLConnect
:xmp.
  RETCODE SQL_API SQLConnect(  LPDBC               lpdbc,
                               UCHAR FAR          *szDSN,
                               SWORD               cbDSN,
                               UCHAR FAR          *szUID,
                               SWORD               cbUID,
                               UCHAR FAR          *szAuthStr,
                               SWORD               cbAuthStr
                            );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpdbc:ehp1. - handle to already allocated database context
:li.:hp1.szDSN:ehp1. - pointer to string containing database source (table)
:li.:hp1.cbDSN:ehp1. - size of string :hp1.szDSN:ehp1. or :hp2.SQL_NTS:ehp2.
if string is \0 (NUL) terminated
:li.:hp1.szUID:ehp1. - pointer to string containing user identifier (user name)
for database access
:li.:hp1.cbUID:ehp1. - size of string :hp1.szUID:ehp1. or :hp2.SQL_NTS:ehp2.
if string is \0 (NUL) terminated
:li.:hp1.szAuthStr:ehp1. - pointer to string containing password for database
access
:li.:hp1.cbAuthStr:ehp1. - size of string :hp1.szAuthStr:ehp1. or
:hp2.SQL_NTS:ehp2. if string is \0 (NUL) terminated
:eul.:lm margin=1.

:note.
.br
This special implementation for :hp4.mSQL:ehp4. may have a different use of
:hp1.szDSN:ehp1. as known by other CLIs or ODBC. You may specify :hp1.user
name:ehp1., :hp1.database name:ehp1. and :hp1.host (system name or IP):ehp1.
within this entry. Examples&colon.
:xmp.
  szDSN = <database name>                        "sample"
          <user name>.<database name>            "kim.sample"
          <database name>@<host>                 "sample@minerva.edu.au"
          <user name>.<database name>@<host>     "kim.sample@127.0.0.1"
:exmp.
:note.
.br
If a :hp1.host:ehp1. isn't specified, a connection to the server on the local
machine (:hp1.localhost:ehp1.) is tried to be established.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.08001  :c.can't connect to server
:row.:c.                     :c.08002  :c.connection already established
:row.:c.                     :c.08004  :c.can't connect to database
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid database context handle
:row.:c.SQL_SUCCESS          :c.-      :c.connection established
:etable.

:p.This function has to be called after
:link reftype=hd refid=cli_SQLAllocConnect.SQLAllocConnect():elink.. It tries
to connect to a database source (:hp1.mSQL:ehp1.&colon. host/database). After
successful connection database activities may start.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLCopyDesc clear.SQLCopyDesc
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLDescribeCol clear.SQLDescribeCol
:xmp.
RETCODE SQL_API SQLDescribeCol(
        LPSTMT  lpstmt,
        UWORD   icol,
        UCHAR FAR *szColName,
        SWORD   cbColNameMax,
        SWORD FAR *pcbColName,
        SWORD FAR *pfSqlType,
        UDWORD FAR *pcbColDef,
        SWORD FAR *pibScale,
        SWORD FAR *pfNullable);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.icol:ehp1. - number of column in result list to be examined (starting with :hp4.1:ehp4.)
:li.:hp1.szColName:ehp1. - pointer to string used for storing column name
:li.:hp1.cbColNameMax:ehp1. - maximum length for :hp1.szColName:ehp1.
:li.:hp1.pcbColName:ehp1. - pointer to variable storing real length of :hp1.szColName:ehp1.
:li.:hp1.pfSqlType:ehp1. - pointer to variable storing type of column
:li.:hp1.pcbColDef:ehp1. - pointer to variable storing precision of column
:li.:hp1.pibScale:ehp1. - pointer to variable storing scale of (numeric) column
:li.:hp1.pfNullable:ehp1. - pointer to boolean variable storing info if column is nullable
(:hp4.SQL_NULLABLE:ehp4.) or not (:hp4.SQL_NO_NULLS:ehp4.)
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.07005  :c.column not available
:row.:c.                     :c.40003  :c.can't get column info from server
:row.:c.                     :c.S1002  :c.invalid column number :hp1.icol:ehp1.
:row.:c.                     :c.S1010  :c.no query has been executed
:row.:c.                     :c.S1097  :c.invalid column type detected
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.This routine can be used first to find out how many columns a query returns.
Second, it can be used to detect the type of columns.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLDescribeParam clear.SQLDescribeParam
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLDisconnect'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLDisconnect clear.SQLDisconnect
:xmp.
  RETCODE SQL_API SQLDisconnect(
                               LPDBC               lpdbc
                               );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpdbc:ehp1. - handle to database context
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.08003  :c.no connection established
:row.:c.                     :c.25000  :c.transaction must be ended first
:row.:c.                     :c.58004  :c.can't find path to database
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle to database context
:row.:c.SQL_SUCCESS          :c.-      :c.connection successfully closed
:etable.

:p.The purpose of this routine is to close an open connection established by
:link reftype=hd refid=cli_SQLBrowseConnect.SQLBrowseConnect():elink.,
:link reftype=hd refid=cli_SQLConnect.SQLConnect():elink. or
:link reftype=hd refid=cli_SQLDriverConnect.SQLDriverConnect():elink.. After
successful close there can't be any database activities. Before closing, all
open transactions have to be ended (see
:link reftype=hd refid=cli_SQLTransact.SQLTransact():elink.).

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLDriverConnect clear.SQLDriverConnect
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLEndTran clear.SQLEndTran
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLError'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLError clear.SQLError
:xmp.
  RETCODE SQL_API SQLError(
          LPENV   lpenv,
          LPDBC   lpdbc,
          LPSTMT  lpstmt,
          UCHAR FAR *szSqlState,
          SDWORD FAR *pfNativeError,
          UCHAR FAR *szErrorMsg,
          SWORD   cbErrorMsgMax,
          SWORD FAR *pcbErrorMsg);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpenv:ehp1. - handle for environment block
:li.:hp1.lpdbc:ehp1. - handle for database context block
:li.:hp1.lpstmt:ehp1. - handle for current statement structure
:li.:hp1.szSqlState:ehp1. - pointer to buffer for SQL error state code
:li.:hp1.pfNativeError:ehp1. - pointer to buffer for internal error code
:li.:hp1.szErrorMsg:ehp1. - pointer to string for storing error message text
:li.:hp1.cgErrorMsgMax:ehp1. - maximum length for :hp1.szErrorMsg:ehp1.
:li.:hp1.pcbErrorMsg:ehp1. - result length for :hp1.szErrorMsg:ehp1.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid :hp1.lpenv:ehp1., :hp1.lpdbc:ehp1. and :hp1.lpstmt:ehp1.
:row.:c.SQL_NO_DATA_FOUND    :c.-      :c.no more data or no previous error
:row.:c.SQL_SUCCESS          :c.-      :c.data available
:etable.

:p.Returns a message text for a previously occurred error. If there was no
previous error, :hp2.SQL_NO_DATA_FOUND:ehp2. is returned. After successful
return of this function, all internal states are resetted.

.*------------------------------------------------------------------------------
.*   'SQLExecDirect'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLExecDirect clear.SQLExecDirect
:xmp.
RETCODE SQL_API SQLExecDirect(
        LPSTMT  lpstmt,
        UCHAR FAR *szSqlStr,
        SDWORD  cbSqlStr);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.sqSqlStr:ehp1. - SQL statement to be prepared
:li.:hp1.cbSqlStr:ehp1. - size of string :hp1.szSqlStr:ehp1. or
:hp2.SQL_NTS:ehp2. if string is \0 (NUL) terminated
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.xxxxx  :c.see below
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.This call combines :link reftype=hd refid=cli_SQLPrepare.SQLPrepare():elink.
with :link reftype=hd refid=cli_SQLExecute.SQLExecute():elink.. It may be used
if there are no parameters to be set between preparation and execution of a
statement. The error code are the same as described at the routines mentioned
above.

.*------------------------------------------------------------------------------
.*   'SQLExecute'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLExecute clear.SQLExecute
:xmp.
  RETCODE SQL_API SQLExecute(
          LPSTMT  lpstmt);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statment
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.08001  :c.cannot execute
:row.:c.                     :c.40003  :c.no connection to database
:row.:c.                     :c.S1010  :c.no prepared statement found
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.execution ended successfully
:etable.

:p.After preparation of a SQL statement with :link reftype=hd
refid=cli_SQLPrepare.SQLPrepare():elink. this function executes the statement.
Afterwards, on insertion or deletion :link reftype=hd
refid=cli_SQLRowCount.SQLRowCount():elink. returns the number of rows affected
by the operation, on selection :link reftype=hd
refid=cli_SQLNumResultCols.SQLNumResultCols():elink. shows the number of
selected rows, that can be queried by :link reftype=hd
refid=cli_SQLDescribeCol.SQLDescribeCol():elink., :link reftype=hd
refid=cli_SQLBindCol.SQLBindCol():elink. and :link reftype=hd
refid=cli_SQLFetch.SQLFetch():elink..

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLExtendedFetch clear.SQLExtendedFetch
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLFetch'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLFetch clear.SQLFetch
:xmp.
RETCODE SQL_API SQLFetch(
        LPSTMT  lpstmt);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.58004  :c.can't get field (internal error)
:row.:c.                     :c.S1010  :c.query must be executed first
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_NO_DATA_FOUND    :c.-      :c.no more results can be fetched
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.The results of a query, executed via :link reftype=hd
refid=cli_SQLExecute.SQLExecute():elink. or :link reftype=hd
refid=cli_SQLExecDirect.SQLExecDirect().:elink., with variables bound by
:link reftype=hd refid=cli_SQLBindCol.SQLBindCol():elink., can be processed
row by row with this function. It copies the resulting fields (columns) into
the bounded variables.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLForeignKeys clear.SQLForeignKeys
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLFreeConnect'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLFreeConnect clear.SQLFreeConnect
:xmp.
  RETCODE SQL_API SQLFreeConnect(
                               LPDBC               lpdbc
                                );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpdbc:ehp1. - handle to database context block
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1010  :c.connection has to be closed first
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid pointer :hp1.lpdbc:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.context successfully freed
:etable.

:p.After database operation this call has to be used to remove the database
context block. After successful removement :hp1.:link reftype=hd
refid=cli_SQLFreeEnv.SQLFreeEnv():elink.:ehp1. can be called.

.*------------------------------------------------------------------------------
.*   'SQLFreeEnv'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLFreeEnv clear.SQLFreeEnv
:xmp.
  RETCODE SQL_API SQLFreeEnv(  LPENV               lpenv
                            );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpenv:ehp1. - handle for environment block
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1010  :c.connections have to be closed first
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid pointer :hp1.lpenv:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.environment successfully freed
:etable.

:p.This function has to be called at the end of the program to free the CLI
environment block. After successful removement of the environment block, the
variable used for handle storage (input parameter :hp1.lpenv:ehp1.) has to be
invalidated.

:note.
After successfully freeing the CLI environment block, no error message can be
obtained through :hp2.SQLError:ehp2..

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLFreeHandle clear.SQLFreeHandle
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLFreeStmt'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLFreeStmt clear.SQLFreeStmt
:xmp.
  RETCODE SQL_API SQLFreeStmt(
          LPSTMT  lpstmt,
          UWORD   fOption);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.fOption:ehp1. - option code&colon.:lm margin=10.
:li.:hp2.SQL_CLOSE:ehp2. - close statement (cursor)
:li.:hp2.SQL_DROP:ehp2. - close statement (cursor) and free handle
:li.:hp2.SQL_UNBIND:ehp2. - unbind columns, keep statement
:li.:hp2.SQL_RESET_PARAMS:ehp2. - reset parameters on bind-columns
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1092  :c.invalid option :hp1.fOption:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.operation succeeded
:etable.

:p.Depending on the option code :hp1.fOption:ehp1. a statement handle allocated
with :link reftype=hd refid=cli_SQLAllocStmt.SQLAllocStmt():elink. is reseted
in parts or total, or is freed.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetCol clear.SQLGetCol
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetConnectAttr clear.SQLGetConnectAttr
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetConnectOption clear.SQLGetConnectOption
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLGetCursorName'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetCursorName clear.SQLGetCursorName
:xmp.
RETCODE SQL_API SQLGetCursorName(
        LPSTMT  lpstmt,
        UCHAR FAR *szCursor,
        SWORD   cbCursorMax,
        SWORD FAR *pcbCursor);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.szCursor:ehp1. - variable to be filled with cursor name
:li.:hp1.cbCursorMax:ehp1. - maximum length of :hp1.szCursor:ehp1.
:li.:hp1.pcbCursor:ehp1. - pointer to variable storing result length of :hp1.szCursor:ehp1.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1090  :c.parameter :hp1.szCursor:ehp1. must not be NULL
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS_WITH_INFO:c.01004  :c.cursor name was truncated
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.This function returns the name of the cursor associated with the statement.
A new cursor name can be set by calling :link reftype=hd
refid=cli_SQLSetCursorName.SQLSetCursorName():elink..

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetData clear.SQLGetData
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetDescField clear.SQLGetDescField
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetDescRec clear.SQLGetDescRec
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetDiagField clear.SQLGetDiagField
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetDiagRec clear.SQLGetDiagRec
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetEnvAttr clear.SQLGetEnvAttr
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetInfo clear.SQLGetInfo
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetStmtAttr clear.SQLGetStmtAttr
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetStmtOption clear.SQLGetStmtOption
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetTypeInfo clear.SQLGetTypeInfo
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLLanguages clear.SQLLanguages
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLMoreResults clear.SQLMoreResults
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLNativeSql clear.SQLNativeSql
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLNumParams clear.SQLNumParams
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLNumResultCols'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLNumResultCols clear.SQLNumResultCols
:xmp.
RETCODE SQL_API SQLNumResultCols(
        LPSTMT  lpstmt,
        SDWORD FAR *pccol);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.pccol:ehp1. - pointer to variable used to store the number of columns
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1009  :c.:hp1.pccol:ehp1. must point to a variable
:row.:c.                     :c.S1010  :c.the query has to be executed first
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid pointer :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.After a successful execution of a query via :link reftype=hd
refid=cli_SQLExecute.SQLExecute():elink., the number of resulting columns can
be obtained by this function.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLParamData clear.SQLParamData
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLParamOptions clear.SQLParamOptions
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLPrepare'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLPrepare clear.SQLPrepare
:xmp.
  RETCODE SQL_API SQLPrepare(
          LPSTMT  lpstmt,
          UCHAR FAR *szSqlStr,
          SDWORD  cbSqlStr);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.sqSqlStr:ehp1. - SQL statement to be prepared
:li.:hp1.cbSqlStr:ehp1. - size of string :hp1.szSqlStr:ehp1. or
:hp2.SQL_NTS:ehp2. if string is \0 (NUL) terminated
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.24000  :c.statement handle already in use
:row.:c.                     :c.S1001  :c.memory allocation error
:row.:c.                     :c.S1009  :c.invalid pointer :hp1.szSqlStr:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.preparation successfully
:etable.

:p.Prepares a SQL statement for execution with :link reftype=hd
refid=cli_SQLExecute.SQLExecute():elink..

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLPrimaryKeys clear.SQLPrimaryKeys
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLProcedureColumns clear.SQLProcedureColumns
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLProcedures clear.SQLProcedures
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLPutData clear.SQLPutData
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLReleaseEnv clear.SQLReleaseEnv
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLRowCount'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLRowCount clear.SQLRowCount
:xmp.
RETCODE SQL_API SQLRowCount(
        LPSTMT  lpstmt,
        SDWORD FAR *pcrow);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.pcrow:ehp1. - pointer to variable used for storage of row count
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1009  :c.:hp1.pcrow:ehp1. must point to a variable
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.no error
:etable.

:p.The number of rows affected by an UPDATE, INSERT or DELETE can be obtained
with this function. For the number of rows returned by a SELECT have a look
at :link reftype=hd refid=cli_SQLNumResultCols.SQLNumResultCols():elink..

:note.
This function is not absolutely identical to the ANSI, ODBC or X/Open version.
On UPDATE, INSERT or DELETE a value of :hp4.0:ehp4. is always returned
regardless the true number of rows affected. On SELECT it returns the number
of rows selected.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLServerInfo clear.SQLServerInfo
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetConnectOption clear.SQLSetConnectOption
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLSetCursorName'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetCursorName clear.SQLSetCursorName
:xmp.
RETCODE SQL_API SQLSetCursorName(
        LPSTMT  lpstmt,
        UCHAR FAR *szCursor,
        SWORD   cbCursor);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.szCursor:ehp1. - pointer to string containing new cursor name
:li.:hp1.cbCursor:ehp1. - length od :hp1.szCursor:ehp1. or :hp4.SQL_NTS:ehp4.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.34000  :c.invalid cursor name in :hp1.szCursor:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.This is the reverse function to :link reftype=hd
refid=cli_SQLGetCursorName.SQLGetCursorName():elink.. It is used to set a new
cursor name for the statement. A cursor name must start with a character
(:hp4.a..z:ehp4. or :hp4.A..Z:ehp4.) and may then contain a mixture of
characters, digits and underscores (:hp4.a..z:ehp4., :hp4.A..Z:ehp4.,
:hp4.0..9:ehp4. or :hp4._:ehp4.).

:note.
Other implementations need unique cursor names and do not allow the re-use of
a cursor name, that has been already in use. This implementation does not
check cursor names for unique use, since cursor names are not being used
internally, but are implemented for compatibility.

:note.
Since there will be a unique cursor name created during allocation of the
statement handle (:link reftype=hd refid=cli_SQLAllocStmt.SQLAllocStmt():elink.),
you may not use this function within your programs.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetDescField clear.SQLSetDescField
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetDescRec clear.SQLSetDescRec
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetEnvAttr clear.SQLSetEnvAttr
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLSetParam'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetParam clear.SQLSetParam
:xmp.
RETCODE SQL_API SQLSetParam(
        LPSTMT      lpstmt,
        UWORD       ipar,
        SWORD       fCType,
        SWORD       fSqlType,
        UDWORD      cbColDef,
        SWORD       ibScale,
        PTR         rgbValue,
        SDWORD FAR *pcbValue );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.ipar:ehp1. - number of parameter to be defined, starting left to right
with :hp4.1:ehp4..
:li.:hp1.fCType:ehp1. - C data type (:hp1.SQL_C_...:ehp1.) or :hp4.SQL_C_DEFAULT:ehp4..
:li.:hp1.fSqlType:ehp1. - SQL data type (e.g. :hp4.SQL_INTEGER:ehp4.).
:li.:hp1.cbColDef:ehp1. - length of data to be transfered (character fields)
or precision on :hp4.SQL_DECIMAL:ehp4. / :hp4.SQL_NUMERIC:ehp4., else ignored.
:li.:hp1.ibScale:ehp1. - scaling factor (used only at :hp4.SQL_DECIMAL:ehp4.
or :hp4.SQL_NUMERIC:ehp4.).
:li.:hp1.rgbValue:ehp1. - pointer to variable to be bound to parameter.
:li.:hp1.pcbValue:ehp1. - pointer to variable used for signalising, how many
bytes were transfered at execution of the statement.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.07006  :c.can't convert C data type into SQL data type
:row.:c.                     :c.S1003  :c.invalid C data type in :hp1.fCType:ehp1.
:row.:c.                     :c.S1004  :c.invalid SQL data type in :hp1.fSqlType:ehp1.
:row.:c.                     :c.S1009  :c.:hp1.rgbValue:ehp1. must not be NULL
:row.:c.                     :c.S1010  :c.must be called after :link reftype=hd refid=cli_SQLPrepare.SQLPrepare():elink.
:row.:c.                     :c.S1013  :c.can't allocate internal memory
:row.:c.                     :c.S1093  :c.invalid parameter number :hp1.ipar:ehp1.
:row.:c.                     :c.S1094  :c.invalid value in :hp1.ibScale:ehp1.
:row.:c.                     :c.S1104  :c.invalid value in :hp1.cbColDef:ehp1.
:row.:c.                     :c.S1C00  :c.unable to resolve the given C or SQL data type
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.A parameter is a place holder in a SQL statement which is resolved at
execution time (via :link reftype=hd refid=cli_SQLExecute.SQLExecute():elink.).
A parameter is marked by a simple question mark (":hp4.?:ehp4."). Question
marks inside of strings delimited by single quotes (":hp4.':ehp4."). are not
treated as parameter placeholders but as characters. An example would be
this&colon.
:lines align=left.
    select name, age from test where name='???' or name=?
:elines.
At execution time this would be resolved to&colon.
:lines align=left.
    select name, age from test where name='???' or name='[contents of variable]'
:elines.

:note.
Character fields will be enclosed in single quotes automatically.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetPos clear.SQLSetPos
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetScrollOptions clear.SQLSetScrollOptions
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetStmtAttr clear.SQLSetStmtAttr
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetStmtOption clear.SQLSetStmtOption
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSpecialColumns clear.SQLSpecialColumns
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLStatistics clear.SQLStatistics
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLTablePrivileges clear.SQLTablePrivileges
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQL'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLTables clear.SQLTables
:xmp.
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.
:row.:c.X/Open          :c.
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.       :c.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.
:row.:c.SQL_SUCCESS          :c.-      :c.
:etable.

:p.

.*------------------------------------------------------------------------------
.*   'SQLTransact'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLTransact clear.SQLTransact
:xmp.
RETCODE SQL_API SQLTransact(
        LPENV   lpenv,
        LPDBC   lpdbc,
        UWORD   fType);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpenv:ehp1. - handle for environment (or :hp4.SQL_NULL_HENV:ehp4.)
:li.:hp1.lpdbc:ehp1. - handle for database context (or :hp4.SQL_NULL_HDBC:ehp4.)
:li.:hp1.fType:ehp1. - type of action to be done: :hp4.SQL_COMMIT:ehp4. to
commit all previous database activities, or :hp4.SQL_ROLLBACK:ehp4. to withdraw
all former activities
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.08003  :c.no connection open for specified action
:row.:c.                     :c.58004  :c.:hp4.SQL_ROLLBACK:ehp4. failed
:row.:c.                     :c.S1012  :c.invalid action code :hp1.fType:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.handle :hp1.lpenv:ehp1. or :hp1.lpdbc:ehp1. must be set
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.The purpose of the function is to commit or rollback (withdraw) database
actions, like INSERT, UPDATE or DELETE. This function is called normally after
(at the end of) a(n) (un)successful transaction.

:note.
mSQL 1.x does not allow rollbacks on previous database actions. This is because
it does not have any recovery mechanism. For that reason all rollback
operations result in an error :hp4.SQL_ERROR:ehp4. with message code
:hp4.58004:ehp4., to signalize an unsuccessful rollback.

.*------------------------------------------------------------------------------
.* 'CLI Function Return Codes'
.*------------------------------------------------------------------------------
:h1 id=cli_function_return_codes clear.CLI Function Return Codes
:p.Each Call-Level Interface (CLI) function returns a result code, that
shows success or failure of an operation, or if there is additional information
code to be processed.

:table cols='25 54'.
:row.:c.SQL_SUCCESS           :c.operation ended successfully
:row.:c.SQL_SUCCESS_WITH_INFO :c.same, but there is additional information
(see table below)
:row.:c.SQL_NEED_DATA         :c.operation aborted due to lack of data
:row.:c.SQL_NO_DATA           :c.operation failed due to lack of data
:row.:c.SQL_NO_DATA_FOUND     :c.there is no data found
:row.:c.SQL_ERROR             :c.operation failed, see :link reftype=hd
refid=cli_SQLError.SQLError:elink.
:row.:c.SQL_INVALID_HANDLE    :c.invalid handle (
:link reftype=hd refid=sql_data_types.HDBC:elink.,
:link reftype=hd refid=sql_data_types.HDESC:elink.,
:link reftype=hd refid=sql_data_types.HENV:elink.,
:link reftype=hd refid=sql_data_types.HSTMT:elink.
)
:etable.

:note.
The definition :hp2.SQL_SUCCEEDED(:ehp2.:hp4.x:ehp4.:hp2.):ehp2. can be used to
detect whether :hp4.x:ehp4. specifies a return code of a successful operation
or not.

:p.:hp2.Internal error messages and codes:ehp2. (set at :hp1.SQL_ERROR:ehp1.)
:table cols='25 54'.
:row.:c.Code  :c.Message
:row.:c.01004 :c.result string has been truncated
:row.:c.07005 :c.column or result value not available
:row.:c.07006 :c.can't convert C data type into SQL data type
:row.:c.08001 :c.can't connect to server, cannot execute
:row.:c.08002 :c.connection already established
:row.:c.08003 :c.no connection established
:row.:c.08004 :c.can't connect to database
:row.:c.24000 :c.statement handle already in use
:row.:c.25000 :c.transaction must be ended first
:row.:c.34000 :c.invalid cursor name
:row.:c.40003 :c.no connection to database or communication error
:row.:c.58004 :c.ROLLBACK failed or an other internal error
:row.:c.S1001 :c.memory allocation error
:row.:c.S1002 :c.invalid column number
:row.:c.S1003 :c.invalid or unsupported C data type
:row.:c.S1004 :c.invalid SQL data type
:row.:c.S1009 :c.pointer must address a variable and mustn't be NULL
:row.:c.S1010 :c.invalid sequence in function calls
:row.:c.S1012 :c.invalid action code
:row.:c.S1013 :c.can't allocate internal memory
:row.:c.S1090 :c.parameter error (parameter must not be NULL, range error)
:row.:c.S1091 :c.invalid sub-function specified
:row.:c.S1092 :c.invalid option
:row.:c.S1093 :c.invalid parameter number
:row.:c.S1094 :c.invalid value
:row.:c.S1097 :c.invalid column type detected
:row.:c.S1104 :c.invalid value
:row.:c.S1C00 :c.a parameter or result can't be resolved
:etable.

.*------------------------------------------------------------------------------
.* 'Sample Sources'
.*------------------------------------------------------------------------------
:h1 id=samples clear.Sample Sources
:p.The sample sources directory contains of the following files&colon.
:table cols='25 54'.
:row.:c.Makefile
:c.Makefile for building the programs, depending on the distribution
(mSQL for OS/2, stand-alone) equals Makefile.OS2 or Makefile.UNX
:row.:c.Makefile.OS2
:c.original Makefile for use with OS/2 and IBM C/C++ Set/2 or IBM Visual
Age C++
:row.:c.Makefile.UNX
:c.original Makefile for use with various UNIX OSs.
:row.:c.README.TXT
:c.file with the latest news about the sample sources
:row.:c.db2conv.c
:c.C source code of a small convertor, that converts binaries (*.EXE)
compiled for use with DB2/2 (-->DB2CLI.DLL), so that they are useable
with mSQL for OS/2 (-->LIBCLI.DLL).
:hp8.NOTE&colon.:ehp8.This program is for use with OS/2 only!
:row.:c.monitor.c
:c.simple SQL monitor written in C. Queries for a SQL statement, sends it
to the server and shows the results.
:row.:c.showtab.c
:c.another C source. Like 'monitor', but returns additional information
about the result columns.
:etable.

.*------------------------------------------------------------------------------
.* 'Limitations and Differences to Standard CLI'
.*------------------------------------------------------------------------------
:h1 id=limits clear.Limitations and Differences to Standard CLI
:p.Depending on the version of this CLI implementation, there are limitations
and differences to the CLI standard. Some of them, which are common to all
version of this CLI, are described below, others, unique to one version, in
the following sub-sections.

:p.There are the following limits dependingless to the version&colon.
:lm margin=5.:ul.
:li.The length of the string associated to a cursor is limited to the value
:hp4.SQL_MAX_CURSOR_NAME:ehp4. (32 byte = :hp4.31:ehp4. characters plus
terminating NUL).
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.* 'Limits on CLI for mSQL'
.*------------------------------------------------------------------------------
:h2 id=limits_msql clear.Limits on CLI for mSQL
:p.Currently these SQL and C data types are supported by CLI for mSQL&colon.
:lm margin=5.:ul.
:li.:link reftype=hd refid=sql_data_types.SQL_CHAR:elink. (SQL_C_CHAR) equals
the :hp1.CHAR:ehp1. data type of mSQL.
:li.:link reftype=hd refid=sql_data_types.SQL_INTEGER:elink. (SQL_C_INTEGER)
equals the :hp1.INT:ehp1. data type of mSQL.
:li.:link reftype=hd refid=sql_data_types.SQL_REAL:elink. (SQL_C_REAL) equals
the :hp1.REAL:ehp1. data type of mSQL.
:eul.:lm margin=1.

:p.The implementation level of routines equals :hp1.ODBC core level:ehp1..

:p.There are the following limits on CLI for mSQL for Unix and mSQL for
OS/2&colon.
:lm margin=5.:ul.
:li.The number of resulting colums which can be bound to variables is limited
to :hp4.SQL_MAX_COLUMN:ehp4. (:hp4.64:ehp4.).
:li.The number of input parameters on a query, insert, update, delete, etc.,
which can be bound to variables, is limited to :hp4.SQL_MAX_PARAM:ehp4.
(:hp4.16:ehp4.).
:li.There is a maximum size a SQL statement can reach at execution time of
:hp4.SQL_MAX_BUFFER_SIZE:ehp4. (:hp4.65535:ehp4.) bytes - this includes the
SQL statement plus all string space provided by input parameters (bounded
variables).
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.* 'Limits on CLI for Oracle'
.*------------------------------------------------------------------------------
:h2 id=limits_oracle clear.Limits on CLI for Oracle
:p.Currently these SQL and C data types are supported by CLI for
Oracle 7.x&colon.
:lm margin=5.:ul.
:li.:link reftype=hd refid=sql_data_types.SQL_CHAR:elink. (SQL_C_CHAR) equals
the :hp1.VARCHAR2:ehp1. data type of Oracle 7.x.
:li.:link reftype=hd refid=sql_data_types.SQL_INTEGER:elink. (SQL_C_INTEGER)
equals the :hp1.NUMBER:ehp1. data type of Oracle 7.x.
:li.:link reftype=hd refid=sql_data_types.SQL_REAL:elink. (SQL_C_REAL) equals
the :hp1.NUMBER:ehp1. data type of Oracle 7.x.
:eul.:lm margin=1.

:p.The implementation level of routines equals :hp1.ODBC core level:ehp1.,
except :hp2.SQLColAttributes():ehp2. (see below).

:p.There are the following limits on CLI for Oracle 7.xcolon.
:lm margin=5.:ul.
:li.Requires Oracle's OCI (:hp1.Oracle Call Interface:ehp1.) at a version
7020200.1 (Feb. 15, 1995) or newer.
:li.:hp2.SQL_CHAR:ehp2. does :hp8.not:ehp8. refer to the :hp2.CHAR:ehp2. data
type of Oracle's database, but refers to :hp2.VARCHAR2:ehp2.. This is due to
the compatibility considerations - mSQL lacks such a data type, but its
:hp1.CHAR:ehp1. data type exquals VARCHAR2. So to keep both CLI implementations
compatible, the :hp1.SQL_CHAR:ehp1. has been defined as stated. Another point
is, that Oracle changed definitions on CHAR and VARCHAR2 data types between
Oracle 6.x and 7.x.
:li.:link reftype=hd refid=cli_SQLColAttributes.SQLColAttributes():elink.
does not work properly (produces core dumps),
:link reftype=hd refid=cli_SQLDescribeCol.SQLDescribeCol():elink. has to be
used instead. There you have to note, that every column can be stated only
one time each! This is a limitation of Oracle's OCI ...
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.* 'Author's Details'
.*------------------------------------------------------------------------------
:h1 id=author clear.Author's Details
:p.The Call-Level Interface (CLI) for mSQL (OS/2) was written by&colon.
:xmp.
  Dirk Ohme
  Programmer at transtec AG
  T&ue.bingen, Germany

  E-mail:  Dirk.Ohme@transtec.de
  Fidonet: 2&colon.246/2001.9@fidonet
:exmp.

.*------------------------------------------------------------------------------
.* 'Archive Location'
.*------------------------------------------------------------------------------
:h1 id=archive clear.Archive Location
:p.The primary site for this product is&colon.
:xmp.
  Host:   www.fh-albsig.de (141.87.110.2)
  URL:    http&colon.//www.fh-albsig.de/~ohme
  Files:  FILES/msql*.lsm (description)
          FILES/msql*.zip (Zip 2.0.1 archive, Source &amp. Binaries)
  Note:   OS/2 port
:exmp.
:p.It can be also be found at&colon.
:xmp.
  WWW:    http&colon.//Hughes.com.au/
  ftp:    ftp&colon.//ftp.Bond.edu.au/pub/Minerva/msql/Contrib/msql*-os2.lsm
          ftp&colon.//ftp.Bond.edu.au/pub/Minerva/msql/Contrib/msql*-os2.zip
:exmp.

.*------------------------------------------------------------------------------
.* end of document
.*------------------------------------------------------------------------------
:euserdoc.
.*==============================================================================
