//
// Msql client library for JAVA
// Copyright (C) 1995 Darryl Collins <darryl@minmet.uq.oz.au>
// This software is provided "as is" without any expressed or implied warranty.
//
// This package implements a client for the mSQL server designed and
// implemented by David Hughes <bambi@hughes.com.au>
//
// $Log: MsqlResult.java,v $
// Revision 1.1.1  1996/02/15 06:12:10  root
// Initial revision
//
//

// package msql;

import java.awt.*;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;

/**
 * Object containing the results of a select query.  A combination of two
 * MsqlData instances representing the retrieved data and a description
 * of the fields which make up the data.
 */
public class MsqlResult {

	private MsqlData rowData, fieldData;
	private MsqlFieldDesc[] fieldDesc;

	private int nCursor=0;
	private int nFields;

/**
 * Constructor - Accepts row and field info as arguments
 *
 * @param table		instance of MsqlData representing the data set.
 * @param fields	instance of MsqlData containing field information.
 */
	public MsqlResult(MsqlData table, MsqlData fields) {

		rowData = new MsqlData(table);
		fieldData = new MsqlData(fields);

		nFields = fields.NumRows();
		if(nFields != 0) {
			fieldDesc = new MsqlFieldDesc[nFields];
			for(int i=0; i<nFields; i++)
				fieldDesc[i] = new MsqlFieldDesc(fields.FetchRow());
		}
	}

/**
 * Fetch the next row from the table
 *
 * @return		an array of Strings representing the columns of the row.
 */
	public String [] FetchRow() {

		return rowData.FetchRow();
	}

/**
 * Fetch the field from the table
 *
 * @return		an array of Strings representing the columns of the row.
 */
	public String [] _FetchField() {

		return fieldData.FetchRow();
	}

/**
 * Fetch the next field from the list of fields
 *
 * @return		an array of Strings representing the Name, Type, Length Non-null flag and key flag of the next field.
 */
	public MsqlFieldDesc FetchField() {

		if(nCursor < nFields) 
			return fieldDesc[nCursor++];

		return null;
	}

/**
 * Return reference to array of field descriptions.
 *
 * @return		an array of MsqlFieldDesc.
 */
	public MsqlFieldDesc[] ListFields() {

		return fieldDesc;
	}

/**
 * Return number of rows in table
 * 
 * @return		the number of rows in this data set.
 */
	public int NumRows() {
		return rowData.NumRows();
	}

/** 	
 * Return number of fields in table
 * 
 * @return		the number of fields in this data set.
 */
	public int NumFields() {
		return nFields;
	}

/**
 * Data Seek
 *
 * @param i		the index of the row to be retrieved.
 */
	public void DataSeek(int i) {

		rowData.DataSeek(i);
	}

/**
 * Field Seek
 *
 * @param i		the index of the field to be retrieved.
 */
	public void FieldSeek(int i) {

		nCursor=i;
	}
}


