head	1.4;
access;
symbols;
locks
	PTI:1.4; strict;
comment	@ * @;


1.4
date	96.08.04.11.51.59;	author PTI;	state Exp;
branches;
next	1.3;

1.3
date	96.08.02.00.29.45;	author PTI;	state Exp;
branches;
next	1.2;

1.2
date	96.08.01.23.30.11;	author PTI;	state Exp;
branches;
next	1.1;

1.1
date	96.07.24.20.45.30;	author PTI;	state Exp;
branches;
next	;


desc
@library routines for client programs
@


1.4
log
@removed conflicts between "errmsg.h" and "winsock.h".
added #undefs (APIENTRY and SOCKET_ERROR)
@
text
@/*
**      libmsql.c       -
**
**
** Copyright (c) 1993-95  David J. Hughes
** Copyright (c) 1995  Hughes Technologies Pty Ltd
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** This software is provided "as is" without any expressed or implied warranty.
**
** ID = "$Id:"
**
*/

/*
 * include files
 */
#ifdef OS2
/*
 * includes necessary on OS/2
 */
#  include <stdio.h>
#  include <fcntl.h>
#  include <sys/types.h>
#  include <sys/stat.h>
#  include <sys/socket.h>
#  include <netinet/in.h>
#  include <arpa/nameser.h>

#  include <signal.h>
#  include <netdb.h>
#  include <stdlib.h>
#  include <stdarg.h>
#  include <memory.h>
#endif
#ifdef WINNT
/*
 * includes necessary on Win NT
 */
#  include <stdio.h>
#  include <fcntl.h>
#  include <sys/types.h>
#  include <sys/stat.h>
#  ifdef WINSOCK
#    include <winsock.h>
#    undef SOCKET_ERROR
#    undef APIENTRY
#    define APIENTRY
#  else
#    include <sys/socket.h>
#    include <netinet/in.h>
#    include <arpa/inet.h>
#  endif
#  include <signal.h>
#  ifndef WINSOCK
#    include <netdb.h>
#  endif
#  include <stdlib.h>
#  include <stdarg.h>
#  include <memory.h>
#  include "errmsg.h"
#endif
/*
 * includes necessary on UNIX
 */
#ifdef UNIX
#  include <stdio.h>
#  include <fcntl.h>
#  include <sys/types.h>
#  include <sys/stat.h>
#  include <sys/socket.h>
#  include <netinet/in.h>
#  include <arpa/inet.h>

#  include <signal.h>
#  include <netdb.h>
#  include <pwd.h>
#  include <stdlib.h>
#  include <varargs.h>
#  include <string.h>
#endif

/*
 * common parts
 */
#include "common/portable.h"

#ifdef HAVE_SYS_UN_H
#  include <sys/un.h>
#endif


#include "common/site.h"

#include "msql_prv.h"
#ifndef WINNT
#  include "errmsg.h"
#endif

#define _LIB_SOURCE
#include "msql.h"

#ifndef INADDR_NONE
#define INADDR_NONE     -1
#endif


static  char    serverInfo[80],
                hostInfo[80];
static  int     curServerSock,
                                         numFields,
                queryTableSize,
                fieldTableSize,
                protoInfo;
static  m_data *tmpDataStore = NULL,
                                         *queryData = NULL,
                                         *fieldData = NULL;


char    msqlErrMsg[160];

#ifdef WINSOCK
int DoWSAInit = -1;
#endif

RETSIGTYPE      (*oldHandler)();
#ifndef UNIX
                  /*
                        * OS2 & WINNT
                        */
  static void msqlDebug( int module, ... );
#else
                  /*
                        * UNIX
                        */
  static void msqlDebug();
#endif

#define resetError()    (void)bzero(msqlErrMsg,sizeof(msqlErrMsg))
#define chopError()     { char *cp; cp = msqlErrMsg+strlen(msqlErrMsg) -1; if (*cp == '\n') *cp = 0;}


extern  char    *packet;

#define safeFree(x)     {if(x) { (void)free(x); x = NULL; } }



/**************************************************************************
**      msqlNoWSAInit
**
**      Purpose : Set DoWSAInit flag to inactive      * OS/2 !!! *
**      Args    :
**      Returns :
**      Notes   : Needed if main app needs sockets of its own
*/
void msqlNoWSAInit()
{
        DoWSAInit = 0;       /* disable calling WSAStartUp, WSACleanUp */
}

/**************************************************************************
**      msqlGetErrMsg
**
**      Purpose : read internal error message variable      * OS/2 !!! *
**      Args    :
**      Returns :
**      Notes   :
*/
#ifdef __STDC__
char   * APIENTRY msqlGetErrMsg( char *pszErrMsg )
#else
char   * APIENTRY msqlGetErrMsg( pszErrMsg )
  char *pszErrMsg;
#endif
{ /*
  ** check parameter
  */
  if( NULL != pszErrMsg )
  { strncpy( pszErrMsg, msqlErrMsg, sizeof(msqlErrMsg) );
         return pszErrMsg;
  }

  /*
  ** NULL parameter -> return pointer to internal variable
  */
  return (char *)&msqlErrMsg;
}


/**************************************************************************
**      _ msqlInitDebug
**
**      Purpose :
**      Args    :
**      Returns :
**      Notes   :
*/

#define MOD_QUERY       1
#define MOD_API         2
#define MOD_MALLOC      4
#define MOD_ERROR       8


static int      debugLevel=0,
                                         debugInit = 0;

static void msqlInitDebug()
{
                  char    *env,
                                         *tmp,
                                         *tok;

                  env = getenv("MINERVA_DEBUG");
                  if(env)
                  {
                                         tmp = (char *)strdup(env);
                  }
                  else
                return;
        printf("\n-------------------------------------------------------\n");
        printf("MINERVA_DEBUG found. libmsql started with the following:-\n\n");
                  tok = (char *)strtok(tmp,":");
        while(tok)
                  {
                if (strcmp(tok,"msql_query") == 0)
                {
                        debugLevel |= MOD_QUERY;
                                                                printf("Debug level : query\n");
                }
                if (strcmp(tok,"msql_api") == 0)
                                         {
                        debugLevel |= MOD_API;
                        printf("Debug level : api\n");
                }
                                         if (strcmp(tok,"msql_malloc") == 0)
                {
                                                                debugLevel |= MOD_MALLOC;
                        printf("Debug level : malloc\n");
                }
                tok = (char *)strtok(NULL,":");
                  }
                  safeFree(tmp);
        printf("\n-------------------------------------------------------\n\n");
}






/**************************************************************************
**      _msqlDebug
**
**      Purpose :
**      Args    :
**      Returns :
**      Notes   :
*/

#ifndef UNIX
                  /*
         * OS2 & WINNT
                        */
  static void msqlDebug( int module, ... )
#else
        /*
                        * UNIX
         */
  static void msqlDebug(va_alist)
                        va_dcl
#endif
{
                va_list args;
                  char    msg[1024],
                *fmt;
                  int     out = 0;

#ifndef UNIX
                /*
                                          * OS2 & WINNT
                 */
        va_start(args, module);
#else
        int     module;

        va_start(args);
                  module = (int) va_arg(args, int *);
#endif
                  if (! (module & debugLevel))
        {
                va_end(args);
                return;
                  }

        fmt = (char *)va_arg(args, char *);
                  if (!fmt)
                return;
        (void)vsprintf(msg,fmt,args);
        va_end(args);
                  printf("[libmsql] %s",msg);
        fflush(stdout);
}


/**************************************************************************
**      _setServerSock
**
**      Purpose : Store the server socket currently in use
**      Args    : Server socket
**      Returns : Nothing
**      Notes   : The current socket is stored so that the signal
**                handlers know which one to shut down.
*/

static void setServerSock(sock)
                  int     sock;
{
                  curServerSock = sock;
}




/**************************************************************************
**      _closeServer
**
**      Purpose : Shut down the server connection
**      Args    : Server socket
**      Returns : Nothing
**      Notes   : This is used by msqlClose and the signal handlers
*/

static void closeServer(sock)
        int     sock;
{
        msqlDebug(MOD_API,"Server socket (%d) closed\n", sock);
        shutdown(sock,2);
#ifndef NOSIGNAL
#ifdef SIGPIPE
                  signal(SIGPIPE,oldHandler);
#else
                  signal(SIGABRT,oldHandler);
#endif
#endif

#ifdef OS2
                  soclose(sock);
#elif defined WINSOCK
                  closesocket(sock);
                  if (DoWSAInit)
                                WSACleanup();
#else
                  close(sock);
#endif
}





/**************************************************************************
**      _msqlClose
**
**      Purpose : Send a QUIT to the server and close the connection
**      Args    : Server socket
**      Returns : Nothing
**      Notes   :
*/

void APIENTRY msqlClose(sock)
        int     sock;
{
        char    buf[6];

                  setServerSock(sock);
        sprintf(packet,"%d:\n",QUIT);
                  writePkt(sock);
                  closeServer(sock);
}





/**************************************************************************
**      _pipeHandler
**
**      Purpose : Close the server connection if we get a SIGPIPE
**      Args    : sig
**      Returns : Nothing
**      Notes   :
*/

RETSIGTYPE pipeHandler(sig)
                  int     sig;
{
        msqlDebug(MOD_API,"Hit by pipe signal\n");
                  closeServer(curServerSock);
        return;
}




static freeQueryData(cur)
        m_data  *cur;
{
                  m_data  *prev;
        int     offset;

        while(cur)
        {
                offset = 0;
                while(offset < cur->width)
                {
                                                                safeFree(cur->data[offset]);
                                                                offset++;
                }
                safeFree(cur->data);
                prev = cur;
                                         cur = cur->next;
                safeFree(prev);
                msqlDebug(MOD_MALLOC, "Query data row - free @@ %X\n", prev);
        }
        safeFree(cur);
}





static freeFieldList(fieldData)
        m_fdata *fieldData;
{
        m_fdata *cur,
                *prev;

        cur = fieldData;
        while(cur)
        {
                prev = cur;
                                         cur = cur->next;
                                         safeFree(prev->field.table);
                safeFree(prev->field.name);
                safeFree(prev);
                msqlDebug(MOD_MALLOC, "Field List Entry- free @@ %X\n", prev);
                  }
}



/**************************************************************************
**      _msqlFreeResult
**
**      Purpose : Free the memory allocated to a table returned by a select
**      Args    : Pointer to head of table
**      Returns : Nothing
**      Notes   :
*/

void APIENTRY msqlFreeResult(result)
        m_result  *result;
{
                  freeQueryData(result->queryData);
                  freeFieldList(result->fieldData);
        safeFree(result);
        msqlDebug(MOD_MALLOC,"Result Handle - Free @@ %X\n",result);
}



static m_fdata *tableToFieldList(data)
                  m_data  *data;
{
        m_data  *curRow;
        m_fdata *curField,
                *prevField,
                *head = NULL;

        curRow = data;
                  while(curRow)
                  {
                curField = (m_fdata *)malloc(sizeof(m_fdata));
                msqlDebug(MOD_MALLOC,"Field List Entry - malloc @@ %X of %d\n",
                        curField, sizeof(m_fdata));
                                         (void)bzero(curField, sizeof(m_fdata));
                if (head)
                {
                                                                prevField->next = curField;
                        prevField = curField;
                }
                else
                {
                                                                head = prevField = curField;
                                         }

                                         curField->field.table = (char *)strdup((char *)curRow->data[0]);
                                         curField->field.name = (char *)strdup((char *)curRow->data[1]);
                                         curField->field.type = atoi((char*)curRow->data[2]);
                curField->field.length = atoi((char*)curRow->data[3]);
                curField->field.flags = 0;
                if (*curRow->data[4] == 'Y')
                        curField->field.flags |= NOT_NULL_FLAG;
                if (*curRow->data[5] == 'Y')
                        curField->field.flags |= PRI_KEY_FLAG;
                curRow = curRow->next;
                  }
                  return(head);
}


/**************************************************************************
**      _msqlConnect
**
**      Purpose : Form a connection to a mSQL server
**      Args    : hostname of server
**      Returns : socket for further use.  -1 on error
**      Notes   : If host == NULL, localhost is used via UNIX domain socket
*/

#ifdef UNIX
        /*
         * UNIX
         */
int APIENTRY msqlConnect(host)
        char    *host;
#else
        /*
         * OS2 & WINNT
         */
int APIENTRY msqlConnect(host)
        char    *host;
{
                  return msqlUserConnect( host, NULL );
}

int APIENTRY msqlUserConnect(host, user)
                  char    *host;
        char    *user;
#endif
{
        char    *cp,
                *envVar,
                *unixPort;
        struct  sockaddr_in IPaddr;

#ifdef HAVE_SYS_UN_H
        struct  sockaddr_un UNIXaddr;
#endif
        struct  servent         *serv_ptr;
                  struct  hostent *hp;
        u_long  IPAddr;
        int     opt,
                version,
                                         sock,
                tcpPort;
        struct  passwd *pw;
#ifdef WINSOCK
                  WORD wVersionRequired = MAKEWORD(1,1);  /* winsock 1.1 required */
                  WSADATA       wsaData;
                  int nErrorStatus;

                  /* startup WINSOCK unless disabled by calling program */
                  if (DoWSAInit != 0) {
                         if(WSAStartup(wVersionRequired, &wsaData) != 0) {
                                printf("msqlConnect : Unable to initialise WINSOCK");
                                exit(1);
                         }
                  }
#endif



                  resetError();
                  initNet();
        if (!debugInit)
        {
                debugInit++;
                                         msqlInitDebug();
        }

        /*
        ** Grab a socket and connect it to the server
        */

#ifndef HAVE_SYS_UN_H
                  if (!host)
        {
                host = MSQL_LOCALHOST;
        }
#endif

        if (!host)
        {
#ifdef HAVE_SYS_UN_H
                /* Shouldn't get in here with UNIX socks */
                unixPort = MSQL_UNIX_ADDR;
                if ((envVar = getenv("MSQL_UNIX_PORT")))
                {
                                                                unixPort = envVar;
                }
                strcpy(hostInfo,"Localhost via UNIX socket");
                msqlDebug(MOD_API,"Server name = NULL.  Using UNIX sock(%s)\n",
                        unixPort);
                sock = socket(AF_UNIX,SOCK_STREAM,0);
                if (sock < 0)
                {
                        sprintf(msqlErrMsg,SOCKET_ERROR);
                        return(-1);
                }
                setServerSock(sock);
                opt = 1;
                                         setsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, (char *)&opt,
                        sizeof(opt));

                (void)bzero(&UNIXaddr,sizeof(UNIXaddr));
                UNIXaddr.sun_family = AF_UNIX;
                strcpy(UNIXaddr.sun_path, unixPort);
                if(connect(sock,(struct sockaddr *) &UNIXaddr,
                        sizeof(UNIXaddr))<0)
                {
                        sprintf(msqlErrMsg,CONNECTION_ERROR);
                        close(sock);
                        return(-1);
                }
#endif
        }
        else
        {
                tcpPort = MSQL_PORT;
                                         if ((serv_ptr = getservbyname("msql", "tcp")))
                {
                        tcpPort = ntohs(serv_ptr->s_port);
                }
                                         if ((envVar = getenv("MSQL_TCP_PORT")))
                {
                        tcpPort = atoi(envVar);
                }

                sprintf(hostInfo,"%s via TCP/IP",host);
                msqlDebug(MOD_API,"Server name = %s.  Using TCP sock (%d)\n",
                        host, tcpPort);
                sock = socket(AF_INET,SOCK_STREAM,0);
                if (sock < 0)
                {
                        sprintf(msqlErrMsg,IPSOCK_ERROR);
                        return(-1);
                }
                                         setServerSock(sock);
                opt = 1;
                setsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, (char *)&opt,
                                                                sizeof(opt));

                (void)bzero(&IPaddr,sizeof(IPaddr));
                IPaddr.sin_family = AF_INET;

                /*
                ** The server name may be a host name or IP address
                */

                if ((IPAddr = inet_addr(host)) != INADDR_NONE)
                {
                        bcopy(&IPAddr,&IPaddr.sin_addr,sizeof(IPAddr));
                }
                                         else
                {
                        hp = gethostbyname(host);
                        if (!hp)
                        {
                                sprintf(msqlErrMsg,
                                        UNKNOWN_HOST,
                                        host);
#ifdef OS2
                                soclose(sock);
#elif defined WINSOCK
                                                                                  closesocket(sock);
#else
                                                                                  close(sock);
#endif
                                                                                  return(-1);
                        }
                        bcopy(hp->h_addr,&IPaddr.sin_addr, hp->h_length);
                }
                                         IPaddr.sin_port = htons(tcpPort);
                if(connect(sock,(struct sockaddr *) &IPaddr,
                        sizeof(IPaddr))<0)
                {
                        sprintf(msqlErrMsg,CONN_HOST_ERROR, host);
                                                                perror("Connect");
#ifdef OS2
                                                                soclose(sock);
#elif defined WINSOCK
                                                                closesocket(sock);
#else
                        close(sock);
#endif
                        return(-1);
                }
                  }

#ifndef NOSIGNAL
#ifdef SIGPIPE
                  oldHandler = signal(SIGPIPE,pipeHandler);
#else
                  oldHandler = signal(SIGABRT,pipeHandler);
#endif
#endif
                  msqlDebug(MOD_API,"Connection socket = %d\n",sock);

        /*
        ** Check the greeting message and save the version info
        */

                  if(readPkt(sock) <= 0)
        {
                                         closeServer(sock);
                strcpy(msqlErrMsg,SERVER_GONE_ERROR);
                return(-1);
        }


                  /*
        ** Check the result.  First check the status code from the
        ** server and then the protocol version.  If the status == -1
        ** or the protocol doesn't match our version, bail out!
        */

        if (atoi(packet) == -1)
        {
                if (cp = (char *)index(packet,':'))
                {
                        strcpy(msqlErrMsg,cp+1);
                        chopError();
                }
                                         else
                {
                        strcpy(msqlErrMsg,UNKNOWN_ERROR);
                }
                                         closeServer(sock);
                return(-1);
        }


        cp = (char *)index(packet,':');
        if (!cp)
        {
                strcpy(msqlErrMsg,PACKET_ERROR);
                                         closeServer(sock);
                return(-1);
        }
        version = atoi(cp + 1);
        if (version != PROTOCOL_VERSION)
        {
                sprintf(msqlErrMsg, VERSION_ERROR, version, PROTOCOL_VERSION);
                closeServer(sock);
                return(-1);
        }
        msqlDebug(MOD_API,"mSQL protocol version - API=%d, server=%d\n",
                PROTOCOL_VERSION, version);
        protoInfo = version;
                  cp = (char *)index(cp+1,':');
        if (cp)
        {
                msqlDebug(MOD_API,"Server greeting = '%s'\n",cp+1);
                strcpy(serverInfo,cp+1);
        }
        else
        {
                strcpy(serverInfo,"Error in server handshake!");
        }
        if (*(serverInfo+strlen(cp+1)-1) == '\n')
        {
                *(serverInfo+strlen(cp+1)-1) = 0;
                  }


        /*
        ** Send the username for this process for ACL checks
        */
#ifdef UNIX
                /*
                 * UNIX
                 */
        pw = getpwuid(geteuid());
        if (!pw)
        {
                                         strcpy(msqlErrMsg,USERNAME_ERROR);
                closeServer(sock);
                return(-1);
        }
        (void)sprintf(packet,"%s\n",pw->pw_name);

#else
                /*
                 * OS2 & WINNT
                 */
        pw = NULL;

        /*---| check for parameter 'user' |---*/
                  if( NULL == user || '\0' == *user )
        {       (void)sprintf( packet, "%s\n",
                               (NULL == getenv("USER")) ? ROOT
                                                        : getenv("USER")
                               );
        }
        else
        {
                (void)sprintf( packet,"x_%s\n", user );
        }
#endif
                  writePkt(sock);
        (void)bzero(packet,PKT_LEN);
                  if(readPkt(sock) <= 0)
        {
                                         closeServer(sock);
                strcpy(msqlErrMsg,SERVER_GONE_ERROR);
                return(-1);
        }


        /*
        ** Check the result
        */

        if (atoi(packet) == -1)
                  {
                char    *cp;

                cp = (char *)index(packet,':');
                if (cp)
                {
                        strcpy(msqlErrMsg,cp+1);
                        chopError();
                }
                else
                {
                        strcpy(msqlErrMsg,UNKNOWN_ERROR);
                }
                                         closeServer(sock);
                return(-1);
                  }
        return(sock);
}






/**************************************************************************
**      _msqlInitDB
**
**      Purpose : Tell the server which database we want to use
**      Args    : Server sock and DB name
**      Returns : -1 on error
**      Notes   :
*/

int APIENTRY msqlSelectDB(sock,db)
        int     sock;
        char    *db;
{
        int     res;



                  msqlDebug(MOD_API,"Select Database = \"%s\"\n",db);

        resetError();
        setServerSock(sock);

        /*
        ** Issue the init DB command
        */

        (void)sprintf(packet,"%d:%s\n",INIT_DB,db);
        writePkt(sock);
                  (void)bzero(packet,PKT_LEN);
        if(readPkt(sock) <= 0)
                  {
                                         closeServer(sock);
                strcpy(msqlErrMsg,SERVER_GONE_ERROR);
                return(-1);
        }


        /*
        ** Check the result
        */

                  if (atoi(packet) == -1)
        {
                                         char    *cp;

                cp = (char *)index(packet,':');
                if (cp)
                {
                        strcpy(msqlErrMsg,cp+1);
                        chopError();
                }
                else
                {
                        strcpy(msqlErrMsg,UNKNOWN_ERROR);
                                         }
                return(-1);
                  }

        return(0);
}





/**************************************************************************
**      _msqlStoreResult
**
**      Purpose : Store the data returned from a query
**      Args    : None
**      Returns : Result handle or NULL if no data
**      Notes   :
*/

m_result * APIENTRY msqlStoreResult()
{
        m_result *tmp;

        if (!queryData && !fieldData)
        {
                                         return(NULL);
        }
                  tmp = (m_result *)malloc(sizeof(m_result));
        msqlDebug(MOD_MALLOC,"Result Handle - malloc @@ %X of %d\n",
                tmp, sizeof(m_result));
        if (!tmp)
        {
                return(NULL);
        }
        (void)bzero(tmp, sizeof(m_result));
        tmp->queryData = queryData;
        tmp->numRows = queryTableSize;
                  tmp->fieldData = tableToFieldList(fieldData);
                  tmp->numFields = fieldTableSize;
        tmp->cursor = tmp->queryData;
                  tmp->fieldCursor = tmp->fieldData;
        freeQueryData(fieldData);
        queryData = NULL;
        fieldData = NULL;
        return(tmp);
}





/**************************************************************************
**      _msqlFetchField
**
**      Purpose : Return a row of the query results
**      Args    : result handle
**      Returns : pointer to row data
**      Notes   :
*/

m_field * APIENTRY msqlFetchField(handle)
        m_result *handle;
{
        m_field *tmp;

        if (!handle->fieldCursor)
                  {
                return(NULL);
        }
        tmp = &(handle->fieldCursor->field);
        handle->fieldCursor = handle->fieldCursor->next;
        return(tmp);
}



/**************************************************************************
**      _msqlFetchRow
**
**      Purpose : Return a row of the query results
**      Args    : result handle
**      Returns : pointer to row data
**      Notes   :
*/

m_row   APIENTRY msqlFetchRow(handle)
        m_result *handle;
{
        m_row   tmp;

                  if (!handle->cursor)
        {
                                         return(NULL);
        }
        tmp = handle->cursor->data;
        handle->cursor = handle->cursor->next;
        return(tmp);
}




/**************************************************************************
**      _msqlFieldSeek
**
**      Purpose : Move the result cursor
**      Args    : result handle, offset
**      Returns : Nothing.  Just sets the cursor
**      Notes   : The data is a single linked list so we can go backwards
*/

void APIENTRY msqlFieldSeek(handle, offset)
        m_result *handle;
        int     offset;
{
        m_fdata *tmp;


                  msqlDebug(MOD_API,"msqlFieldSeek() pos = \n",offset);
        tmp = handle->fieldData;
        while(offset)
        {
                if (!tmp)
                        break;
                tmp = tmp->next;
                offset--;
        }
        handle->fieldCursor = tmp;
}

/**************************************************************************
**      _msqlDataSeek
**
**      Purpose : Move the result cursor
**      Args    : result handle, offset
**      Returns : Nothing.  Just sets the cursor
**      Notes   : The data is a single linked list so we can go backwards
*/

void APIENTRY msqlDataSeek(handle, offset)
        m_result *handle;
        int     offset;
{
        m_data  *tmp;


        msqlDebug(MOD_API,"msqlDataSeek() pos = \n",offset);
        tmp = handle->queryData;
        while(offset)
        {
                if (!tmp)
                        break;
                tmp = tmp->next;
                offset--;
        }
                  handle->cursor = tmp;
}



/**************************************************************************
**      _
**
**      Purpose :
**      Args    :
**      Returns :
**      Notes   :
*/

int APIENTRY msqlQuery(sock,q)
                  int     sock;
        char    *q;
{
                  int     len,
                res;
        char    *cp;



        msqlDebug(MOD_QUERY,"Query = \"%s\"\n",q);
        resetError();
                  setServerSock(sock);

                  /*
        ** Issue the query
        */

        (void)sprintf(packet,"%d:%s\n",DB_QUERY,q);
        writePkt(sock);
        (void)bzero(packet,PKT_LEN);
                  if(readPkt(sock) <= 0)
        {
                                         closeServer(sock);
                strcpy(msqlErrMsg,SERVER_GONE_ERROR);
                                         return(-1);
        }


        /*
                  ** Check the result.  It may be an indication of further data to
        ** come (ie. from a select)
        */

        if (atoi(packet) == -1)
        {
                cp = (char *)index(packet,':');
                if (cp)
                                         {
                        strcpy(msqlErrMsg,cp+1);
                                                                chopError();
                }
                else
                                         {
                        strcpy(msqlErrMsg,UNKNOWN_ERROR);
                }
                return(-1);
        }

        cp = (char *)index(packet,':');
        numFields = 0;
                  if (cp)
        {
                                         numFields = atoi(cp+1);
                if (numFields <= 0)
                        return(0);
                  }
        else
        {
                return(0);
        }

        /*
        ** numFields > 0 therefore we have data waiting on the socket.
                  ** Grab it and dump it into a table structure.  If there's
        ** uncollected data free it - it's no longer available.
                  */
        if (queryData)
        {
                                         freeQueryData(queryData);
                freeQueryData(fieldData);
                queryData = NULL;
                fieldData = NULL;
        }

        queryTableSize = readQueryData(sock);
        if (queryTableSize < 0)
                  {
                return(-1);
                  }
        queryData = tmpDataStore;
        tmpDataStore = NULL;
                  numFields = 6;
        fieldTableSize = readQueryData(sock);
        if (fieldTableSize < 0)
        {
                return(-1);
        }
        fieldData = tmpDataStore;
        tmpDataStore = NULL;
                  return(0);
}




/**************************************************************************
**      _
**
**      Purpose :
**      Args    :
**      Returns :
**      Notes   :
*/

int readQueryData(sock)
                  int     sock;
{
                  int     off,
                                         len,
                numRows;
        char    *cp;
        m_data  *cur;

                  if (readPkt(sock) <= 0)
        {
                                         closeServer(sock);
                strcpy(msqlErrMsg,SERVER_GONE_ERROR);
                return(-1);
        }

        numRows = 0;
                  while(atoi(packet) != -100)
        {
                if (atoi(packet) == -1)
                {
                        cp = (char *)index(packet,':');
                        if (cp)
                        {
                                                                                  strcpy(msqlErrMsg,cp+1);
                                chopError();
                        }
                        else
                        {
                                strcpy(msqlErrMsg,UNKNOWN_ERROR);
                                                                }
                        return(-1);
                }
                numRows++;
                if(!tmpDataStore)
                {
                        tmpDataStore = cur = (m_data *)malloc(sizeof(m_data));
                                         }
                else
                {
                        cur->next = (m_data *)malloc(sizeof(m_data));
                        cur = cur->next;
                }
                                         msqlDebug(MOD_MALLOC,"Query data row - malloc @@ %X of %d\n",
                        cur, sizeof(m_data));
                (void)bzero(cur,sizeof(m_data));
                cur->data = (char **)malloc(numFields * sizeof(char *));
                (void)bzero(cur->data,numFields * sizeof(char *));
                cur->width = numFields;
                off = 0;
                                         cp = packet;
                while(off < numFields)
                {
                        len = atoi(cp);
                        cp = (char *)index(cp,':');
                        if (len == -2)
                                                                {
                                cur->data[off] = (char *)NULL;
                                cp++;
                        }
                        else
                        {
                                cur->data[off] = (char *)malloc(len+1);
                                                                                  (void)bzero(cur->data[off],len+1);
                                (void)bcopy(cp+1,cur->data[off],len);
                                cp += len + 1;
                        }
                        off++;
                }

                if (readPkt(sock) <= 0)
                {
                        closeServer(sock);
                        strcpy(msqlErrMsg,SERVER_GONE_ERROR);
                        return(-1);
                }
                  }
        return(numRows);
}






/**************************************************************************
**      _
**
**      Purpose :
**      Args    :
**      Returns :
**      Notes   :
*/

m_result * APIENTRY msqlListDBs(sock)
                  int     sock;
{
                  m_result *tmp;

                  msqlDebug(MOD_API,"msqlListDBs(%d)\n",sock);
        tmp = (m_result *)malloc(sizeof(m_result));
        if (!tmp)
                  {
                return(NULL);
        }
        (void)bzero(tmp, sizeof(m_result));
        msqlDebug(MOD_MALLOC,"Result Handle - malloc @@ %X of %d\n",
                                         tmp, sizeof(m_result));
                  sprintf(packet,"%d:\n",DB_LIST);
                  writePkt(sock);
        numFields = 1;
                  tmp->numRows = readQueryData(sock);
                  if (tmp->numRows < 0)
        {
                (void)free(tmp);
                                         return(NULL);
        }
        tmp->queryData = tmpDataStore;
        tmp->cursor = tmp->queryData;
        tmp->numFields = 1;
                  tmp->fieldData = (m_fdata *)malloc(sizeof(m_fdata));
                  msqlDebug(MOD_MALLOC,"Field List Entry - malloc @@ %X of %d\n",
                tmp->fieldData, sizeof(m_fdata));
        (void)bzero(tmp->fieldData, sizeof(m_fdata));
                  tmp->fieldData->field.table = (char *)strdup("mSQL Catalog");
                  tmp->fieldData->field.name = (char *)strdup("Database");
        tmp->fieldData->field.type = CHAR_TYPE;
        tmp->fieldData->field.length = NAME_LEN;
                  tmp->fieldData->field.flags = 0;
        tmp->fieldCursor = tmp->fieldData;
        tmpDataStore = NULL;
        return(tmp);
}





/**************************************************************************
**      _
**
**      Purpose :
**      Args    :
**      Returns :
**      Notes   :
*/

m_result * APIENTRY msqlListTables(sock)
                  int     sock;
{
                  m_result *tmp;

                  msqlDebug(MOD_API,"msqlListTables(%d)\n",sock);
                  tmp = (m_result *)malloc(sizeof(m_result));
                  if (!tmp)
                  {
                                         return(NULL);
                  }
                  msqlDebug(MOD_MALLOC,"Result Handle - malloc @@ %X of %d\n",
                                         tmp, sizeof(m_result));
                  (void)bzero(tmp, sizeof(m_result));
                  sprintf(packet,"%d:\n",TABLE_LIST);
                  writePkt(sock);
                  numFields = 1;
                  tmp->numRows = readQueryData(sock);
                  if (tmp->numRows < 0)
                  {
                                         (void)free(tmp);
                                         return(NULL);
                  }
                  tmp->queryData = tmpDataStore;
                  tmp->numFields = 0;
                  tmp->cursor = tmp->queryData;
                  tmp->fieldCursor = NULL;
                  tmpDataStore = NULL;
                  tmp->numFields = 1;
                  tmp->fieldData = (m_fdata *)malloc(sizeof(m_fdata));
                  msqlDebug(MOD_MALLOC,"Field List Entry - malloc @@ %X of %d\n",
                                         tmp->fieldData, sizeof(m_fdata));
                  (void)bzero(tmp->fieldData, sizeof(m_fdata));
                  tmp->fieldData->field.table = (char *)strdup("mSQL Catalog");
                  tmp->fieldData->field.name = (char *)strdup("Table");
                  tmp->fieldData->field.type = CHAR_TYPE;
                  tmp->fieldData->field.length = NAME_LEN;
                  tmp->fieldData->field.flags = 0;
                  tmp->fieldCursor = tmp->fieldData;
                  return(tmp);
}


/**************************************************************************
**      _
**
**      Purpose :
**      Args    :
**      Returns :
**      Notes   :
*/

m_result * APIENTRY msqlListFields(sock,table)
                  int     sock;
                  char    *table;
{
                  m_result *tmp;

                  msqlDebug(MOD_API,"msqlListFields(%d,%s)\n",sock,table);
                  tmp = (m_result *)malloc(sizeof(m_result));
        if (!tmp)
        {
                return(NULL);
        }
        msqlDebug(MOD_MALLOC,"Result Handle - malloc @@ %X of %d\n",
                tmp, sizeof(m_result));
        (void)bzero(tmp, sizeof(m_result));
        sprintf(packet,"%d:%s\n",FIELD_LIST,table);
                  writePkt(sock);
                  numFields = 6;
        tmp->numFields = readQueryData(sock);
        if(tmp->numFields < 0)
                  {
                (void)free(tmp);
                return(NULL);
        }
        tmp->fieldData = tableToFieldList(tmpDataStore);
        tmp->fieldCursor = tmp->fieldData;
        tmp->queryData = NULL;
        tmp->cursor = NULL;
        tmp->numRows = 0;
        freeQueryData(tmpDataStore);
                  tmpDataStore = NULL;
        return(tmp);
}




int APIENTRY msqlCreateDB(sock,DB)
        int     sock;
        char    *DB;
{
        char    *cp;

                  msqlDebug(MOD_API,"msqlCreateDB(%d,%s)\n",sock,DB);
        sprintf(packet,"%d:%s\n",CREATE_DB,DB);
                  writePkt(sock);
                  (void)bzero(packet,PKT_LEN);
                  if(readPkt(sock) <= 0)
        {
                                         closeServer(sock);
                strcpy(msqlErrMsg,SERVER_GONE_ERROR);
                return(-1);
        }


        /*
                  ** Check the result.
        */

                  if (atoi(packet) == -1)
        {
                cp = (char *)index(packet,':');
                if (cp)
                {
                        strcpy(msqlErrMsg,cp+1);
                        chopError();
                }
                else
                {
                                                                strcpy(msqlErrMsg,UNKNOWN_ERROR);
                }
                return(-1);
                  }
        return(0);
}

int APIENTRY msqlDropDB(sock,DB)
        int     sock;
        char    *DB;
{
        char    *cp;

                  msqlDebug(MOD_API,"msqlDropDB(%d,%s)\n",sock,DB);
        sprintf(packet,"%d:%s\n",DROP_DB,DB);
        writePkt(sock);
                  (void)bzero(packet,PKT_LEN);
        if(readPkt(sock) <= 0)
        {
                closeServer(sock);
                strcpy(msqlErrMsg,SERVER_GONE_ERROR);
                return(-1);
        }


        /*
                  ** Check the result.
        */

                  if (atoi(packet) == -1)
        {
                cp = (char *)index(packet,':');
                if (cp)
                {
                        strcpy(msqlErrMsg,cp+1);
                        chopError();
                }
                else
                {
                                                                strcpy(msqlErrMsg,UNKNOWN_ERROR);
                }
                return(-1);
                  }
        return(0);
}


int APIENTRY msqlShutdown(sock)
        int     sock;
{
        char    *cp;

                  msqlDebug(MOD_API,"msqlShutdown(%d)\n",sock);
        sprintf(packet,"%d:\n",SHUTDOWN);
                  writePkt(sock);
                  (void)bzero(packet,PKT_LEN);
                  if(readPkt(sock) <= 0)
        {
                                         closeServer(sock);
                strcpy(msqlErrMsg,SERVER_GONE_ERROR);
                return(-1);
        }


        /*
                  ** Check the result.
        */

                  if (atoi(packet) == -1)
        {
                cp = (char *)index(packet,':');
                if (cp)
                {
                        strcpy(msqlErrMsg,cp+1);
                        chopError();
                }
                else
                {
                                                                strcpy(msqlErrMsg,UNKNOWN_ERROR);
                }
                return(-1);
                  }
        return(0);
}



int APIENTRY msqlReloadAcls(sock)
        int     sock;
{
        char    *cp;

        msqlDebug(MOD_API,"msqlReloadAcl(%d)\n",sock);
        sprintf(packet,"%d:\n",RELOAD_ACL);
                  writePkt(sock);
        (void)bzero(packet,PKT_LEN);
        if(readPkt(sock) <= 0)
        {
                closeServer(sock);
                strcpy(msqlErrMsg,SERVER_GONE_ERROR);
                return(-1);
        }


                  /*
        ** Check the result.
        */

        if (atoi(packet) == -1)
        {
                cp = (char *)index(packet,':');
                if (cp)
                {
                        strcpy(msqlErrMsg,cp+1);
                        chopError();
                }
                else
                                         {
                        strcpy(msqlErrMsg,UNKNOWN_ERROR);
                }
                                         return(-1);
        }
        return(0);
}



char * APIENTRY msqlGetServerInfo()
{
        return(serverInfo);
}


char * APIENTRY msqlGetHostInfo()
{
                  return(hostInfo);
}


int APIENTRY msqlGetProtoInfo()
{
        return(protoInfo);
}

@


1.3
log
@Fixed bug in calling WSAStartup.
@
text
@a43 1
#  include "errmsg.h"
d50 2
d65 1
d115 1
a115 1
					 numFields,
d120 2
a121 2
					 *queryData = NULL,
					 *fieldData = NULL;
d132 3
a134 3
		  /*
			* OS2 & WINNT
			*/
d137 3
a139 3
		  /*
			* UNIX
			*/
d163 1
a163 1
	DoWSAInit = 0;       /* disable calling WSAStartUp, WSACleanUp */
d185 1
a185 1
	 return pszErrMsg;
d211 1
a211 1
					 debugInit = 0;
d215 10
a224 10
		  char    *env,
					 *tmp,
					 *tok;

		  env = getenv("MINERVA_DEBUG");
		  if(env)
		  {
					 tmp = (char *)strdup(env);
		  }
		  else
d228 1
a228 1
		  tok = (char *)strtok(tmp,":");
d230 1
a230 1
		  {
d234 1
a234 1
								printf("Debug level : query\n");
d237 1
a237 1
					 {
d241 1
a241 1
					 if (strcmp(tok,"msql_malloc") == 0)
d243 1
a243 1
								debugLevel |= MOD_MALLOC;
d247 2
a248 2
		  }
		  safeFree(tmp);
d267 1
a267 1
		  /*
d269 1
a269 1
			*/
d273 1
a273 1
			* UNIX
d276 1
a276 1
			va_dcl
d280 1
a280 1
		  char    msg[1024],
d282 1
a282 1
		  int     out = 0;
d286 1
a286 1
					  * OS2 & WINNT
d293 1
a293 1
		  module = (int) va_arg(args, int *);
d295 1
a295 1
		  if (! (module & debugLevel))
d299 1
a299 1
		  }
d302 1
a302 1
		  if (!fmt)
d306 1
a306 1
		  printf("[libmsql] %s",msg);
d322 1
a322 1
		  int     sock;
d324 1
a324 1
		  curServerSock = sock;
d346 1
a346 1
		  signal(SIGPIPE,oldHandler);
d348 1
a348 1
		  signal(SIGABRT,oldHandler);
d353 1
a353 1
		  soclose(sock);
d355 3
a357 3
		  closesocket(sock);
		  if (DoWSAInit)
				WSACleanUp();
d359 1
a359 1
		  close(sock);
d381 1
a381 1
		  setServerSock(sock);
d383 2
a384 2
		  writePkt(sock);
		  closeServer(sock);
d401 1
a401 1
        int     sig;
d404 1
a404 1
		  closeServer(curServerSock);
d414 1
a414 1
        m_data  *prev;
d422 2
a423 2
								safeFree(cur->data[offset]);
								offset++;
d427 1
a427 1
                cur = cur->next;
d448 2
a449 2
					 cur = cur->next;
					 safeFree(prev->field.table);
d453 1
a453 1
        }
d470 2
a471 2
		  freeQueryData(result->queryData);
		  freeFieldList(result->fieldData);
d479 1
a479 1
        m_data  *data;
d487 2
a488 2
		  while(curRow)
		  {
d492 1
a492 1
                (void)bzero(curField, sizeof(m_fdata));
d495 1
a495 1
								prevField->next = curField;
d500 2
a501 2
								head = prevField = curField;
					 }
d503 3
a505 3
					 curField->field.table = (char *)strdup((char *)curRow->data[0]);
					 curField->field.name = (char *)strdup((char *)curRow->data[1]);
                curField->field.type = atoi((char*)curRow->data[2]);
d513 2
a514 2
		  }
		  return(head);
d540 1
a540 1
		  return msqlUserConnect( host, NULL );
d544 1
a544 1
        char    *host;
d557 1
a557 1
        struct  hostent *hp;
d561 1
a561 1
					 sock,
d565 3
a567 3
		  WORD wVersionRequired = MAKEWORD(1,1);  /* winsock 1.1 required */
		  WSADATA	wsaData;
		  int nErrorStatus;
d569 7
a575 6
		  /* startup WINSOCK unless disabled by calling program */
		  if (DoWSAInit && (WSAStartup(wVersionRequired, &wsaData) != 0))
		  {
			 printf("msqlConnect : Unable to initialise WINSOCK");
			 exit(1);
		  }
d580 2
a581 2
		  resetError();
		  initNet();
d585 1
a585 1
					 msqlInitDebug();
d593 1
a593 1
		  if (!host)
d606 1
a606 1
								unixPort = envVar;
d619 1
a619 1
					 setsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, (char *)&opt,
d637 1
a637 1
					 if ((serv_ptr = getservbyname("msql", "tcp")))
d641 1
a641 1
					 if ((envVar = getenv("MSQL_TCP_PORT")))
d655 1
a655 1
					 setServerSock(sock);
d658 1
a658 1
								sizeof(opt));
d671 1
a671 1
					 else
d682 1
a682 1
										  closesocket(sock);
d684 1
a684 1
										  close(sock);
d686 1
a686 1
										  return(-1);
d690 1
a690 1
					 IPaddr.sin_port = htons(tcpPort);
d695 1
a695 1
								perror("Connect");
d697 1
a697 1
								soclose(sock);
d699 1
a699 1
								closesocket(sock);
d705 1
a705 1
		  }
d709 1
a709 1
		  oldHandler = signal(SIGPIPE,pipeHandler);
d711 1
a711 1
		  oldHandler = signal(SIGABRT,pipeHandler);
d714 1
a714 1
		  msqlDebug(MOD_API,"Connection socket = %d\n",sock);
d720 1
a720 1
		  if(readPkt(sock) <= 0)
d722 1
a722 1
                closeServer(sock);
d728 1
a728 1
		  /*
d741 1
a741 1
					 else
d745 1
a745 1
					 closeServer(sock);
d754 1
a754 1
					 closeServer(sock);
d767 1
a767 1
		  cp = (char *)index(cp+1,':');
d780 1
a780 1
		  }
d793 1
a793 1
					 strcpy(msqlErrMsg,USERNAME_ERROR);
d806 1
a806 1
		  if( NULL == user || '\0' == *user )
d817 1
a817 1
		  writePkt(sock);
d819 1
a819 1
		  if(readPkt(sock) <= 0)
d821 1
a821 1
					 closeServer(sock);
d832 1
a832 1
		  {
d845 1
a845 1
					 closeServer(sock);
d847 1
a847 1
		  }
d873 1
a873 1
		  msqlDebug(MOD_API,"Select Database = \"%s\"\n",db);
d884 1
a884 1
		  (void)bzero(packet,PKT_LEN);
d886 2
a887 2
		  {
					 closeServer(sock);
d897 1
a897 1
		  if (atoi(packet) == -1)
d899 1
a899 1
					 char    *cp;
d910 1
a910 1
					 }
d912 1
a912 1
		  }
d936 1
a936 1
					 return(NULL);
d938 1
a938 1
		  tmp = (m_result *)malloc(sizeof(m_result));
d948 2
a949 2
		  tmp->fieldData = tableToFieldList(fieldData);
		  tmp->numFields = fieldTableSize;
d951 1
a951 1
		  tmp->fieldCursor = tmp->fieldData;
d977 1
a977 1
		  {
d1001 1
a1001 1
		  if (!handle->cursor)
d1003 1
a1003 1
					 return(NULL);
d1029 1
a1029 1
		  msqlDebug(MOD_API,"msqlFieldSeek() pos = \n",offset);
d1066 1
a1066 1
		  handle->cursor = tmp;
d1081 1
a1081 1
		  int     sock;
d1084 1
a1084 1
		  int     len,
d1092 1
a1092 1
		  setServerSock(sock);
d1094 1
a1094 1
		  /*
d1101 1
a1101 1
		  if(readPkt(sock) <= 0)
d1103 1
a1103 1
                closeServer(sock);
d1105 1
a1105 1
					 return(-1);
d1110 1
a1110 1
		  ** Check the result.  It may be an indication of further data to
d1118 1
a1118 1
					 {
d1120 1
a1120 1
								chopError();
d1123 1
a1123 1
					 {
d1131 1
a1131 1
		  if (cp)
d1133 1
a1133 1
					 numFields = atoi(cp+1);
d1136 1
a1136 1
		  }
d1144 1
a1144 1
		  ** Grab it and dump it into a table structure.  If there's
d1146 1
a1146 1
		  */
d1149 1
a1149 1
					 freeQueryData(queryData);
d1157 1
a1157 1
		  {
d1159 1
a1159 1
		  }
d1162 1
a1162 1
		  numFields = 6;
d1170 1
a1170 1
		  return(0);
d1186 1
a1186 1
		  int     sock;
d1188 2
a1189 2
		  int     off,
					 len,
d1194 1
a1194 1
		  if (readPkt(sock) <= 0)
d1196 1
a1196 1
					 closeServer(sock);
d1202 1
a1202 1
		  while(atoi(packet) != -100)
d1209 1
a1209 1
										  strcpy(msqlErrMsg,cp+1);
d1215 1
a1215 1
								}
d1222 1
a1222 1
					 }
d1228 1
a1228 1
					 msqlDebug(MOD_MALLOC,"Query data row - malloc @@ %X of %d\n",
d1235 1
a1235 1
					 cp = packet;
d1241 1
a1241 1
								{
d1248 1
a1248 1
										  (void)bzero(cur->data[off],len+1);
d1261 1
a1261 1
		  }
d1280 1
a1280 1
		  int     sock;
d1282 1
a1282 1
		  m_result *tmp;
d1284 1
a1284 1
		  msqlDebug(MOD_API,"msqlListDBs(%d)\n",sock);
d1287 1
a1287 1
		  {
d1292 3
a1294 3
					 tmp, sizeof(m_result));
		  sprintf(packet,"%d:\n",DB_LIST);
		  writePkt(sock);
d1296 2
a1297 2
        tmp->numRows = readQueryData(sock);
		  if (tmp->numRows < 0)
d1300 1
a1300 1
					 return(NULL);
d1305 2
a1306 2
		  tmp->fieldData = (m_fdata *)malloc(sizeof(m_fdata));
		  msqlDebug(MOD_MALLOC,"Field List Entry - malloc @@ %X of %d\n",
d1309 2
a1310 2
		  tmp->fieldData->field.table = (char *)strdup("mSQL Catalog");
		  tmp->fieldData->field.name = (char *)strdup("Database");
d1313 1
a1313 1
		  tmp->fieldData->field.flags = 0;
d1333 1
a1333 1
		  int     sock;
d1335 1
a1335 1
		  m_result *tmp;
d1337 35
a1371 35
		  msqlDebug(MOD_API,"msqlListTables(%d)\n",sock);
		  tmp = (m_result *)malloc(sizeof(m_result));
		  if (!tmp)
		  {
					 return(NULL);
		  }
		  msqlDebug(MOD_MALLOC,"Result Handle - malloc @@ %X of %d\n",
					 tmp, sizeof(m_result));
		  (void)bzero(tmp, sizeof(m_result));
		  sprintf(packet,"%d:\n",TABLE_LIST);
		  writePkt(sock);
		  numFields = 1;
		  tmp->numRows = readQueryData(sock);
		  if (tmp->numRows < 0)
		  {
					 (void)free(tmp);
					 return(NULL);
		  }
		  tmp->queryData = tmpDataStore;
		  tmp->numFields = 0;
		  tmp->cursor = tmp->queryData;
		  tmp->fieldCursor = NULL;
		  tmpDataStore = NULL;
		  tmp->numFields = 1;
		  tmp->fieldData = (m_fdata *)malloc(sizeof(m_fdata));
		  msqlDebug(MOD_MALLOC,"Field List Entry - malloc @@ %X of %d\n",
					 tmp->fieldData, sizeof(m_fdata));
		  (void)bzero(tmp->fieldData, sizeof(m_fdata));
		  tmp->fieldData->field.table = (char *)strdup("mSQL Catalog");
		  tmp->fieldData->field.name = (char *)strdup("Table");
		  tmp->fieldData->field.type = CHAR_TYPE;
		  tmp->fieldData->field.length = NAME_LEN;
		  tmp->fieldData->field.flags = 0;
		  tmp->fieldCursor = tmp->fieldData;
		  return(tmp);
d1385 2
a1386 2
		  int     sock;
		  char    *table;
d1388 1
a1388 1
		  m_result *tmp;
d1390 2
a1391 2
		  msqlDebug(MOD_API,"msqlListFields(%d,%s)\n",sock,table);
		  tmp = (m_result *)malloc(sizeof(m_result));
d1400 2
a1401 2
		  writePkt(sock);
		  numFields = 6;
d1404 1
a1404 1
		  {
d1414 1
a1414 1
		  tmpDataStore = NULL;
d1427 1
a1427 1
		  msqlDebug(MOD_API,"msqlCreateDB(%d,%s)\n",sock,DB);
d1429 3
a1431 3
		  writePkt(sock);
		  (void)bzero(packet,PKT_LEN);
        if(readPkt(sock) <= 0)
d1433 1
a1433 1
					 closeServer(sock);
d1440 1
a1440 1
		  ** Check the result.
d1443 1
a1443 1
		  if (atoi(packet) == -1)
d1453 1
a1453 1
								strcpy(msqlErrMsg,UNKNOWN_ERROR);
d1456 1
a1456 1
		  }
d1466 1
a1466 1
		  msqlDebug(MOD_API,"msqlDropDB(%d,%s)\n",sock,DB);
d1469 1
a1469 1
		  (void)bzero(packet,PKT_LEN);
d1479 1
a1479 1
		  ** Check the result.
d1482 1
a1482 1
		  if (atoi(packet) == -1)
d1492 1
a1492 1
								strcpy(msqlErrMsg,UNKNOWN_ERROR);
d1495 1
a1495 1
		  }
d1505 1
a1505 1
		  msqlDebug(MOD_API,"msqlShutdown(%d)\n",sock);
d1507 3
a1509 3
		  writePkt(sock);
		  (void)bzero(packet,PKT_LEN);
        if(readPkt(sock) <= 0)
d1511 1
a1511 1
					 closeServer(sock);
d1518 1
a1518 1
		  ** Check the result.
d1521 1
a1521 1
		  if (atoi(packet) == -1)
d1531 1
a1531 1
								strcpy(msqlErrMsg,UNKNOWN_ERROR);
d1534 1
a1534 1
		  }
d1547 1
a1547 1
		  writePkt(sock);
d1557 1
a1557 1
		  /*
d1570 1
a1570 1
					 {
d1573 1
a1573 1
					 return(-1);
d1588 1
a1588 1
		  return(hostInfo);
@


1.2
log
@Moved WSAStartUp to msqlConnect and WSACleanup to msqlClose. Makes clients
a lot friendlier.
Added a function to disable this feature, so the calling program can take
control of the WSAStartup and WSACleanup activities.
@
text
@d567 2
a568 1
		  if (WSAStartup(wVersionRequired, &wsaData) != 0)
@


1.1
log
@Initial revision
@
text
@d118 2
a119 2
                *queryData = NULL,
                *fieldData = NULL;
d124 4
d132 1
a132 1
         */
d135 3
a137 3
        /*
         * UNIX
         */
d150 14
d209 1
a209 1
                debugInit = 0;
d213 3
a215 3
        char    *env,
                *tmp,
                *tok;
d217 2
a218 2
        env = getenv("MINERVA_DEBUG");
        if(env)
d221 2
a222 2
        }
        else
d226 1
a226 1
        tok = (char *)strtok(tmp,":");
d228 1
a228 1
        {
d235 1
a235 1
                {
d239 1
a239 1
                if (strcmp(tok,"msql_malloc") == 0)
d241 1
a241 1
                        debugLevel |= MOD_MALLOC;
d265 1
a265 1
        /*
d267 1
a267 1
         */
d274 1
a274 1
         va_dcl
d278 1
a278 1
        char    msg[1024],
d280 1
a280 1
        int     out = 0;
d291 1
a291 1
        module = (int) va_arg(args, int *);
d293 1
a293 1
        if (! (module & debugLevel))
d300 1
a300 1
        if (!fmt)
d304 1
a304 1
        printf("[libmsql] %s",msg);
d320 1
a320 1
        int     sock;
d322 1
a322 1
        curServerSock = sock;
d354 2
d420 1
a420 1
                        safeFree(cur->data[offset]);
d446 1
a446 1
                cur = cur->next;
d485 1
a485 1
        while(curRow)
d498 1
a498 1
                        head = prevField = curField;
d511 1
a511 1
        }
d559 1
a559 1
                sock,
d562 12
@
