/**************************************************************************/
/*                                                                        */
/* What's it called: EPM TeX Front End (texfe.e)                          */
/*                                                                        */
/*                                                                        */
/* What does it do:  The E source code for the EPM TeX Front End          */
/*                                                                        */
/* Who and When:     Originally written as 'EPMTeX' by John Hacker,       */
/*                   Rodney Korte, Thorsten Domsalla and Joachim Koenen,  */
/*                   1/1993-10/1995;                                      */
/*                   this version by Walter Schmidt, 07/2004,             */
/*                   with contributions by Wonkoo Kim                     */
/*                   and  Andreas Schnellbacher                           */
/*                                                                        */
/* Copyright (c) Walter Schmidt 1997--2004                                */
/*                                                                        */
/**************************************************************************/


define
   PrimVersion = '5.4'
-- please change this number whenever the source code is modified!
-- in case of bug fixes, please change only the digit(s) after the "b"
const
   TEXFE_COPYRIGHT = '(c) Walter Schmidt 1997-2004'

/*
Version 5.4

    * tex_find_errors:
    After TeXing of a region, too, errors are shown in the original
    source file.
    
    * tex_find_errors:
    The cursor position in the log file is always set to the last error
    found, regardless of whether the log file will be displayed
    immediately.  Thus, switching to the log file will always show the
    "current" error message, unless the cursor position in the log file
    has been altered manually in the meantime.  
    
    * tex_find_errors:
    If the log file is corrupt, and the name of the related source
    file for an error message cannot be determined, this situation
    will no longer result in undefined behavior.

    * tex_find_errors (with VTeX only)
    Red circle should no longer cover the last column of the indicated
    error context.

    * tex_run_tex, definit:  
    Several new global variables serve for the communication between
    tex_run_tex and tex_find_errors wrt/ TeXing of marked regions; they
    are initialized in definit.

    * tex_view_log:
    Command rewritten.  Log file is no longer re-loaded unnecessarily.
    The cursor position in the log file remains unchanged now, except
    when the parsing facility is reset.
    
Version 5.2

    * Bug fix in tex_find_errors:  when loading the source file that
    contains the error, don't forget to memorize the fileID.

Version 5.1

    * TFE now works with NEPMD, too (thanks to Andreas Schnellbacher)

    * Precompiled module shows the same menu as the "Pro" version;
    thus, the module provides all features of the compiled version.

    * Changed order of items in the configuration window.

    * Fixed typo in the menu item "ps2pdf".

    * Name of last log file is no longer displayed at definit, so as
    to make EPM start up faster.

    * The auto-indentation package is no longer supported; the
    compile-time variable const EXTENDED_LATEX_ASSIST is gone.

    * Definition of the `quick keys' can be suppresed at compile-time
    through const WANT_TEX_HOTKEYS = 0.

    * File MYMNUINI.ADD is no longer needed.

Version 4.2

    * Bug fix:  Default actions for PDF and PS preview are properly
    initialized with classical version, too.

    * New menu item to run ps2pdf (classical version only)

    * "DTX" and "INS" added to the default TeX document file types;
    "CLS" added to the default style file types.

    * In the documentation and in the menus, "style files" are now
    called "macro files".

    * No more annoying messages, when the location of an error cannot be
    determined from the log file.

    * Enhanced debugging facilities in the procedure tex_run_cmd.

Version 4.0

    * Everything, except for the additional menu items, can be
    configured interactively now; this holds for the classical version,
    too.

    * The format can be specified in teTeX-like syntax, i.e., by a
    pseudo comment like %&latex in the first line.  The old texit-style
    syntax (% Format: latex) is still valid, too.

    * External commands are passed the fully qualified filename now,
    in order to avoid potential problems.

    * Minor "clean up" of menus, window titles and error messages.

    * Default path for gsview updated with respect to GSView 4.x.

    * Default VTeX options fixed:  With PS mode, the default BoundingBox
    is set to A4; with PDF mode, CFF is enabled.

    * New menu item (VTeX only):  Build cache.

    * VTeX variant only:  Changed VTeX invocation so that the window
    will stay open, if there was any error.  This should only be used
    with VTeX 7.45e or later and appropriate setting of retcodes=0,0,1,1
    in vtex.ini; otherwise any warning will cause the window to stay
    open.

    * VTeX variant only:  Improved parsing of the log file, making use
    of VTeX's particular error messages, which indicate the file name,
    too.

    * Classical variant only:  No more translation of format names to
    commands, except for "plain" -> "tex".

    * Classical variant only:  The menu item "TeX/PS" will not start,
    if dvips program is not known, With the previous version, this
    situation would result in a strange error message from the command
    shell.

    * "Pro" version only:  The extra "OS/2" menu is no longer built,
    when STD_MENU_NAME is defined.  Instead, the "Folder" and "Shell"
    items are put in the "TeX" menu, just like with the module.

    * The experimental Emacs-like reflowing and indentation package
    can be linked to the VTeX variant, too.

Known bugs and deficiencies:

    * You cannot TeX a file whose name has no extension.

    * The LaTeX command \includeonly should be honored when master file
    support is on.

    * Only one single \include or \input command per line is recognized.

    * A drive letter in a '%master' statement must be followed by an
    absolute path.

    * A drive letter in a '%master' statement is not recognized at all,
    if there is no colon after the keyword 'master'.

    * You cannot jump back to the _previous_ error.

    * You cannot request the window of a command to stay open after
    completion, because the `start' command has no such option.  This
    would sometimes be convenient, so as to see whether a command has
    terminated normally or with an error message.

    * You cannot request a user command to check whether the document
    and the dependent files need to be saved before the command is
    executed.


Version 3.0

    * changed default VTeX options with respect to VTeX 7.x

    * optionally bind bracket matching facility to Ctrl-a,
    controlled by const WANT_CTRLA

    * quick keys are always active;
    the list of "auxiliary" file types is no longer needed.

    * Pro version:  TeX menu is never disabled


Version 2.6

    * name of conf. variable "my_vtex" changed to "vtex".

    * menu item for "quick" VTeX added.

    * defproc tex_editsetting; one common procedure for editing
    the TeX settings; additional button to restore the default
    settings

    * Default settings are defined as const's now.

    * With the TeX Front End for VTeX all settings (except for
    the user commands) can be edited interactively.


Version 2.5

    * Bug fix:  Folders will be opened via SysSetObjectData instead of
    SysOpenObject; see the file tfefm.cmd.  As a result, they can be
    closed via the window list now.

    * Bug fix:  tex_cd won't fail any more, when changing to the root
    directory of a drive.

    * menu item for pdf preview added

    * menu shortcut for dvips changed to v

    * v2.5 should understand VTeX's error messages, too

    * new configuration variable:  my_vtex:  dvi stuff won't be
    included, when this variable is defined.  TeX and TeX/PS will call
    VTEX.EXE immediately and pass the (unchanged) format name to it; the
    configuration keywords PDF_OPTIONS and PS_OPTIONS determine the
    options to be passed to VTEX.EXE in PDF and PS mode.


Version 2.4

    * Path of master file should be recognized properly now.

    * ADVANCED marking mode is no longer required for TeXing a marked
    region; now this works with CHAR marks, too;

    * New way to call TeX and/or dvips; tfetexps.cmd is no longer
    required, and the window will stay open in case of dvips errors.

    * The commands for running the various TeX formats as well as the
    dvips command can be of type .exe or .cmd; the extension needs not
    to be specified.

    * dvips options are now placed before the .dvi filename

    * The name of the dvi file is passed to dvips WITHOUT the extension
    '.dvi' .

    * Enhanced syntax assist:  expand \[ and \(

    * Quick key' and menu shortcut for dvips added.

    * The menu item PRINT is suppressed if there is no command defined
    for it.

    * It seemed as if setTexKeySets() and setTexHilite() would not
    always be excuted when a file name was passed via the command line
    or by 'drag and drop,' so we call them once more at definit.  This
    affects the texfe module only, not the Pro version.

    * const WANT_INCLUDEONLY_SUPPORT (experimental feature, see the file
    'compile.txt')


Version 2.2

    * Default value of LATEX_SYNTAX_INDENT is now 2

    * Improved syntax assist:  Arguments of environments may appear on
    the same line.  Arbitrary long environment names are recognized.
    Reasonable handling of the 'verbatim' and 'macrocode' environments.
    (See file texfek.e)

    * Optimized code for processing the EPMTeX accelerator keys; approx.
    1kB smaller than the previous version.  (See file texfed.e)


Version 2.1

    * tex_file_in_ring() rewritten; files differing in path only
    should now be handled properly.

    * Call 'TeXMenuEnable' once more, because the TeX menu would be
    enabled erroneously under certain circumstances.  There is, however,
    no complete solution to this problem.

    * Fixed the menu item "Menu always on', which would not display its
    current setting.


Version 2.0

    * The TeX menu is now provided with the module, too.

    * The default format can be changed via the settings menu; manual
    format select is no longer provided.

    * Removed the menu item "Delete log file".

    * Bug fix: Customized <enter> key would not be honored

    * Bug fix: \end{...} would not be properly indented

    * New optional feature: Simple automatic indentation within LaTeX
    environmemts, controlled by const LATEX_SYNTAX_INDENT.

    * Syntax assist (expansion): \fo -> \footnote{}

    * "Menu always on" can be toggled via the TeX menu only.

    * const EXTENDED_LATEX_ASSIST = 1 will include Juan J.G.Ripoll's
    LaTeX auto-indentation package.

    * strip leading and trailing spaces from settings values which are
    entered interactively


Version 1.1

    * Bug fix:  Menu item "Master file support" was broken.  (Only vith
    v1.1 as of 1998-01-07.)

    * Added "Cancel" buttons to options entry box and to "process
    marked region" dialog box.

    * TeXing a marked region is now possible with plain TeX, too.  The
    end of the header is indicated by "%**end of header"

    * "Locate Next Error" and "View Log File" will always refer to the
    log file of the *last* TeX run.  The name of the log file is
    memorized from one EPM invocation to the next and will be displayed
    while definit.

    * "Locate Next Error" will again draw a circle around the location
    of the error.  I have found a reliable (!) method to do so.

    * "Locate next error" will at least display the name of the TeX
    input file an error message refers to, if line number of error is
    not indicated in the transcript file.

    * "View Log File" will reset the error browsing facility when called
    from within the log file.

    * rewrote tex_more_errors(), the old one was too obscure ...

    * fixed a bug which caused the first line of the log file to be
    displayed instead of the recently found error, if the Log action was
    triggered after the last error in the file had been processed.

    * The TeX command connected with a certain format can now be an exe
    file, too.

    * Syntax highlighting is checked while defload; file types DTX and
    FDD are never highlighted.

    * *Each* occurence of %**N or %**F in the external commands will now
    be replaced with the filename.

    * Syntax assist: Fixed a bug which prevented the description
    environment from being recognized (file texfek.e).

    * Syntax assist (expansion):
    New :    \la -> \label{},   \re -> \ref{}
    Removed: \hs -> \hspace{},  \vs -> \vspace{}

    * Preview, user commands etc.  will no longer change into master
    file.  However, they cannot be executed, if master file does not
    exist, regardless of the associated file type.

    * In case an external command is undefined, the corresponding menu
    item or toolbar button will display an appropriate error message.

    * Replaced various error messages with pop-up windows for better
    information.

    * Pro version: "Shell" and "Folder" added to the "Command" and
    "File" submenus, instead of creating an "OS/2" submenu.  Applies
    only if STD_MENU_NAME is undefined, i.e. the standard menu is used.

    * Code optimization; no more unnecessary directory switching etc.

    * Many changes to the messages in texfeen.e

    * German version.

    * Settings menu rewritten for NLS.


Version 1.0

    * TeX a marked region of the current file

    * Various changes to tex_extract_filename and tex_find_errors.
    Should now handle *all* TeX error messages!  If location of error
    cannot be determined, the log file will be displayed.

    * "View LOG File" now goes to the line of the last error which has
    been located before; the parsing routines will only be initialized,
    if there are no more errors or the log file is not found in the
    ring.

    * The log file being viewed is read-only.

    * Fixed one more error affecting handling of filenames without
    extension, in the procedure tex_file_in_ring.

    * Removed defc tex_warning

    * In case a specified master file does not exist, the current action
    will be stopped without querying "Continue processing ... ?".

    * Fixed the TeX/PS action, which used to fail with file types other
    than '.TEX'.

    * The name of the dvips executable will be determined from the INI
    file.  The default is 'dvips', as before.

    * The debug level is no longer saved in the INI file.  Each EPM
    session will start with TeX_debug = 0 .


Version 0.96

    * File types, highlighting etc.  are configured via a menu.  The
    EPM commands introduced with v0.92 have been removed.

    * The procedure tex_locate_error will no longer run into an endless
    loop , if the TeX error does not refer to a line number, e.g.  with
    "runaway argument".  Furthermore, it will move the cursor only; no
    mark will be set.

    * Changes to the syntax assist facility:  Completion of environments
    and keywords will always be active with TeX documents/styles.  The
    new command tex_keys will toggle the behaviour of the accelerator
    keys only.  The command tex_syntaxassist has been abandoned.
    New expansion: "\fr " -> "\frac{}{}"
    Removed:       "\it " -> "\item "

    * Restored the "Quick Keys":
    TeX               : Ctrl F9
    TeX/PS            : Ctrl F10
    locate next error : Ctlr F11
    view log file     : Ctrl F12
    This was the only way to get the same sequence as in the toolbar, so
    it is necessarily different from EPMTeX's key assignments.

    * Restored the EPMTeX accelerator keys


Changes from epmtex 3.1a to TeX Front End 0.92 (the first public
version):

    Toolbar:

    * The standard version has no pull-down menus any more.  Instead it
    is controlled via the toolbar.  This is because the menu identifiers
    from different modules may clash.  With the Pro version one has
    the source code available and can ensure unique menu identifiers.

    Files:

    * TeX documents are no longer required to have the extension .TEX

    * Since TeXing is no longer restricted to .TEX files, there are now
    three different lists of 'file extensions to associate with TeX':
    One for TeX documents, another one for style files, and a third one
    for auxiliary files.  The syntax assist is available with the
    documents and the style files, and the auxiliary files are those
    which provide syntax highlighting and the quick keys, too.  The TeX
    menu of the Pro version is enabled with file types from any list.

    Formats:

    * The default format is 'latex', unless there is a different
    specification in the configuration file.

    * Each format is called through its own batch file, so that the TeX
    options and the environment settings can be specified individually.

    Configuration, external programs:

    * The master file support is now toggled via the menu resp.  the
    toolbar.

    * The program epmtex.exe has disappeared.  Instead, some of the
    settings are controlled via EPM commands; others are defined in a
    text file TFE.CFG and transferred to EPM.INI by a configuration
    script named TFCONFIG.CMD, which is *not* run from within the EPM.
    The entries in the configuration file specify EPM commands, so that
    one can run external programs (start /n program), EPM REXX programs
    (rx program) or built-in EPM commands (sayerror ...).

    * Options may be passed interactively to external programs; see the
    documentation.  Thus, e.g. the printer driver can now be told to
    process a certain range of pages only.

    * The passing of the filename to an external command has been
    changed:  Within the "executable file name" (i.e.  the command
    line) the following substitutions will occur:

      %**N  ->  the filename without extension
      %**F  ->  the filename incl. extension

    This syntax is similar to the WPS, and it should cover all possible
    calling schemes of external programs.  In case none of the above
    strings is present, the filename will *not* be passed to the
    program.

    New features:

    * The commands for previewimg, printing, dvips and the user commands
    will switch to the master file before running.

    * New menu items resp. toolbar buttons:  "Folder" opens the
    directory of the current file as a WPS folder.  "Command Prompt"
    creates an OS/2 shell window in the directory of the current file.

    * New menu items for dvips and Postscript viewing (Ghostview) have
    been added.  (In case your *printer* supports Postscript, then you
    just have to specify dvips to be used as the printer driver, too.)

    * There is a new menu item named TeX/PS.  It will run TeX and dvips
    in sequence, so that you need not call dvips explicitly.  This is
    useful if you know that you will have to preview your document via
    Postscript, because it contains Type 1 fonts or other Postscript
    material.

    * The syntax assist facility will recognize more expansions:
      "equ " -> "equation"
      "eqn " -> "eqnarray"
      "\hs " -> "\hspace"
      "\vs " -> "\vspace"

    Removed features:

    * The 'TeX margins' have been removed due to their somewhat obscure
    interaction with the `general' margins setting:  Switching the TeX
    margins ON does not immediately affect the current file, but when
    you open and close the settings notebook while the TeX margins are
    active, then they will be saved, too, and become the 'general'
    default for all file types.  (I do understand what happens here,
    but what about users who are interested in writing texts and not in
    the EPM internals?)

    * The 'user defined formats' have disappeared.  To my opinion it is
    difficult to understand why there are two different ways of defining
    the format to be used: The 'automatic format selection' and the
    'user formats'.

    * The following features have also been removed:
      Orientation
      Resolving of references to environment variables (Will perhaps
        return in a later version)
      Unix style directory separators
      The menu item 'Remove DVI file'
      The option 'Auto save' (i.e. it is now always on)
      The option 'Auto log delete' (i.e. it is now always off)
      The 'Quick keys' (they may return in a later version)
      The 'Accelerator keys', except for '{', '$' and Ctrl-x,
        which are now included in the 'Syntax Assist' option.
      The TeX tabs
      The TeX margins (see above)
      The user formats (see above)
      (My policy was: Keep it small and simple!)

    Bug fixes:

    * Dependent files will be recognized when given as "\input{file}",
    too.  Formerly only "\input file" and "\include{file}" were allowed.

    * Dependent files will no lomger be checked for modification if the
    \input or \include commands are commented out.

    * A user defined mouse pointer will no longer be overwritten by the
    TeX module.

    * 'Locate Next Error' has been made much more robust and handles
    arbitrary filenames now.

    * The initialization code is no longer executed multiple times.

    Source code:

    * When compiling the Pro version, the TeX module is now included
    into EPM.EX so that no separate .ex file must be loaded at startup
    time.

    * All messages are defined in a separate file so that support for
    different languages will be possible in the future.

    * Cleaned up the source code, removed unused universal variables
    etc.
*/


/*********************************/
/*                               */
/*  We need EPM 6.03b or later   */
/*                               */
/*********************************/

compile if EVERSION < '6.03b'
  *** Error: EPM version 6.03b required
compile endif


/*
Ŀ
  Include the standard stuff we need  when we are compiling separately      
  from epm.ex.                                                              

*/

compile if not defined(SMALL)  -- Being compiled separately
  include 'stdconst.e'
  include 'colors.e'
  define INCLUDING_FILE = 'TEXFE.E'
  tryinclude 'MYCNF.E'
  compile if not defined(SITE_CONFIG)
    const SITE_CONFIG = 'SITECNF.E'
  compile endif
  compile if SITE_CONFIG
    tryinclude SITE_CONFIG
  compile endif
  compile if not defined(NLS_LANGUAGE)
    const NLS_LANGUAGE = 'ENGLISH'
  compile endif
compile endif -- SMALL


/**************************************************/
/*                                                */
/* Default settings of the compile-time variables */
/*                                                */
/**************************************************/

compile if not defined(WANT_TEX_MENU) -- may have been defined in MYCNF.E
  define WANT_TEX_MENU = 1  -- default is to include the menu
compile endif

compile if not defined(WANT_TEX_HOTKEYS) -- may have been defined in MYCNF.E
  define WANT_TEX_HOTKEYS = 1  -- default is to include the hot-keys
compile endif

compile if not defined(WANT_INCLUDEONLY_SUPPORT)
  define WANT_INCLUDEONLY_SUPPORT = 0
compile endif

compile if not defined(WANT_CTRLA)
  define WANT_CTRLA = 0
compile endif


/************************/
/*                      */
/*   Default settings   */
/*                      */
/************************/

const
/* Within EPM.INI this application identifies itself as EPMTFE */
  TEX_APP = 'EPMTFE'
  TEX_STYLETYPES_D = 'STY CLS'
  TEX_DOCTYPES_D = 'TEX DTX INS'
  TEX_DEFAULT_FORMAT_D = 'latex'
  TEX_PDF_OPTIONS_D = '-ov -pu0 -ox2 -ob2 -of=pdf.fm -$p(h=29.7cm,w=21cm,f=cf,t=f,g=f,!'
  TEX_PS_OPTIONS_D = '-ov -pu0 -ox2 -ob2 -of=ps.fm -$s(h=29.7cm,w=21cm,g=a,!'
  TEX_VIEWPDF_D = 'start /n /f c:\gs\gsview2\gvpm.exe %**N.pdf'
  TEX_VIEWPS_D = 'start /n /f c:\gs\gsview2\gvpm.exe %**N.ps'
  TEX_DVIPS_D = 'dvips'
  TEX_VIEW_D = 'start /c /f vp.cmd %**N'
  TEX_PRINTDVI_D = ' '
  TEX_PS2PDF_D = 'ps2pdf'


compile if defined (vtex)
  TEXFE_VERSION = PrimVersion 'V'
compile else
  TEXFE_VERSION = PrimVersion 'C'
compile endif


/************************/
/*                      */
/* Include NLS support  */
/*                      */
/************************/

/* only German and English currently available */
compile if NLS_LANGUAGE = 'DEUTSCH'
   include 'texfede.e'
compile else
   include 'texfeen.e'
compile endif


/***************/
/*             */
/*   definit   */
/*             */
/***************/

-- definit is called once after an .EX file is linked,
-- before its defmain will be called.

definit  -- called once at startup time
   universal app_hini,
             tex_debug,
             tex_log_file_name,
             tex_log_file_line,
             tex_log_file_curr,
             tex_mark_fname,
             tex_mark_first,
             tex_mark_preamble

-- we initialize the information in the INI file, if necessary

   answer = queryprofile(app_hini, TEX_APP, 'VERSION')
   if answer <> TEXFE_VERSION then
      -- the data structures might have been changed,
      -- so we must check some of the settings:
      answer = queryprofile(app_hini, TEX_APP, 'STYLETYPES')
      if answer = '' then
         call setprofile(app_hini, TEX_APP, 'STYLETYPES', TEX_STYLETYPES_D)
      endif
      answer = queryprofile(app_hini, TEX_APP, 'DOCTYPES')
      if answer = '' then
         call setprofile(app_hini, TEX_APP, 'DOCTYPES', TEX_DOCTYPES_D)
      endif
      answer = queryprofile(app_hini, TEX_APP, 'DEFAULT_FORMAT')
      if answer = '' then
         call setprofile(app_hini, TEX_APP, 'DEFAULT_FORMAT', TEX_DEFAULT_FORMAT_D)
      endif
      answer = queryprofile(app_hini, TEX_APP, 'VIEWPDF_CMD')
      if answer = '' then
         call setprofile(app_hini, TEX_APP, 'VIEWPDF_CMD', TEX_VIEWPDF_D)
      endif
      answer = queryprofile(app_hini, TEX_APP, 'VIEWPS_CMD')
      if answer = '' then
         call setprofile(app_hini, TEX_APP, 'VIEWPS_CMD', TEX_VIEWPS_D)
      endif
compile if defined (vtex)
      answer = queryprofile(app_hini, TEX_APP, 'PDF_OPTIONS')
      if answer = '' then
         call setprofile(app_hini, TEX_APP, 'PDF_OPTIONS', TEX_PDF_OPTIONS_D)
      endif
      answer = queryprofile(app_hini, TEX_APP, 'PS_OPTIONS')
      if answer = '' then
         call setprofile(app_hini, TEX_APP, 'PS_OPTIONS', TEX_PS_OPTIONS_D)
      endif
compile else
      answer = queryprofile(app_hini, TEX_APP, 'DVIPS_EXEC')
      if answer = '' then
         call setprofile(app_hini, TEX_APP, 'DVIPS_EXEC', TEX_DVIPS_D)
      endif
      answer = queryprofile(app_hini, TEX_APP, 'VIEW_CMD')
      if answer = '' then
         call setprofile(app_hini, TEX_APP, 'VIEW_CMD', TEX_VIEW_D)
      endif
      answer = queryprofile(app_hini, TEX_APP, 'PS2PDF_CMD')
      if answer = '' then
         call setprofile(app_hini, TEX_APP, 'PS2PDF_CMD', TEX_PS2PDF_D)
      endif
compile endif
      -- leave an 'ok' mark:
      call setprofile(app_hini, TEX_APP, 'VERSION', TEXFE_VERSION)
   endif -- VERSION

compile if WANT_TEX_MENU
 compile if defined(SMALL)  -- if compiled into EPM...
   if isadefc('HookAdd') then  -- use hook interface for NEPMD
      'HookAdd addmenu AddTexMenu'
   else
 compile endif  -- defined(SMALL)
      'PostMe BuildTexMenu'    -- delay creating menu until after the definit
 compile if defined(SMALL)  -- if not compiled separately
   endif
 compile endif  -- defined(SMALL)
compile endif

-- we initialize the debug level
   tex_debug = 0

-- we initialize log file processing
   tex_log_file_name = queryprofile(app_hini, TEX_APP, 'LOGFILE')
   tex_log_file_line = 1
   tex_log_file_curr = 1
   tex_mark_fname = ''
   tex_mark_first = 0
   tex_mark_preamble = 0

-- initialize those keys which are always to be defined
compile if WANT_TEX_HOTKEYS
   def C_F9=  'tex'
   def C_F10= 'texps'
compile if not defined (vtex)
   def C_v=   'tex_dvips'
compile endif
   def C_F11= 'tex_locate_error'
   def C_F12= 'tex_view_log'
compile endif -- WANT_TEX_HOTKEYS

compile if WANT_CTRLA
   def c_a call passist()
compile endif -- WANT_CTRLA


/***************/
/*             */
/*   defload   */
/*             */
/***************/

-- defloads from linked packages are called before all other defloads.
-- Therefore these defloads must be posted, to work properly in most
-- cases.

defload
   compile if defined(SMALL)  -- if not compiled separately
      'ProcessTexDefload'
   compile else
      -- 'postme' is required here, because defloads from linked
      -- packages will be processed before other defloads. Without
      -- 'postme' any externally defined .keyset would be overwritten
      -- by the statement in LOAD.E's defload: keys edit_keys.
      'postme ProcessTexDefload'
   compile endif

defc ProcessTexDefload
   -- set hiliting if TeX file loaded
   -- disable this for NEPMD
   if not isadefc('Mode') then
      call setTexHilite()
   endif
   -- load any requested keysets and enable syntax expansion
   call SetTexKeySets()


/**********************************************************/
/*                                                        */
/*  include the key set and the syntax assist functions   */
/*                                                        */
/**********************************************************/

include 'texfek.e'


/****************************/
/*                          */
/*  Define TeX menu system  */
/*                          */
/****************************/

compile if WANT_TEX_MENU

-- Determine current menu at runtime
-- Returns: -1  (if NEPMD)
--           1  (elseif STDMENU)
--           0  (else)
defproc tex_is_std_menu
   ret = 0      -- additional menu items can be put into standard menu
   if isadefc('Mode') then  -- only defined in NEPMD
      ret = -1  -- NEPMD comes with additional menu items already
   elseif isadefproc('add_command_menu') then  -- only defined in STDMENU
      ret = 1   -- put additional menu items into TeX/VTeX menu
   endif
   return ret


defc BuildTexMenu
   universal defaultmenu
   -- Temporarily delete Help menu so we can put it back later on the end
   -- of the menu bar where it belongs!
   deletemenu defaultmenu, HELP_MENU_ID, 0, 0  -- delete the existing Help menu
   'AddTexMenu'                                -- (we want it to stay at the right)
   call readd_help_menu();   -- Put Help menu back in
   showmenu defaultmenu


defc AddTexMenu
    universal  defaultmenu,
               app_hini

-- load in required environment information to build menu system
    TEX_USER1_MENU_TEXT = queryprofile( app_hini, TEX_APP, 'USER1_MENU_TEXT')
    TEX_USER1__MSG = queryprofile( app_hini, TEX_APP, 'USER1__MSG')
    TEX_USER2_MENU_TEXT = queryprofile( app_hini, TEX_APP, 'USER2_MENU_TEXT')
    TEX_USER2__MSG = queryprofile( app_hini, TEX_APP, 'USER2__MSG')
    TEX_USER3_MENU_TEXT = queryprofile( app_hini, TEX_APP, 'USER3_MENU_TEXT')
    TEX_USER3__MSG = queryprofile( app_hini, TEX_APP, 'USER3__MSG')
    TEX_USER4_MENU_TEXT = queryprofile( app_hini, TEX_APP, 'USER4_MENU_TEXT')
    TEX_USER4__MSG = queryprofile( app_hini, TEX_APP, 'USER4__MSG')

   if tex_is_std_menu() = 1 then
-- we add the OS/2 items to the "Command" and " File" submenus
     buildmenuitem defaultmenu, 1, 105, \0,                      '',            4, 0
     buildmenuitem defaultmenu, 1, 106, TEX_OSSHELL1_MENU_TEXT, 'tex_osshell'\1TEX_OSSHELL__MSG, 0, 0
     buildmenuitem defaultmenu, 2, 212, \0,                      '',            4, 0
     buildmenuitem defaultmenu, 2, 213, TEX_FOLDER1_MENU_TEXT,  'tex_fm'\1TEX_FM__MSG,     0, 0
   endif

-- TeX menu
compile if defined (vtex)
    buildsubmenu defaultmenu, 9, 'V~TeX', \1TEX_BAR__MSG, 0,0
compile else
    buildsubmenu defaultmenu, 9, '~TeX', \1TEX_BAR__MSG, 0,0
compile endif
      buildmenuitem defaultmenu, 9, 901, TEX_TEX_MENU_TEXT\9'Ctrl+F9',      'tex'\1TEX_TEX__MSG, 0,0
      buildmenuitem defaultmenu, 9, 908, TEX_TEXPS_MENU_TEXT\9'Ctrl+F10',   'texps'\1TEX_TEXPS__MSG, 0,0
compile if defined (vtex)
      buildmenuitem defaultmenu, 9, 925, TEX_Q_MENU_TEXT, \1TEX_Q__MSG, 17, 0
      buildmenuitem defaultmenu, 9, 926, TEX_TEXQ_MENU_TEXT,                'texq', 0,0
      buildmenuitem defaultmenu, 9, 928, TEX_TEXQPS_MENU_TEXT,              'texqps', 32769,0
compile endif
      buildmenuitem defaultmenu, 9, 924, TEX_LOCERR_MENU_TEXT\9'Ctrl+F11',  'tex_locate_error'\1TEX_LOCATE_ERROR__MSG, 0,0
      buildmenuitem defaultmenu, 9, 905, TEX_VIEWLOG_MENU_TEXT\9'Ctrl+F12', 'tex_view_log'\1TEX_VIEWLOG__MSG,  0,0

      buildmenuitem defaultmenu, 9, 902, \0, '', 4, 0

compile if defined (vtex)
      buildmenuitem defaultmenu, 9, 923, TEX_VIEWPDF_MENU_TEXT, 'tex_view_pdf'\1TEX_VIEWPDF__MSG, 0,0
      buildmenuitem defaultmenu, 9, 943, TEX_VIEWPS_MENU_TEXT, 'tex_view_ps'\1TEX_VIEWPS__MSG, 0,0
      buildmenuitem defaultmenu, 9, 941, \0, '', 4, 0
compile else
      buildmenuitem defaultmenu, 9, 903, TEX_VIEW_MENU_TEXT,   'tex_view_dvi'\1TEX_VIEWDVI__MSG,  0,0
      buildmenuitem defaultmenu, 9, 943, TEX_VIEWPS_MENU_TEXT, 'tex_view_ps'\1TEX_VIEWPS__MSG, 0,0
      buildmenuitem defaultmenu, 9, 923, TEX_VIEWPDF_MENU_TEXT, 'tex_view_pdf'\1TEX_VIEWPDF__MSG, 0,0
      if tex_check_print_exec() then
        buildmenuitem defaultmenu, 9, 904, TEX_PRINT_MENU_TEXT,  'tex_print'\1TEX_PRINT__MSG,  0,0
      endif
compile endif

      buildmenuitem defaultmenu, 9, 941, \0, '', 4, 0

compile if not defined (vtex)
      buildmenuitem defaultmenu, 9, 944, TEX_DVIPS_MENU_TEXT\9'Ctrl+V',  'tex_dvips'\1TEX_DVIPS__MSG, 0,0
      buildmenuitem defaultmenu, 9, 918, TEX_PS2PDF_MENU_TEXT,  'tex_ps2pdf'\1TEX_PS2PDF__MSG, 0,0
compile endif
      if TEX_USER1_MENU_TEXT <> '' then
        buildmenuitem defaultmenu, 9, 911, TEX_USER1_MENU_TEXT,'texuser1exec' \1TEX_USER1__MSG, 0,0
      endif
      if TEX_USER2_MENU_TEXT <> '' then
        buildmenuitem defaultmenu, 9, 921, TEX_USER2_MENU_TEXT,'texuser2exec' \1TEX_USER2__MSG, 0,0
      endif
      if TEX_USER3_MENU_TEXT <> '' then
        buildmenuitem defaultmenu, 9, 930, TEX_USER3_MENU_TEXT,'texuser3exec' \1TEX_USER3__MSG, 0,0
      endif
      if TEX_USER4_MENU_TEXT <> '' then
        buildmenuitem defaultmenu, 9, 933, TEX_USER4_MENU_TEXT,'texuser4exec' \1TEX_USER4__MSG, 0,0
      endif

      buildmenuitem defaultmenu, 9, 927, \0, '', 4, 0

      buildmenuitem defaultmenu, 9, 940, TEX_MFS_MENU_TEXT, 'tex_master_file_support' \1TEX_MASTER__MSG,0,0
      buildmenuitem defaultmenu, 9, 931, TEX_CONF_MENU_TEXT,'texfe_settings_window' \1TEX_CONF__MSG,0,0
compile if defined (vtex)
      buildmenuitem defaultmenu, 9, 916, TEX_CACHE_MENU_TEXT, 'tex_cache' \1TEX_CACHE__MSG,0,0
compile endif

   if tex_is_std_menu() = 0 then
      buildmenuitem defaultmenu, 9, 917, \0, '',4, 0

      buildmenuitem defaultmenu, 9, 910, TEX_OSSHELL2_MENU_TEXT, 'tex_osshell'\1TEX_OSSHELL__MSG, 0, 0
      buildmenuitem defaultmenu, 9, 912, TEX_FOLDER2_MENU_TEXT,  'tex_fm'\1TEX_FM__MSG,     0, 0
   endif

      buildmenuitem defaultmenu, 9, 922, \0, '', 4, 0

      buildmenuitem defaultmenu, 9, 929, TEX_ABOUT_MENU_TEXT, 'tex_ver' HELP_PROD_MENUP__MSG,0,0

-- enable/disable single menu items:
defc menuinit_9
        if tex_is_doc() then
            SetMenuAttribute( 901, 16384, 1)   -- enable TeX Document
            SetMenuAttribute( 908, 16384, 1)   -- enable TeX/PS
compile if defined (vtex)
            SetMenuAttribute( 925, 16384, 1)   -- enable quick TeX
compile endif
        else
            SetMenuAttribute( 901, 16384, 0)   -- disable TeX Document
            SetMenuAttribute( 908, 16384, 0)   -- disable TeX & dvips
compile if defined (vtex)
            SetMenuAttribute( 925, 16384, 0)   -- disable quick TeX
compile endif
        endif

        if tex_more_errors() then
            SetMenuAttribute( 924, 16384, 1)   -- enable Locate Error
        else
            SetMenuAttribute( 924, 16384, 0)   -- disable Locate Error
        endif

        if tex_current_log() then
            SetMenuAttribute( 905, 16384, 1)   -- enable LOG file view
        else
            SetMenuAttribute( 905, 16384, 0)   -- disable LOG file view
        endif

compile if not defined (vtex)
        if tex_check_print_exec() then
            if tex_check_exist('.DVI') then
               SetMenuAttribute( 904, 16384, 0)   -- disable TeX Print Document
            else
               SetMenuAttribute( 904, 16384, 1)   -- enable TeX Print Document
            endif
        endif

        if tex_check_exist('.DVI') then
            SetMenuAttribute( 903, 16384, 0)   -- disable TeX Preview Document
            SetMenuAttribute( 944, 16384, 0)   -- disable dvips
        else
            SetMenuAttribute( 903, 16384, 1)   -- enable TeX Preview Document
            SetMenuAttribute( 944, 16384, 1)   -- enable dvips
        endif
        if tex_check_exist('.PS') then
            SetMenuAttribute( 918, 16384, 0)   -- disable ps2pdf
        else
            SetMenuAttribute( 918, 16384, 1)   -- enable ps2pdf
        endif

compile endif

        if tex_check_exist('.PS') then
            SetMenuAttribute( 943, 16384, 0)   -- disable PS Preview
        else
            SetMenuAttribute( 943, 16384, 1)   -- enable PS Preview
        endif

        if tex_check_exist('.PDF') then
            SetMenuAttribute( 923, 16384, 0)   -- disable PDF Preview
        else
            SetMenuAttribute( 923, 16384, 1)   -- enable PDF Preview
        endif

        if tex_check_user_exec(1) then
           if tex_check_exist(get_tex_user_ext(1)) then
              SetMenuAttribute( 911, 16384, 0) -- disable
           else
              SetMenuAttribute( 911, 16384, 1) -- enable
           endif
        endif

        if tex_check_user_exec(2) then
           if tex_check_exist(get_tex_user_ext(2)) then
              SetMenuAttribute( 921, 16384, 0) -- disable
           else
              SetMenuAttribute( 921, 16384, 1) -- enable
           endif
        endif

        if tex_check_user_exec(3) then
           if tex_check_exist(get_tex_user_ext(3)) then
              SetMenuAttribute( 930, 16384, 0) -- disable
           else
              SetMenuAttribute( 930, 16384, 1) -- enable
           endif
        endif

        if tex_check_user_exec(4) then
           if tex_check_exist(get_tex_user_ext(4)) then
              SetMenuAttribute( 933, 16384, 0) -- disable
           else
              SetMenuAttribute( 933, 16384, 1) -- enable
           endif
        endif

        -- Master file support
        SetMenuAttribute( 940, 8192, not check_tex_master())

compile if defined (vtex)
        if tex_use_cache() then
              SetMenuAttribute( 916, 16384, 1) -- disable
           else
              SetMenuAttribute( 916, 16384, 0) -- enable
        endif
compile endif
compile endif -- WANT_TEX_MENU


/**************************/
/*                        */
/*  Enable highlighting   */
/*                        */
/**************************/

defproc setTexHilite
    universal  app_hini

if .visible and
   tex_is_file() and not ( (filetype()='DTX' or filetype()='FDD') ) and
   queryprofile(app_hini, TEX_APP, 'TEX_SYNTAXHILITE') then
      'toggle_parse 1 EPMKWDS.TEX'
endif


/********************/
/*                  */
/*  Execute TeX     */
/*                  */
/********************/

defc tex
   call tex_run_tex(0, 0)  -- run TeX

defc texps
   call tex_run_tex(1, 0)  -- run TeX and dvips

compile if defined (vtex)

defc texq
   call tex_run_tex(0, 1)

defc texqps
   call tex_run_tex(1, 1)

compile endif

defproc tex_run_tex(application, quick) -- here we do the real work

-- application = 0:  TeX (or VTeX in PDF mode, resp.)
--               1:  generate PostScript

   universal  tex_log_file_line,
              tex_log_file_curr,
              tex_log_file_name,
              tex_mark_fname,    -- name of original source, if a marked region is TeXed 
              tex_mark_first,    -- no. of first marked line                              
              tex_mark_preamble, -- no. of lines in the preamble                           
              app_hini,
              tex_debug

-- bail out, if not a TeX document
   if not tex_is_doc() then
       call WinMessageBox(TEXFE_TITLE, TEX_NODOC_STRING,
                            MB_OK+MB_WARNING+MB_MOVEABLE)
       RETURN
   endif

compile if WANT_INCLUDEONLY_SUPPORT
-- clear name of included file
   istem = ''
compile endif

-- memorize id of file being edited
   getfileid working_fid

-- If a line or character mark exists, then ask whether only the
-- marked region is to be processed;  indicate this by process_mark = 1.
   process_mark = 0
   if ((marktype() = 'LINE') or (marktype() = 'CHAR')) then
      getmark a,b,c,d,marked_fid
      -- memorize line where mark starts
      tex_mark_first = a
      process_mark = (marked_fid = working_fid) -- mark is in the current file
   endif
   if process_mark then
      rc = WinMessageBox(TEXFE_TITLE,
                      TEX_MARK_STRING,
                      MB_YESNOCANCEL+MB_NOICON+MB_DEFBUTTON1+MB_MOVEABLE)
      if rc = MBID_NO then
         process_mark = 0 -- proceed as usual
      elseif rc = MBID_CANCEL then
         RETURN  -- cancel
      endif
   endif

-- If master file system is enabled, then check for master file

    tex_master= queryprofile( app_hini, TEX_APP, 'TEX_MASTERFILE')
    if tex_master then  /* master file system enabled */
        master = tex_master_name()

-- Now change to master file

        if master = '-1' then   -- master file specified but not found on disk
           RETURN
        endif

        if master = '' then  -- no master file specified
            sayerror .filename||TEX_M_ASSUME_STRING
            call tex_parse_filename(.filename,dr,dir,stem,ext)
            call tex_check_for_save()
        else   -- a master file is being used
            sayerror TEX_M_NAME_STRING||master
compile if WANT_INCLUDEONLY_SUPPORT
            -- memorize name of included file (lowercase)
            call tex_parse_filename(lowcase(.filename),idr,idir,istem,iext)
compile endif
            call tex_parse_filename(master,dr,dir,stem,ext)
            if tex_file_in_ring(master) then
                getfileid master_fid,master
                activatefile master_fid
                call tex_check_for_save()
            else
                'edit /d' master
                getfileid master_fid
            endif
        endif

-- Here we look for file dependencies in the file to be formatted
-- and if dependent files are loaded in the editor
-- they are checked for modification as well.
-- Notes:
--    * we search each line of the file so this can be a real
--      performance bottleneck with large files
--    * nested dependencies more than one level deep are ignored
--
--  We recognize 3 methods to specify an included file:
--  LaTeX: \include{file} or \input{file}
--  TeX:   \input file

        getfileid source_fid
        for counter = 1 to .last
            getline line, counter
            if pos('%', strip(line)) <> 1 then  -- line doesn't start with %
                parse value line with '\include{' dep_fname '}' .
                if dep_fname = '' then
                   parse value line with '\input{' dep_fname '}' .
                   if dep_fname = '' then
                      parse value line with '\input ' dep_fname .
                   endif
                endif
            else
               dep_fname = ''
            endif

            if dep_fname <> '' then
-- Translate from unix-style to OS/2-style and add '.tex' extension if missing
               dep_fname = translate(strip(dep_fname),'\','/')
               n = lastpos('\',dep_fname)
               tmp = substr(dep_fname,n+1)
               if lastpos('.', tmp) <> length(tmp) then
                  parse value tmp with  tmpStem '.' tmpExt
                  if tmpExt = ''  then
                      dep_fname = dep_fname||'.tex'
                  endif
               else
                  -- the given filename ends with '.', so
                  -- we remove the '.' to get the real name
                  dep_fname = substr(dep_fname, 1, length(dep_fname)-1)
               endif
               sayerror TEX_CHKDEP_STRING||dep_fname
               if tex_file_in_ring(dep_fname) = 1 then
                   getfileid dep_fid,dep_fname
                   activatefile dep_fid
                   call tex_check_for_save()
                   activatefile source_fid   /* restore source file */
               endif
            endif
        endfor
    else /* master file system disabled */
        call tex_parse_filename(.filename,dr,dir,stem,ext)
        call tex_check_for_save()
        master = ''
    endif /* tex_master */

-- determine TeX format
   format = tex_auto_format()

compile if not defined (vtex)
-- get name of TeX program for the requested format
   if  translate(format) = 'PLAIN' then
      texprog = 'tex'
   else
      texprog = format
   endif
compile endif

-- Change working directory to directory of current file since that is
-- where the .DVI and .LOG files (and any others) should go.
   call tex_cd()

-- TeX marked region only?
   if process_mark then
      -- memorize name of marked file
      tex_mark_fname = .filename
      getfileid current_fid  -- memorize current file
      'edit /n 'stem'.___'   -- create temporary file
      -- first we locate the end of the preamble;
      bye = ''
      do counter = 1 to current_fid.last
         getline line, counter, current_fid
         insertline line
         if pos('\begin{document}', line) then
            bye = '\end{document}'
            leave
         endif
         if pos('%**end of header', line) then
            bye = '\bye'
            leave
         endif
      enddo
      -- memorize length of preamble
      tex_mark_preamble = counter
      if bye = '' then
         .modify = 0;
         'quit'
         activatefile current_fid
         call WinMessageBox(TEXFE_TITLE, TEX_MARK3_STRING,
                            MB_OK+MB_WARNING+MB_MOVEABLE)
         RETURN
         -- we stay in the file the above warning refers to !
      endif
      -- now copy the marked lines from marked_fid to temporary file
      do counter = a to b
         getline line, counter, marked_fid
         if ((marktype() = 'CHAR') and (a=b)) then
            line = substr(line,c,(d-c+1))
         elseif ((marktype() = 'CHAR') and (counter=a)) then
            line = substr(line,c)
         elseif ((marktype() = 'CHAR') and (counter=b)) then
            line = substr(line,1,d)
         endif
         insertline line
      enddo
      insertline bye
      'file' -- save and quit temporary file
      activatefile current_fid  -- return to main document
      ext = '___'
compile if WANT_INCLUDEONLY_SUPPORT
--    clear name of included file, if TeXing a marked region only
      istem = ''
compile endif
   else
      tex_mark_fname = ''
      tex_mark_first = 0
      tex_mark_preamble = 0
   endif /* process_mark */

compile if WANT_INCLUDEONLY_SUPPORT
-- include working file only
   if istem <> ''  then
      -- TeXing was requested while an included file was being edited
      do counter = 1 to .last -- we are in the master file now!
         getline line, counter
         if pos('\begin{document}', line) then
            leave
         endif
         parse value line with code '%'
         parse value code with '\includeonly{' junk
         if junk <> '' then
            newline = '\includeonly{' || istem || '}'
            replaceline newline, counter
            'Save'
            sayerror newline
            leave
         endif
      enddo
   endif
compile endif

-- Put together the TeX command from the following parts:
--    tex invocation
--    stem
--    ext

compile if defined (vtex)
   if application=1 then
      vtexoptions = queryprofile(app_hini, TEX_APP, 'PS_OPTIONS')
   else
      vtexoptions = queryprofile(app_hini, TEX_APP, 'PDF_OPTIONS')
   endif
   if quick=1 then
      vtexoptions = '-q ' || vtexoptions
   endif
   cmdline = 'vtex '  || vtexoptions || ' @' || format || ' ' || stem
   if translate(ext) <> 'TEX' then -- add extension
      cmdline = cmdline||'.'||ext
   endif
   -- Do not close the OS/2 window, if any error occurs.;
   cmdline = '" ' || cmdline || ' || pause "'
/*
   -- Alternatively, we check for a particular errorlevel:
   cmdline = '"' cmdline '& if errorlevel 3 pause "'
*/
   -- execute the above command line using cmd.exe:
   command = 'start "VTeX" /f /c' cmdline

compile else
   cmdline = texprog || ' ' || stem
   if translate(ext) <> 'TEX' then -- add extension
      cmdline = cmdline||'.'||ext
   endif
   if application=1 then
      -- run TeX and dvips in sequence;
      -- first we need the name of the dvips program
      dvips = queryprofile(app_hini, TEX_APP, 'DVIPS_EXEC')
      if dvips = '' then
         call WinMessageBox(TEXFE_TITLE, TEX_NODVIPS_STRING,
                              MB_OK+MB_WARNING+MB_MOVEABLE)
         RETURN
      else
      endif
      -- an example what to execute:
      -- "( latex myprog.dtx && dvips32 myprog ) || pause "
      cmdline = '"(' cmdline '&&' dvips stem ') || pause "'
      -- start cmd.exe and pass it the above command line
      command = 'start "TeX - dvips" /f /n cmd.exe /C ' cmdline
   else
      -- run TeX only
      command = 'start /f /c "TeX"' cmdline
   endif
compile endif

-- launch the TeX command
   if tex_debug=1 then sayerror command; endif
   command
   if rc <> 0 then
      sayerror command || TEX_CMDFAIL_STRING || rc
      call tex_cmderror()
   else
      -- Memorize fully qualified name of current log file
      tex_log_file_name = dr||dir||stem||'.log'
      call setprofile(app_hini, TEX_APP, 'LOGFILE', tex_log_file_name)
      -- Remove old LOG file from the ring after successful TeX compilation
      if tex_file_in_ring(tex_log_file_name) = 1 then
        getfileid log_fid,tex_log_file_name
        activatefile log_fid
        .modify = 0             -- set this in case user modified file
        'quit'                  -- close the file
      endif
      -- Can't load new log file here unless we wait for TeX to finish
      tex_log_file_line = 1
      tex_log_file_curr = 1
      -- need this in case the log file will be loaded manually
   endif /* rc <> 0 */

-- Change back to file from which we called TeX if we changed it
   getfileid current_fid
   if current_fid <> working_fid then
      activatefile working_fid
   endif
RETURN


compile if not defined (vtex)
/********************/
/*                  */
/*   DVI preview    */
/*                  */
/********************/

defc tex_view_dvi
    universal  app_hini

    command = queryprofile( app_hini, TEX_APP, 'VIEW_CMD')
    call tex_run_cmd('.dvi', command, TEX_VIEW_TITLE, 'TEX_VIEW_DVI_OPT')
compile endif


compile if not defined (vtex)
/***************/
/*             */
/*   Print     */
/*             */
/***************/

defc tex_print
    universal  app_hini

    command = queryprofile( app_hini, TEX_APP, 'PRINT_CMD')
    call tex_run_cmd('.dvi', command, TEX_PRINT_TITLE, 'TEX_PRINT_OPT')
compile endif


/********************/
/*                  */
/*   PS preview     */
/*                  */
/********************/

defc tex_view_ps
    universal  app_hini

    command = queryprofile( app_hini, TEX_APP, 'VIEWPS_CMD')
    call tex_run_cmd('.ps', command, TEX_VIEWPS_TITLE, 'TEX_VIEWPS_OPT')


/********************/
/*                  */
/*  PDF preview     */
/*                  */
/********************/

defc tex_view_pdf
    universal  app_hini

    command = queryprofile( app_hini, TEX_APP, 'VIEWPDF_CMD')
    call tex_run_cmd('.pdf', command, TEX_VIEWPDF_TITLE, 'TEX_VIEWPDF_OPT')


compile if not defined (vtex)
/**************/
/*            */
/*   dvips    */
/*            */
/**************/

defc tex_dvips
    universal  app_hini

    dvips = queryprofile( app_hini, TEX_APP, 'DVIPS_EXEC')
    if dvips = '' then
       call WinMessageBox(TEXFE_TITLE, TEX_NODVIPS_STRING,
                            MB_OK+MB_WARNING+MB_MOVEABLE)
       RETURN
    endif
    cmdline = '"' dvips '[' dvips '] %**N || pause"'
    -- pass the above command line to cmd.exe
    command  = 'start /f /n cmd.exe /C ' cmdline
    call tex_run_cmd('.dvi', command, TEX_DVIPS_TITLE, 'TEX_DVIPS_OPT')


/**************/
/*            */
/*   ps2pdf   */
/*            */
/**************/

defc tex_ps2pdf
    universal  app_hini

    ps2pdf = queryprofile( app_hini, TEX_APP, 'PS2PDF_CMD')
    if ps2pdf = '' then
       call WinMessageBox(TEXFE_TITLE, TEX_NOPS2PDF_STRING,
                            MB_OK+MB_WARNING+MB_MOVEABLE)
       RETURN
    endif
    cmdline = '"' ps2pdf '[' ps2pdf '] %**N || pause"'
    -- pass the above command line to cmd.exe
    command  = 'start /f /n cmd.exe /C ' cmdline
    call tex_run_cmd('.ps', command, TEX_PS2PDF_TITLE, 'TEX_PS2PDF_OPT')

compile endif


/**********************/
/*                    */
/*   View log file    */
/*                    */
/**********************/

defc tex_view_log
    universal  tex_log_file_curr,
               tex_log_file_name,
               app_hini

   -- lockout if there is no "current" log file yet
   if not tex_current_log() then
      call WinMessageBox( TEXFE_TITLE, TEX_NOCURRLOG_STRING,
                          MB_OK+MB_WARNING+MB_MOVEABLE)
      RETURN
   endif

   call tex_parse_filename(tex_log_file_name,dr,dir,stem,ext)

   -- if log file is already in the ring
   if tex_file_in_ring(tex_log_file_name) then
      getfileid log_fid,tex_log_file_name
      getfileid current_fid
      -- if we are alreay in the log file, then reset the parsing facility
      if current_fid = log_fid then
         call tex_parse_init()
         if .last > 2 then .line = 3 else .line = 1 endif
         .col = 1
      -- else switch to log file
      else
         activatefile log_fid
      endif
   -- log file needs to be loaded
   else  
      if not exist(tex_log_file_name) then
         call WinMessageBox( TEXFE_TITLE,
                             TEX_L_LOG_STRING || tex_log_file_name || 
                             TEX_NOTFOUND_STRING,
                             MB_OK+MB_WARNING+MB_MOVEABLE)
         -- clear the current log file name
         tex_log_file_name = ''
         call setprofile(app_hini, TEX_APP, 'LOGFILE', '')
         RETURN
      endif
      -- load log file read-only
      'edit /d /r' tex_log_file_name
      -- go to location of last error, if possible
      if tex_log_file_curr <= .last then
         .line = tex_log_file_curr
         .col = 1
      endif
      -- initialize the parsing routines
      call tex_parse_init()
   endif


/*************************/
/*                       */
/*   The user commands   */
/*                       */
/*************************/

defc texuser1exec
   universal app_hini

   UserMenuText = queryprofile( app_hini, TEX_APP, 'USER1_MENU_TEXT')
   UserMenuTexT = translate(UserMenuText, '', '~')
   UserExt = queryprofile( app_hini, TEX_APP, 'USER1_EXT')
   command = queryprofile( app_hini, TEX_APP, 'USER1_CMD')
   key = 'USER1_OPT'
   call tex_run_cmd(UserExt, command, UserMenuText, key)

defc texuser2exec
   universal app_hini

   UserMenuText = queryprofile( app_hini, TEX_APP, 'USER2_MENU_TEXT')
   UserMenuTexT = translate(UserMenuText, '', '~')
   UserExt = queryprofile( app_hini, TEX_APP, 'USER2_EXT')
   command = queryprofile( app_hini, TEX_APP, 'USER2_CMD')
   key = 'USER2_OPT'
   call tex_run_cmd(UserExt, command, UserMenuText, key)

defc texuser3exec
   universal app_hini

   UserMenuText = queryprofile( app_hini, TEX_APP, 'USER3_MENU_TEXT')
   UserMenuTexT = translate(UserMenuText, '', '~')
   UserExt = queryprofile( app_hini, TEX_APP, 'USER3_EXT')
   command = queryprofile( app_hini, TEX_APP, 'USER3_CMD')
   key = 'USER3_OPT'
   call tex_run_cmd(UserExt, command, UserMenuText, key)

defc texuser4exec
   universal app_hini

   UserMenuText = queryprofile( app_hini, TEX_APP, 'USER4_MENU_TEXT')
   UserMenuTexT = translate(UserMenuText, '', '~')
   UserExt = queryprofile( app_hini, TEX_APP, 'USER4_EXT')
   command = queryprofile( app_hini, TEX_APP, 'USER4_CMD')
   key = 'USER4_OPT'
   call tex_run_cmd(UserExt, command, UserMenuText, key)


/***************************************/
/*                                     */
/*   Execute an external command       */
/*                                     */
/***************************************/

defproc tex_run_cmd(FileExt, cmd, title, optname) =

-- Arguments:
-- FileExt      check for the existence of this file type first
-- cmd          the command to be executed
-- title        use this as the window title
-- optname      save extra options under this key in the INI file

universal app_hini,
          tex_debug

if tex_debug=1 then
   sayerror 'tex_run_cmd started:'
   sayerror 'FileExt=' FileExt
   sayerror 'cmd=' cmd
   sayerror 'title=' title
   sayerror 'optname=' optname
endif

if cmd = '' then
     call WinMessageBox(TEXFE_TITLE, TEX_NOCONFIG_STRING,
                          MB_OK+MB_WARNING+MB_MOVEABLE)
   RETURN
endif

-- If master file system is enabled, then check for master file
tex_master= queryprofile( app_hini, TEX_APP, 'TEX_MASTERFILE')
if tex_master  then
    master = tex_master_name()
    if master = '-1' then
       RETURN
    endif
    if master = '' then
        sayerror .filename||TEX_M_ASSUME_STRING
        call tex_parse_filename(.filename,dr,dir,stem,ext)
    else
        sayerror TEX_M_NAME_STRING||master
        call tex_parse_filename(master,dr,dir,stem,ext)
    endif
else
   call tex_parse_filename(.filename,dr,dir,stem,ext)
endif /* masterfile support */

-- lockout if file does not exist
if FileExt <> '' then
   -- is the current file a real document?
   if (dr = '') or (dir ='') then
      call WinMessageBox(TEXFE_TITLE, TEX_NOCURRDOC_STRING,
         MB_OK+MB_WARNING+MB_MOVEABLE)
      RETURN
   endif
   if not exist(dr||dir||stem||FileExt) then
      call WinMessageBox(TEXFE_TITLE,
         TEX_FILE_STRING || dr||dir||stem||FileExt || TEX_NOTFOUND_STRING,
         MB_OK+MB_WARNING+MB_MOVEABLE)
      RETURN
   endif
endif

-- Substitute the filename in the command string
command = tex_makecmd(cmd, dr||dir||stem , ext)

-- Evaluate options to be entered interactively
if pos('[',command) and optname <> '' then
    parse value command with lcommand '[' prompttext ']' rcommand
    curopts = queryprofile( app_hini, TEX_APP, optname)
    sbuf = entrybox(title,
                    TEX_XOPT_BUTTONS,
                    curopts,60,62,
                    atoi(1) ||            -- default button #
                    atoi(0) ||            -- help panel ID (0 for no help)
                    gethwnd(APP_HANDLE) ||
                    TEX_ADDOPT_STRING||prompttext||\0)
                                          -- prompt
    button = asc(leftstr(sbuf,1))
    if button=3 or button=0 then RETURN; endif -- Cancel or closed otherwise
    if button=2 then                           -- Use std. options
       options = ''
    else                                       -- Use extra options
       EOS = pos(\0,sbuf,2)    -- CHR(0) signifies End Of String
       options = substr(sbuf,2,EOS-2)
       call setprofile( app_hini, TEX_APP, optname, options)
    endif
    command = lcommand||options||rcommand
endif

-- tell the user that the command is going to be launched:
sayerror title

--  Change working directory to directory of current or master file

wrkdir = dr || leftstr(dir,length(dir)-1)
-- dirty patch to get root directory right
if lastpos(':', wrkdir) = length(wrkdir) then
   wrkdir = wrkdir || '\'
endif
if tex_debug then sayerror 'going to 'wrkdir; endif
call directory(wrkdir)

-- launch the command
if tex_debug=1 then sayerror command; endif
command
if rc <> 0 then
  sayerror command || TEX_CMDFAIL_STRING || rc
  call tex_cmderror()
endif



/******************************************************/
/*                                                    */
/*   Read LOG file and find errors in source code     */
/*                                                    */
/******************************************************/

defc tex_locate_error
   universal tex_log_file_name

-- lockout if there is no "current" log file yet
if not tex_current_log() then
   call WinMessageBox(TEXFE_TITLE, TEX_NOCURRLOG_STRING,
                         MB_OK+MB_WARNING+MB_MOVEABLE)
   RETURN
endif

if tex_more_errors() then  -- more errors to be shown?
    call tex_find_errors()
else
    sayerror TEX_NOERRORS_STRING
endif


/***************************/
/*                         */
/*   Product information   */
/*                         */
/***************************/
defc tex_ver
   call WinMessageBox(TEXFE_TITLE||TEX_ABOUT_TITLE,
                      TEXFE_TITLE||TEXFE_VERSION_STRING||TEXFE_VERSION||\13||
                      TEXFE_COPYRIGHT\13\13||
                      TEXFE_THANKS_STRING,
                      MB_OK+MB_INFORMATION+MB_DEFBUTTON1+MB_MOVEABLE)


/************************************/
/*                                  */
/*  (Re-)build path cache for VTeX  */
/*                                  */
/************************************/
compile if defined (vtex)

defc tex_cache
   universal tex_debug,
             app_hini

   if tex_use_cache() then
      defformat = queryprofile (app_hini, TEX_APP, 'DEFAULT_FORMAT')
      format = defformat
      do forever
      sbuf = entrybox(TEX_CACHE_TITLE,
                      TEX_SOPT_BUTTONS,
                      format,15,31,
                      atoi(1) ||            -- default button #
                      atoi(0) ||            -- help panel ID (0 for no help)
                      gethwnd(APP_HANDLE) ||
                      TEX_CACHE_PROMPT||\0) -- prompt
        button = asc(leftstr(sbuf,1))
        if button=3 or button=0 then -- Cancel or closed otherwise
           format = ''
           LEAVE;
        endif
        if button=2 then             -- Default
           format = defformat
        else                         -- OK
           EOS = pos(\0,sbuf,2)    -- CHR(0) signifies End Of String
           format = substr(sbuf,2,EOS-2)
           LEAVE
        endif
      enddo
      if format <> '' then
         command = '"vtex -pw @' || format || ' & pause"'
         command = 'start "VTeX: '||TEX_CACHE_TITLE||'" /f /c' command
         if tex_debug=1 then sayerror command; endif
         command
         if rc <> 0 then
            sayerror command || TEX_CMDFAIL_STRING || rc
            call tex_cmderror()
         endif
      endif
   else
--      sayerror(TEX_NOCACHE_STRING)
   call WinMessageBox(TEXFE_TITLE, TEX_NOCACHE_STRING,
                        MB_OK+MB_WARNING+MB_MOVEABLE)
   endif

compile endif


/*
Ŀ
  Procedure definitions                                                     

*/

-----------------------------------------------------------------------------
-- Determine format to use with this file from first line of the file.
-- Same specification as Eberhard Mattes' TEXIT.CMD distributed with emTeX.
-- The default format is DEFAULT_FORMAT.

defproc tex_auto_format =
    universal app_hini

    format = ''
    getline line, 1
    if substr(word(line,1),1,2) == '%&' then
       format=substr(word(line,1),3)
    endif
    if format = '' then
       parse value line with '%' 'format:' format .
    endif
    if format = '' then
       parse value line with '%' 'format ' format .
    endif
    if format = '' then
       parse value line with '%' 'Format:' format .
    endif
    if format = '' then
       parse value line with '%' 'Format ' format .
    endif
    if format = '' then
       format = queryprofile (app_hini, TEX_APP, 'DEFAULT_FORMAT')
       sayerror TEX_NO_FORMAT_STRING||format||TEX_USE_FORMAT_STRING
    else
       sayerror TEX_FORMAT_STRING||format||TEX_USE_FORMAT_STRING
    endif
    return format

-----------------------------------------------------------------------------
-- Called from menuinit_9 to determine if file of given type exists for the
-- associated master file, or for current file.
-- Returns:  1 if file does not exist or if the master file does not exist
--           0 if the file exists

defproc tex_check_exist(FileExt) =
    universal  app_hini

-- If master file system is enabled, then check for master file
    if queryprofile( app_hini, TEX_APP, 'TEX_MASTERFILE') then
        master = tex_master_name('ignore')
        if master = '' then
            fname = .filename
        else
            fname = master
        endif
    else
        fname = .filename
    endif -- master file support
    if fname = '-1' then
       ret = 1
    else
       if FileExt = '' then
          ret= 0
       else
          call tex_parse_filename(fname,dr,dir,stem,ext)
          ret = not exist(dr||dir||stem||FileExt)
       endif
    endif
return ret

-----------------------------------------------------------------------------
-- get the value of USER?_EXT

defproc get_tex_user_ext =
    universal  app_hini

    if arg(1) = 1 then
        return  queryprofile(app_hini, TEX_APP, 'USER1_EXT')
    elseif arg(1) = 2 then
        return  queryprofile(app_hini, TEX_APP, 'USER2_EXT')
    elseif arg(1) = 3 then
        return  queryprofile(app_hini, TEX_APP, 'USER3_EXT')
    elseif arg(1) = 4 then
        return  queryprofile(app_hini, TEX_APP, 'USER4_EXT')
    else
         return ''
    endif

-----------------------------------------------------------------------------
compile if not defined (vtex)
defproc tex_check_print_exec =
   universal app_hini

   return queryprofile(app_hini, TEX_APP, 'PRINT_CMD') <> ''
compile endif

-----------------------------------------------------------------------------
-- determine if TEX_USER?_MENU_TEXT is defined

defproc tex_check_user_exec =
    universal app_hini

    if arg(1) = 1 then
        return  queryprofile(app_hini, TEX_APP, 'USER1_MENU_TEXT') <> ''
    elseif arg(1) = 2 then
        return  queryprofile(app_hini, TEX_APP, 'USER2_MENU_TEXT') <> ''
    elseif arg(1) = 3 then
        return  queryprofile(app_hini, TEX_APP, 'USER3_MENU_TEXT') <> ''
    elseif arg(1) = 4 then
        return  queryprofile(app_hini, TEX_APP, 'USER4_MENU_TEXT') <> ''
    else
         return 0
    endif

-----------------------------------------------------------------------------
--  Check to see if current file has been modified.  If it has, save it.

defproc tex_check_for_save =

    if .modify then
       'Save'
    endif

-----------------------------------------------------------------------------
/*
Extract master file name from first line of file

Returns: a) '' if master file is not specified;
         b) master file name with path added on if file exists;
         c) '-1', if master file is specified but doesn't exist.

If arg(1) <> 'ignore' AND the master file is specified, but doesn't
exist, a warning message is displayed.
*/

defproc tex_master_name
    universal  app_hini

    master = ''
    getline line, 1
    parse value line with '%' . 'master' ':' master .
    if master = '' then
        parse value line with '%' . 'master' master .
        if master = '' then
            parse value line with '%' . 'Master'  ':' master .
            if master = '' then
                parse value line with '%' . 'Master'  master .
            endif
        endif
    endif

    if master <> '' then
        master = translate(master,'\','/') -- convert to DOS format
        if lastpos('\', master) >= lastpos('.',master) then
           -- there is no '.' in the name
           master = master||'.tex'
        endif
--  *** bug: filename. -> filename..tex

--  Now, make the master filename fully qualified.
--      First we determine current drive and dir;
        tex_parse_filename(.filename,dr,dir,stem,ext)
--      If there is a colon in the filename, then we're finished:
        if not pos(':',master) then
--         does the name start with '..' ?
           if pos('..', master) = 1 then
              call tex_cd() -- switch to dir. of current file
              currdir = directory() -- save current directory
              call directory('..')
              master = substr(master,3) -- must include backslash!
              mdir = directory()  -- does not include backslash!
              master = mdir||master
              call directory(currdir) -- restore directory
--         does the name start with '.\' ?
           elseif pos('.\', master) = 1 then
              master = substr(master,3)
              master = dr||dir||master
--         absolute path, without drive letter?
           elseif pos('\',master) = 1 then
              master = dr||master
           else
--         it must be a relative path then:
--         add drive letter and current dir
              master = dr||dir||master
           endif
        endif
-- Does the master file exist?
        if not exist(master) then
           if arg(1) <> 'ignore' then
              call WinMessageBox(TEXFE_TITLE, TEX_M_MASTER_STRING||
                                         TEX_NOTFOUND_STRING,
                                 MB_OK+MB_WARNING+MB_MOVEABLE)
           endif
           master = '-1'
        endif
    endif

    return master

-----------------------------------------------------------------------------
-- Parse a file name:  d:\dir1\dir2\file.ext
--                     \dir1\dir2\file.ext
--                     file.ext
--                     .ext
--                     \dir1\.ext
--                     ...etc,  but NOT d:test2.ext
-- returns  dr      d:
--          dir     \dir1\dir2\    if any of these does not exist,
--          stem    file           a null is returned.
--          ext     ext

defproc tex_parse_filename(fname, var dr, var dir, var stem, var ext)

-- Translate from Unix-style to OS/2-style names
   fname = translate(fname,'\','/')
   n = lastpos('\',fname)
   tmp = substr(fname,n+1)
   parse value tmp with  stem '.' ext
   tmp = substr(fname,1,n)
   n = pos(':',tmp)
   dr = substr(tmp,1,n)
   dir = substr(tmp,n+1)

-----------------------------------------------------------------------------
-- Determine if a file already is in ring.

defproc tex_file_in_ring(fname)
   universal tex_debug

   getfileid id, fname
   return (id <> '')
/*
   tex_parse_filename(fname,dr,dir,stem,ext)
   if ext = '' then
      return pfile_exists(stem)
   else
      return pfile_exists(stem||'.'||ext)
   endif
*/

-----------------------------------------------------------------------------
-- Called to determine whether or not to disable
-- the error browsing facility.
-- Returns 1 if there can be more errors,
--         0 if not or no "current" log file exists

defproc tex_more_errors
   universal  tex_log_file_line,
              tex_log_file_last,
              tex_log_file_name

   if tex_log_file_name <> '' then    -- a current log file exists
      if tex_file_in_ring(tex_log_file_name) then   -- loaded?
         -- can there still be errors in it?
         res = ( tex_log_file_line < tex_log_file_last )
      else
         res = 1
      endif  -- file in ring
   else
      res = 0
   endif -- current log file exists
return res

-----------------------------------------------------------------------------
-- Determine whether there is a "current" log file.
-- Returns 1 if so.

defproc tex_current_log
   universal tex_log_file_name
return tex_log_file_name <> ''

-----------------------------------------------------------------------------
--  Read LOG file and find errors in source code

defproc tex_find_errors
   universal  tex_log_file_line,     -- current line to be analyzed
              tex_log_file_curr,     -- current error msg starts here
              tex_log_file_last,     -- no. of last line in log file
              tex_log_file_name,     -- name of current log file
              tex_error_fname,       -- source file which caused current error
              tex_mark_fname,        -- name of original source, if a marked region was TeXed
              tex_mark_first,        -- no. of first marked line
              tex_mark_preamble,     -- no. of lines in the preamble
              name_count,
              par_count,
              EPM_utility_array_ID,
              app_hini,
              tex_debug

   empty = ''
   getfileid tex_return_to_fid
   
call tex_parse_filename(tex_log_file_name,dr,dir,stem,ext)

-- Load/switch to .LOG file
   if tex_file_in_ring(tex_log_file_name) = 1 then
      getfileid log_fid, tex_log_file_name
      activatefile log_fid
   else
      if not exist(tex_log_file_name) then
         call WinMessageBox( TEXFE_TITLE,
                             TEX_L_LOG_STRING || tex_log_file_name ||
                             TEX_NOTFOUND_STRING,
                             MB_OK+MB_WARNING+MB_MOVEABLE)
         -- clear the current log file name
         tex_log_file_name = ''
         call setprofile(app_hini, TEX_APP, 'LOGFILE', '')
         RETURN
      endif
      'edit /d /r' tex_log_file_name
      getfileid log_fid
      tex_error_fname = ''
      call tex_parse_init()
   endif

   call tex_cd()

   do while (tex_log_file_line < tex_log_file_last)

      getline line, tex_log_file_line

      if leftstr(line,1) = '!' then
         -- memorize line number of the current error
         tex_log_file_curr = tex_log_file_line
         parse value line with '!'error_msg
         -- catch VTeX PostScript errors
         if word(error_msg, 1) <> 'PostScript' then
            -- search for line containing line number of error;
            -- if none is present, we must not run over the end of the file;
            -- better: realise this situation before -- how?
            do forever
               tex_log_file_line = tex_log_file_line + 1
               if tex_log_file_line > tex_log_file_last then leave endif
               getline line, tex_log_file_line
               if (leftstr(line,1) = 'l') or (leftstr(line,1) = '!')  then
                  leave
               endif
            enddo
         endif
-- The message
compile if defined (vtex) -- with VTeX, obtain also name of source file in this step
         parse value line with 'l.' linenum '.' colnum '(' vfilename ')'
         if word(error_msg, 1) = 'PostScript' then
            sayerror error_msg
            linenum = 'unknown'
         else
            if isnum(linenum) and isnum(colnum) and vfilename <> '' and (tex_log_file_line < tex_log_file_last) then
               getline vline, tex_log_file_line+1
               parse value vline with '> ' contexttext
               sayerror error_msg': 'contexttext
               tex_error_fname = translate(vfilename,'\','/')
            else
               -- no success
               linenum = 'unknown'
            endif
         endif
compile else
         parse value line with 'l.' linenum contexttext
         if word(error_msg, 1) = 'PostScript' then
            sayerror error_msg
            linenum = 'unknown'
         elseif isnum(linenum) then
            -- try ordinary message format
            sayerror error_msg': 'contexttext
         else
            -- try VTeX's format
            parse value line with 'l.' linenum '.' junk '(' vfilename ')'
            if isnum(linenum) and isnum(junk) and vfilename <> '' and (tex_log_file_line < tex_log_file_last) then
               getline vline, tex_log_file_line+1
               parse value vline with '> ' contexttext
               sayerror error_msg': 'contexttext
            else
               -- no success, either
               linenum = 'unknown'
            endif
         endif
compile endif
-- The cursor position in the log file:
         .line = tex_log_file_curr
         .col = 1
-- If a marked region was TeXed, determine original filename and line number.
-- Otherwise, use the indicated filename immediately.
         if pos(stem'.___', tex_error_fname) then
            tex_source_fname = tex_mark_fname
            if isnum(linenum) then
               if linenum > tex_mark_preamble then
                  linenum = linenum - tex_mark_preamble + tex_mark_first - 1
               endif
            endif
            -- NB:  if the log file stems from a previous EPM session,
            -- then tex_mark_fname is still empty; this case will be handled
            -- appropriately, though!
         else
            tex_source_fname = tex_error_fname
         endif
         if tex_debug > 0 then sayerror '  source: 'tex_source_fname endif
-- The source file, where the error is located:
         if tex_source_fname = '' then 
            -- no related source file name was found;
            -- we just proceed, with fingers crossed ;-)
            -- if a line number was found, it is, most likely, garbage:
            linenum = 'unknown'
         elseif  not isnum(linenum) then
            -- at least, anounce the name of the related source file:
            sayerror TEX_NOLOC_STRING||tex_source_fname
         elseif tex_file_in_ring(tex_source_fname) = 1 then
            'edit' tex_source_fname
            getfileid tex_source_fid
         else
            -- This file should exist since we 'just' compiled it.
            'edit /d' tex_source_fname
            getfileid tex_source_fid
         endif
-- How to proceed?
         if not isnum(linenum) then -- this covers also the case of empty filename
            -- Proceed with line after the error message:
            tex_log_file_line = tex_log_file_curr + 1 
         elseif linenum > .last then
            -- Don't run over the last line; go back to log file instead
            activatefile log_fid
            sayerror TEX_ERRERR_STRING||tex_source_fname
         else
            -- OK, proceed and show the error in the source code:
            getline errorline, linenum
            tex_log_file_line = tex_log_file_line + 1
compile if defined (vtex)
            col2 = colnum + 1
            col1 = colnum - length(contexttext)
            if col1 < 1 then col1 = 1 endif /* just to make sure...*/
compile else
            if length(contexttext) > 4 then
               chopum = 4
            else
               chopum = 1
            endif
            col1 = pos( substr(contexttext,chopum), errorline)
            col2 = col1 + length(contexttext) - chopum + 1
            /* I don't understand this code any more... */
compile endif
            --.line = linenum
            --.col  = col2
            --'PostMe tex_circleit '||col1
            -- Better delay the following to position the cursor
            -- properly after file switching is completed and to make
            -- the circle for the first error stay for more cases,
            -- even when the .LOG file was not loaded before.
            'postme tex_show_error' tex_source_fid linenum col2 col1
         endif
         RETURN
      else    /* This is not a line starting with '!' */

compile if not defined (vtex)
-- analyze current line to determine tex_error_fname
         do while not ( line = '')

            if tex_debug > 2 then sayerror 'line='line; endif
            left_par =  pos('(',line)
            right_par = pos(')',line)
            if tex_debug > 2 then sayerror 'left_par='left_par'  right_par='right_par; endif
-- EPM5 can only handle lines of 255 chars anyway, so make them 256 if the
-- are 0 to simplify things a bit.
            if left_par = 0 then left_par = 256 endif
            if right_par = 0 then right_par = 256 endif

            if (right_par < left_par) then
               par_count = par_count - 1
               if tex_debug > 2 then sayerror 'par_count (decreased) ='par_count; endif
               if par_count = 0 then
                  if tex_debug > 2 then sayerror 'Erasing name 'name_count' from array'; endif
                  do_array 2, EPM_utility_array_ID, 'tex_fname.'name_count, empty
                  do_array 2, EPM_utility_array_ID, 'tex_par.'name_count, empty
                  name_count = name_count - 1
-- name_count will be 0 when we are finished
                  if name_count > 0 then
                     do_array 3, EPM_utility_array_ID, 'tex_fname.'name_count, tex_error_fname
                     do_array 3, EPM_utility_array_ID, 'tex_par.'name_count, par_count
                     if tex_debug > 2 then sayerror 'Got 'tex_error_fname'('name_count') and par_count='par_count; endif
                  else
                     if tex_debug > 2 then sayerror 'name_count = 0'; endif
                  endif
                  endif
                  if tex_debug > 2 then sayerror 'line=   'line; endif
                  line = substr(line,right_par+1)
                  if tex_debug > 2 then sayerror 'newline='line; endif
            else
               if not (left_par = 256) then
                  line = substr(line,left_par+1)
                  if tex_debug > 1  then
                     sayerror 'searching for filename in:'line
                  endif
                  if tex_extract_fname(line,dr,dir) = 0 then
                     par_count = par_count + 1
                     if tex_debug > 2 then sayerror 'par_count (increased) ='par_count; endif
                  else
                     par_count = 1
                     if tex_debug > 2 then sayerror 'par_count set to 1'; endif
                  endif
               else
                  line = ''
               endif
            endif
         enddo  /*  while not (line='')  */
compile endif
          tex_log_file_line = tex_log_file_line + 1
      endif /* line starts with ! */

    enddo     /*  while (tex_log_file_line < tex_log_file_last)  */

    if not (tex_log_file_line < tex_log_file_last) then
       activatefile tex_return_to_fid
       sayerror TEX_NOERRORS_STRING
    endif

-----------------------------------------------------------------------------
defc tex_show_error
   parse arg tex_source_fid linenum col2 col1
   activatefile tex_source_fid
   'goto 'linenum col2  -- must be posted as well
   -- center line
   oldline = .line
   .cursory = .windowheight%2
   oldline
   refresh  -- process scrolling now
   -- 3x postme makes the circle for the 1st error stay
   'postme postme tex_circleit 'col1

-----------------------------------------------------------------------------
-- executed (if requested) after the above routine returns to the user
defc tex_circleit
   circleit 3, .line, arg(1), .col, LIGHT_RED
   -- thick light-red circle; well visible,
   -- except on red background, which is unlikely
return

-----------------------------------------------------------------------------
-- we are in the log file and initialize the error parsing facility
defproc tex_parse_init
   universal tex_log_file_line,
             tex_log_file_curr,
             tex_log_file_last,
             name_count,
             par_count

   tex_log_file_line = 3
   tex_log_file_curr = 3
   tex_log_file_last = .last
   name_count = 0
   par_count = 1
return

-----------------------------------------------------------------------------
compile if not defined (vtex)

-- This routine is called by tex_find_errors .
-- Its 1st argument is a part of a line from the log file, starting after a '('.
-- It determines whether or not the text following the '(' is a filename.
-- If it is, tex_error_fname is changed to that name, and the routine
-- returns 1.  Otherwise, a 0 is returned.
--
-- The logic goes like this:
--  1) search for '(', ')' and ' '; throw away what follows
--  2) make sure there is a '.' in the remaining string
--  3) parse it into pieces before '.' and after '.'
--  4) make sure that the first part is not empty
--  5) the name is fully qualified and placed in
--     tex_error_fname, and is also put into an array.
--  6) take name out of "line"
--  7) return

defproc tex_extract_fname(var line, dr, dir)
   universal tex_error_fname,
             par_count,
             name_count,
             EPM_utility_array_ID,
             tex_debug

   flag = 0
   tmp = line
   -- truncate before a possible space, '(' or ')':
   ppos = pos(' ', tmp)
   if ppos > 0 then
      tmp = leftstr(tmp, (ppos-1))
   endif
   ppos = pos('(', tmp)
   if ppos > 0 then
      tmp = leftstr(tmp, (ppos-1))
   endif
   ppos = pos(')', tmp)
   if ppos > 0 then
      tmp = leftstr(tmp, (ppos-1))
   endif
   -- now make sure there is still a '.' in it:
   if pos('.', tmp) then
      -- break it into pieces before and after the '.'
      parse value tmp with tmp1 '.' tmp2
      if tmp1 <> '' then -- yes, it was a filename
         if tmp2 = '' then -- take tmp1 only
            tmpname = tmp1
         else
            tmpname = tmp1||'.'||tmp2
         endif
--       Translate from Unix-style to OS/2-style file names
         tex_error_fname = translate(tmpname,'\','/')
--  Now, name the name fully qualified
--       If only a stem.ext
         if lastpos('\',tex_error_fname) = 0 then
            tex_error_fname = dr||dir||tex_error_fname
            if tex_debug > 2 then sayerror 'tex_error_fname (again1)='tex_error_fname; endif
         else
--          if no drive letter
            if leftstr(tex_error_fname,1) = '\' then
               tex_error_fname = dr||tex_error_fname
               if tex_debug > 2 then sayerror 'tex_error_fname (again2)='tex_error_fname; endif
            endif
         endif
         name_count = name_count + 1
         if tex_debug > 2 then  sayerror 'Putting 'tex_error_fname' on stack with par_count='par_count' at position 'name_count; endif
         do_array 2, EPM_utility_array_ID, 'tex_fname.'name_count, tex_error_fname
         do_array 2, EPM_utility_array_ID, 'tex_par.'name_count, par_count
         flag = 1
-- Take the filename out of line for next loop
;         line = substr(line,pos(tmpname,line)+length(tmpname))
         line = substr(line,pos(tmp,line)+length(tmp)) -- *** v1.1
      endif
   endif

   return flag
compile endif

-----------------------------------------------------------------------------
/*
-- A procedure to expand environment variables in user defined constants
--
-- searches for $variable: in user defined constants and expands 'variable'
-- if found

defproc Expand_Env(Input)

   Parse Value Input with Lead_Var '$' Env_Var ':' Trail_Var

   if Env_Var <> '' & LastPos(':',Input) > Pos('$',Input) then
      Output = Lead_Var || Get_Env(Env_Var) || Trail_Var
   else
      Output = Input
   endif

return Output
*/

-----------------------------------------------------------------------------
-- A procedure to check whether VTeX is using a cache
compile if defined (vtex)

defproc tex_use_cache
   universal app_hini

   opts = queryprofile(app_hini, TEX_APP, 'PDF_OPTIONS')
   opts = opts || queryprofile(app_hini, TEX_APP, 'PS_OPTIONS')
return pos('-pr', opts)

compile endif
-----------------------------------------------------------------------------
-- A procedure to check whether the current file is a TeX document

defproc tex_is_doc
   universal app_hini

   types = queryprofile( app_hini, TEX_APP, 'DOCTYPES')
   return wordpos(filetype(), types)

-----------------------------------------------------------------------------
-- A procedure to check whether the current file is a TeX style file

defproc tex_is_style
   universal app_hini

   types = queryprofile( app_hini, TEX_APP, 'STYLETYPES')
   return wordpos(filetype(), types)

----------------------------------------------------------------------------
-- A procedure to check whether the current file is a TeX file

defproc tex_is_file
   universal app_hini

   doctypes   = queryprofile( app_hini, TEX_APP, 'DOCTYPES')
   styletypes = queryprofile( app_hini, TEX_APP, 'STYLETYPES')
   return wordpos(filetype(), doctypes styletypes)

-----------------------------------------------------------------------------
-- Substitute the arg specifieres %**N and %**F within a command string

defproc tex_makecmd(command, fname, ext)
-- we perform the following substitutions:
-- %**N   ->  filename without extension
-- %**F   ->  filename with extension

   do forever
      posi=pos('%**N', command)
      if posi then
         command = delstr(command, posi, 4)
         command = insertstr(fname, command, (posi-1))
      else
         leave
      endif
   enddo
   do forever
      posi=pos('%**F', command)
      if posi then
         command=delstr(command, posi, 4)
         command = insertstr(fname'.'ext, command, (posi-1))
      else
         leave
      endif
   enddo
   return command

-----------------------------------------------------------------------------
-- check a variable from the INI file, return its value as 'ON' or 'OFF'

defproc tex_querysetting(name)
   universal app_hini
   if queryprofile(app_hini, TEX_APP, name) then
      return(TEX_ON_STRING)
   else
      return(TEX_OFF_STRING)
   endif
return

-----------------------------------------------------------------------------
-- toggle a variable from the INI file

defproc tex_togglesetting(name)
   universal app_hini
   if queryprofile(app_hini, TEX_APP, name) then
      call setprofile(app_hini, TEX_APP, name, '')
   else
      call setprofile(app_hini, TEX_APP, name, '1')
   endif
return

-----------------------------------------------------------------------------
-- Switch to the directory of the current file

defproc tex_cd
   universal tex_debug

   dirpos=lastpos('\',.filename)
   if dirpos>1 then
      dir = substr(.filename,1,dirpos-1)
      if lastpos(':', dir) = length(dir) then
         dir = dir || '\'
      endif
      if  tex_debug then
         sayerror 'tex_cd 'dir
      endif
      call directory(dir)
   endif
return

-----------------------------------------------------------------------------
-- Pop up a warning about a command that crashed

defproc tex_cmderror
   call WinMessageBox(TEXFE_TITLE, TEX_CMDERR_STRING,
                      MB_OK+MB_ERROR+MB_MOVEABLE)
return

-----------------------------------------------------------------------------


/************************************/
/*                                  */
/*   The OS/2 related procedures    */
/*                                  */
/************************************/

defc tex_osshell

   call tex_cd()
   title = 'Shell - 'directory()
   command = 'start "'title'" /F /K MODE CO80, 40'
   command
   if rc <> 0 then
      sayerror command || TEX_CMDFAIL_STRING || rc
      call tex_cmderror()
   endif
return


defc tex_fm -- 'fm' means 'file manager' :-)

   call tex_cd()
   command = 'start /F /C /MIN TFEFM.CMD'
   command
   if rc <> 0 then
      sayerror command || TEX_CMDFAIL_STRING || rc
      call tex_cmderror()
   endif
return


/********************************************************/
/*                                                      */
/*   All the procedures to change/show the settings     */
/*                                                      */
/********************************************************/

defc tex_debuglevel
   universal tex_debug
   if arg(1) = '' then
      sayerror 'TeX_debuglevel: 'tex_debug
   else
      tex_debug = arg(1)
   endif


compile if WANT_TEX_MENU

defproc check_tex_master --  check whether master file support is enabled
   universal app_hini
   if queryprofile(app_hini, TEX_APP, 'TEX_MASTERFILE') then
      return 1
   else
      return 0
   endif
return

defc tex_master_file_support
   call tex_togglesetting('TEX_MASTERFILE')
return

compile endif -- WANT_TEX_MENU


defproc tex_editsetting(name, defaultvalue, prompt)
   universal app_hini

   setting = queryprofile(app_hini, TEX_APP, name)
   do forever
      sbuf = entrybox( TEX_CONF_TITLE,
                       TEX_SOPT_BUTTONS,
                       setting, 60, 80,
                       atoi(1) ||            -- default button #
                       atoi(0) ||            -- help panel ID (0 for no help)
                       gethwnd(APP_HANDLE) ||
                       prompt\0)             -- prompt
      button = asc(leftstr( sbuf, 1))
      if button = 3 or button=0 then LEAVE; endif -- Cancel or closed otherwise
      if button = 2 then                          -- Use std. setting
         setting = defaultvalue
      else                                      -- OK
         EOS = pos( \0, sbuf, 2)    -- CHR(0) signifies End Of String
         setting = substr( sbuf, 2, EOS - 2)
         call setprofile( app_hini, TEX_APP, name, setting)
         LEAVE
      endif
   enddo
return


defproc tex_set_data(id) -- change user settings
   universal app_hini

   if id='1' then -- document file types
      call tex_editsetting('DOCTYPES', TEX_DOCTYPES_D, TEX_DOCTYPES_STRING)

   elseif id='2' then -- style file types
      call tex_editsetting('STYLETYPES', TEX_STYLETYPES_D, TEX_STYLETYPES_STRING)

   elseif id='3' then -- accelerator keys
      call tex_togglesetting('TEX_KEYS')

   elseif id='4' then -- default format
      call tex_editsetting('DEFAULT_FORMAT', TEX_DEFAULT_FORMAT_D, TEX_FORMAT_TITLE)

   elseif id='5' then -- master file support
      call tex_togglesetting('TEX_MASTERFILE')

compile if defined (vtex)
   elseif id='6' then -- vtex options for pdf mode
      call tex_editsetting('PDF_OPTIONS', TEX_PDF_OPTIONS_D, TEX_PDFOPTIONS_STRING)

   elseif id='7' then -- vtex options for ps mode
      call tex_editsetting('PS_OPTIONS', TEX_PS_OPTIONS_D, TEX_PSOPTIONS_STRING)

   elseif id='8' then -- PDF preview
      call tex_editsetting('VIEWPDF_CMD', TEX_VIEWPDF_D, TEX_PDFV_STRING)

   elseif id='9' then -- PS preview
      call tex_editsetting('VIEWPS_CMD', TEX_VIEWPS_D, TEX_PSV_STRING)

   elseif id='10' then -- highlighting
      call tex_togglesetting('TEX_SYNTAXHILITE')
compile else
   elseif id='6' then -- DVI preview
      call tex_editsetting('VIEW_CMD', TEX_VIEW_D, TEX_DVV_STRING)

   elseif id='7' then -- PS preview
      call tex_editsetting('VIEWPS_CMD', TEX_VIEWPS_D, TEX_PSV_STRING)

   elseif id='8' then -- PDF preview
      call tex_editsetting('VIEWPDF_CMD', TEX_VIEWPDF_D, TEX_PDFV_STRING)

   elseif id='9' then -- DVI printing
      call tex_editsetting('PRINT_CMD', TEX_PRINTDVI_D, TEX_DVIPR_STRING)

   elseif id='10' then -- dvips program
      call tex_editsetting('DVIPS_EXEC', TEX_DVIPS_D, TEX_DVIPS_STRING)

   elseif id='11' then -- ps2pdf
      call tex_editsetting('PS2PDF_CMD', TEX_PS2PDF_D, TEX_PS2PDF_STRING)

   elseif id='12' then -- highlighting
      if not isadefc('Mode') then  -- disable this for NEPMD
        call tex_togglesetting('TEX_SYNTAXHILITE')
      endif
compile endif

   endif
return /* tex_set_data() */


defc texfe_settings_window
-- contributed by Wonkoo Kim (wkim+@pitt.edu), November 14, 1997;

   universal app_hini

   if arg(1) = '' then
      id = 1
   else
      id = arg(1)
   endif

   menu_title = TEX_CONF_TITLE
   settings = ''
   no = 1
   settings = settings\1no' 'TEX_S_DOCTYPES' = 'queryprofile( app_hini, TEX_APP, 'DOCTYPES')
   no = no + 1
   settings = settings\1no' 'TEX_S_FILTYPES' = 'queryprofile( app_hini, TEX_APP, 'STYLETYPES')
   no = no + 1
   settings = settings\1no' 'TEX_S_ACCEKEYS' = 'tex_querysetting('TEX_KEYS')
   no = no + 1
   settings = settings\1no' 'TEX_S_DEFFORMA' = 'queryprofile( app_hini, TEX_APP, 'DEFAULT_FORMAT')
   no = no + 1
   settings = settings\1no' 'TEX_S_MASTERFS' = 'tex_querysetting('TEX_MASTERFILE')
compile if defined (vtex)
   no = no + 1
   settings = settings\1no' 'TEX_S_PDFOPTIO' = 'queryprofile( app_hini, TEX_APP, 'PDF_OPTIONS')
   no = no + 1
   settings = settings\1no' 'TEX_S_POSOPTIO' = 'queryprofile( app_hini, TEX_APP, 'PS_OPTIONS')
   no = no + 1
   settings = settings\1no' 'TEX_S_VIEWPDFC' = 'queryprofile( app_hini, TEX_APP, 'VIEWPDF_CMD')
   no = no + 1
   settings = settings\1no' 'TEX_S_VIEWPOSC' = 'queryprofile( app_hini, TEX_APP, 'VIEWPS_CMD')
compile else
   no = no + 1
   settings = settings\1no' 'TEX_S_VIEWDVIC' = 'queryprofile( app_hini, TEX_APP, 'VIEW_CMD')
   no = no + 1
   settings = settings\1no' 'TEX_S_VIEWPOSC' = 'queryprofile( app_hini, TEX_APP, 'VIEWPS_CMD')
   no = no + 1
   settings = settings\1no' 'TEX_S_VIEWPDFC' = 'queryprofile( app_hini, TEX_APP, 'VIEWPDF_CMD')
   no = no + 1
   settings = settings\1no' 'TEX_S_DVIPRINT' = 'queryprofile( app_hini, TEX_APP, 'PRINT_CMD')
   no = no + 1
   settings = settings\1no' 'TEX_S_DVIPSEXE' = 'queryprofile( app_hini, TEX_APP, 'DVIPS_EXEC')
   no = no + 1
   settings = settings\1no' 'TEX_S_PS2PDFCM' = 'queryprofile( app_hini, TEX_APP, 'PS2PDF_CMD')
compile endif
   if not isadefc('Mode') then  -- disable this for NEPMD
      no = no + 1
      settings = settings\1no' 'TEX_S_HIGHLITE' = 'tex_querysetting('TEX_SYNTAXHILITE')
   endif
--
   y = min( 25, .windowheight + 2)
   x = min( 15, .windowwidth*.3)
   h = min( min( 10, no), .windowheight*.75)  -- max. lines = 10 (or no, if no < 10)
   w = min( 70, .windowwidth)
   sbuf = listbox( menu_title, settings,
                   TEX_MO_BUTTONS,
                   y, x, h, w,  -- row,col,height,width
                   gethwnd(APP_HANDLE) ||
                   atoi(id) ||  -- initial item # selected (start from 1)
                   atoi(1)  ||  -- default button # selected (start from 1)
                   atoi(0)  ||  -- help panel ID (0 for no help)
                   ''\0);       -- prompt
   button = asc( leftstr( sbuf, 1))
   if button = 1 then
      EOS = pos( \0, sbuf, 2)  -- CHR(0) signifies End Of String
      select = substr( sbuf, 2, EOS - 2)
   else
      return
   endif
   -- 'TeX_'||word( select, 2)
   call tex_set_data( word( select, 1))
   'texfe_settings_window' word( select, 1)


/* Finis */
