/*
 * Copyright 1989 O'Reilly and Associates, Inc.
 * See ../Copyright for complete rights and liability information.
 */
#include "Xlib.h"  /* system's Xlib.h need to be modified. */
#include <X11/Xutil.h>
#include <X11/Xos.h>

#include <stdio.h>

#include "icon_bitmap"
#define BITMAPDEPTH 1
#define in_window2(x,y) (y >= oymin && y<= oymax && x <oxmax && x > oxmin)

extern float oxmin,oxmax,oymin,oymax;
extern char *odetitle;

Display *display;
int screen;
int xinitialized=0;
char position_buf[64];
int owidth, oheight;
unsigned int width, height, button;
Window win, subwin;
GC gc;

init_x(argc, argv)
     int argc; char **argv;
{
  unsigned int x = 0, y = 0;   /* window size and position */
  unsigned int border_width = 4;  /* four pixels */
  unsigned int display_width, display_height;
  unsigned int icon_width, icon_height;
  unsigned int pos_x, pos_y;
  char *window_name = "dfplot";
  char *icon_name = "Test";
  Pixmap icon_pixmap;
  XSizeHints size_hints;
  XIconSize * size_list;
  XSetWindowAttributes attrib;
  XEvent report;
  XFontStruct * font_info;
  char *display_name = NULL;
  int root_x, root_y;
  int win_x, win_y;
  Window root, child;
  unsigned int keys_buttons;
  unsigned long valuemask;
  float wx,wy;
  int i, count = 0, work = 0;

  if( (display = XOpenDisplay(display_name)) == NULL ) 
    {
      (void)fprintf(stderr,"\n dfplot: cannot connect to X server %s\n",   
		    XDisplayName(display_name));
      return( -1 );
    }
  xinitialized=1; 

  screen = DefaultScreen(display);
  display_width = DisplayWidth(display, screen);
  display_height = DisplayHeight(display, screen);

  width = 2*display_width / 3, height = 2*display_height / 3;
  owidth = width -80; oheight = height -80;
  set_scale_factor(owidth, oheight);

  win = XCreateSimpleWindow(display, RootWindow(display,
            screen), x, y, width, height, border_width, BlackPixel(display,
            screen), WhitePixel(display, screen));

  subwin = XCreateSimpleWindow(display, win, 40, 40, (unsigned)owidth,
            (unsigned)oheight, 1, BlackPixel(display, screen), 
            WhitePixel(display,screen));

  icon_pixmap = XCreateBitmapFromData(display, win, icon_bitmap_bits,
            icon_bitmap_width, icon_bitmap_height);

  size_hints.flags = PPosition | PSize | PMinSize;
  size_hints.x = x;
  size_hints.y = y;
  size_hints.width = width;
  size_hints.height = height;
  size_hints.min_width = 400;
  size_hints.min_height = 300;

  XSetStandardProperties(display, win, window_name, icon_name,
            icon_pixmap, argv, argc, &size_hints);
  attrib.win_gravity = UnmapGravity;
  valuemask = CWWinGravity;
  XChangeWindowAttributes(display,subwin,valuemask,&attrib);
  subwin = XCreateSimpleWindow(display, win, 40, 40, (unsigned)owidth,
            (unsigned)oheight, 1, BlackPixel(display, screen), 
            WhitePixel(display,screen));
  
  XSelectInput(display, win, ExposureMask | KeyPressMask | StructureNotifyMask |
		 ButtonPressMask);

  XSelectInput(display, subwin, ExposureMask| ButtonMotionMask |
	       StructureNotifyMask | ButtonPressMask);

  load_font(&font_info);

  getGC(win, &gc, font_info);

  XMapWindow(display, win);
  XMapWindow(display, subwin);	
  
  while (1)  {
    XNextEvent(display, &report);
    switch (report.type) 
      {
      case Expose:
	if(report.xexpose.window == subwin) 
	  {
	    while (XCheckTypedWindowEvent(display,subwin,Expose,&report));
	    tic_marks();
	    reset_ode();
	    plot_ode();
	  } 
	else
	  {
	    while (XCheckTypedWindowEvent(display,win,Expose,&report));
	    display_position(win,gc,font_info);
	  }
	break;
      case ConfigureNotify:
	if(report.xconfigure.width != width ||
	   report.xconfigure.height != height) /* resized */
	  {
	    width = report.xconfigure.width;
	    height = report.xconfigure.height;
	    owidth = width - 80; oheight = height - 80;
	    XDestroyWindow(display,subwin);
	    subwin =XCreateSimpleWindow(display, win, 40, 40, (unsigned)owidth,
                  (unsigned)oheight, 1, BlackPixel(display, screen), 
		  WhitePixel(display,screen));
	    XSelectInput(display, subwin, ExposureMask| ButtonMotionMask |
			 StructureNotifyMask | ButtonPressMask);
	    XMapWindow(display, subwin);	
	    XClearWindow(display,win); 
	    display_position(win,gc,font_info);
	    set_scale_factor(owidth, oheight);
	    tic_marks();
	    reset_ode();
	    plot_ode(); 
	  }
	break;
      case ButtonPress: /* generate a new orbit if middle button is pressed */
	if(report.xbutton.window==subwin)
	  {
	    float xx,yy;
	    if(!XQueryPointer(display,subwin,&root,&child, 
			      &root_x,&root_y,&pos_x, &pos_y,&keys_buttons));
	    else
	      {
		screen_2_world(pos_x,pos_y, &xx, &yy);
		if(report.xbutton.button==Button2 &&in_window2(xx,yy))
		  {
		    (void)sprintf(position_buf,
			  "Working on the traj. through P=(%f,%f) ...",xx,yy);
		    XClearWindow(display,win); 
		    display_position(win,gc,font_info);
		    XFlush(display);
		    ode_orbit(xx,yy);
		    plot_ode();
		    (void)sprintf(position_buf,"Done with P= (%f,%f)",xx,yy);
		    XClearWindow(display,win); 		
		    display_position(win,gc,font_info);    
		  }
		else
		  {
		    (void)sprintf(position_buf,"P=(%f,%f)",xx,yy);
		    XClearWindow(display,win); 
		    display_position(win,gc,font_info);
		  }
	      }
	  } 
	break;
      case MotionNotify:
	screen_2_world(report.xmotion.x, report.xmotion.y,&wx,&wy);
	(void)sprintf(position_buf,"P=(%f,%f)",wx,wy);
	XClearWindow(display,win);
	display_position(win,gc,font_info);
	break;

      case KeyPress:
	df_mode();   /* so if your `plot' current_graph again, it'll start 
		      * with direction field. Plot destroy all of the
		      * generated data*/
	reset_ode(); /* if the command `lpr' (for hard copy) or `replot'
		      * is issued, it'll show the direc. field and all
		      * the orbits. Data is saved till the next `plot'
		      * command */
	xinitialized = 0;
	XUnloadFont(display, font_info->fid);
	XFreeGC(display, gc);
	XCloseDisplay(display);
	return(1);
      default:
	break;
      } /* end switch */
  } /* end while */
}

getGC(win, gc, font_info)
     Window win; GC *gc; XFontStruct *font_info;
{
  unsigned long valuemask = 0; /* ignore XGCvalues and use defaults */
  XGCValues values;
  unsigned int line_width = 1;
  int line_style = LineSolid;
  int cap_style = CapRound;
  int join_style = JoinRound;

  *gc = XCreateGC(display, win, valuemask, &values);

  XSetFont(display, *gc, font_info->fid);
  XSetForeground(display, *gc, BlackPixel(display, screen));

  XSetLineAttributes(display, *gc, line_width, line_style,
		     cap_style, join_style);
}

load_font(font_info)
     XFontStruct **font_info;
{
  char *fontname = "9x15";

  if ((*font_info = XLoadQueryFont(display, fontname)) == NULL)
    {
      (void) fprintf( stderr, "Cannot open 9x15 font\n");
      exit(-1);
    }
}

display_position(win, gc, font_info)
     Window win; GC gc; XFontStruct *font_info;
{
  int tlength,twidth,i,j;
  char v[32];
  float unit;

  tlength = strlen(position_buf);
  twidth = XTextWidth(font_info, position_buf, tlength);
  XDrawString(display, win, gc, (width - twidth) / 2,
	      height -10, position_buf, tlength);
  tlength = strlen(odetitle);
  twidth = XTextWidth(font_info, odetitle, tlength);
  XDrawString(display, win, gc, (width - twidth) / 2,
	      30, odetitle, tlength);  
  
  unit = (oxmax -oxmin)/4.0;
  j = owidth/4;
  for(i = 0; i <= 4; i++)
    {
      (void)sprintf(v,"%g",oxmin + unit * i);
      tlength = strlen(v);
      twidth = XTextWidth(font_info, v, tlength);
      XDrawString(display, win, gc, (j*i) - (twidth) / 2 + 40,
		  height -25, v, tlength);        
    }
  unit = (oymax -oymin)/4.0;
  j = oheight/4;
  for(i = 0; i <= 4; i++)
    {
      (void)sprintf(v,"%g",oymin + unit * i);
      tlength = strlen(v);
      twidth = XTextWidth(font_info, v, tlength);
      XDrawString(display, win, gc, (30 - twidth) / 2,
		  height - 40 - j*i, v, tlength);        
    }
}


make_a_line_segment(x,y,u,v)
     float x,y,u,v;
{
  int a,b,c,d;
  world_2_screen(x,y,&a,&b);
  world_2_screen(u,v,&c,&d);  
  XDrawLine(display,subwin,gc,a,b,c,d);
}

tic_marks()
{
  int i, unit,x,y;
  unit = owidth/32;
  y =oheight; x = unit;
  for(i = 1; i < 32; i++)
    {
      XDrawLine(display,subwin,gc,x,y-4,x,y);
      x += unit;
    }
  unit *= 4; x= unit;
  for(i=1; i<8; i++)
    {
      XDrawLine(display,subwin,gc,x,y-7,x,y);
      x += unit;
    }
  unit = oheight/32;
  x = 0; y = unit;
  for(i=1; i<32; i++)
    {
      XDrawLine(display,subwin,gc,x,y,x+4,y);
      y += unit;
    }
  unit *= 4; y=unit; 
  for(i=1; i<8; i++)
    {
      XDrawLine(display,subwin,gc,x,y,x+7,y);
      y += unit;
    }
}
/*******************************************************/
