.file "erfc.s"


// Copyright (c) 2001 - 2005, Intel Corporation
// All rights reserved.
//
// Contributed 2001 by the Intel Numerics Group, Intel Corporation
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// * Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// * The name of Intel Corporation may not be used to endorse or promote
// products derived from this software without specific prior written
// permission.

// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR ITS
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Intel Corporation is the author of this code, and requests that all
// problem reports or change requests be submitted to it directly at
// http://www.intel.com/software/products/opensource/libraries/num.htm.
//
// History
//==============================================================
// 11/12/01  Initial version
// 05/20/02  Cleaned up namespace and sf0 syntax
// 02/06/03  Reordered header: .section, .global, .proc, .align
// 03/31/05  Reformatted delimiters between data tables
//
// API
//==============================================================
// double erfc(double)
//
// Overview of operation
//==============================================================
// 1. 0 <= x <= 28.0
//
//    erfc(x)  = P14(z) * exp( -x^2 ), z = x - x(i).
//
//    Comment:
//
//    Let x(i) = -1.0 + 2^(i/4),i=0,...19. So we have 20 unequal
//    argument intervals [x(i),x(i+1)] with length ratio q = 2^(1/4).
//    Values x(i) we have in the table erfc_xb_table.
//
//    Let x(i)<= x < x(i+1).
//    We can find i as exponent of number (x + 1)^4.
//
//    Let P14(z) - polynomial approximation of degree 14 for function
//    erfc(z+x(i)) * exp( (z+x(i))^2) and 0 <= z <= x(i+1)-x(i).
//    Polynomial coeffitients we have in the table erfc_p_table.
//
//    So we can find result for erfc(x) as above.
//    Algorithm description for exp function see below.
//
// 2. -6 <= x < 0
//
//      erfc(x)  = 2.0 - erfc(-x)
//
// 3. x > 28.0
//    erfc(x)  ~=~ 0.0
//
// 4. x < -6.0
//    erfc(x)  ~=~ 2.0

// Special values
//==============================================================
// erfc(+0)    = 1.0
// erfc(-0)    = 1.0

// erfc(+qnan) = +qnan
// erfc(-qnan) = -qnan
// erfc(+snan) = +qnan
// erfc(-snan) = -qnan

// erfc(-inf)  = 2.0
// erfc(+inf)  = +0

//==============================================================
// Take double exp(double) from libm_64.
//
// Overview of operation
//==============================================================
// Take the input x. w is "how many log2/128 in x?"
//  w = x * 128/log2
//  n = int(w)
//  x = n log2/128 + r + delta

//  n = 128M + index_1 + 2^4 index_2
//  x = M log2 + (log2/128) index_1 + (log2/8) index_2 + r + delta

//  exp(x) = 2^M  2^(index_1/128)  2^(index_2/8) exp(r) exp(delta)
//       Construct 2^M
//       Get 2^(index_1/128) from table_1;
//       Get 2^(index_2/8)   from table_2;
//       Calculate exp(r) by series
//          r = x - n (log2/128)_high
//          delta = - n (log2/128)_low
//       Calculate exp(delta) as 1 + delta
//==============================================================
//  Comment for exp for erfc:
//
//  We use quad precision for calculate input argument -x^2 and add
//  result low bits to value delta in exp.

// Registers used
//==============================================================
// Floating Point registers used:
// f8, input
// f9 -> f15,  f32 -> f93

// General registers used:
// r32 -> r68

// Predicate registers used:
// p6 -> p15

// Assembly macros
//==============================================================

exp_GR_rshf            = r33
EXP_AD_TB1             = r34
EXP_AD_TB2             = r35
EXP_AD_P               = r36
exp_GR_N               = r37
exp_GR_index_1         = r38
exp_GR_index_2_16      = r39
exp_GR_biased_M        = r40
EXP_AD_T1              = r41
EXP_AD_T2              = r42
exp_GR_sig_inv_ln2     = r43
exp_GR_17ones          = r44
exp_TB1_size           = r45
exp_TB2_size           = r46
exp_GR_rshf_2to56      = r47
exp_GR_exp_2tom56      = r48

// GR for erfc(x)
//==============================================================
GR_POS_ARG_ASYMP       = r49
GR_NEG_ARG_ASYMP       = r50
GR_ARG_ASYMP           = r51
GR_ERFC_XB_TB          = r52
GR_ERFC_P_TB           = r53
GR_IndxPlusBias        = r54
GR_BIAS                = r55
GR_P_A12               = r56
GR_P_A13               = r57
GR_AbsArg              = r58
GR_ShftXBi             = r59
GR_ShftPi              = r60
GR_mBIAS               = r61
GR_ShftPi_bias         = r62
GR_ShftXBi_bias        = r63
GR_ShftA12             = r64
GR_ShftA13             = r65
GR_EpsNorm             = r66
GR_0x1                 = r67
GR_ShftPi_8            = r68

// GR for __libm_support call

//==============================================================

GR_SAVE_B0             = r61
GR_SAVE_PFS            = r62
GR_SAVE_GP             = r63
GR_SAVE_SP             = r64

GR_Parameter_X         = r65
GR_Parameter_Y         = r66
GR_Parameter_RESULT    = r67
GR_Parameter_TAG       = r68


// FR for exp(-x^2)
//==============================================================
FR_X                   = f10
FR_Y                   = f1
FR_RESULT              = f8

EXP_2TOM56             = f6
EXP_INV_LN2_2TO63      = f7
EXP_W_2TO56_RSH        = f9
EXP_RSHF_2TO56         = f10

exp_P4                 = f11
exp_P3                 = f12
exp_P2                 = f13
exp_P1                 = f14
exp_ln2_by_128_hi      = f15

exp_ln2_by_128_lo      = f32
EXP_RSHF               = f33
EXP_Nfloat             = f34
exp_r                  = f35
exp_f                  = f36
exp_rsq                = f37
exp_rcube              = f38
EXP_2M                 = f39
exp_S1                 = f40
exp_T1                 = f41
exp_rP4pP3             = f42
exp_P_lo               = f43
exp_P_hi               = f44
exp_P                  = f45
exp_S                  = f46
EXP_NORM_f8            = f47
exp_S2                 = f48
exp_T2                 = f49

// FR for erfc(x)
//==============================================================
FR_AbsArg              = f50
FR_Tmp                 = f51
FR_Xb                  = f52
FR_A0                  = f53
FR_A1                  = f54
FR_A2                  = f55
FR_A3                  = f56
FR_A4                  = f57
FR_A5                  = f58
FR_A6                  = f59
FR_A7                  = f60
FR_A8                  = f61
FR_A9                  = f62
FR_A10                 = f63
FR_A11                 = f64
FR_A12                 = f65
FR_A13                 = f66
FR_A14                 = f67

FR_P14_0_1             = f68
FR_P14_0_2             = f69
FR_P14_1_1             = f70
FR_P14_1_2             = f71
FR_P14_2_1             = f72
FR_P14_2_2             = f73
FR_P14_3_1             = f74
FR_P14_3_2             = f75
FR_P14_6_1             = f76

FR_P14_7_1             = f77
FR_P14_7_2             = f78
FR_P14_8_1             = f79
FR_P14_8_2             = f80
FR_P14_12_1            = f81
FR_P14_13_1            = f82
FR_P14_13_2            = f83
FR_Pol                 = f84
FR_Exp                 = f85
FR_2                   = f86
f8_sq_lo               = f87
FR_LocArg              = f88
FR_Tmpf                = f89
FR_Tmp1                = f90
FR_EpsNorm             = f91
FR_UnfBound            = f92
FR_NormX               = f93


// Data tables
//==============================================================
RODATA
.align 16

// ************* DO NOT CHANGE ORDER OF THESE TABLES ********************

LOCAL_OBJECT_START(exp_table_1)

data8 0x403a8b12fc6e4892 , 0          // underflow boundary
data8 0xb17217f7d1cf79ab , 0x00003ff7 // ln2/128 hi
data8 0xc9e3b39803f2f6af , 0x00003fb7 // ln2/128 lo
//
// Table 1 is 2^(index_1/128) where
// index_1 goes from 0 to 15
//
data8 0x8000000000000000 , 0x00003FFF
data8 0x80B1ED4FD999AB6C , 0x00003FFF
data8 0x8164D1F3BC030773 , 0x00003FFF
data8 0x8218AF4373FC25EC , 0x00003FFF
data8 0x82CD8698AC2BA1D7 , 0x00003FFF
data8 0x8383594EEFB6EE37 , 0x00003FFF
data8 0x843A28C3ACDE4046 , 0x00003FFF
data8 0x84F1F656379C1A29 , 0x00003FFF
data8 0x85AAC367CC487B15 , 0x00003FFF
data8 0x8664915B923FBA04 , 0x00003FFF
data8 0x871F61969E8D1010 , 0x00003FFF
data8 0x87DB357FF698D792 , 0x00003FFF
data8 0x88980E8092DA8527 , 0x00003FFF
data8 0x8955EE03618E5FDD , 0x00003FFF
data8 0x8A14D575496EFD9A , 0x00003FFF
data8 0x8AD4C6452C728924 , 0x00003FFF
LOCAL_OBJECT_END(exp_table_1)

// Table 2 is 2^(index_1/8) where
// index_2 goes from 0 to 7
LOCAL_OBJECT_START(exp_table_2)
data8 0x8000000000000000 , 0x00003FFF
data8 0x8B95C1E3EA8BD6E7 , 0x00003FFF
data8 0x9837F0518DB8A96F , 0x00003FFF
data8 0xA5FED6A9B15138EA , 0x00003FFF
data8 0xB504F333F9DE6484 , 0x00003FFF
data8 0xC5672A115506DADD , 0x00003FFF
data8 0xD744FCCAD69D6AF4 , 0x00003FFF
data8 0xEAC0C6E7DD24392F , 0x00003FFF
LOCAL_OBJECT_END(exp_table_2)

LOCAL_OBJECT_START(exp_p_table)
data8 0x3f8111116da21757 //P_4
data8 0x3fa55555d787761c //P_3
data8 0x3fc5555555555414 //P_2
data8 0x3fdffffffffffd6a //P_1
LOCAL_OBJECT_END(exp_p_table)

LOCAL_OBJECT_START(erfc_xb_table)
data8 0x0000000000000000, 0x00000000 //XB[0] = +0.00000000000000000000e-01L
data8 0xC1BF828C6DC54B7A, 0x00003FFC //XB[1] = +1.89207115002721066717e-01L
data8 0xD413CCCFE7799211, 0x00003FFD //XB[2] = +4.14213562373095048802e-01L
data8 0xAE89F995AD3AD5E8, 0x00003FFE //XB[3] = +6.81792830507429086062e-01L
data8 0x8000000000000000, 0x00003FFF //XB[4] = +1.00000000000000000000e+00L
data8 0xB06FE0A31B7152DF, 0x00003FFF //XB[5] = +1.37841423000544213343e+00L
data8 0xEA09E667F3BCC909, 0x00003FFF //XB[6] = +1.82842712474619009760e+00L
data8 0x9744FCCAD69D6AF4, 0x00004000 //XB[7] = +2.36358566101485817212e+00L
data8 0xC000000000000000, 0x00004000 //XB[8] = +3.00000000000000000000e+00L
data8 0xF06FE0A31B7152DF, 0x00004000 //XB[9] = +3.75682846001088426687e+00L
data8 0x9504F333F9DE6484, 0x00004001 //XB[10] = +4.65685424949238019521e+00L
data8 0xB744FCCAD69D6AF4, 0x00004001 //XB[11] = +5.72717132202971634425e+00L
data8 0xE000000000000000, 0x00004001 //XB[12] = +7.00000000000000000000e+00L
data8 0x8837F0518DB8A96F, 0x00004002 //XB[13] = +8.51365692002176853374e+00L
data8 0xA504F333F9DE6484, 0x00004002 //XB[14] = +1.03137084989847603904e+01L
data8 0xC744FCCAD69D6AF4, 0x00004002 //XB[15] = +1.24543426440594326885e+01L
data8 0xF000000000000000, 0x00004002 //XB[16] = +1.50000000000000000000e+01L
data8 0x9037F0518DB8A96F, 0x00004003 //XB[17] = +1.80273138400435370675e+01L
data8 0xAD04F333F9DE6484, 0x00004003 //XB[18] = +2.16274169979695207808e+01L
data8 0xCF44FCCAD69D6AF4, 0x00004003 //XB[19] = +2.59086852881188653770e+01L
LOCAL_OBJECT_END(erfc_xb_table)

LOCAL_OBJECT_START(erfc_p_table)

// Pol0
data8 0x8000000000000000, 0x00003FFF //A0 = +1.00000000000000000000e+00L
data8 0x906EBA8214DB688D, 0x0000BFFF //A1 = -1.12837916709551257389e+00L
data8 0xFFFFFFFFFFFFFFEB, 0x00003FFE //A2 = +9.99999999999999998841e-01L
data8 0xC093A3581BCF2925, 0x0000BFFE //A3 = -7.52252778063674869885e-01L
data8 0xFFFFFFFFFFF7CDBD, 0x00003FFD //A4 = +4.99999999999985440383e-01L
data8 0x9A0FB5E014AE3EFB, 0x0000BFFD //A5 = -3.00901111224757482205e-01L
data8 0xAAAAAAAA4672B0BD, 0x00003FFC //A6 = +1.66666666643879582201e-01L
data8 0xB011F45C9F590FC0, 0x0000BFFB //A7 = -8.59717455640916223912e-02L
data8 0xAAAAA89474161033, 0x00003FFA //A8 = +4.16666588928413935202e-02L
data8 0x9C818E2CE37D4214, 0x0000BFF9 //A9 = -1.91047455656271634308e-02L
data8 0x8885969315AB76A1, 0x00003FF8 //A10 = +8.33263115449753085659e-03L
data8 0xE36112A686F5165B, 0x0000BFF6 //A11 = -3.46953111013788405745e-03L
data8 0xB3DD6B2DB3307D2E, 0x00003FF5 //A12 = +1.37226041156280127011e-03L
data8 0x8018A34267FED226, 0x0000BFF4 //A13 = -4.88648380816410282971e-04L
data8 0xFBBA6A7AEBD3ABD9, 0x00003FF1 //A14 = +1.20033353451879025825e-04L
// Pol1
data8 0xD15A1EF03BB91E71, 0x00003FFE //A0 = +8.17781385088640600540e-01L
data8 0xD1A4ADDAC3337118, 0x0000BFFE //A1 = -8.18919053944410683867e-01L
data8 0xA9AF9FFA2AD18CB0, 0x00003FFE //A2 = +6.62836073471060947628e-01L
data8 0xECB77514F0F151B3, 0x0000BFFD //A3 = -4.62337168508812580002e-01L
data8 0x934AB35EA5CD5EEB, 0x00003FFD //A4 = +2.87679295829458273854e-01L
data8 0xA71410A68C1EF21C, 0x0000BFFC //A5 = -1.63162479558223113104e-01L
data8 0xAF506A335238094A, 0x00003FFB //A6 = +8.56025978958108330224e-02L
data8 0xABFDF67F968765A7, 0x0000BFFA //A7 = -4.19902447551140139048e-02L
data8 0x9F0B0165A6CDCA99, 0x00003FF9 //A8 = +1.94144274984979538382e-02L
data8 0x8B8197BFC346CDEA, 0x0000BFF8 //A9 = -8.51478404279186775501e-03L
data8 0xE950D763FE51AB1E, 0x00003FF6 //A10 = +3.56011637267641495904e-03L
data8 0xBA821A59FC05FBAD, 0x0000BFF5 //A11 = -1.42294475244146555952e-03L
data8 0x8D535042E11A0D89, 0x00003FF4 //A12 = +5.39113782651680545599e-04L
data8 0xBE589447DB26564E, 0x0000BFF2 //A13 = -1.81528103431449706486e-04L
data8 0xABC8C7EF636F5B0A, 0x00003FF0 //A14 = +4.09565689009869217620e-05L
// Pol2
data8 0xA9973ABB272898B2, 0x00003FFE //A0 = +6.62463827792779356910e-01L
data8 0x945F1A7993F7AADD, 0x0000BFFE //A1 = -5.79576162988785154930e-01L
data8 0xD84439C6609A8A62, 0x00003FFD //A2 = +4.22395520654665085222e-01L
data8 0x8A1BBAA7E9CB8C52, 0x0000BFFD //A3 = -2.69742806431984313298e-01L
data8 0x9F0F67364B466975, 0x00003FFC //A4 = +1.55332195938916594663e-01L
data8 0xA843F180287DAF7F, 0x0000BFFB //A5 = -8.21608416782158837025e-02L
data8 0xA59D71B7C690E545, 0x00003FFA //A6 = +4.04333536247671644540e-02L
data8 0x991A733518C74874, 0x0000BFF9 //A7 = -1.86893701691354422481e-02L
data8 0x85E7F91148F9F6D2, 0x00003FF8 //A8 = +8.17298243522623724858e-03L
data8 0xDEE0607CC9D6777E, 0x0000BFF6 //A9 = -3.40082507754089306495e-03L
data8 0xB145D2CC470B306B, 0x00003FF5 //A10 = +1.35248373238824318949e-03L
data8 0x86FAEBB4438A20FA, 0x0000BFF4 //A11 = -5.14908443679775343409e-04L
data8 0xC2503856CE48A657, 0x00003FF2 //A12 = +1.85311660448280465934e-04L
data8 0xF52642F22A26965B, 0x0000BFF0 //A13 = -5.84481856856861454591e-05L
data8 0xC98588E1A95FFDBD, 0x00003FEE //A14 = +1.20116245684500489648e-05L
// Pol3
data8 0x887CBA2C47B1E2B5, 0x00003FFE //A0 = +5.33153186617432643784e-01L
data8 0xCD81909CF194328E, 0x0000BFFD //A1 = -4.01379126699602646289e-01L
data8 0x84DCA15C52122372, 0x00003FFD //A2 = +2.59495775718310530164e-01L
data8 0x993AA9C76AD28157, 0x0000BFFC //A3 = -1.49637844845261107836e-01L
data8 0xA140CD8A96FADBA5, 0x00003FFB //A4 = +7.87368829650154013961e-02L
data8 0x9D36B25E76E56EEA, 0x0000BFFA //A5 = -3.83822410143975630292e-02L
data8 0x8F8BCC2C0536ECD3, 0x00003FF9 //A6 = +1.75227153523910189727e-02L
data8 0xF77EDC644BA17AF9, 0x0000BFF7 //A7 = -7.55296479527793552675e-03L
data8 0xCAB8AC76793C1151, 0x00003FF6 //A8 = +3.09328279988546711083e-03L
data8 0x9E8FCBC793D555AF, 0x0000BFF5 //A9 = -1.20972979110659888616e-03L
data8 0xEDC1328664A0CE79, 0x00003FF3 //A10 = +4.53481058502015766058e-04L
data8 0xAAE3CAAB9D117591, 0x0000BFF2 //A11 = -1.62973223928790256249e-04L
data8 0xE7704D06A3080C19, 0x00003FF0 //A12 = +5.51792801195012080688e-05L
data8 0x875A5B53E510F305, 0x0000BFEF //A13 = -1.61353297293572230995e-05L
data8 0xC8F10CDDB9CC9A42, 0x00003FEC //A14 = +2.99426321046583353559e-06L
// Pol4
data8 0xDAEC3C07CAB590C1, 0x00003FFD //A0 = +4.27583576155807004411e-01L
data8 0x8BE271F8BE0280AC, 0x0000BFFD //A1 = -2.73212014783898564863e-01L
data8 0x9E13941E19661429, 0x00003FFC //A2 = +1.54371561371908397882e-01L
data8 0xA241BFC48377449D, 0x0000BFFB //A3 = -7.92269689413235358504e-02L
data8 0x99E56877AD00D1AE, 0x00003FFA //A4 = +3.75722962151600767952e-02L
data8 0x887E78DA3BA57C80, 0x0000BFF9 //A5 = -1.66618690872055148862e-02L
data8 0xE465CAA9F4D54FD8, 0x00003FF7 //A6 = +6.97014232347351913821e-03L
data8 0xB57930370208D4A7, 0x0000BFF6 //A7 = -2.76906420823065422653e-03L
data8 0x89A90B5DF0C0C55E, 0x00003FF5 //A8 = +1.05026496655247749532e-03L
data8 0xC83DB867F08D93C6, 0x0000BFF3 //A9 = -3.81929578900287685559e-04L
data8 0x8C0C9113FC8061FA, 0x00003FF2 //A10 = +1.33561218944256209215e-04L
data8 0xBC17A73E9CA51313, 0x0000BFF0 //A11 = -4.48447217225392170834e-05L
data8 0xED10FE8FC0E44CAD, 0x00003FEE //A12 = +1.41302576244352578317e-05L
data8 0xFE49912328516F81, 0x0000BFEC //A13 = -3.78917710289305330220e-06L
data8 0xA8F6077E25DAFD33, 0x00003FEA //A14 = +6.29428967202166402369e-07L
// Pol5
data8 0xAF72220985BED710, 0x00003FFD //A0 = +3.42667640364081975844e-01L
data8 0xBC1CB559042410AB, 0x0000BFFC //A1 = -1.83703263815036934677e-01L
data8 0xB730BF62E0B63A3C, 0x00003FFB //A2 = +8.94484474229911741150e-02L
data8 0xA4F307B1D1A1534E, 0x0000BFFA //A3 = -4.02708340235238993824e-02L
data8 0x8B0327F5117861DB, 0x00003FF9 //A4 = +1.69692783752415790321e-02L
data8 0xDD4059307B2B081C, 0x0000BFF7 //A5 = -6.75205569219747369303e-03L
data8 0xA761D738974FECF6, 0x00003FF6 //A6 = +2.55404953403837072821e-03L
data8 0xF208F6D704F4B487, 0x0000BFF4 //A7 = -9.23290315545127419886e-04L
data8 0xA7F3658D34EC10B9, 0x00003FF3 //A8 = +3.20340668304962386053e-04L
data8 0xE079C35CEFD4E6D6, 0x0000BFF1 //A9 = -1.07038324953715640850e-04L
data8 0x90C5CDD19BB3DD2F, 0x00003FF0 //A10 = +3.45164947021915687751e-05L
data8 0xB3911863705825F6, 0x0000BFEE //A11 = -1.07030140392753204852e-05L
data8 0xD023CF5C3F915685, 0x00003FEC //A12 = +3.10152594473606007552e-06L
data8 0xCA7016FADFF584F5, 0x0000BFEA //A13 = -7.54139761055503416594e-07L
data8 0xEEBB5CC0901D2BB0, 0x00003FE7 //A14 = +1.11168196441717301549e-07L
// Pol6
data8 0x8CD1160326A754AF, 0x00003FFD //A0 = +2.75032699474947383325e-01L
data8 0xFB22A4C657119388, 0x0000BFFB //A1 = -1.22624671271190511269e-01L
data8 0xD02B2CA872A774E9, 0x00003FFA //A2 = +5.08224243596176920409e-02L
data8 0xA23302E146E9E406, 0x0000BFF9 //A3 = -1.97997146844646077750e-02L
data8 0xEF8918FEDE237C98, 0x00003FF7 //A4 = +7.31004448401605074486e-03L
data8 0xA8A8B598FA20D881, 0x0000BFF6 //A5 = -2.57353242430059589053e-03L
data8 0xE3964D9788BFF50F, 0x00003FF4 //A6 = +8.68175969920725727944e-04L
data8 0x93B83C10B7210AC7, 0x0000BFF3 //A7 = -2.81752903983413936245e-04L
data8 0xB913B752B0D56A42, 0x00003FF1 //A8 = +8.82515983758695613094e-05L
data8 0xE0623EFA0B1E8DE9, 0x0000BFEF //A9 = -2.67486302195396417310e-05L
data8 0x83C4D1A4019E1D2E, 0x00003FEE //A10 = +7.85403393879249335151e-06L
data8 0x950CBA5D80D8125E, 0x0000BFEC //A11 = -2.22101388436550539151e-06L
data8 0x9CE72C0409A3E800, 0x00003FEA //A12 = +5.84509280984781223375e-07L
data8 0x88CCD7A000D1C213, 0x0000BFE8 //A13 = -1.27405082040077425019e-07L
data8 0x8DF4EC84F093B1C0, 0x00003FE5 //A14 = +1.65259388738830506389e-08L
// Pol7
data8 0xE2BF82A153B1B82E, 0x00003FFC //A0 = +2.21433678719152843912e-01L
data8 0xA72A9AE0BD7F29D5, 0x0000BFFB //A1 = -8.16242313227913578068e-02L
data8 0xE98939292289EDBE, 0x00003FF9 //A2 = +2.85078159732432477516e-02L
data8 0x9B93E5E0EEFF9516, 0x0000BFF8 //A3 = -9.49571084105114051468e-03L
data8 0xC6B39897AABC47BC, 0x00003FF6 //A4 = +3.03194499398790451607e-03L
data8 0xF442AC7D84DDF1E0, 0x0000BFF4 //A5 = -9.31779649708690069328e-04L
data8 0x90FBD9F8B41DF23E, 0x00003FF3 //A6 = +2.76534642660360753287e-04L
data8 0xA6AC59077C78B437, 0x0000BFF1 //A7 = -7.94759910003852154521e-05L
data8 0xB9FC0BADD531E5E9, 0x00003FEF //A8 = +2.21710864553358009804e-05L
data8 0xC9CFC8CD93648856, 0x0000BFED //A9 = -6.01445608619100503330e-06L
data8 0xD4FA51B86A9B2494, 0x00003FEB //A10 = +1.58680833469323702924e-06L
data8 0xD8D0ED030032926D, 0x0000BFE9 //A11 = -4.03851487695924456733e-07L
data8 0xCCA1CA2AC3EB8973, 0x00003FE7 //A12 = +9.52891963880517988726e-08L
data8 0x9E26A080F9DA39DE, 0x0000BFE5 //A13 = -1.84111863600343741644e-08L
data8 0x8F3DC58F64A92C62, 0x00003FE2 //A14 = +2.08443519336792003049e-09L
// Pol8
data8 0xB74C13E914E9666F, 0x00003FFC //A0 = +1.79001151181389950418e-01L
data8 0xDEB57268A58B763B, 0x0000BFFA //A1 = -5.43722600071728705200e-02L
data8 0x821FF0D4C605A4CD, 0x00003FF9 //A2 = +1.58843711598712515609e-02L
data8 0x92C830DD423DB924, 0x0000BFF7 //A3 = -4.47943101836927657394e-03L
data8 0xA04E61767A095BB6, 0x00003FF5 //A4 = +1.22303905230942532198e-03L
data8 0xA9EF64E0F6654358, 0x0000BFF3 //A5 = -3.24125543666296226957e-04L
data8 0xAF39C8969BD163E8, 0x00003FF1 //A6 = +8.35541329311315562274e-05L
data8 0xB01273B34197330C, 0x0000BFEF //A7 = -2.09894273215824495783e-05L
data8 0xACAE4C820B99EBAC, 0x00003FED //A8 = +5.14629050848703676006e-06L
data8 0xA57BF2AEA52B92DF, 0x0000BFEB //A9 = -1.23295315941138567172e-06L
data8 0x9AD6FE7A852DA239, 0x00003FE9 //A10 = +2.88411640627675721042e-07L
data8 0x8BFE95FCD7B92763, 0x0000BFE7 //A11 = -6.51900079707465044843e-08L
data8 0xE9F15C8E7F58CF90, 0x00003FE4 //A12 = +1.36172642554216769522e-08L
data8 0x9E90F22B11FAF8B5, 0x0000BFE2 //A13 = -2.30744183054978535129e-09L
data8 0xF8CF74F1A138FBBA, 0x00003FDE //A14 = +2.26291720693360003233e-10L
// Pol9
data8 0x94D45274A831ED57, 0x00003FFC //A0 = +1.45341194505862183128e-01L
data8 0x94D4518B699A4A68, 0x0000BFFA //A1 = -3.63352952323113355459e-02L
data8 0x90C3B59FF403A916, 0x00003FF8 //A2 = +8.83572327421709216515e-03L
data8 0x893B796D0E9B4867, 0x0000BFF6 //A3 = -2.09399904729894563201e-03L
data8 0xFDFFA94903DCB8EA, 0x00003FF3 //A4 = +4.84464029001979577664e-04L
data8 0xE5CE7C2E4B05CF16, 0x0000BFF1 //A5 = -1.09580317663729186599e-04L
data8 0xCB88CC8F1146FDAE, 0x00003FEF //A6 = +2.42631878042764234194e-05L
data8 0xB0AA52C6F44E47C8, 0x0000BFED //A7 = -5.26503698764159271674e-06L
data8 0x966DD813170F8EBD, 0x00003FEB //A8 = +1.12078397189300511086e-06L
data8 0xFB75782788A6E378, 0x0000BFE8 //A9 = -2.34189317246047219283e-07L
data8 0xCDF787C4E5FDCF2A, 0x00003FE6 //A10 = +4.79554094892420966704e-08L
data8 0xA34CD3DFAC12AA45, 0x0000BFE4 //A11 = -9.50531730989412282035e-09L
data8 0xEEBB49645DE0E34C, 0x00003FE1 //A12 = +1.73700091999434388879e-09L
data8 0x8C86D8677DEACFBA, 0x0000BFDF //A13 = -2.55616650187281815453e-10L
data8 0xBDB223D0FE2A7D6B, 0x00003FDB //A14 = +2.15659223402509415592e-11L
// Pol10
data8 0xF2C1812715E4050A, 0x00003FFB //A0 = +1.18533143048567888157e-01L
data8 0xC7DA2C565ADAEE57, 0x0000BFF9 //A1 = -2.43960252726894623056e-02L
data8 0xA15CEFFD632F697D, 0x00003FF7 //A2 = +4.92440908672041077933e-03L
data8 0xFFCFF4D3FB118F69, 0x0000BFF4 //A3 = -9.75846593969603576904e-04L
data8 0xC73F437D2F226C56, 0x00003FF2 //A4 = +1.90016864347860462550e-04L
data8 0x989D7E1F60845811, 0x0000BFF0 //A5 = -3.63863004988760879054e-05L
data8 0xE615A5A669361BE1, 0x00003FED //A6 = +6.85705419984646959791e-06L
data8 0xAACD08E0BE6270F8, 0x0000BFEB //A7 = -1.27256599602163049440e-06L
data8 0xF9DEE9C1C02A3062, 0x00003FE8 //A8 = +2.32710274258898439253e-07L
data8 0xB420E960508A3003, 0x0000BFE6 //A9 = -4.19394488070741280136e-08L
data8 0xFF5E3ECA229CB0C7, 0x00003FE3 //A10 = +7.43219121339261970485e-09L
data8 0xAF86504D78D35E89, 0x0000BFE1 //A11 = -1.27711000692808421573e-09L
data8 0xDE1CE78ADB6DDF04, 0x00003FDE //A12 = +2.02010513073041015283e-10L
data8 0xE124FFAA267301A5, 0x0000BFDB //A13 = -2.55959692063871343080e-11L
data8 0x81F1BEBEFBE168D2, 0x00003FD8 //A14 = +1.84661980716000872722e-12L
// Pol11
data8 0xC6CE5D7D18203EAA, 0x00003FFB //A0 = +9.70732978630764996752e-02L
data8 0x86E8A30A76923C88, 0x0000BFF9 //A1 = -1.64683517829920230086e-02L
data8 0xB4A1CBB7576B4183, 0x00003FF6 //A2 = +2.75622581042760461528e-03L
data8 0xEEB782FBC8BB352B, 0x0000BFF3 //A3 = -4.55316242981110299585e-04L
data8 0x9BC489CC00C7E63A, 0x00003FF1 //A4 = +7.42758405750422020216e-05L
data8 0xC8D418A9F2A78515, 0x0000BFEE //A5 = -1.19703114831817055481e-05L
data8 0xFFE671DCEE8665A8, 0x00003FEB //A6 = +1.90660487794668853072e-06L
data8 0xA1313247D3E35365, 0x0000BFE9 //A7 = -3.00243820009225833104e-07L
data8 0xC8D5A87C970712B1, 0x00003FE6 //A8 = +4.67604496871825103188e-08L
data8 0xF77258CEF4675E25, 0x0000BFE3 //A9 = -7.20164586117313631144e-09L
data8 0x96549D79C0F33C27, 0x00003FE1 //A10 = +1.09379854902340983112e-09L
data8 0xB16A6CC5A3AE6E01, 0x0000BFDE //A11 = -1.61358659378896671620e-10L
data8 0xC0970F2551C52F96, 0x00003FDB //A12 = +2.18949565869759698947e-11L
data8 0xA6E029ABB3BB500C, 0x0000BFD8 //A13 = -2.37144541649446501026e-12L
data8 0xA3E43F3857D1B6A5, 0x00003FD4 //A14 = +1.45564973108152568130e-13L
// Pol12
data8 0xA36E35FC807B3E64, 0x00003FFB //A0 = +7.98000543291529334886e-02L
data8 0xB725A29237C8F94F, 0x0000BFF8 //A1 = -1.11784064873715046550e-02L
data8 0xCB51EF23EAD5F327, 0x00003FF5 //A2 = +1.55120891755237931425e-03L
data8 0xDFA838770AE711A2, 0x0000BFF2 //A3 = -2.13296043002775850891e-04L
data8 0xF3D7B777730B202D, 0x00003FEF //A4 = +2.90683082614108095819e-05L
data8 0x83C5FF0D475796DD, 0x0000BFED //A5 = -3.92715403535014263671e-06L
data8 0x8D37B41345244FD5, 0x00003FEA //A6 = +5.26076523514903487927e-07L
data8 0x9616B7E9C40C1DCC, 0x0000BFE7 //A7 = -6.98905176445499510102e-08L
data8 0x9E38FDF61B26699A, 0x00003FE4 //A8 = +9.20976891314475742405e-09L
data8 0xA565DFE27AEA03A1, 0x0000BFE1 //A9 = -1.20342845518628622757e-09L
data8 0xAAEB9EFB497EC812, 0x00003FDE //A10 = +1.55451193328690040046e-10L
data8 0xABD305A38349EAEB, 0x0000BFDB //A11 = -1.95341618552982314342e-11L
data8 0x9EDB00104DB66DD9, 0x00003FD8 //A12 = +2.25747200093121867690e-12L
data8 0xE9F80AF513F2B8AB, 0x0000BFD4 //A13 = -2.07806143133802417637e-13L
data8 0xC2B840C3859AB166, 0x00003FD0 //A14 = +1.08091168358477817812e-14L
// Pol13
data8 0x86CD0BF01914407A, 0x00003FFB //A0 = +6.58207829138836028568e-02L
data8 0xF9F4A17FA70807C3, 0x0000BFF7 //A1 = -7.62803922344113067603e-03L
data8 0xE63BF84EDE20EDAA, 0x00003FF4 //A2 = +8.78273993036530088653e-04L
data8 0xD2B746011B39D879, 0x0000BFF1 //A3 = -1.00477176633442906101e-04L
data8 0xBFA4F1F66023C975, 0x00003FEE //A4 = +1.14228914411837438985e-05L
data8 0xAD3A05E1F1F0EA8F, 0x0000BFEB //A5 = -1.29063913420827451449e-06L
data8 0x9BA1F2E56DBE1B49, 0x00003FE8 //A6 = +1.44944165416032280452e-07L
data8 0x8AFE93AF627BAFA6, 0x0000BFE5 //A7 = -1.61810825806733824014e-08L
data8 0xF6CEAB6E78304875, 0x00003FE1 //A8 = +1.79575947795401009493e-09L
data8 0xD9BFD64FD9166ECF, 0x0000BFDE //A9 = -1.98041892772535870322e-10L
data8 0xBE482C8AEA403737, 0x00003FDB //A10 = +2.16325508593741350803e-11L
data8 0xA1FB98FA19E62A4F, 0x0000BFD8 //A11 = -2.30191407969654156362e-12L
data8 0xFDB2E0599016AD1E, 0x00003FD4 //A12 = +2.25329742249079975388e-13L
data8 0x9E179A99CDD4BF4B, 0x0000BFD1 //A13 = -1.75517603530017718494e-14L
data8 0xDE4DE992A707C7BC, 0x00003FCC //A14 = +7.71273133169032472595e-16L
// Pol14
data8 0xDF0639E60CF6E96C, 0x00003FFA //A0 = +5.44492971101228988138e-02L
data8 0xAB6737B6065BD1C2, 0x0000BFF7 //A1 = -5.23081035867078490333e-03L
data8 0x8322CC0765FD9C27, 0x00003FF4 //A2 = +5.00243857322493802503e-04L
data8 0xC7C37C447AABC9BE, 0x0000BFF0 //A3 = -4.76273572257807668623e-05L
data8 0x977C068C67DD09B3, 0x00003FED //A4 = +4.51458915834329225528e-06L
data8 0xE4C00648054CBD72, 0x0000BFE9 //A5 = -4.26080256412742187632e-07L
data8 0xABF9032C426C0F54, 0x00003FE6 //A6 = +4.00405155179176153559e-08L
data8 0x80BD82177111B70D, 0x0000BFE3 //A7 = -3.74683488305340664541e-09L
data8 0xBFEFB2BBFC4AAE16, 0x00003FDF //A8 = +3.49130134089615132836e-10L
data8 0x8E68BCEC2A2F6025, 0x0000BFDC //A9 = -3.23800879252444001040e-11L
data8 0xD19FEF92B2157585, 0x00003FD8 //A10 = +2.97894685764287382560e-12L
data8 0x967A0ECC142382D9, 0x0000BFD5 //A11 = -2.67300472044743953909e-13L
data8 0xC6D8869855133985, 0x00003FD1 //A12 = +2.20763189681614758000e-14L
data8 0xD10AC0B228ABCECC, 0x0000BFCD //A13 = -1.45052027893524847250e-15L
data8 0xF7C6DEB4522487A3, 0x00003FC8 //A14 = +5.37280367113168366711e-17L
// Pol15
data8 0xB8F57DECFAC3B255, 0x00003FFA //A0 = +4.51559943173131409760e-02L
data8 0xEC1B8A6C822C036F, 0x0000BFF6 //A1 = -3.60271577347565115947e-03L
data8 0x963A6DD66951B72E, 0x00003FF3 //A2 = +2.86537625289770759336e-04L
data8 0xBE93F9E80DF4AE0A, 0x0000BFEF //A3 = -2.27186718010906557773e-05L
data8 0xF10589FC10D908E0, 0x00003FEB //A4 = +1.79575113004740124999e-06L
data8 0x97F1A2435C7877EF, 0x0000BFE8 //A5 = -1.41508767557208714648e-07L
data8 0xBEFF2FB5F00E9327, 0x00003FE4 //A6 = +1.11174782364058338591e-08L
data8 0xEF5E09DC714DF198, 0x0000BFE0 //A7 = -8.70813302639377671664e-10L
data8 0x958A6EB9408970A4, 0x00003FDD //A8 = +6.80032608255179732632e-11L
data8 0xBA31F40954675710, 0x0000BFD9 //A9 = -5.29198388081297293593e-12L
data8 0xE63B9CEEDC4CF0E6, 0x00003FD5 //A10 = +4.08975721481205179918e-13L
data8 0x8AF8F1E3FED32CEC, 0x0000BFD2 //A11 = -3.08580807479307213059e-14L
data8 0x9A88033A08842BEA, 0x00003FCE //A12 = +2.14455258045503137285e-15L
data8 0x88BCF775B7B3A939, 0x0000BFCA //A13 = -1.18601440246395438386e-16L
data8 0x88687B63A5B7135E, 0x00003FC5 //A14 = +3.69734984736162880476e-18L
// Pol16
data8 0x99B8A501204BF3E7, 0x00003FFA //A0 = +3.75296063885057657456e-02L
data8 0xA33FA20D2867C79C, 0x0000BFF6 //A1 = -2.49097544033960143953e-03L
data8 0xACFD14CA6AA55829, 0x00003FF2 //A2 = +1.64974783411741182991e-04L
data8 0xB6E9B4ED9B378B09, 0x0000BFEE //A3 = -1.09024594422859744844e-05L
data8 0xC0FD95D38ADCF301, 0x00003FEA //A4 = +7.18945888498730738040e-07L
data8 0xCB302F7AAFFFA074, 0x0000BFE6 //A5 = -4.73084450875945514829e-08L
data8 0xD578674188198402, 0x00003FE2 //A6 = +3.10640208133938026422e-09L
data8 0xDFCC6ED4219E7FC4, 0x0000BFDE //A7 = -2.03543610142159316364e-10L
data8 0xEA1F448AA373E4A9, 0x00003FDA //A8 = +1.33083028465054001215e-11L
data8 0xF44780B8EACD37B5, 0x0000BFD6 //A9 = -8.67854438613319891312e-13L
data8 0xFD55794492F53AEE, 0x00003FD2 //A10 = +5.62514216652784597182e-14L
data8 0x805C040421E7A098, 0x0000BFCF //A11 = -3.56269003968981157635e-15L
data8 0xEFCCD20DE93A138E, 0x00003FCA //A12 = +2.07993414310230172191e-16L
data8 0xB259764466732080, 0x0000BFC6 //A13 = -9.66834364652262630640e-18L
data8 0x9597C1DB6AF830E4, 0x00003FC1 //A14 = +2.53420063550355940811e-19L
// Pol17
data8 0xFFFCBD66BAA4368C, 0x00003FF9 //A0 = +3.12484454387527380657e-02L
data8 0xE28174723762D197, 0x0000BFF5 //A1 = -1.72810121976742793952e-03L
data8 0xC81D832836019EC4, 0x00003FF1 //A2 = +9.54224026432644399736e-05L
data8 0xB0885530C7D7AB5B, 0x0000BFED //A3 = -5.26107996417947739207e-06L
data8 0x9B7EA64F62F6FD06, 0x00003FE9 //A4 = +2.89631495607631932854e-07L
data8 0x88C24ACAA9042166, 0x0000BFE5 //A5 = -1.59208376111789845204e-08L
data8 0xF033E5CD9B7F2822, 0x00003FE0 //A6 = +8.73852423930118273815e-10L
data8 0xD2A1B161FB4DFBFE, 0x0000BFDC //A7 = -4.78920839886600387264e-11L
data8 0xB86B27FCBB5A1E9D, 0x00003FD8 //A8 = +2.62074563162805723295e-12L
data8 0xA124E1303F08E508, 0x0000BFD4 //A9 = -1.43124677534734729453e-13L
data8 0x8C0B270950D7C697, 0x00003FD0 //A10 = +7.77397948226387851915e-15L
data8 0xEE034E350C65D2D9, 0x0000BFCB //A11 = -4.12886586201102092942e-16L
data8 0xBA94473E52495304, 0x00003FC7 //A12 = +2.02289587087169937807e-17L
data8 0xE913D34CBB853CEE, 0x0000BFC2 //A13 = -7.89697093687557412061e-19L
data8 0xA44576A85E8CAB59, 0x00003FBD //A14 = +1.73929048516879172258e-20L
// Pol18
data8 0xD579A3FE4622DED2, 0x00003FF9 //A0 = +2.60589793198885278242e-02L
data8 0x9D97EB84E7CD89C8, 0x0000BFF5 //A1 = -1.20234251012583627659e-03L
data8 0xE86EFDC2CCA5C47B, 0x00003FF0 //A2 = +5.54164790116744315389e-05L
data8 0xAB39FA5621E39B15, 0x0000BFEC //A3 = -2.55147332073979814633e-06L
data8 0xFC0244F58F8D8097, 0x00003FE7 //A4 = +1.17350772365097747003e-07L
data8 0xB941D44B71B14FE2, 0x0000BFE3 //A5 = -5.39169255673480031672e-09L
data8 0x880B4A40B6F2C901, 0x00003FDF //A6 = +2.47462779512141204748e-10L
data8 0xC7998AE5652CDCFC, 0x0000BFDA //A7 = -1.13459336509953900777e-11L
data8 0x92438AA45915CD95, 0x00003FD6 //A8 = +5.19633524685027215673e-13L
data8 0xD6067243AD3AEAE6, 0x0000BFD1 //A9 = -2.37615683835509918256e-14L
data8 0x9BD0722A07669E4D, 0x00003FCD //A10 = +1.08117849400479298186e-15L
data8 0xDDF6F1B79F50E3C4, 0x0000BFC8 //A11 = -4.81309059042573202592e-17L
data8 0x91F283C0351A9ACA, 0x00003FC4 //A12 = +1.97795505638619048412e-18L
data8 0x990BC4FAFA9C7542, 0x0000BFBF //A13 = -6.48174913943425248713e-20L
data8 0xB536865B89676892, 0x00003FB9 //A14 = +1.19916696090758913485e-21L
// Pol19
data8 0xB241CEB1B7C953F1, 0x00003FF9 //A0 = +2.17598950382519671244e-02L
data8 0xDBD6FBA9B11B85E1, 0x0000BFF4 //A1 = -8.38622198373701898430e-04L
data8 0x877605B1AD082441, 0x00003FF0 //A2 = +3.22964249573360786077e-05L
data8 0xA6D04DC067A5D310, 0x0000BFEB //A3 = -1.24285881515578912302e-06L
data8 0xCD458A72BC161315, 0x00003FE6 //A4 = +4.77935289502172654216e-08L
data8 0xFC6902CFB5DE90A2, 0x0000BFE1 //A5 = -1.83652591038905929358e-09L
data8 0x9B12B0707DFE615C, 0x00003FDD //A6 = +7.05190381049444126079e-11L
data8 0xBE67972F2C8EE5AE, 0x0000BFD8 //A7 = -2.70581282732878853626e-12L
data8 0xE99D8CAF9A3FFE02, 0x00003FD3 //A8 = +1.03746090805854376435e-13L
data8 0x8F35F5BBEF9E4299, 0x0000BFCF //A9 = -3.97489765699919189983e-15L
data8 0xAF6E62C3C91B7178, 0x00003FCA //A10 = +1.52162305785839987182e-16L
data8 0xD6636229C1646963, 0x0000BFC5 //A11 = -5.81100425482928485309e-18L
data8 0x810331BF289E068F, 0x00003FC1 //A12 = +2.18555638648715837944e-19L
data8 0x8E3D07CA59546B83, 0x0000BFBC //A13 = -7.53003820427900359431e-21L
data8 0xD5970B291ED73560, 0x00003FB6 //A14 = +1.76677518655145552907e-22L
LOCAL_OBJECT_END(erfc_p_table)


.section .text
GLOBAL_LIBM_ENTRY(erfc)

{ .mfi
      alloc       r32 = ar.pfs, 0, 33, 4, 0
      fma.s1      FR_Tmp = f1, f1, f8                      // |x|+1, if x >= 0
      nop.i       0
}
{ .mfi
      addl        EXP_AD_TB1    = @ltoff(exp_table_1), gp
      fms.s1      FR_Tmp1 = f1, f1, f8                      // |x|+1, if x < 0
      mov         exp_GR_rshf_2to56 = 0x4768            // begin 1.1 2^(63+56)
};;

{ .mfi
      ld8         EXP_AD_TB1    = [EXP_AD_TB1]
      fcmp.ge.s1  p6,p7 = f8, f0                        // p6: x >= 0 ,p7: x<0
      mov         exp_GR_rshf_2to56 = 0x4768            // begin 1.1 2^(63+56)
}
{ .mlx
      mov         exp_TB1_size  = 0x100
      movl        exp_GR_sig_inv_ln2 = 0xb8aa3b295c17f0bc   //signif. of 1/ln2
};;

{ .mfi
      nop.m       0
      fclass.m    p8,p0 = f8,0x07                                 // p8: x = 0
      shl         exp_GR_rshf_2to56 = exp_GR_rshf_2to56, 48 //end 1.1 2^(63+56)
}
{ .mfi
      mov         exp_GR_exp_2tom56 = 0xffff-56
      fnma.s1     EXP_NORM_f8   = f8, f8, f0             // high bits for -x^2
      nop.i       0
};;


.pred.rel "mutex",p6,p7
{ .mfi
      setf.sig    EXP_INV_LN2_2TO63 = exp_GR_sig_inv_ln2  // form 1/ln2 * 2^63
(p6)  fma.s1      FR_AbsArg = f1, f0, f8                     // |x|, if x >= 0
      mov         GR_POS_ARG_ASYMP = 0x403C
}
{ .mfi
      mov         GR_NEG_ARG_ASYMP = 0x4018
(p7)  fms.s1      FR_AbsArg = f1, f0, f8                      // |x|, if x < 0
      mov         exp_GR_rshf = 0x43e8       // begin 1.1 2^63 for right shift
};;

{ .mfi
      setf.exp    EXP_2TOM56 = exp_GR_exp_2tom56   // 2^-56 for scaling Nfloat
      fclass.m    p10,p0 = f8, 0x21                           // p10: x = +inf
      mov         exp_GR_17ones = 0x1FFFF
}
{ .mlx
      setf.d      EXP_RSHF_2TO56 = exp_GR_rshf_2to56   // const 1.10*2^(63+56)
      movl        GR_ERFC_XB_TB = 0x1A0
};;


.pred.rel "mutex",p6,p7
{ .mfi
      ldfd        FR_UnfBound = [EXP_AD_TB1], 16
(p6)  fma.s1      FR_Tmp = FR_Tmp, FR_Tmp, f0               // (|x|+1)^2,x >=0
      shl         exp_GR_rshf = exp_GR_rshf, 48 //end 1.1 2^63 for right shift
}
{ .mfi
      nop.m       0
(p7)  fma.s1      FR_Tmp = FR_Tmp1, FR_Tmp1, f0              // (|x|+1)^2, x<0
      mov         GR_0x1 = 0x1
};;

{ .mfi
      mov         GR_BIAS = 0x0FFFF
      fclass.m    p9,p0 = f8, 0x22                             // p9: x = -inf
      shl         GR_EpsNorm = GR_0x1,53
}
{ .mfb
      mov         exp_TB2_size  = 0x80
(p8)  fma.d.s0    f8 = f1, f1, f0                         //p8: y = 1.0, x = 0
(p8)  br.ret.spnt b0                               //p8:  quick exit for x = 0
};;

{ .mfi
      nop.m       0
      fclass.m    p11,p0 = f8, 0xc3                          // p11: x = nan
      nop.i       0
}
{ .mfi
      setf.d      EXP_RSHF = exp_GR_rshf //Form right shift const 1.100 * 2^63
      fma.s1      FR_NormX = f8,f1,f0
      nop.i       0
};;

{ .mfi
      setf.d      FR_EpsNorm = GR_EpsNorm
      nop.f       0
(p6)  shl         GR_ARG_ASYMP = GR_POS_ARG_ASYMP, 48//p6:ARG_ASYMP= 28.0,x>=0
}
{ .mfi
      nop.m       0
      fma.s1      FR_2 = f1, f1, f1
      nop.i       0
};;

{ .mfi
      ldfe        exp_ln2_by_128_hi  = [EXP_AD_TB1],16
      fma.s1      f8_sq_lo = f8, f8, EXP_NORM_f8          // low bits for -x^2
(p7)  shl         GR_ARG_ASYMP = GR_NEG_ARG_ASYMP, 48//p6:ARG_ASYMP= 6.0,x < 0
};;

{ .mfi
      sub         GR_mBIAS = r0, GR_BIAS
      fma.s1      FR_Tmp = FR_Tmp, FR_Tmp, f0                     // (|x|+1)^4
      nop.i       0
}
{ .mfi
      ldfe        exp_ln2_by_128_lo  = [EXP_AD_TB1], 16
      nop.f       0
      nop.i       0
};;

{ .mfi
      getf.d      GR_AbsArg = FR_AbsArg
      nop.f       0
      add         GR_ERFC_XB_TB = GR_ERFC_XB_TB, EXP_AD_TB1//pointer to XB_TBL
}
{ .mfb
      shladd      GR_ShftPi_bias = GR_BIAS, 4, GR_mBIAS // BIAS *  2^4 - BIAS
(p9)  fma.d.s0    f8 = f1, f1, f1                   // p9: y = 2 for x = -inf
(p9)  br.ret.spnt b0                           // p9: quick exit for x = -inf
};;

{ .mfi
      add         GR_ERFC_P_TB = 0x140, GR_ERFC_XB_TB      // pointer to P_TBL
      fma.s1    EXP_W_2TO56_RSH = EXP_NORM_f8,EXP_INV_LN2_2TO63,EXP_RSHF_2TO56
      shladd      GR_ShftPi_bias = GR_ShftPi_bias, 4, r0        //  BIAS * 240
}
{ .mfb
      nop.m       0
(p10) fma.d.s0       f8 = f0, f1, f0                   // p10: y = 0 for x = +inf
(p10) br.ret.spnt b0                           // p10: quick exit for x = +inf
};;


.pred.rel "mutex",p6,p7
{ .mfi
(p6)  cmp.gt.unc  p15,p0 = GR_AbsArg,GR_ARG_ASYMP   //p15: x > 28.0,p6: x >= 0
      nop.f       0
(p7)  cmp.gt.unc  p14,p0 = GR_AbsArg, GR_ARG_ASYMP  //p14: x < - 6.0,p7: x < 0
}
{ .mfb
      add         EXP_AD_TB2 = exp_TB1_size, EXP_AD_TB1
(p11) fma.d.s0    f8 = f8, f1, f0                     //p11: y = x for x = nan
(p11) br.ret.spnt b0                             //p11: quick exit for x = nan
};;

{ .mfi
      add         EXP_AD_P = exp_TB2_size, EXP_AD_TB2
      fms.s1      f8_sq_lo = f1, f1, f8_sq_lo         // 1 - low bits for -x^2
      nop.i       0
};;

{ .mfi
      ldfpd       exp_P4, exp_P3  = [EXP_AD_P], 16
      fmerge.s    FR_X = f8,f8
      shladd      GR_ShftXBi_bias = GR_mBIAS, 4, r0
}
{ .mfb
      nop.m       0
(p14) fnma.d.s0   FR_RESULT = FR_EpsNorm,FR_EpsNorm,FR_2 //p14:y ~=~ 2,x< -6.0
(p14) br.ret.spnt b0                            //p14: quick exit for x < -6.0
};;

//p15: y ~=~ 0.0(result with underflow error), x > ARG_ASYMP = 28,
{ .mfi
      ldfpd       exp_P2, exp_P1  = [EXP_AD_P]
      fma.d.s0    FR_Tmpf = f1, f1, FR_EpsNorm                      // flag i
      nop.i       0
}
{ .mfb
(p15) mov         GR_Parameter_TAG = 208
(p15) fma.d.s0    FR_RESULT = FR_EpsNorm,FR_EpsNorm,f0
(p15) br.cond.spnt __libm_error_region
};;

//p8: x < 27.0, result without ungerflow error
{ .mfi
      getf.exp    GR_IndxPlusBias = FR_Tmp         // exp + bias for (|x|+1)^4
      fcmp.lt.s1  p8,p0 = FR_NormX,FR_UnfBound
      nop.i       0
}
{ .mfi
      nop.m       0
      fms.s1      EXP_Nfloat = EXP_W_2TO56_RSH, EXP_2TOM56, EXP_RSHF
      nop.i       0
};;

{ .mmi
      shladd      GR_ShftXBi = GR_IndxPlusBias, 4, GR_ShftXBi_bias
      shladd      GR_ShftPi = GR_IndxPlusBias, 4, GR_ShftPi_bias
      shl         GR_ShftPi_8 = GR_IndxPlusBias, 8
};;

{ .mmi
      getf.sig    exp_GR_N        = EXP_W_2TO56_RSH
      add         GR_ERFC_XB_TB = GR_ERFC_XB_TB, GR_ShftXBi// pointer to XB[i]
      sub         GR_ShftPi = GR_ShftPi_8, GR_ShftPi             // (256-16)*i
};;

{ .mmi
      ldfe        FR_Xb  = [GR_ERFC_XB_TB]
      add         GR_ShftA12 = 0xC0, GR_ShftPi        // pointer shift for A12
      add         GR_ShftA13 = 0xD0, GR_ShftPi        // pointer shift for A13
};;

{ .mfi
      add         GR_P_A13 = GR_ERFC_P_TB, GR_ShftA13        // pointer to A13
      nop.f       0
      and         exp_GR_index_1 = 0x0f, exp_GR_N
}
{ .mfi
      add         GR_P_A12 = GR_ERFC_P_TB, GR_ShftA12        // pointer to A12
      fnma.s1     exp_r   = EXP_Nfloat, exp_ln2_by_128_hi, EXP_NORM_f8
      nop.i       0
};;

{ .mfi
      ldfe        FR_A12 = [GR_P_A12], -64
      nop.f       0
      and         exp_GR_index_2_16 = 0x70, exp_GR_N
}
{ .mfi
      ldfe        FR_A13 = [GR_P_A13], -64
      nop.f       0
      shladd      EXP_AD_T1 = exp_GR_index_1, 4, EXP_AD_TB1
};;

{ .mmi
      ldfe        FR_A8 = [GR_P_A12], 32
      ldfe        FR_A9 = [GR_P_A13], 32
      add         EXP_AD_T2 = EXP_AD_TB2, exp_GR_index_2_16
};;

{ .mmi
      ldfe        FR_A10 = [GR_P_A12], -96
      ldfe        FR_A11 = [GR_P_A13], -96
      nop.i       0
};;

{ .mmi
      ldfe        FR_A4 = [GR_P_A12], 32
      ldfe        FR_A5 = [GR_P_A13], 32
      shr         r2 = exp_GR_N,  0x7
};;

{ .mfi
      ldfe        FR_A6 = [GR_P_A12], -64
      fma.s1      exp_rP4pP3 = exp_r, exp_P4, exp_P3
      nop.i       0
}
{ .mfi
      ldfe        FR_A7 = [GR_P_A13], -64
      fma.s1      exp_rsq = exp_r, exp_r, f0
      nop.i       0
};;

{ .mmi
      ldfe        FR_A2 = [GR_P_A12], -32
      ldfe        FR_A3 = [GR_P_A13], -32
      addl        exp_GR_biased_M = 0xffff, r2
};;

{ .mmi
      ldfe        FR_A0 = [GR_P_A12], 224
      ldfe        FR_A1 = [GR_P_A13]
      nop.i       0
};;

{ .mfi
      ldfe        FR_A14 = [GR_P_A12]
      fms.s1      FR_LocArg = FR_AbsArg, f1, FR_Xb          // xloc = x - x[i]
      nop.i       0
};;

{ .mmi
      setf.exp    EXP_2M = exp_GR_biased_M
      ldfe        exp_T1  = [EXP_AD_T1]
      nop.i       0
};;

{ .mfi
      ldfe        exp_T2  = [EXP_AD_T2]
      fma.s1      exp_P_hi  = exp_rsq, exp_P1, exp_r
      nop.i       0
};;

{ .mfi
      nop.m       0
      fma.s1      exp_rcube = exp_r, exp_rsq, f0
      nop.i       0
}
{ .mfi
      nop.m       0
      fma.s1      exp_P_lo  = exp_r, exp_rP4pP3, exp_P2
      nop.i       0
};;

{ .mfi
      nop.m       0
      fnma.s1     exp_f   = EXP_Nfloat, exp_ln2_by_128_lo, f8_sq_lo
      nop.i       0
};;

{ .mfi
      nop.m       0
      fma.s1      FR_P14_0_1 = FR_LocArg, FR_LocArg, f0            // xloc ^2
      nop.i       0
}
{ .mfi
      nop.m       0
      fma.s1      FR_P14_0_2 = FR_A13, FR_LocArg, FR_A12
      nop.i       0
};;

{ .mfi
      nop.m       0
      fma.s1      FR_P14_1_1 = FR_A9, FR_LocArg, FR_A8
      nop.i       0
}
{ .mfi
      nop.m       0
      fma.s1      FR_P14_1_2 = FR_A11, FR_LocArg, FR_A10
      nop.i       0
};;

{ .mfi
      nop.m       0
      fma.s1      FR_P14_2_1 = FR_A5, FR_LocArg, FR_A4
      nop.i       0
}
{ .mfi
      nop.m       0
      fma.s1      FR_P14_2_2 = FR_A7, FR_LocArg, FR_A6
      nop.i       0
};;

{ .mfi
      nop.m       0
      fma.s1      FR_P14_3_1 = FR_A1, FR_LocArg, FR_A0
      nop.i       0
}
{ .mfi
      nop.m       0
      fma.s1      FR_P14_3_2 = FR_A3, FR_LocArg, FR_A2
      nop.i       0
};;

{ .mfi
      nop.m       0
      fma.s1      FR_P14_6_1 = FR_P14_0_1, FR_A14, FR_P14_0_2
      nop.i       0
}
{ .mfi
      nop.m       0
      fma.s1      FR_P14_7_2 = FR_P14_0_1, FR_P14_0_1, f0
      nop.i       0
};;

{ .mfi
      nop.m       0
      fma.s1      FR_P14_7_1 = FR_P14_0_1, FR_P14_1_2, FR_P14_1_1
      nop.i       0
}
{ .mfi
      nop.m       0
      fma.s1      exp_S2  = exp_f, exp_T2, f0
      nop.i       0
};;
{ .mfi
      nop.m       0
      fma.s1      exp_S1  = EXP_2M, exp_T1, f0
      nop.i       0
};;

{ .mfi
      nop.m       0
      fma.s1      FR_P14_8_1 = FR_P14_0_1, FR_P14_3_2, FR_P14_3_1
      nop.i       0
}
{ .mfi
      nop.m       0
      fma.s1      FR_P14_8_2 = FR_P14_0_1, FR_P14_2_2, FR_P14_2_1
      nop.i       0
};;

{ .mfi
      nop.m       0
      fma.s1      FR_P14_12_1 = FR_P14_7_2, FR_P14_6_1, FR_P14_7_1
      nop.i       0
};;

{ .mfi
      nop.m       0
      fma.s1      exp_S   = exp_S1, exp_S2, f0
      nop.i       0
}
{ .mfi
      nop.m       0
      fma.s1      exp_P     = exp_rcube, exp_P_lo, exp_P_hi
      nop.i       0
};;


{ .mfi
      nop.m       0
      fma.s1      FR_P14_13_1 = FR_P14_7_2, FR_P14_8_2, FR_P14_8_1
      nop.i       0
}
{ .mfi
      nop.m       0
      fma.s1      FR_P14_13_2 = FR_P14_7_2, FR_P14_7_2, f0           // xloc^8
      nop.i       0
};;

{ .mfi
      nop.m       0
      fma.s1      FR_Exp = exp_S, exp_P, exp_S                    // exp(-x^2)
      nop.i       0
}
{ .mfi
      nop.m       0
      fma.s1      FR_Pol = FR_P14_13_2, FR_P14_12_1, FR_P14_13_1
      nop.i       0
};;

{ .mfi
      nop.m       0
      fma.d.s0    FR_Tmpf = f8, f1, f0                             //  flag  d
      nop.i       0
};;

//p6: result for     0 < x < = 28.0,
//p7: result for    -6.0  <= x < 0,
//p8: exit   for   - 6.0  <=   x < UnfBound ~=~ 26.54..

.pred.rel "mutex",p6,p7
{ .mfi
      nop.m       0
(p6)  fma.d.s0    f8 = FR_Exp, FR_Pol, f0
      nop.i       0
}
{ .mfb
      mov         GR_Parameter_TAG = 208
(p7)  fnma.d.s0   f8 = FR_Exp, FR_Pol, FR_2
(p8)  br.ret.sptk b0
};;

GLOBAL_LIBM_END(erfc)

// call via (p15) br.cond.spnt   __libm_error_region
//          for  x > ARG_ASYMP = 28.0
// or
//
// after .endp erfc for UnfBound < = x < = ARG_ASYMP = 28.0

LOCAL_LIBM_ENTRY(__libm_error_region)
.prologue
{ .mfi
        add   GR_Parameter_Y=-32,sp                       // Parameter 2 value
        nop.f 0
.save   ar.pfs,GR_SAVE_PFS
        mov  GR_SAVE_PFS=ar.pfs                                 // Save ar.pfs
}
{ .mfi
.fframe 64
        add sp=-64,sp                                      // Create new stack
        nop.f 0
        mov GR_SAVE_GP=gp                                           // Save gp
};;
{ .mmi
        stfd [GR_Parameter_Y] = FR_Y,16          // STORE Parameter 2 on stack
        add GR_Parameter_X = 16,sp                      // Parameter 1 address
.save   b0, GR_SAVE_B0
        mov GR_SAVE_B0=b0                                           // Save b0
};;
.body
{ .mib
        stfd [GR_Parameter_X] = FR_X             // STORE Parameter 1 on stack
        add   GR_Parameter_RESULT = 0,GR_Parameter_Y    // Parameter 3 address
        nop.b 0
}
{ .mib
        stfd [GR_Parameter_Y] = FR_RESULT        // STORE Parameter 3 on stack
        add   GR_Parameter_Y = -16,GR_Parameter_Y
        br.call.sptk b0=__libm_error_support#  // Call error handling function
};;
{ .mmi
        nop.m 0
        nop.m 0
        add   GR_Parameter_RESULT = 48,sp
};;
{ .mmi
        ldfd  f8 = [GR_Parameter_RESULT]        // Get return result off stack
.restore sp
        add   sp = 64,sp                              // Restore stack pointer
        mov   b0 = GR_SAVE_B0                        // Restore return address
};;
{ .mib
        mov   gp = GR_SAVE_GP                                    // Restore gp
        mov   ar.pfs = GR_SAVE_PFS                           // Restore ar.pfs
        br.ret.sptk     b0                                           // Return
};;

LOCAL_LIBM_END(__libm_error_region)
.type   __libm_error_support#,@function
.global __libm_error_support#



