/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io.parser;

public class TermParserUtils {
    public static final int EOF_TOKEN = 0;

    private TermParserUtils() {
    }

    public static String convertQuotedString(String str, char quote) {
        int n = str.length();
        if (str.charAt(0) != quote || str.charAt(n - 1) != quote) {
            return null;
        }
        char ch = '\u0000';
        str = str.substring(1, n - 1);
        n -= 2;
        StringBuffer bu = new StringBuffer();
        block15: for (int i = 0; i < n; ++i) {
            char buch = str.charAt(i);
            block0 : switch (buch) {
                case '\\': {
                    buch = str.charAt(++i);
                    switch (buch) {
                        case 'a': {
                            ch = '\u0007';
                            break;
                        }
                        case 'b': {
                            ch = '\b';
                            break;
                        }
                        case 'f': {
                            ch = '\f';
                            break;
                        }
                        case 'n': {
                            ch = '\n';
                            break;
                        }
                        case 't': {
                            ch = '\t';
                            break;
                        }
                        case 'v': {
                            ch = '\u000b';
                            break;
                        }
                        case 'r': {
                            ch = '\r';
                            break;
                        }
                        case '\r': {
                            buch = str.charAt(i + 1);
                            if (buch == '\n') {
                                ++i;
                            }
                        }
                        case '\n': {
                            continue block15;
                        }
                        case 'x': {
                            ch = '\u0000';
                            while ((buch = str.charAt(++i)) != '\\') {
                                ch = (char)(ch * 16 + Character.digit(buch, 16));
                            }
                            break block0;
                        }
                        default: {
                            buch = str.charAt(i);
                            if (buch >= '0' && buch < '8') {
                                ch = '\u0000';
                                while ((buch = str.charAt(i)) != '\\') {
                                    ch = (char)(ch * 8 + Character.digit(buch, 8));
                                    ++i;
                                }
                                break block0;
                            }
                            ch = buch;
                            break;
                        }
                    }
                    break;
                }
                default: {
                    if (buch != quote || (ch = str.charAt(++i)) != quote) {
                        // empty if block
                    }
                    ch = buch;
                }
            }
            bu.append(ch);
        }
        return bu.toString();
    }

    public static char convertQuotedChar(String str, char quote) {
        int i = 0;
        char buch = str.charAt(i);
        char ch = '\u0000';
        block0 : switch (buch) {
            case '\\': {
                buch = str.charAt(++i);
                switch (buch) {
                    case 'a': {
                        ch = '\u0007';
                        break block0;
                    }
                    case 'b': {
                        ch = '\b';
                        break block0;
                    }
                    case 'f': {
                        ch = '\f';
                        break block0;
                    }
                    case 'n': {
                        ch = '\n';
                        break block0;
                    }
                    case 't': {
                        ch = '\t';
                        break block0;
                    }
                    case 'v': {
                        ch = '\u000b';
                        break block0;
                    }
                    case 'r': {
                        ch = '\r';
                        break block0;
                    }
                    case 'x': {
                        ch = '\u0000';
                        while ((buch = str.charAt(++i)) != '\\') {
                            ch = (char)(ch * 16 + Character.digit(buch, 16));
                        }
                        break;
                    }
                }
                ch = '\u0000';
                while ((buch = str.charAt(++i)) != '\\') {
                    ch = (char)(ch * 8 + Character.digit(buch, 8));
                }
                break;
            }
            default: {
                if (buch != quote || (ch = str.charAt(++i)) != quote) {
                    // empty if block
                }
                ch = buch;
            }
        }
        return ch;
    }
}

