#!/bin/csh
#
# Shell script to generate data files for Matlab processing
#
# Generate synthetic data for comparision.
#
echo "synth_noise"
ntpsim -i3 -D10 -w3.5e-9 >synth_noise
echo "synth_pps"
ntpsim -i3 -D10 -p5.7e-6 -w3.5e-9 >synth_pps
echo "synth_lan"
ntpsim -i3 -D10 -p3.1e-5 -w2.6e-8 >synth_lan
#
# Simulate rawstats data and generate synthetic data for comparision.
#
echo "barn"
ntpsim -frawstats -r128.4.1.4 -u >barn
ntpsim -i3 -D10 -p2.19e-4 >synth_barn
echo "peers"
ntpsim -frawstats -l -u >peers
ntpsim -i3 -D10 -p5.50e-4 >synth_peers
echo "usno"
ntpsim -frawstats -r192.5.41.40 -u >usno
ntpsim -i3 -D10 -p8.38e-4 >synth_usno
echo "ien"
ntpsim -frawstats -r193.204.114.1 -u >ien
ntpsim -i3 -D10 -p4.00e-3 >synth_ien
#
# Process rawstats data and generate synthetic data for comparision.
#
echo "usno_raw"
awk -f raw.awk rawstats >usno_raw
ntpsim -i3 -D10 -p1.74e-2 >synth_usno_raw
