/*
** ident.h
*/

#ifndef __IDENT_H__
#define __IDENT_H__

#define UIDENT_VERSION 1

struct uident_request
{
  unsigned short version;   /* Protocol version, 1 for now */
  unsigned short reqno;     /* Request number */
  unsigned short lport;     /* Local port number */
  unsigned short fport;     /* Foreign port number */
  unsigned long  laddr;     /* Local host address */
};


#define UIDENT_MAXLEN 400

#define UIDENT_T_USERID 1
#define UIDENT_T_ERROR  2

struct uident_reply
{
  unsigned short version;       /* Same as in the request */
  unsigned short reqno;
  unsigned short lport;
  unsigned short fport;
  unsigned long  laddr;
  
  unsigned short type;    /* Reply type */
  union
  {
    struct
    {
      unsigned short idlen;
      char buf[UIDENT_MAXLEN];
    } userid;
    struct
    {
      unsigned short code;
    } error;
  } u;
};

#define UIDENT_E_ILLEGAL_VERSION	1
#define UIDENT_E_INVALID_PORT		2
#define UIDENT_E_NO_USER		3
#define UIDENT_E_UNKNOWN_ERROR		4

#endif

