/*
 * This file is part of the coreboot project.
 *
 * Copyright 2015 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef SOC_MEDIATEK_MT8173_GPIO_H
#define SOC_MEDIATEK_MT8173_GPIO_H

#include <stdint.h>
#include <stdlib.h>
#include <soc/addressmap.h>
#include <soc/gpio_common.h>

enum {
	MAX_GPIO_REG_BITS = 16,
	MAX_GPIO_MODE_PER_REG = 5,
	GPIO_MODE_BITS = 3,
};

enum external_power {
	GPIO_EINT_3P3V = 0,
	GPIO_EINT_1P8V = 1,
};

#define PIN(id, name, func1, func2, func3, func4, func5, func6, func7) \
	PAD_##name##_ID = id, \
	PAD_##name##_FUNC_##func1 = 1, \
	PAD_##name##_FUNC_##func2 = 2, \
	PAD_##name##_FUNC_##func3 = 3, \
	PAD_##name##_FUNC_##func4 = 4, \
	PAD_##name##_FUNC_##func5 = 5, \
	PAD_##name##_FUNC_##func6 = 6, \
	PAD_##name##_FUNC_##func7 = 7

#define GPIO(name) ((gpio_t){.id = PAD_##name##_ID})

enum {
	PIN(0, EINT0, IRDA_PDN, I2S1_WS, AUD_SPDIF,
		UTXD0, RES5, RES6, DBG_MON_A_20),
	PIN(1, EINT1, IRDA_RXD, I2S1_BCK, SDA5,
		URXD0, RES5, RES6, DBG_MON_A_21),
	PIN(2, EINT2, IRDA_TXD, I2S1_MCK, SCL5,
		UTXD3, RES5, RES6, DBG_MON_A_22),
	PIN(3, EINT3, DSI1_TE, I2S1_DO_1, SDA3,
		URXD3, RES5, RES6, DBG_MON_A_23),
	PIN(4, EINT4, DISP_PWM1, I2S1_DO_2, SCL3,
		UCTS3, RES5, SFWP_B, RES7),
	PIN(5, EINT5, PCM1_CLK, I2S2_WS, SPI_CK_3,
		URTS3, AP_MD32_JTAG_TMS, SFOUT, RES7),
	PIN(6, EINT6, PCM1_SYNC, I2S2_BCK, SPI_MI_3,
		RES4, AP_MD32_JTAG_TCK, SFCS0, RES7),
	PIN(7, EINT7, PCM1_DI, I2S2_DI_1, SPI_MO_3,
		RES4, AP_MD32_JTAG_TDI, SFHOLD, RES7),
	PIN(8, EINT8, PCM1_DO, I2S2_DI_2, SPI_CS_3,
		AUD_SPDIF, AP_MD32_JTAG_TDO, SFIN, RES7),
	PIN(9, EINT9, USB_DRVVBUS_P0, I2S2_MCK, RES3,
		USB_DRVVBUS_P1, AP_MD32_JTAG_TRST, SFCK, RES7),
	PIN(10, EINT10, CLKM0, DSI1_TE, DISP_PWM1,
		PWM4, IRDA_RXD, RES6, RES7),
	PIN(11, EINT11, CLKM1, I2S3_WS, USB_DRVVBUS_P0,
		PWM5, IRDA_TXD, USB_DRVVBUS_P1, DBG_MON_B_30),
	PIN(12, EINT12, CLKM2, I2S3_BCK, SRCLKENA0,
		RES4, I2S2_WS, RES6, DBG_MON_B_32),
	PIN(13, EINT13, CLKM3, I2S3_MCK, SRCLKENA0,
		RES4, I2S2_BCK, RES6, DBG_MON_A_32),
	PIN(14, EINT14, CMDAT0, CMCSD0, RES3,
		CLKM2, RES5, RES6, DBG_MON_B_6),
	PIN(15, EINT15, CMDAT1, CMCSD1, CMFLASH,
		CLKM3, RES5, RES6, DBG_MON_B_29),
	PIN(16, IDDIG, IDDIG, CMFLASH, RES3,
		PWM5, RES5, RES6, RES7),
	PIN(17, WATCHDOG, WATCHDOG_AO, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(18, CEC, CEC, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(19, HDMISCK, HDMISCK, HDCP_SCL, RES3,
		RES4, RES5, RES6, RES7),
	PIN(20, HDMISD, HDMISD, HDCP_SDA, RES3,
		RES4, RES5, RES6, RES7),
	PIN(21, HTPLG, HTPLG, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(22, MSDC3_DAT0, MSDC3_DAT0, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(23, MSDC3_DAT1, MSDC3_DAT1, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(24, MSDC3_DAT2, MSDC3_DAT2, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(25, MSDC3_DAT3, MSDC3_DAT3, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(26, MSDC3_CLK, MSDC3_CLK, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(27, MSDC3_CMD, MSDC3_CMD, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(28, MSDC3_DSL, MSDC3_DSL, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(29, UCTS2, UCTS2, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(30, URTS2, URTS2, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(31, URXD2, URXD2, UTXD2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(32, UTXD2, UTXD2, URXD2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(33, DAICLK, MRG_CLK, PCM0_CLK, RES3,
		RES4, RES5, RES6, RES7),
	PIN(34, DAIPCMIN, MRG_DI, PCM0_DI, RES3,
		RES4, RES5, RES6, RES7),
	PIN(35, DAIPCMOUT, MRG_DO, PCM0_DO, RES3,
		RES4, RES5, RES6, RES7),
	PIN(36, DAISYNC, MRG_SYNC, PCM0_SYNC, RES3,
		RES4, RES5, RES6, RES7),
	PIN(37, EINT16, USB_DRVVBUS_P0, USB_DRVVBUS_P1, PWM0,
		PWM1, PWM2, CLKM0, RES7),
	PIN(38, CONN_RST, USB_DRVVBUS_P0, USB_DRVVBUS_P1, RES3,
		RES4, RES5, CLKM1, RES7),
	PIN(39, CM2MCLK, CM2MCLK, CMCSD0, RES3,
		RES4, RES5, RES6, DBG_MON_A_17),
	PIN(40, CMPCLK, CMPCLK, CMCSK, CMCSD2,
		RES4, RES5, RES6, DBG_MON_A_18),
	PIN(41, CMMCLK, CMMCLK, RES2, RES3,
		RES4, RES5, RES6, DBG_MON_A_19),
	PIN(42, DSI_TE, DSI_TE, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(43, SDA2, SDA2, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(44, SCL2, SCL2, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(45, SDA0, SDA0, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(46, SCL0, SCL0, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(47, RDN0_A, CMDAT2, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(48, RDP0_A, CMDAT3, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(49, RDN1_A, CMDAT4, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(50, RDP1_A, CMDAT5, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(51, RCN_A, CMDAT6, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(52, RCP_A, CMDAT7, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(53, RDN2_A, CMDAT8, CMCSD3, RES3,
		RES4, RES5, RES6, RES7),
	PIN(54, RDP2_A, CMDAT9, CMCSD2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(55, RDN3_A, CMHSYNC, CMCSD1, RES3,
		RES4, RES5, RES6, RES7),
	PIN(56, RDP3_A, CMVSYNC, CMCSD0, RES3,
		RES4, RES5, RES6, RES7),
	PIN(57, MSDC0_DAT0, MSDC0_DAT0, I2S1_WS, RES3,
		RES4, RES5, RES6, DBG_MON_B_7),
	PIN(58, MSDC0_DAT1, MSDC0_DAT1, I2S1_BCK, RES3,
		RES4, RES5, RES6, DBG_MON_B_8),
	PIN(59, MSDC0_DAT2, MSDC0_DAT2, I2S1_MCK, RES3,
		RES4, RES5, RES6, DBG_MON_B_9),
	PIN(60, MSDC0_DAT3, MSDC0_DAT3, I2S1_DO_1, RES3,
		RES4, RES5, RES6, DBG_MON_B_10),
	PIN(61, MSDC0_DAT4, MSDC0_DAT4, I2S1_DO_2, RES3,
		RES4, RES5, RES6, DBG_MON_B_11),
	PIN(62, MSDC0_DAT5, MSDC0_DAT5, I2S2_WS, RES3,
		RES4, RES5, RES6, DBG_MON_B_12),
	PIN(63, MSDC0_DAT6, MSDC0_DAT6, I2S2_BCK, RES3,
		RES4, RES5, RES6, DBG_MON_B_13),
	PIN(64, MSDC0_DAT7, MSDC0_DAT7, I2S2_DI_1, RES3,
		RES4, RES5, RES6, DBG_MON_B_14),
	PIN(65, MSDC0_CLK, MSDC0_CLK, RES2, RES3,
		RES4, RES5, RES6, DBG_MON_B_16),
	PIN(66, MSDC0_CMD, MSDC0_CMD, I2S2_DI_2, RES3,
		RES4, RES5, RES6, DBG_MON_B_15),
	PIN(67, MSDC0_DSL, MSDC0_DSL, RES2, RES3,
		RES4, RES5, RES6, DBG_MON_B_17),
	PIN(68, MSDC0_RST, MSDC0_RSTB, I2S2_MCK, RES3,
		RES4, RES5, RES6, DBG_MON_B_18),
	PIN(69, SPI_CK, SPI_CK_0, I2S3_DO_1, PWM0,
		PWM5, I2S2_MCK, RES6, DBG_MON_B_19),
	PIN(70, SPI_MI, SPI_MI_0, I2S3_DO_2, PWM1,
		SPI_MO_0, I2S2_DI_1, DSI1_TE, DBG_MON_B_20),
	PIN(71, SPI_MO, SPI_MO_0, I2S3_DO_3, PWM2,
		SPI_MI_0, I2S2_DI_2, RES6, DBG_MON_B_21),
	PIN(72, SPI_CS, SPI_CS_0, I2S3_DO_4, PWM3,
		PWM6, DISP_PWM1, RES6, DBG_MON_B_22),
	PIN(73, MSDC1_DAT0, MSDC1_DAT0, RES2, RES3,
		RES4, RES5, RES6, DBG_MON_B_24),
	PIN(74, MSDC1_DAT1, MSDC1_DAT1, RES2, RES3,
		RES4, RES5, RES6, DBG_MON_B_25),
	PIN(75, MSDC1_DAT2, MSDC1_DAT2, RES2, RES3,
		RES4, RES5, RES6, DBG_MON_B_26),
	PIN(76, MSDC1_DAT3, MSDC1_DAT3, RES2, RES3,
		RES4, RES5, RES6, DBG_MON_B_27),
	PIN(77, MSDC1_CLK, MSDC1_CLK, RES2, RES3,
		RES4, RES5, RES6, DBG_MON_B_28),
	PIN(78, MSDC1_CMD, MSDC1_CMD, RES2, RES3,
		RES4, RES5, RES6, DBG_MON_B_23),
	PIN(79, PWRAP_SPI0_MI, PWRAP_SPIMI, PWRAP_SPIMO, RES3,
		RES4, RES5, RES6, RES7),
	PIN(80, PWRAP_SPI0_MO, PWRAP_SPIMO, PWRAP_SPIMI, RES3,
		RES4, RES5, RES6, RES7),
	PIN(81, PWRAP_SPI0_CK, PWRAP_SPICK, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(82, PWRAP_SPI0_CSN, PWRAP_SPICS, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(83, AUD_CLK_MOSI, AUD_CLK_MOSI, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(84, AUD_DAT_MISO, AUD_DAT_MISO, AUD_DAT_MOSI, RES3,
		RES4, RES5, RES6, RES7),
	PIN(85, AUD_DAT_MOSI, AUD_DAT_MOSI, AUD_DAT_MISO, RES3,
		RES4, RES5, RES6, RES7),
	PIN(86, RTC32K_CK, RTC32K_CK, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(87, DISP_PWM0, DISP_PWM0, DISP_PWM1, RES3,
		RES4, RES5, RES6, DBG_MON_B_31),
	PIN(88, SRCLKENAI, SRCLKENAI, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(89, SRCLKENAI2, SRCLKENAI2, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(90, SRCLKENA0, SRCLKENA0, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(91, SRCLKENA1, SRCLKENA1, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(92, PCM_CLK, PCM1_CLK, I2S0_BCK, RES3,
		RES4, RES5, RES6, DBG_MON_A_24),
	PIN(93, PCM_SYNC, PCM1_SYNC, I2S0_WS, RES3,
		RES4, RES5, RES6, DBG_MON_A_25),
	PIN(94, PCM_RX, PCM1_DI, I2S0_DI, RES3,
		RES4, RES5, RES6, DBG_MON_A_26),
	PIN(95, PCM_TX, PCM1_DO, I2S0_DO, RES3,
		RES4, RES5, RES6, DBG_MON_A_27),
	PIN(96, URXD1, URXD1, UTXD1, RES3,
		RES4, RES5, RES6, DBG_MON_A_28),
	PIN(97, UTXD1, UTXD1, URXD1, RES3,
		RES4, RES5, RES6, DBG_MON_A_29),
	PIN(98, URTS1, URTS1, UCTS1, RES3,
		RES4, RES5, RES6, DBG_MON_A_30),
	PIN(99, UCTS1, UCTS1, URTS1, RES3,
		RES4, RES5, RES6, DBG_MON_A_31),
	PIN(100, MSDC2_DAT0, MSDC2_DAT0, RES2, USB_DRVVBUS_P0,
		SDA5, USB_DRVVBUS_P1, RES6, DBG_MON_B_0),
	PIN(101, MSDC2_DAT1, MSDC2_DAT1, RES2, AUD_SPDIF,
		SCL5, RES5, RES6, DBG_MON_B_1),
	PIN(102, MSDC2_DAT2, MSDC2_DAT2, RES2, UTXD0,
		RES4, PWM0, SPI_CK_1, DBG_MON_B_2),
	PIN(103, MSDC2_DAT3, MSDC2_DAT3, RES2, URXD0,
		RES4, PWM1, SPI_MI_1, DBG_MON_B_3),
	PIN(104, MSDC2_CLK, MSDC2_CLK, RES2, UTXD3,
		SDA3, PWM2, SPI_MO_1, DBG_MON_B_4),
	PIN(105, MSDC2_CMD, MSDC2_CMD, RES2, URXD3,
		SCL3, PWM3, SPI_CS_1, DBG_MON_B_5),
	PIN(106, SDA3, SDA3, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(107, SCL3, SCL3, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(108, JTMS, JTMS, MFG_JTAG_TMS, RES3,
		RES4, AP_MD32_JTAG_TMS, DFD_TMS, RES7),
	PIN(109, JTCK, JTCK, MFG_JTAG_TCK, RES3,
		RES4, AP_MD32_JTAG_TCK, DFD_TCK, RES7),
	PIN(110, JTDI, JTDI, MFG_JTAG_TDI, RES3,
		RES4, AP_MD32_JTAG_TDI, DFD_TDI, RES7),
	PIN(111, JTDO, JTDO, MFG_JTAG_TDO, RES3,
		RES4, AP_MD32_JTAG_TDO, DFD_TDO, RES7),
	PIN(112, JTRST_B, JTRST_B, MFG_JTAG_TRSTN, RES3,
		RES4, AP_MD32_JTAG_TRST, DFD_NTRST, RES7),
	PIN(113, URXD0, URXD0, UTXD0, RES3,
		RES4, RES5, I2S2_WS, DBG_MON_A_0),
	PIN(114, UTXD0, UTXD0, URXD0, RES3,
		RES4, RES5, I2S2_BCK, DBG_MON_A_1),
	PIN(115, URTS0, URTS0, UCTS0, RES3,
		RES4, RES5, I2S2_MCK, DBG_MON_A_2),
	PIN(116, UCTS0, UCTS0, URTS0, RES3,
		RES4, RES5, I2S2_DI_1, DBG_MON_A_3),
	PIN(117, URXD3, URXD3, UTXD3, RES3,
		RES4, RES5, RES6, DBG_MON_A_9),
	PIN(118, UTXD3, UTXD3, URXD3, RES3,
		RES4, RES5, RES6, DBG_MON_A_10),
	PIN(119, KPROW0, KROW0, RES2, RES3,
		RES4, RES5, RES6, DBG_MON_A_11),
	PIN(120, KPROW1, KROW1, RES2, PWM6,
		RES4, RES5, RES6, DBG_MON_A_12),
	PIN(121, KPROW2, KROW2, IRDA_PDN, USB_DRVVBUS_P0,
		PWM4, USB_DRVVBUS_P1, RES6, DBG_MON_A_13),
	PIN(122, KPCOL0, KCOL0, RES2, RES3,
		RES4, RES5, RES6, DBG_MON_A_14),
	PIN(123, KPCOL1, KCOL1, IRDA_RXD, PWM5,
		RES4, RES5, RES6, DBG_MON_A_15),
	PIN(124, KPCOL2, KCOL2, IRDA_TXD, USB_DRVVBUS_P0,
		PWM3, USB_DRVVBUS_P1, RES6, DBG_MON_A_16),
	PIN(125, SDA1, SDA1, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(126, SCL1, SCL1, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(127, LCM_RST, LCM_RST, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(128, I2S0_LRCK, I2S0_WS, I2S1_WS, I2S2_WS,
		RES4, SPI_CK_2, RES6, DBG_MON_A_4),
	PIN(129, I2S0_BCK, I2S0_BCK, I2S1_BCK, I2S2_BCK,
		RES4, SPI_MI_2, RES6, DBG_MON_A_5),
	PIN(130, I2S0_MCK, I2S0_MCK, I2S1_MCK, I2S2_MCK,
		RES4, SPI_MO_2, RES6, DBG_MON_A_6),
	PIN(131, I2S0_DATA0, I2S0_DO, I2S1_DO_1, I2S2_DI_1,
		RES4, SPI_CS_2, RES6, DBG_MON_A_7),
	PIN(132, I2S0_DATA1, I2S0_DI, I2S1_DO_2, I2S2_DI_2,
		RES4, RES5, RES6, DBG_MON_A_8),
	PIN(133, SDA4, SDA4, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(134, SCL4, SCL4, RES2, RES3,
		RES4, RES5, RES6, RES7),
};

struct val_regs {
	uint32_t val;
	uint32_t set;
	uint32_t rst;
	uint32_t align;
};

struct gpio_regs {
	struct val_regs dir[9];
	uint8_t rsv00[112];
	struct val_regs pullen[9];
	uint8_t rsv01[112];
	struct val_regs pullsel[9];
	uint8_t rsv02[112];
	uint8_t rsv03[256];
	struct val_regs dout[9];
	uint8_t rsv04[112];
	struct val_regs din[9];
	uint8_t rsv05[112];
	struct val_regs mode[27];
	uint8_t rsv06[336];
	struct val_regs ies[3];
	struct val_regs smt[3];
	uint8_t rsv07[160];
	struct val_regs tdsel[8];
	struct val_regs rdsel[6];
	uint8_t rsv08[32];
	struct val_regs drv_mode[10];
	uint8_t rsv09[96];
	struct val_regs msdc_rsv0[11];
	struct val_regs msdc2_ctrl5;
	struct val_regs msdc_rsv1[12];
	uint8_t rsv10[64];
	struct val_regs exmd_ctrl[1];
	uint8_t rsv11[48];
	struct val_regs kpad_ctrl[2];
	struct val_regs hsic_ctrl[4];
};

check_member(gpio_regs, msdc2_ctrl5, 0xcb0);
check_member(gpio_regs, hsic_ctrl[3], 0xe50);

static struct gpio_regs *const mtk_gpio = (void *)(GPIO_BASE);

void gpio_init(enum external_power);

#endif /* SOC_MEDIATEK_MT8173_GPIO_H */
