C     MAIN PROGRAM
C
C     Program to compute antenna gains (from ITS HFMUFF program)
C     ref: Barghausen, et al, ESSA Technical Report ERL 110-ITS 78
C
C     Antenna types and parameters
C
C     Rhombic antenna (1)
C     H      feed height (meters/wavelengths)
C     L      leg length (meters/wavelengths)
C     D      tilt angle (degrees)
C     EX     (not used)
C
C     Vertical antenna (2)
C     H      (not used)
C     L      length of driven element (meters/wavelengths)
C     D      length of radials (meters/wavelengths)
C     EX(1)  radial length/diameter ratio
C     EX(2)  number of radials
C
C     Horizontal half-wave dipole (3)
C     H      height (meters/wavelenths)
C     L      length (must be -.5)
C     D      (tilt from horizontal (must be 0.)
C     EX     (not used)
C
C     Horizontal Yagi array (4)
C     H      height (meters/wavelengths)
C     L      length of driven element (meters/wavelengths)
C     D      length of reflector element (meters/wavelengths)
C     EX(1)  length of director element (meters/wavelengths)
C     EX(2)  number of elements (1<elements<11)
C     EX(3)  director spacing (meters/wavelengths)
C     EX(4)  reflector spacing (meters/wavelengths)
C
C     Vertical dipole (5)
C     H      feed height (meters/wavelengths)
C     L      length (meters/wavelengths)
C     D      (not used)
C     EX(1)  element length/diameter ratio
C
C     Curtain array with screen (6)
C     H      height of lowest element (meters/wavelengths)
C     L      lenght of element (meters/wavelengths)
C     D      number of bays (1<bays<6)
C     EX(1)  number of elements in each bay (1<elements<6)
C     EX(2)  bay separation (meters/wavelengths)
C     EX(3)  vertical spacing of elements (meters/wavelengths)
C     EX(4)  screen spacing (meters/wavelengths)
C
C     Terminated sloping VEE (7)
C     H      feed height (meters/wavelengths)
C     L      leg length (meters/wavelengths)
C     D      semi-apex angle (degrees)
C     EX(1)  termination height (meters/wavelengths)
C
C     Inverted L (8)
C     H      height (meters/wavelengths)
C     L      length (meters/wavelengths)
C     D      (not used)
C     EX     (not used)
C
C     Terminated sloping rhombic (9)
C     H      feed height (meters/wavelengths)
C     L      leg length (meters/wavelengths)
C     D      semi-apex angle (degrees)
C     EX(1)  termination height (meters/wavelengths)
C
C     Sloping wire (11)
C     H      feed height (meters/wavelengths)
C     L      length (meters/wavelengths)
C     D      slope from horizontal (degrees)
C     EX     (not used)
C
C     Constant gain (12)
C     H      gain (decibels)
C     L      (not used)
C     D      (not used)
C     EX     (not used)
C
C     Horizontal log-periodic array (13)
C     H      feed height (meters/wavelengths)
C     L      rear element length (meters/wavelengths)
C     D      array slope from vertical (degrees)
C     EX(1)  loaded transmission line impedance (ohms)
C     EX(2)  angle between axis and element tips (degrees)
C     EX(3)  geometric ratio of element lengths
C     EX(4)  Number of elements (1<elements<11)
C
C     Arbitray tilted dipole (14)
C     H      feed height (meters/wavelengths)
C     L      length (meters/wavelengths)
C     D      tilt from horizontal (degrees)
C     EX(1)  element length/diameter ratio
C
C     Half rhombic (15)
C     H      (not used)
C     L      leg length (meters/wavelengths)
C     D      angle between leg and ground (degrees)
C     EX     (not used)
C
      DIMENSION EX(4),RAIN(91)
      COMMON /CON/ D2R,DCL,GAMA,PI,PI2,PIO2,R2D,RO,VOFL
      PI=3.14159265359
      VOFL=2.997925E5
      GAMA=0.5772156649
      PI2=2.*PI
      PIO2=PI/2.
      D2R=PI/180.
      CALL ASSIGN(1,'GAIN.DAT')
      CALL ASSIGN(2,'TT:')
      CALL ASSIGN(3,'GAIN.AZL')
      DEFINE FILE 3(322,182,U,NREC)
      IREC=1
      READ (1,*) SIGMA,ER
500   READ (1,*,END=99) KOP,F,XNH,XNL,XND,EX
      WRITE (2,79)
      WRITE (2,*)'Ground conductivity:',SIGMA,ER
      WRITE (2,*)'Antenna type and frequency:',KOP,F
      WRITE (2,*)'Height, length and angle:',XNH,XNL,XND
      WRITE (2,*)'Array parameters:',EX
      DO 300 I=1,46
      E=(I-1)*2.
      D=E*PI/180.
      DO 210 J=1,91
      B=(J-1)*2
      GOTO (10,40,10,20,40,30,10,10,10,87,10,10,20,60,10),IABS(KOP)
C
10    K=IGAIN1(KOP,D,B,F,SIGMA,ER,XND,XNL,XNH,EX,RIX,EFF,RIN)
      GOTO 200
C
20    K=IGAIN3(KOP,D,B,F,SIGMA,ER,XND,XNL,XNH,EX,RIX,EFF,RIN)
      GOTO 200
C
30    K=IGAIN2(KOP,D,B,F,SIGMA,ER,XND,XNL,XNH,EX,RIX,EFF,RIN)
      GOTO 200
C
40    IF (J.GT.1) GOTO 210
60    K=IGAIN4(KOP,D,B,F,SIGMA,ER,XND,XNL,XNH,EX,RIX,EFF,RIN)
200   GOTO (82,83,87),K
C
82    IF (RIX.GT.0.) GOTO 84
83    RIX=-30.
      GOTO 86
C
84    RIX=10.*ALOG10(RIX)+EFF
      IF (RIX.LT.-30.) GOTO 83
86    IF (KOP.LT.0) GOTO 210
      KOP=-KOP
      WRITE (2,*)'Radiation resistance, efficiency:',RIN,EFF
      WRITE (2,80)((K-1)*2.,K=1,91,5)
210   RAIN(J)=RIX
      WRITE (2,100)E,(RAIN(K),K=1,91,5)
      WRITE (3'IREC)RAIN
      IREC=IREC+1
300   CONTINUE
      GOTO 500
C
87    WRITE (2,*)'Bad antenna parameters'
      GOTO 500
C
99    CALL CLOSE(1)
      CALL CLOSE(2)
      CALL CLOSE(3)
      STOP
C
79    FORMAT ('1Antenna Gain Characteristics')
80    FORMAT (' Elevation/Azimuth Plot'/'      ',19F6.1)
100   FORMAT (20F6.1)
      END
C     CANG FUNCTION
      FUNCTION CANG(C)
      COMPLEX C
      CX = REAL(C)
      CY = AIMAG(C)
      CANG = ATAN2(CY, CX)
      RETURN
      END
      COMPLEX FUNCTION CSZ1 (X)
      COMMON /CON/ D2R,DCL,GAMA,PI,PI2,PIO2,R2D,RO,VOFL
      COMPLEX A,AM1,AM2,B,BM1,BM2,SA
      DATA  TESTQ/4.0E-10/
      IF (X.GT.6.0) GO TO 5
      EN=0.0
      X2=X**2
      TN=X
      SI=X
1     EN=EN+1.0
      TN=-TN*X2*(2.0*EN-1.0)/((2.0*EN)*(2.0*EN+1.0)**2)
      IF (ABS(TN/SI).LE.TESTQ) GO TO 2
      SI=SI+TN
      GO TO 1
2     EN=1.0
      TN=-X2/4.0
      CI=TN+GAMA+ALOG(X)
3     EN=EN+1.0
      TN=-TN*X2*(2.0*EN-2.0)/((2.0*EN-1.0)*(2.0*EN)**2)
      IF (ABS(TN/CI).LE.TESTQ) GO TO 4
      CI=CI+TN
      GO TO 3
4     CSZ1=CMPLX(CI,-SI)
      GO TO 10
5     AM1=(1.0,0.0)
      AM2=(1.0,0.0)
      BM1=(1.0,0.0)
      BM2=(0.0,0.0)
      P=0.0
      K=0
      TM1=0.0
6     P=P+1.0
      K=K+1
      IF (MOD(K,2).EQ.0) GO TO 7
      SA=CMPLX(0.0,(P+1.0)/(2.0*X))
      GO TO 8
7     SA=CMPLX(0.0,P/(2.0*X))
8     A=AM1+SA*AM2
      B=BM1+SA*BM2
      CSZ1=A/B
      T=CABS(CSZ1)
      IF (ABS((T-TM1)/T).LE.TESTQ) GO TO 9
      AM2=AM1
      AM1=A
      BM2=BM1
      BM1=B
      TM1=T
      GO TO 6
9     CSZ1=CMPLX(0.0,PIO2)+CMPLX(COS(X),SIN(X))/(CMPLX(0.0,X)*CSZ1)
      CSZ1=CONJG(CSZ1)
10    RETURN
      END
                                                                                                                                                                                                                                                                                                                                              