%!PS-Adobe-2.0
%%Title: PADS Postscript Driver Header
%%Creator: Andy Montalvo, 18 Lupine St., Lowell, MA  01851
%%CreationDate: 06/08/90
%%For: CAD Software, Littleton, MA
%%EndComments
%%BeginProcSet: Markers 1.0 0
% marker attributes
/MAttr_Width 1 def
/MAttr_Size  0 def
/MAttr_Type /M1 def
% procedures
/M1 { %def
% draw marker 1: plus
% Stack: - M1 -
    -2 0 rmoveto
    4 0 rlineto
    -2 2 rmoveto
    0 -4 rlineto
} bind def
/M2 { %def
% draw marker 2: cross
% Stack: - M2 -
    -2 -2 rmoveto
    4 4 rlineto
    -4 0 rmoveto
    4 -4 rlineto
} bind def
/M3 { %def
% draw marker 3: square
% Stack: - M3 -
    0 2 rlineto
    2 0 rlineto
    0 -4 rlineto
    -4 0 rlineto
    0 4 rlineto
    2 0 rlineto
} bind def
/M4 { %def
% draw marker 4: diamond
% Stack: - M4 -
    0 2 rlineto
    2 -2 rlineto
    -2 -2 rlineto
    -2 2 rlineto
    2 2 rlineto
} bind def
/M5 { %def
% draw marker 5: hourglass
% Stack: - M5 -
    2 2 rlineto
    -4 0 rlineto
    4 -4 rlineto
    -4 0 rlineto
    2 2 rlineto
} bind def
/M6 { %def
% draw marker 6: bowtie
% Stack: - M6 -
    2 2 rlineto
    0 -4 rlineto
    -4 4 rlineto
    0 -4 rlineto
    2 2 rlineto
} bind def
/M7 { %def
% draw marker 7: small plus (goes with char marker)
% Stack: - M7 -
    -1 0 rmoveto
    2 0 rlineto
    -1 1 rmoveto
    0 -2 rlineto
} bind def
/Marker { %def
% Command from driver: draw marker
% STACK: x y Marker -
    MAttr_Size 0 gt
    {
        gsave
        moveto
        MAttr_Size 4 div dup scale
        MAttr_Type load exec
        4 MAttr_Size div dup scale
        MAttr_Width setlinewidth
        stroke
        grestore
    } if
} def
%%EndProcSet: Markers 1.0 0
%%BeginProcSet: Lib 1.0 0
/sg { %def
% Command from driver: set the gray scale 0 - 100
% STACK: greylevel sg
    100 div dup setgray /glev exch def
} bind def
/Circle { %def
% draw a circle
% STACK: x y radius Circle -
    0 360 arc
} bind def
/RndAper { %def
% select a round aperture
% STACK: - RndAper -
    1 setlinejoin
    1 setlinecap
} bind def
/SqrAper { %def
% select a square aperture
% STACK: - SqrAper -
    0 setlinejoin
    2 setlinecap
} bind def
/Line { %def
% draw a set of connected lines
% STACK: x1 y1 [ x2 y2 ... xn yn ] Line -
    3 1 roll
    moveto
    true
    exch
    % This pushes the x then the y then does lineto
    { exch  { false } { lineto true } ifelse } forall
    pop
} bind def
/Clipto { %def
% set clipping rectangle from 0,0 to new values
% STACK: x y Clipto -
    0 0 moveto
    dup 0 exch lineto
    2 copy lineto
    pop
    0 lineto
    closepath
    clip
    newpath
} bind def
/Clip4 { %def
% set clipping rectangle from xmin,ymin to xmax,ymax
% STACK: xmin ymin xmax ymax Clip4 -
    4 copy pop pop moveto
    4 copy pop exch lineto pop
    2 copy lineto
    exch pop exch pop lineto
    closepath
    clip
    newpath
} bind def
%%EndProcSet: Lib 1.0 0
%%BeginProcSet: Lines 1.0 0
% line attributes %
/LAttr_Width 1 def
% line procedures
/PLine { %def
% Cammand from driver: draw a set of connected lines
% STACK: x1 y1 [ x2 y2 ... xn yn ] PLine -
    Line
    LAttr_Width setlinewidth
    stroke
} bind def % PLine
/Char { %def
% Command from driver: draw a character at the current position
% STACK: type x y stroke_array Char -
%    stroke array -- [ stroke1 stroke2 ... stroken ]
%    stroke -- connected staight lines
%    type = 0 if text  1 if marker
    gsave
    4 1 roll
    translate
    0 eq { TAttr_Width } { MAttr_Width } ifelse setlinewidth
    {
        dup length 2 gt
        {
            dup dup 0 get exch 1 get % get starting point
            3 -1 roll                % put x y before array
            dup length 2 sub 2 exch getinterval % delete first items from array
            Line
            stroke
        }
        {
            aload pop currentlinewidth 2 div Circle fill
        } ifelse
    } forall
    grestore
} bind def % Char
/PArc { %def
% Command from driver: draw an arc
% STACK: x y radius startangle deltaangle Arc -
	 10 div exch 10 div exch
    2 copy pop add
    arc
    LAttr_Width setlinewidth
    stroke
} bind def
/PCircle { %def
% Command from driver: draw an circle
% STACK: x y radius PCircle -
    Circle
    LAttr_Width setlinewidth
    stroke
} bind def
%%EndProcSet: Lines 1.0 0
%%BeginProcSet: Polygon 1.0 0
% polygon attributes %
/PAttr_ExtWidth 1 def
/PAttr_IntWidth 1 def
/PAttr_Grid 1 def
% polygon procedures
/LoopSet { %def
% set up for loop condition
% STACK: start end LoopSet low gridwidth high
    2 copy lt { exch } if
    % make grid line up to absolute coordinates
    PAttr_Grid div truncate PAttr_Grid mul exch
    PAttr_Grid exch
} bind def
/Hatch { %def
% draw cross hatch pattern in current path
% STACK: - Hatch -
    pathbbox
    /ury exch def
    /urx exch def
    /lly exch def
    /llx exch def
    clip
    newpath
    llx urx LoopSet
    { % x loop
        dup lly exch ury moveto lineto
    } for
    lly ury LoopSet
    { % y loop
        llx exch dup urx exch moveto lineto
    } for
    PAttr_IntWidth setlinewidth
    stroke
} bind def
/PPoly { %def
% Command from driver: draw a plygon
% STACK: x1 y1 [ x2 y2 ... xn yn ] PLine -
    Line
    closepath
    gsave
    PAttr_IntWidth PAttr_Grid ge {fill} {Hatch} ifelse
    grestore
    PAttr_ExtWidth setlinewidth
    stroke
} bind def
%%EndProcSet: Polygon 1.0 0
%%BeginProcSet: Text 1.0 0
% text attributes %
/TAttr_Mirr 0 def
/TAttr_Orient 0 def
/TAttr_Width 1 def
% text procedures
/Text { %def
% Command from driver: Draw text
% STACK: x y width string Text -
    gsave
    4 2 roll
    translate
    TAttr_Mirr 0 gt
    {
        -1 1 scale
    } if
    TAttr_Orient rotate
    0 0 moveto
    dup length dup 1 gt
    {
        exch dup stringwidth pop
        4 -1 roll
        exch 2 copy
        lt
        {
            div 1 scale show
        }
        {
            sub
            3 -1 roll 1 sub div
            0 3 -1 roll ashow
        }
        ifelse
    }
    {
        pop
        show
    } ifelse
    grestore
} bind def
%%EndProcSet: Text 1.0 0
%%BeginProcSet: FlashSymbols 1.0 0
% flash symbol attributes %
/FAttr_Type /PRndPad def
/FAttr_Width  0 def
/FAttr_Length 1 def
/FAttr_Orient 0 def
% flash symbol procedures
/PRndPad { %def
% Command from driver: draw an circular pad
% STACK: - PCirclePad -
    FAttr_Width dup scale
    0 0 .5 Circle
    fill
} bind def
/PSqrPad { %def
% Draw an Square pad
% STACK: - PRectPad -
    FAttr_Width dup scale
    .5 .5 moveto
    -.5 .5 lineto
    -.5 -.5 lineto
    .5 -.5 lineto
    closepath
    fill
} bind def
/PRectPad { %def
% Draw an rectangular pad
% STACK: - PRectPad -
    FAttr_Length FAttr_Width scale
    .5 .5 moveto
    -.5 .5 lineto
    -.5 -.5 lineto
    .5 -.5 lineto
    closepath
    fill
} bind def
/POvalPad { %def
% Draw an oval pad
% STACK: - POvalPad -
    FAttr_Width setlinewidth
    FAttr_Length FAttr_Width sub 2 div dup
    neg 0 moveto
    0 lineto
    RndAper
    stroke
} bind def
/Anl { %def
    0 0 .5 Circle
    fill
    FAttr_Length FAttr_Width lt
    { % inner circle
        0 0
        FAttr_Length 0 gt { FAttr_Length FAttr_Width div } { .5 } ifelse
        2 div Circle
        1 setgray
        fill
        glev setgray
    } if
} bind def
/PAnlPad { %def
% Draw an annular pad
% STACK: - PAnlPad -
    FAttr_Width dup scale
    Anl
} bind def
/PRelPad { %def
% Draw an thermal relief pad
% STACK: - PRelPad -
    PAnlPad
    1 setgray
    .17 setlinewidth
    0 setlinecap   % the x
    45 rotate
    .5 0 moveto -.5 0 lineto
    0 .5 moveto  0 -.5 lineto
    stroke
    glev setgray
} bind def
/Flash { %def
% Command from driver: Flash a symbol
% STACK: x y Flash -
    FAttr_Width 0 gt
    {
        gsave
        translate
        FAttr_Orient rotate
        FAttr_Type load exec
        grestore
    } if
} def
%%EndProcSet: FlashSymbols 1.0 0
%%BeginProcSet: SetAttr 1.0 0
/SetLine { %def
% Set the width of the lines
% STACK: linewidth SetLine -
    /LAttr_Width exch def
    RndAper
} bind def
/SetPoly { %def
% Set attribute of polygon
% STACK: external_width internal_grid_width grid_spacing SetPoly -
    /PAttr_Grid exch def
    /PAttr_IntWidth exch def
    /PAttr_ExtWidth exch def
    RndAper
} bind def
/SetFlash { %def
% Set Attributed of flash pad
% STACK: orientation_angle length width aperture_type SetFlash -
    /FAttr_Type exch def
    FAttr_Type /PSqrPad eq FAttr_Type /PRectPad eq or
    { SqrAper } { RndAper } ifelse
    /FAttr_Width exch def
    /FAttr_Length exch def
    /FAttr_Orient exch 10 div def
} bind def
/SetMkr { %def
% Set attributes of markers
% STACK: linewidth size type SetMkr -
    /MAttr_Type exch def
    /MAttr_Size exch def
    /MAttr_Width exch def
    RndAper
} bind def
/SetText1 { %def
% Set attributes of text
% STACK: fontname height orient mirror SetMkr -
    /TAttr_Mirr exch def
    /TAttr_Orient exch 10 div def
    exch findfont exch scalefont setfont
    RndAper
} bind def
/SetText2 { %def
% Set attributes of text
% STACK: linewidth height mirror orient SetMkr -
    /TAttr_Width exch def
    RndAper
} bind def
%%EndProcSet: SetAttr 1.0 0
%%BeginProcSet: Initialize 1.0 0
/Init { %def
% Initialize the driver
% STACK: Init -
    72 1000 div dup scale % Scale to 1/1000 inch
    250 250 translate     % make origin 1/4 inch from bottom left
    1.5 setmiterlimit 1 RndAper                     % set line defaults
    0 setgray                                       % set color default
    /glev 0 def
} def
%%EndProcSet: Initialize 1.0 0
%%EndProlog
/Helvetica findfont 12 scalefont setfont
35 760 moveto
(lr.job - Fri Jul 17 02:19:23 1992) show
gsave
Init
8000 10500 Clipto
6062 9252 translate
90 rotate
1 1 div dup scale
75 sg
50 sg
25 sg
0 sg
200 SetLine
-6650 1450 [ -6650 3700 ] PLine
100 SetLine
-6650 3750 [ -7875 3750 ] PLine
25 25 50 SetPoly
-7175 3700 [ -7175 3750 -7800 3750 -7800 3550 -7650 3425 -7550 3425 -7425 3550 -7425 3700 -7325 3700 -7325 3525 -7175 3525 -7175 3700 -7125 3700 -7125 3375 -7375 3375 -7375 3075 -7475 3075 -7475 2775 -7625 2775 -7625 2925 -7775 2925 -7775 2775 -7650 2775 -7650 2325 -7825 2325 -7825 3700 -7175 3700 ] PPoly
25 25 50 SetPoly
-6925 3725 [ -6925 3550 -7025 3550 -7025 3400 -6925 3400 -6925 3275 -7050 3075 -7125 3075 -7125 2775 -6850 2775 -6850 2550 -6675 2550 -6675 3725 -6925 3725 ] PPoly
25 25 50 SetPoly
-7875 2325 [ -7775 2325 -7775 1875 -7625 1875 -7625 2000 -7475 2000 -7475 1875 -7525 1875 -7525 1725 -7225 1725 -7225 1875 -7025 1875 -7025 1800 -7100 1800 -7100 1500 -6800 1500 -6800 1450 -7225 1450 -7225 1575 -7450 1575 -7450 1625 -7600 1625 -7600 1475 -7575 1475 -7575 1375 -7875 1375 -7875 2325 ] PPoly
25 25 50 SetPoly
-6850 2525 [ -6850 2200 -7025 2200 -7025 1800 -6800 1800 -6800 1425 -6675 1425 -6675 2525 -6850 2525 ] PPoly
100 SetLine
-7450 1400 [ -6656 1400 ] PLine
25 25 50 SetPoly
-7450 2775 [ -7375 2775 -7375 2225 -7450 2225 -7450 2775 ] PPoly
25 25 50 SetPoly
-7050 2775 [ -7050 2475 -7175 2475 -7175 2350 -7250 2225 -7275 2225 -7275 2775 -7050 2775 ] PPoly
200 SetLine
-7875 3700 [ -7875 1450 ] PLine
100 SetLine
-7875 1400 [ -7600 1400 ] PLine
10 SetLine
-7805 3900 [ -8005 3900 ] PLine
-8005 3900 [ -8005 3700 ] PLine
10 SetLine
-8000 200 [ -8000 0 ] PLine
-8000 0 [ -7800 0 ] PLine
10 SetLine
-200 0 [ 0 0 ] PLine
0 0 [ 0 200 ] PLine
10 SetLine
-200 3892 [ 0 3892 ] PLine
0 3892 [ 0 3692 ] PLine
0 0 60 /PRndPad SetFlash
-7100 3150 Flash
-6800 3150 Flash
-7400 3000 Flash
-7700 3000 Flash
-7400 2850 Flash
-7700 2850 Flash
-7700 2250 Flash
-7400 2250 Flash
-7700 2100 Flash
-7400 2100 Flash
-7100 2250 Flash
-6800 2250 Flash
-7400 1950 Flash
-7700 1950 Flash
-7100 1950 Flash
-6800 1950 Flash
-7450 1100 Flash
-7650 1100 Flash
-7300 1800 Flash
-7300 1500 Flash
-7400 1250 Flash
-7700 1250 Flash
-6500 800 Flash
-6800 800 Flash
-6900 800 Flash
-7200 800 Flash
-6150 1100 Flash
-6150 1400 Flash
-7500 800 Flash
-7700 800 Flash
-7300 350 Flash
-7300 650 Flash
-7400 950 Flash
-7700 950 Flash
-4850 2600 Flash
-4850 2900 Flash
-6000 3050 Flash
-6000 2850 Flash
-6650 400 Flash
-6350 400 Flash
-6350 600 Flash
-6650 600 Flash
-6000 800 Flash
-6200 800 Flash
-5600 450 Flash
-5600 750 Flash
-5925 950 Flash
-6225 950 Flash
-6300 2200 Flash
-6300 2500 Flash
-6450 2200 Flash
-6450 2500 Flash
-5850 2300 Flash
-5850 2500 Flash
-6000 2200 Flash
-6000 2500 Flash
-5700 2450 Flash
-5400 2450 Flash
-4850 2450 Flash
-5150 2450 Flash
-550 700 Flash
-550 500 Flash
-4450 3100 Flash
-4450 3400 Flash
-2250 3700 Flash
-2250 3400 Flash
-1350 3700 Flash
-1350 3400 Flash
-4450 2800 Flash
-4450 2500 Flash
-2950 2800 Flash
-2950 2500 Flash
-4450 2100 Flash
-4450 1800 Flash
-3050 2100 Flash
-3050 1800 Flash
-4450 1400 Flash
-4450 1100 Flash
-3450 1400 Flash
-3450 1100 Flash
-4450 800 Flash
-4450 500 Flash
-2050 800 Flash
-2050 500 Flash
-4750 700 Flash
-4750 500 Flash
-750 700 Flash
-750 500 Flash
-4800 3500 Flash
-4800 3300 Flash
-4750 1300 Flash
-4750 1100 Flash
0 0 60 /PSqrPad SetFlash
-7700 3300 Flash
0 0 60 /PRndPad SetFlash
-7300 3300 Flash
0 0 60 /PSqrPad SetFlash
-7300 3150 Flash
0 0 60 /PRndPad SetFlash
-7700 3150 Flash
0 0 60 /PSqrPad SetFlash
-4750 2150 Flash
0 0 60 /PRndPad SetFlash
-5150 2150 Flash
0 0 60 /PSqrPad SetFlash
-5700 3050 Flash
0 0 60 /PRndPad SetFlash
-5300 3050 Flash
0 0 60 /PSqrPad SetFlash
-6150 2200 Flash
0 0 60 /PRndPad SetFlash
-6150 2600 Flash
0 0 50 /PSqrPad SetFlash
-6877 1721 Flash
0 0 50 /PRndPad SetFlash
-6947 1751 Flash
-7017 1721 Flash
-7047 1651 Flash
-7017 1581 Flash
-6947 1551 Flash
-6877 1581 Flash
-6847 1651 Flash
0 0 60 /PSqrPad SetFlash
-7250 950 Flash
0 0 60 /PRndPad SetFlash
-7150 950 Flash
-7050 950 Flash
-6950 950 Flash
-6850 950 Flash
-6750 950 Flash
-6650 950 Flash
-6550 950 Flash
-6550 1250 Flash
-6650 1250 Flash
-6750 1250 Flash
-6850 1250 Flash
-6950 1250 Flash
-7050 1250 Flash
-7150 1250 Flash
-7250 1250 Flash
0 0 50 /PSqrPad SetFlash
-6880 570 Flash
0 0 50 /PRndPad SetFlash
-6950 600 Flash
-7020 570 Flash
-7050 500 Flash
-7020 430 Flash
-6950 400 Flash
-6880 430 Flash
-6850 500 Flash
0 0 60 /PRndPad SetFlash
-6400 2800 Flash
-6200 2800 Flash
-6300 2800 Flash
0 0 177 /PRndPad SetFlash
-6300 3550 Flash
0 0 50 /PSqrPad SetFlash
-6166 571 Flash
0 0 50 /PRndPad SetFlash
-6196 501 Flash
-6166 431 Flash
-6096 401 Flash
-6026 431 Flash
-5996 501 Flash
-6026 571 Flash
-6096 601 Flash
0 0 60 /PSqrPad SetFlash
-5650 950 Flash
0 0 60 /PRndPad SetFlash
-5550 950 Flash
-5450 950 Flash
-5350 950 Flash
-5250 950 Flash
-5150 950 Flash
-5050 950 Flash
-4950 950 Flash
-4950 1250 Flash
-5050 1250 Flash
-5150 1250 Flash
-5250 1250 Flash
-5350 1250 Flash
-5450 1250 Flash
-5550 1250 Flash
-5650 1250 Flash
0 0 60 /PSqrPad SetFlash
-5650 2600 Flash
0 0 60 /PRndPad SetFlash
-5550 2600 Flash
-5450 2600 Flash
-5350 2600 Flash
-5250 2600 Flash
-5150 2600 Flash
-5050 2600 Flash
-5050 2900 Flash
-5150 2900 Flash
-5250 2900 Flash
-5350 2900 Flash
-5450 2900 Flash
-5550 2900 Flash
-5650 2900 Flash
0 0 60 /PSqrPad SetFlash
-5650 1550 Flash
0 0 60 /PRndPad SetFlash
-5550 1550 Flash
-5450 1550 Flash
-5350 1550 Flash
-5250 1550 Flash
-5150 1550 Flash
-5050 1550 Flash
-4950 1550 Flash
-4950 1850 Flash
-5050 1850 Flash
-5150 1850 Flash
-5250 1850 Flash
-5350 1850 Flash
-5450 1850 Flash
-5550 1850 Flash
-5650 1850 Flash
0 0 60 /PSqrPad SetFlash
-4350 3100 Flash
0 0 60 /PRndPad SetFlash
-4250 3100 Flash
-4150 3100 Flash
-4050 3100 Flash
-3950 3100 Flash
-3850 3100 Flash
-3750 3100 Flash
-3650 3100 Flash
-3550 3100 Flash
-3450 3100 Flash
-3350 3100 Flash
-3250 3100 Flash
-3150 3100 Flash
-3050 3100 Flash
-2950 3100 Flash
-2850 3100 Flash
-2750 3100 Flash
-2650 3100 Flash
-2550 3100 Flash
-2450 3100 Flash
-2450 3700 Flash
-2550 3700 Flash
-2650 3700 Flash
-2750 3700 Flash
-2850 3700 Flash
-2950 3700 Flash
-3050 3700 Flash
-3150 3700 Flash
-3250 3700 Flash
-3350 3700 Flash
-3450 3700 Flash
-3550 3700 Flash
-3650 3700 Flash
-3750 3700 Flash
-3850 3700 Flash
-3950 3700 Flash
-4050 3700 Flash
-4150 3700 Flash
-4250 3700 Flash
-4350 3700 Flash
0 0 60 /PSqrPad SetFlash
-2950 1800 Flash
0 0 60 /PRndPad SetFlash
-2850 1800 Flash
-2750 1800 Flash
-2650 1800 Flash
-2550 1800 Flash
-2450 1800 Flash
-2350 1800 Flash
-2250 1800 Flash
-2250 2100 Flash
-2350 2100 Flash
-2450 2100 Flash
-2550 2100 Flash
-2650 2100 Flash
-2750 2100 Flash
-2850 2100 Flash
-2950 2100 Flash
0 0 60 /PSqrPad SetFlash
-4350 1800 Flash
0 0 60 /PRndPad SetFlash
-4250 1800 Flash
-4150 1800 Flash
-4050 1800 Flash
-3950 1800 Flash
-3850 1800 Flash
-3750 1800 Flash
-3650 1800 Flash
-3550 1800 Flash
-3450 1800 Flash
-3450 2100 Flash
-3550 2100 Flash
-3650 2100 Flash
-3750 2100 Flash
-3850 2100 Flash
-3950 2100 Flash
-4050 2100 Flash
-4150 2100 Flash
-4250 2100 Flash
-4350 2100 Flash
0 0 60 /PSqrPad SetFlash
-4350 2500 Flash
0 0 60 /PRndPad SetFlash
-4250 2500 Flash
-4150 2500 Flash
-4050 2500 Flash
-3950 2500 Flash
-3850 2500 Flash
-3750 2500 Flash
-3650 2500 Flash
-3550 2500 Flash
-3450 2500 Flash
-3350 2500 Flash
-3250 2500 Flash
-3250 2800 Flash
-3350 2800 Flash
-3450 2800 Flash
-3550 2800 Flash
-3650 2800 Flash
-3750 2800 Flash
-3850 2800 Flash
-3950 2800 Flash
-4050 2800 Flash
-4150 2800 Flash
-4250 2800 Flash
-4350 2800 Flash
0 0 60 /PSqrPad SetFlash
-1950 1100 Flash
0 0 60 /PRndPad SetFlash
-1850 1100 Flash
-1750 1100 Flash
-1650 1100 Flash
-1550 1100 Flash
-1450 1100 Flash
-1350 1100 Flash
-1250 1100 Flash
-1150 1100 Flash
-1050 1100 Flash
-950 1100 Flash
-850 1100 Flash
-750 1100 Flash
-650 1100 Flash
-650 1500 Flash
-750 1500 Flash
-850 1500 Flash
-950 1500 Flash
-1050 1500 Flash
-1150 1500 Flash
-1250 1500 Flash
-1350 1500 Flash
-1450 1500 Flash
-1550 1500 Flash
-1650 1500 Flash
-1750 1500 Flash
-1850 1500 Flash
-1950 1500 Flash
0 0 60 /PSqrPad SetFlash
-1950 500 Flash
0 0 60 /PRndPad SetFlash
-1850 500 Flash
-1750 500 Flash
-1650 500 Flash
-1550 500 Flash
-1450 500 Flash
-1350 500 Flash
-1250 500 Flash
-1150 500 Flash
-1050 500 Flash
-1050 800 Flash
-1150 800 Flash
-1250 800 Flash
-1350 800 Flash
-1450 800 Flash
-1550 800 Flash
-1650 800 Flash
-1750 800 Flash
-1850 800 Flash
-1950 800 Flash
0 0 60 /PSqrPad SetFlash
-1950 2500 Flash
0 0 60 /PRndPad SetFlash
-1850 2500 Flash
-1750 2500 Flash
-1650 2500 Flash
-1550 2500 Flash
-1450 2500 Flash
-1350 2500 Flash
-1250 2500 Flash
-1150 2500 Flash
-1050 2500 Flash
-950 2500 Flash
-850 2500 Flash
-750 2500 Flash
-650 2500 Flash
-650 3100 Flash
-750 3100 Flash
-850 3100 Flash
-950 3100 Flash
-1050 3100 Flash
-1150 3100 Flash
-1250 3100 Flash
-1350 3100 Flash
-1450 3100 Flash
-1550 3100 Flash
-1650 3100 Flash
-1750 3100 Flash
-1850 3100 Flash
-1950 3100 Flash
0 0 60 /PSqrPad SetFlash
-1950 1700 Flash
0 0 60 /PRndPad SetFlash
-1850 1700 Flash
-1750 1700 Flash
-1650 1700 Flash
-1550 1700 Flash
-1450 1700 Flash
-1350 1700 Flash
-1250 1700 Flash
-1150 1700 Flash
-1050 1700 Flash
-950 1700 Flash
-850 1700 Flash
-750 1700 Flash
-650 1700 Flash
-650 2300 Flash
-750 2300 Flash
-850 2300 Flash
-950 2300 Flash
-1050 2300 Flash
-1150 2300 Flash
-1250 2300 Flash
-1350 2300 Flash
-1450 2300 Flash
-1550 2300 Flash
-1650 2300 Flash
-1750 2300 Flash
-1850 2300 Flash
-1950 2300 Flash
0 0 60 /PSqrPad SetFlash
-2850 2500 Flash
0 0 60 /PRndPad SetFlash
-2750 2500 Flash
-2650 2500 Flash
-2550 2500 Flash
-2450 2500 Flash
-2350 2500 Flash
-2250 2500 Flash
-2250 2800 Flash
-2350 2800 Flash
-2450 2800 Flash
-2550 2800 Flash
-2650 2800 Flash
-2750 2800 Flash
-2850 2800 Flash
0 0 60 /PSqrPad SetFlash
-4350 500 Flash
0 0 60 /PRndPad SetFlash
-4250 500 Flash
-4150 500 Flash
-4050 500 Flash
-3950 500 Flash
-3850 500 Flash
-3750 500 Flash
-3650 500 Flash
-3550 500 Flash
-3450 500 Flash
-3350 500 Flash
-3250 500 Flash
-3250 800 Flash
-3350 800 Flash
-3450 800 Flash
-3550 800 Flash
-3650 800 Flash
-3750 800 Flash
-3850 800 Flash
-3950 800 Flash
-4050 800 Flash
-4150 800 Flash
-4250 800 Flash
-4350 800 Flash
0 0 60 /PSqrPad SetFlash
-3350 1100 Flash
0 0 60 /PRndPad SetFlash
-3250 1100 Flash
-3150 1100 Flash
-3050 1100 Flash
-2950 1100 Flash
-2850 1100 Flash
-2750 1100 Flash
-2650 1100 Flash
-2550 1100 Flash
-2450 1100 Flash
-2350 1100 Flash
-2250 1100 Flash
-2250 1400 Flash
-2350 1400 Flash
-2450 1400 Flash
-2550 1400 Flash
-2650 1400 Flash
-2750 1400 Flash
-2850 1400 Flash
-2950 1400 Flash
-3050 1400 Flash
-3150 1400 Flash
-3250 1400 Flash
-3350 1400 Flash
0 0 60 /PSqrPad SetFlash
-2150 3400 Flash
0 0 60 /PRndPad SetFlash
-2050 3400 Flash
-1950 3400 Flash
-1850 3400 Flash
-1750 3400 Flash
-1650 3400 Flash
-1550 3400 Flash
-1550 3700 Flash
-1650 3700 Flash
-1750 3700 Flash
-1850 3700 Flash
-1950 3700 Flash
-2050 3700 Flash
-2150 3700 Flash
0 0 60 /PSqrPad SetFlash
-4350 1100 Flash
0 0 60 /PRndPad SetFlash
-4250 1100 Flash
-4150 1100 Flash
-4050 1100 Flash
-3950 1100 Flash
-3850 1100 Flash
-3750 1100 Flash
-3750 1400 Flash
-3850 1400 Flash
-3950 1400 Flash
-4050 1400 Flash
-4150 1400 Flash
-4250 1400 Flash
-4350 1400 Flash
0 0 60 /PSqrPad SetFlash
-1250 3400 Flash
0 0 60 /PRndPad SetFlash
-1150 3400 Flash
-1050 3400 Flash
-950 3400 Flash
-850 3400 Flash
-750 3400 Flash
-650 3400 Flash
-650 3700 Flash
-750 3700 Flash
-850 3700 Flash
-950 3700 Flash
-1050 3700 Flash
-1150 3700 Flash
-1250 3700 Flash
-7250 3600 Flash
-7150 3600 Flash
0 0 70 /PRndPad SetFlash
-271 2698 Flash
-271 2590 Flash
-271 2482 Flash
-271 2374 Flash
-271 2266 Flash
-271 2158 Flash
-271 2050 Flash
-271 1942 Flash
-271 1834 Flash
-271 1726 Flash
-271 1618 Flash
-271 1510 Flash
-271 1402 Flash
-157 2644 Flash
-157 2536 Flash
-157 2428 Flash
-157 2320 Flash
-157 2212 Flash
-157 2104 Flash
-157 1996 Flash
-157 1888 Flash
-157 1780 Flash
-157 1672 Flash
-157 1564 Flash
-157 1456 Flash
0 0 177 /PRndPad SetFlash
-214 1110 Flash
-214 2990 Flash
900 400 70 /POvalPad SetFlash
-900 -100 Flash
-1000 -100 Flash
-1100 -100 Flash
-1200 -100 Flash
-1300 -100 Flash
-1400 -100 Flash
-1500 -100 Flash
-1600 -100 Flash
-1700 -100 Flash
-1800 -100 Flash
-1900 -100 Flash
-2000 -100 Flash
-2100 -100 Flash
-2200 -100 Flash
-2300 -100 Flash
-2400 -100 Flash
-2500 -100 Flash
-2600 -100 Flash
-2700 -100 Flash
-2800 -100 Flash
-2900 -100 Flash
-3000 -100 Flash
-3100 -100 Flash
-3200 -100 Flash
-3300 -100 Flash
-3400 -100 Flash
-3500 -100 Flash
-3600 -100 Flash
-3700 -100 Flash
-3800 -100 Flash
-3900 -100 Flash
0 0 60 /PSqrPad SetFlash
-7000 3625 Flash
0 0 60 /PRndPad SetFlash
-7000 3325 Flash
-7000 3475 Flash
-6700 3625 Flash
-6700 3325 Flash
0 0 90 /PRndPad SetFlash
-6850 3675 Flash
-6850 3275 Flash
0 0 60 /PSqrPad SetFlash
-7100 2400 Flash
0 0 60 /PRndPad SetFlash
-7100 2700 Flash
-7100 2550 Flash
-7400 2400 Flash
-7400 2700 Flash
0 0 90 /PRndPad SetFlash
-7250 2350 Flash
-7250 2750 Flash
0 0 60 /PSqrPad SetFlash
-7525 2400 Flash
0 0 60 /PRndPad SetFlash
-7525 2700 Flash
-7525 2550 Flash
-7825 2400 Flash
-7825 2700 Flash
0 0 90 /PRndPad SetFlash
-7675 2350 Flash
-7675 2750 Flash
0 0 60 /PSqrPad SetFlash
-6975 2700 Flash
0 0 60 /PRndPad SetFlash
-6975 2400 Flash
-6975 2550 Flash
-6675 2700 Flash
-6675 2400 Flash
0 0 90 /PRndPad SetFlash
-6825 2750 Flash
-6825 2350 Flash
0 0 60 /PSqrPad SetFlash
-7450 1500 Flash
0 0 60 /PRndPad SetFlash
-7450 1800 Flash
-7450 1650 Flash
-7750 1500 Flash
-7750 1800 Flash
0 0 90 /PRndPad SetFlash
-7600 1450 Flash
-7600 1850 Flash
0 0 60 /PSqrPad SetFlash
-7450 350 Flash
0 0 60 /PRndPad SetFlash
-7450 650 Flash
-7450 500 Flash
-7750 350 Flash
-7750 650 Flash
0 0 90 /PRndPad SetFlash
-7600 300 Flash
-7600 700 Flash
0 0 60 /PRndPad SetFlash
-7500 3600 Flash
-7600 3500 Flash
-7700 3600 Flash
-7200 3000 Flash
-6800 3000 Flash
-7200 2850 Flash
-6800 2850 Flash
-7200 2100 Flash
-6800 2100 Flash
-6300 1650 Flash
-6300 2050 Flash
-6450 1650 Flash
-6450 2050 Flash
-6000 1100 Flash
-6000 1500 Flash
-6150 1650 Flash
-6150 2050 Flash
-4950 3300 Flash
-4950 3700 Flash
-6300 1500 Flash
-6300 1100 Flash
-4750 2000 Flash
-5150 2000 Flash
-5150 2300 Flash
-4750 2300 Flash
-5850 3050 Flash
-5850 2650 Flash
-5750 350 Flash
-5750 750 Flash
-5450 825 Flash
-5050 825 Flash
-6000 2050 Flash
-6000 1650 Flash
-5850 1650 Flash
-5850 2050 Flash
-5750 1450 Flash
-5350 1450 Flash
-4850 1450 Flash
-5250 1450 Flash
-5850 1100 Flash
-5850 1500 Flash
-5300 2000 Flash
-5700 2000 Flash
-5300 2150 Flash
-5700 2150 Flash
-5300 2300 Flash
-5700 2300 Flash
-4650 3300 Flash
-4650 3700 Flash
-350 900 Flash
-350 500 Flash
-200 500 Flash
-200 900 Flash
-350 3400 Flash
-350 3800 Flash
0 0 60 /PSqrPad SetFlash
-2950 500 Flash
0 0 60 /PRndPad SetFlash
-2850 500 Flash
-2750 500 Flash
-2650 500 Flash
-2550 500 Flash
-2450 500 Flash
-2350 500 Flash
-2250 500 Flash
-2250 800 Flash
-2350 800 Flash
-2450 800 Flash
-2550 800 Flash
-2650 800 Flash
-2750 800 Flash
-2850 800 Flash
-2950 800 Flash
0 0 60 /PSqrPad SetFlash
-5100 350 Flash
0 0 60 /PRndPad SetFlash
-5100 650 Flash
-5100 500 Flash
-5400 350 Flash
-5400 650 Flash
0 0 90 /PRndPad SetFlash
-5250 300 Flash
-5250 700 Flash
0 0 60 /PSqrPad SetFlash
-5800 3300 Flash
0 0 60 /PRndPad SetFlash
-5200 3300 Flash
-5200 3600 Flash
-5800 3600 Flash
-6000 3225 Flash
-6000 3525 Flash
0 0 177 /PRndPad SetFlash
-7875 3700 Flash
-6650 3150 Flash
-6650 1450 Flash
-7875 1450 Flash
10 SetText2
0 -4225 4350 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -4169 4350 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -4117 4350 [ [ 15 65 15 0 ] [ 0 65 31 65 ] ] Char
0 -4065 4350 [ [ 0 65 11 0 ] [ 22 65 11 0 ] [ 22 65 34 0 ] [ 45 65 34 0 ] ] Char
0 -4000 4350 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -3944 4350 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -3892 4350 [ [ 0 65 0 0 ] [ 31 65 0 21 ] [ 11 37 31 0 ] ] Char
0 -3788 4350 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -3736 4350 [ [ 0 65 0 0 ] ] Char
0 -3716 4350 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -3664 4350 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -3562 4350 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -7175 100 [ [ -31 56 -27 62 -20 65 -11 65 -4 62 0 56 0 50 -2 43 -4 40 -9 37 -22 31 -27 28 -29 25 -31 18 -31 9 -27 3 -20 0 -11 0 -4 3 0 9 ] ] Char
0 -7227 100 [ [ 0 65 0 0 ] ] Char
0 -7247 100 [ [ 0 65 0 0 ] [ 0 65 -15 65 -22 62 -27 56 -29 50 -31 40 -31 25 -29 15 -27 9 -22 3 -15 0 0 0 ] ] Char
0 -7299 100 [ [ 0 65 0 0 ] [ 0 65 -29 65 ] [ 0 34 -18 34 ] [ 0 0 -29 0 ] ] Char
0 -7401 100 [ [ -2 50 -2 53 -4 59 -6 62 -11 65 -20 65 -25 62 -27 59 -29 53 -29 46 -27 40 -22 31 0 0 -31 0 ] ] Char
50 SetLine
-4625 3300 [ -4650 3300 ] PLine
-4625 3500 [ -4625 2800 ] PLine
-4625 2800 [ -4625 2100 ] PLine
-4625 1550 [ -4625 2100 ] PLine
-4450 1400 [ -4450 1550 ] PLine
-4350 1550 [ -4350 1400 ] PLine
-3450 1400 [ -3450 1550 ] PLine
-4625 1550 [ -4625 250 ] PLine
-4450 250 [ -3700 250 ] PLine
-3700 250 [ -3700 50 ] PLine
-3350 1400 [ -3350 2100 ] PLine
-3050 2800 [ -3050 2100 ] PLine
-2850 2800 [ -2850 2925 ] PLine
-2325 2925 [ -2325 3700 ] PLine
-2325 3700 [ -2250 3700 ] PLine
-2250 3700 [ -2150 3700 ] PLine
-2150 3700 [ -2150 3800 ] PLine
-2150 3800 [ -1350 3800 ] PLine
-1350 3800 [ -1350 3700 ] PLine
-1350 3800 [ -1250 3800 ] PLine
-1250 3800 [ -1250 3700 ] PLine
-1250 3800 [ -450 3800 ] PLine
-450 3800 [ -450 3400 ] PLine
-350 3400 [ -450 3400 ] PLine
-450 3400 [ -450 2590 ] PLine
-450 900 [ -450 2590 ] PLine
-750 700 [ -750 900 ] PLine
-450 900 [ -450 300 ] PLine
-1100 50 [ -1025 300 ] PLine
-950 1100 [ -950 900 ] PLine
-1950 900 [ -1950 800 ] PLine
-6800 3000 [ -6800 3150 ] PLine
-6800 3150 [ -6700 3325 ] PLine
-6800 2850 [ -6800 3000 ] PLine
-6850 3275 [ -6700 3325 ] PLine
-6700 3325 [ -6700 3625 ] PLine
-6800 2850 [ -6800 2750 ] PLine
-6800 2750 [ -6825 2750 ] PLine
-6700 3625 [ -6850 3675 ] PLine
-6675 2400 [ -6675 2700 ] PLine
-6825 2350 [ -6825 2250 ] PLine
-6825 2250 [ -6800 2250 ] PLine
-6450 2500 [ -6675 2500 ] PLine
-7100 2550 [ -7100 2700 ] PLine
-7700 3000 [ -7825 3000 ] PLine
-7825 3000 [ -7825 2400 ] PLine
-7825 2550 [ -7675 2550 ] PLine
-7675 2550 [ -7675 2750 ] PLine
-6800 2250 [ -6800 2100 ] PLine
-6800 2100 [ -6800 1950 ] PLine
-6300 2800 [ -6300 2500 ] PLine
-6847 1651 [ -6850 1650 ] PLine
-6800 1650 [ -6800 1950 ] PLine
-6947 1751 [ -6950 1650 ] PLine
-6950 1650 [ -6847 1651 ] PLine
-6847 1651 [ -7047 1651 ] PLine
-7047 1651 [ -7150 1650 ] PLine
-7150 1650 [ -7150 1425 ] PLine
-7150 1425 [ -7050 1425 ] PLine
-7050 1425 [ -7050 1250 ] PLine
-7047 1651 [ -7500 1651 ] PLine
-7500 1651 [ -7450 1650 ] PLine
-7750 1650 [ -7450 1650 ] PLine
-7750 1800 [ -7750 1500 ] PLine
-7750 1500 [ -7700 1250 ] PLine
-7750 1500 [ -7600 1450 ] PLine
-6300 2800 [ -6300 3225 ] PLine
-6300 3225 [ -6000 3225 ] PLine
-6000 2850 [ -6000 2500 ] PLine
-5350 2800 [ -5350 2900 ] PLine
-1650 2700 [ -1650 2500 ] PLine
-1550 1600 [ -1550 1700 ] PLine
-2075 1600 [ -2075 2700 ] PLine
-7750 1800 [ -7600 1850 ] PLine
-7700 1250 [ -7700 1100 ] PLine
-7700 1100 [ -7650 1100 ] PLine
-7700 1100 [ -7700 950 ] PLine
-7700 950 [ -7700 800 ] PLine
-7700 800 [ -7750 650 ] PLine
-7750 650 [ -7750 350 ] PLine
-7750 650 [ -7600 700 ] PLine
-7450 500 [ -7750 500 ] PLine
-7750 350 [ -7600 300 ] PLine
-7450 500 [ -7050 500 ] PLine
-7050 500 [ -6850 500 ] PLine
-6850 500 [ -6650 500 ] PLine
-6650 500 [ -6650 600 ] PLine
-6650 500 [ -6200 500 ] PLine
-6200 500 [ -6200 501 ] PLine
-6200 501 [ -6196 501 ] PLine
-6196 501 [ -6100 501 ] PLine
-6100 501 [ -6100 401 ] PLine
-6100 401 [ -6096 401 ] PLine
-6096 601 [ -6096 500 ] PLine
-6096 500 [ -6200 500 ] PLine
-6200 800 [ -6100 600 ] PLine
-6100 600 [ -6100 601 ] PLine
-6100 601 [ -6096 601 ] PLine
-6225 950 [ -6200 800 ] PLine
-6150 1400 [ -6150 1325 ] PLine
-6150 1325 [ -6225 1325 ] PLine
-6225 1325 [ -6225 950 ] PLine
-6150 1400 [ -6075 1625 ] PLine
-6075 1625 [ -6075 1775 ] PLine
-5775 1325 [ -5775 825 ] PLine
-5775 825 [ -5675 825 ] PLine
-5675 825 [ -5675 575 ] PLine
-5675 575 [ -5250 575 ] PLine
-5250 575 [ -5250 700 ] PLine
-7000 3475 [ -6925 3475 ] PLine
-6925 3475 [ -6925 3700 ] PLine
-6925 3700 [ -6850 3700 ] PLine
-6850 3700 [ -6850 3675 ] PLine
-7150 3600 [ -7150 3700 ] PLine
-7150 3700 [ -6925 3700 ] PLine
-7400 2400 [ -7400 2250 ] PLine
-6825 2350 [ -6675 2400 ] PLine
-7700 3150 [ -7825 3150 ] PLine
-7825 3150 [ -7825 3000 ] PLine
-7700 3300 [ -7825 3300 ] PLine
-7825 3300 [ -7825 3150 ] PLine
-750 1600 [ -750 1500 ] PLine
-750 1500 [ -750 1250 ] PLine
-350 700 [ -350 900 ] PLine
-200 1250 [ -200 1375 ] PLine
-200 1375 [ -157 1456 ] PLine
-7875 3700 [ -7825 3650 ] PLine
-7825 3650 [ -7825 3300 ] PLine
-6700 3625 [ -6650 3150 ] PLine
-6650 1450 [ -6650 1650 ] PLine
-6650 1650 [ -6850 1650 ] PLine
-6847 1651 [ -6847 1650 ] PLine
-7750 1500 [ -7875 1450 ] PLine
-4550 1800 [ -4550 1100 ] PLine
-4250 800 [ -4250 950 ] PLine
-4550 2500 [ -4550 1800 ] PLine
-3750 1100 [ -3750 950 ] PLine
-4250 2900 [ -4250 2800 ] PLine
-4550 2500 [ -4550 3400 ] PLine
-3450 1100 [ -3450 950 ] PLine
-4550 1100 [ -4550 150 ] PLine
-4550 150 [ -3900 150 ] PLine
-3900 150 [ -3900 50 ] PLine
-3650 950 [ -3650 1650 ] PLine
-3450 1650 [ -3450 1800 ] PLine
-3350 950 [ -3350 800 ] PLine
-3350 800 [ -3350 600 ] PLine
-3250 600 [ -3250 500 ] PLine
-3250 1400 [ -3250 1800 ] PLine
-3250 1800 [ -3250 2300 ] PLine
-2950 2500 [ -2950 2300 ] PLine
-3250 2300 [ -3250 2500 ] PLine
-3250 2500 [ -3250 2800 ] PLine
-2150 1800 [ -2150 2500 ] PLine
-2150 2500 [ -2150 3250 ] PLine
-2150 1100 [ -2150 1800 ] PLine
-2450 3525 [ -2450 3700 ] PLine
-2050 3700 [ -2050 3525 ] PLine
-2150 1100 [ -2250 1100 ] PLine
-2350 1475 [ -2350 1400 ] PLine
-2150 500 [ -2150 1100 ] PLine
-1850 600 [ -1850 800 ] PLine
-2150 500 [ -2150 300 ] PLine
-1875 300 [ -1800 50 ] PLine
-2250 3525 [ -2250 3250 ] PLine
-1550 3400 [ -1550 3250 ] PLine
-1350 3400 [ -1350 3250 ] PLine
-750 3100 [ -750 3250 ] PLine
-525 2200 [ -525 3250 ] PLine
-750 2300 [ -750 2200 ] PLine
-525 2200 [ -525 975 ] PLine
-525 975 [ -750 975 ] PLine
-750 975 [ -750 1100 ] PLine
-625 500 [ -625 975 ] PLine
-750 500 [ -900 50 ] PLine
-1700 50 [ -1700 400 ] PLine
-1700 400 [ -1050 400 ] PLine
12 SetLine
-1500 200 [ -1500 50 ] PLine
-1000 550 [ -1600 550 ] PLine
-1050 1700 [ -1050 1650 ] PLine
-1050 1650 [ -1000 1600 ] PLine
-1000 1600 [ -1000 550 ] PLine
-1050 2500 [ -1050 2425 ] PLine
-1050 2425 [ -1100 2375 ] PLine
-1100 2375 [ -1100 2225 ] PLine
-1100 2225 [ -1050 2175 ] PLine
-1050 2175 [ -1050 1700 ] PLine
-6350 600 [ -6166 571 ] PLine
-7450 350 [ -7300 350 ] PLine
-7300 350 [ -7020 430 ] PLine
-7020 430 [ -7000 350 ] PLine
-7000 350 [ -6700 350 ] PLine
-6700 350 [ -6650 400 ] PLine
-6350 400 [ -6166 431 ] PLine
-7700 2100 [ -7600 2100 ] PLine
-7600 2100 [ -7600 2700 ] PLine
-7600 2700 [ -7525 2700 ] PLine
-7100 2250 [ -6900 2250 ] PLine
-6900 2250 [ -6900 2700 ] PLine
-6900 2700 [ -6975 2700 ] PLine
-4850 2600 [ -4800 2550 ] PLine
-4800 2550 [ -4800 2050 ] PLine
-4800 2050 [ -4750 2000 ] PLine
-4750 2000 [ -4750 1800 ] PLine
-5200 1800 [ -5200 1475 ] PLine
-5200 1475 [ -5150 1375 ] PLine
-5150 1375 [ -5150 1250 ] PLine
-5250 1250 [ -5250 950 ] PLine
-5250 950 [ -5250 775 ] PLine
-5250 775 [ -5100 775 ] PLine
-5100 775 [ -5100 650 ] PLine
-5600 450 [ -5750 350 ] PLine
-5750 350 [ -6026 431 ] PLine
-5600 450 [ -5400 350 ] PLine
-6000 800 [ -6026 571 ] PLine
-6026 571 [ -5996 501 ] PLine
-5450 825 [ -5400 650 ] PLine
-5150 2150 [ -5150 2300 ] PLine
-5150 2300 [ -5200 2350 ] PLine
-5200 2350 [ -5200 2850 ] PLine
-5200 2850 [ -5250 2900 ] PLine
-5150 2150 [ -5150 2000 ] PLine
-6000 2200 [ -5950 2150 ] PLine
-5950 2150 [ -5950 1650 ] PLine
-6000 1650 [ -5950 1650 ] PLine
-5950 1650 [ -5950 1000 ] PLine
-5950 1000 [ -5975 1000 ] PLine
-5975 1000 [ -5975 875 ] PLine
-5975 875 [ -5850 875 ] PLine
-5850 875 [ -5850 500 ] PLine
-5850 500 [ -5100 500 ] PLine
-5150 2675 [ -5150 2900 ] PLine
-5050 2900 [ -5050 2750 ] PLine
-5050 2750 [ -4950 2750 ] PLine
-4950 2750 [ -4950 2375 ] PLine
-4950 2375 [ -4975 2350 ] PLine
-4975 2350 [ -4975 2150 ] PLine
-5300 3050 [ -5050 3050 ] PLine
-5050 3050 [ -5050 2900 ] PLine
-5450 3050 [ -5450 2900 ] PLine
-5050 1250 [ -5050 950 ] PLine
-5050 950 [ -5150 950 ] PLine
-5050 950 [ -5000 900 ] PLine
-5000 900 [ -5000 350 ] PLine
-5000 350 [ -5100 350 ] PLine
-6650 950 [ -6750 1250 ] PLine
-7450 1800 [ -7300 1800 ] PLine
-7400 1250 [ -7450 1100 ] PLine
-7450 1500 [ -7300 1500 ] PLine
-6850 1250 [ -6850 950 ] PLine
-6850 950 [ -6750 950 ] PLine
-6850 950 [ -6950 950 ] PLine
-5700 1050 [ -5700 2000 ] PLine
-5700 2000 [ -5700 2150 ] PLine
-5700 2150 [ -5700 2300 ] PLine
-5850 1650 [ -5900 1600 ] PLine
-5900 1600 [ -5900 1025 ] PLine
-4850 1450 [ -4850 1250 ] PLine
-5850 1100 [ -5850 1450 ] PLine
-5850 1450 [ -5750 1450 ] PLine
-6500 800 [ -6550 950 ] PLine
-5400 2450 [ -5400 1600 ] PLine
-5150 2450 [ -5150 2600 ] PLine
-5150 2600 [ -5100 2650 ] PLine
-5100 2650 [ -5000 2650 ] PLine
-5000 2650 [ -5000 2500 ] PLine
-5000 2500 [ -5023 2475 ] PLine
-5023 2475 [ -5025 2450 ] PLine
-5025 2450 [ -5025 2000 ] PLine
-5025 2000 [ -4950 2000 ] PLine
-4950 2000 [ -4950 1850 ] PLine
-6450 1000 [ -6450 1650 ] PLine
-5350 1450 [ -5350 1550 ] PLine
-5250 1450 [ -5250 1550 ] PLine
-6400 1250 [ -6400 750 ] PLine
-6400 750 [ -6850 750 ] PLine
-6850 750 [ -6900 800 ] PLine
-6950 600 [ -6950 700 ] PLine
-6950 700 [ -6300 700 ] PLine
-6300 700 [ -6300 1100 ] PLine
-5350 1850 [ -5300 2000 ] PLine
-5300 2150 [ -5250 2100 ] PLine
-5250 2100 [ -5250 1850 ] PLine
-5300 2300 [ -5225 2300 ] PLine
-5225 2300 [ -5225 1900 ] PLine
-5225 1900 [ -5150 1850 ] PLine
-7450 650 [ -7500 800 ] PLine
-6500 1100 [ -6500 1700 ] PLine
-7450 650 [ -7300 650 ] PLine
-4950 3300 [ -4950 2900 ] PLine
-7100 3150 [ -7000 3325 ] PLine
-7000 3625 [ -7075 3625 ] PLine
-7075 3625 [ -7075 3350 ] PLine
-7075 3350 [ -7275 3000 ] PLine
-7275 3000 [ -7400 3000 ] PLine
-2450 3100 [ -2450 3275 ] PLine
-2450 3275 [ -2550 3275 ] PLine
-2550 3275 [ -2550 3700 ] PLine
-275 500 [ -275 825 ] PLine
-850 825 [ -825 825 ] PLine
-825 825 [ -825 1100 ] PLine
-825 1100 [ -850 1100 ] PLine
-825 750 [ -800 750 ] PLine
-800 750 [ -800 2400 ] PLine
-3850 3100 [ -3900 3175 ] PLine
-3900 3175 [ -4050 3175 ] PLine
-4050 3175 [ -4050 3700 ] PLine
-1850 3400 [ -1850 3525 ] PLine
-2050 3400 [ -2075 3400 ] PLine
-2075 3400 [ -2075 2825 ] PLine
-2000 425 [ -2000 900 ] PLine
-2000 900 [ -2025 925 ] PLine
-2025 925 [ -2025 3325 ] PLine
-2025 3325 [ -2000 3350 ] PLine
-100 3675 [ -100 2700 ] PLine
-100 2700 [ -157 2644 ] PLine
-4900 75 [ -4900 2150 ] PLine
-4900 2150 [ -4950 2200 ] PLine
-4950 2200 [ -4950 2300 ] PLine
-4950 2300 [ -4900 2350 ] PLine
-4900 2350 [ -4900 3575 ] PLine
-4700 575 [ -4700 1200 ] PLine
-4700 1200 [ -4675 1225 ] PLine
-4675 1225 [ -4675 3050 ] PLine
-4675 3050 [ -4700 3050 ] PLine
-2300 650 [ -2300 975 ] PLine
-2300 975 [ -2350 1025 ] PLine
-2350 1025 [ -2350 1100 ] PLine
-3650 3400 [ -3650 3100 ] PLine
-3050 925 [ -3050 1100 ] PLine
-2200 225 [ -2200 1000 ] PLine
-2200 1000 [ -2225 1025 ] PLine
-1150 1700 [ -1150 2175 ] PLine
-950 2175 [ -1000 2225 ] PLine
-1000 2225 [ -1000 2375 ] PLine
-1000 2375 [ -950 2425 ] PLine
-1400 750 [ -1400 1450 ] PLine
-1400 1450 [ -1350 1500 ] PLine
-1600 3100 [ -1650 3100 ] PLine
-3250 3275 [ -3250 3100 ] PLine
-1600 3100 [ -1600 3650 ] PLine
-1600 3650 [ -1550 3700 ] PLine
-1600 3100 [ -1600 2350 ] PLine
-1600 2350 [ -1650 2300 ] PLine
-850 3100 [ -850 2850 ] PLine
-850 2850 [ -800 2800 ] PLine
-800 2800 [ -800 2475 ] PLine
-800 2475 [ -850 2425 ] PLine
-850 2425 [ -850 2300 ] PLine
-700 2350 [ -700 1650 ] PLine
-1750 800 [ -1750 900 ] PLine
-1750 900 [ -1700 950 ] PLine
-1700 950 [ -1700 1450 ] PLine
-1700 1450 [ -1650 1500 ] PLine
-2850 1800 [ -2850 1475 ] PLine
-2850 1475 [ -2900 1425 ] PLine
-2900 1425 [ -2900 1300 ] PLine
-2900 1300 [ -2925 1275 ] PLine
-4100 1275 [ -4100 1575 ] PLine
-4100 1575 [ -4150 1625 ] PLine
-4150 1625 [ -4150 1800 ] PLine
-1750 3100 [ -1750 2850 ] PLine
-1750 2850 [ -1700 2800 ] PLine
-1700 2800 [ -1700 2350 ] PLine
-1700 2350 [ -1750 2300 ] PLine
-950 2900 [ -950 3100 ] PLine
-1750 2300 [ -1700 2250 ] PLine
-1700 2250 [ -1600 2250 ] PLine
-1600 2250 [ -1600 1500 ] PLine
-1600 1500 [ -1550 1500 ] PLine
-1650 800 [ -1600 850 ] PLine
-1600 850 [ -1600 1500 ] PLine
-1850 3100 [ -1850 2700 ] PLine
-1850 2700 [ -1800 2650 ] PLine
-1800 2650 [ -1800 2350 ] PLine
-1800 2350 [ -1850 2300 ] PLine
-1050 3100 [ -1050 2850 ] PLine
-1050 2850 [ -1000 2800 ] PLine
-1000 2800 [ -1000 2425 ] PLine
-1000 2425 [ -1050 2375 ] PLine
-1050 2300 [ -1050 2375 ] PLine
-1850 2300 [ -1925 2225 ] PLine
-1925 2225 [ -1925 1875 ] PLine
-1050 2300 [ -1050 2225 ] PLine
-1050 2225 [ -1000 2175 ] PLine
-1000 2175 [ -1000 2100 ] PLine
-1400 2075 [ -1400 1550 ] PLine
-1400 1550 [ -1450 1500 ] PLine
-1550 800 [ -1500 850 ] PLine
-1500 850 [ -1500 1275 ] PLine
-1500 1275 [ -1450 1325 ] PLine
-1450 1325 [ -1450 1500 ] PLine
-1950 3100 [ -1950 2800 ] PLine
-1950 2800 [ -1900 2750 ] PLine
-1900 2750 [ -1900 2350 ] PLine
-1900 2350 [ -1950 2300 ] PLine
-1150 2800 [ -1150 3100 ] PLine
-2400 2225 [ -2400 1925 ] PLine
-2400 1925 [ -2550 1925 ] PLine
-2550 1925 [ -2550 1800 ] PLine
-1800 2250 [ -1800 1000 ] PLine
-1450 800 [ -1450 1025 ] PLine
-3000 3150 [ -3000 2025 ] PLine
-1250 2300 [ -1250 2025 ] PLine
-1250 3100 [ -1200 3050 ] PLine
-1200 3050 [ -1200 2425 ] PLine
-1200 2425 [ -1250 2375 ] PLine
-1250 2375 [ -1250 2300 ] PLine
-1000 2025 [ -1000 1650 ] PLine
-1000 1650 [ -950 1600 ] PLine
-950 1500 [ -950 1600 ] PLine
-1350 800 [ -1350 975 ] PLine
-875 975 [ -900 975 ] PLine
-900 975 [ -900 1175 ] PLine
-900 1175 [ -950 1225 ] PLine
-950 1225 [ -950 1500 ] PLine
-3400 3200 [ -3400 2425 ] PLine
-3400 2425 [ -3350 2375 ] PLine
-3350 2375 [ -3350 2175 ] PLine
-1350 2300 [ -1350 2125 ] PLine
-1350 3100 [ -1300 3050 ] PLine
-1300 3050 [ -1300 2425 ] PLine
-1300 2425 [ -1350 2375 ] PLine
-1350 2375 [ -1350 2300 ] PLine
-1100 2125 [ -1100 1650 ] PLine
-1100 1650 [ -1050 1600 ] PLine
-1050 1500 [ -1050 1600 ] PLine
-1250 800 [ -1200 750 ] PLine
-1200 750 [ -1100 750 ] PLine
-1100 750 [ -1100 1450 ] PLine
-1100 1450 [ -1050 1500 ] PLine
-2650 3100 [ -2600 3150 ] PLine
-2600 3150 [ -2500 3150 ] PLine
-2500 3150 [ -2500 2700 ] PLine
-2500 2700 [ -2600 2700 ] PLine
-2600 2700 [ -2600 2275 ] PLine
-2600 2275 [ -2550 2225 ] PLine
-2550 2225 [ -2550 2100 ] PLine
-2550 2100 [ -2550 1975 ] PLine
-1450 3100 [ -1400 3050 ] PLine
-1400 3050 [ -1400 2350 ] PLine
-1400 2350 [ -1450 2300 ] PLine
-1450 2300 [ -1450 1800 ] PLine
-1450 1800 [ -1500 1750 ] PLine
-1500 1750 [ -1500 1450 ] PLine
-1150 800 [ -1200 850 ] PLine
-1200 850 [ -1200 1125 ] PLine
-1200 1125 [ -1150 1175 ] PLine
-1150 1175 [ -1150 1500 ] PLine
-1950 3400 [ -1900 3350 ] PLine
-1900 3350 [ -1900 3050 ] PLine
-2900 3225 [ -2900 2725 ] PLine
-2900 2725 [ -2800 2675 ] PLine
-2800 2675 [ -2800 2400 ] PLine
-2800 2400 [ -2700 2400 ] PLine
-2700 2400 [ -2700 2250 ] PLine
-2700 2250 [ -2750 2200 ] PLine
-2750 2200 [ -2750 2100 ] PLine
-1550 3100 [ -1500 3050 ] PLine
-1500 3050 [ -1500 2350 ] PLine
-1500 2350 [ -1550 2300 ] PLine
-1550 2300 [ -1500 2250 ] PLine
-1500 2250 [ -1500 1850 ] PLine
-1300 1850 [ -1300 1650 ] PLine
-1300 1650 [ -1250 1600 ] PLine
-1250 1500 [ -1250 1600 ] PLine
-1300 750 [ -1300 1450 ] PLine
-1300 1450 [ -1250 1500 ] PLine
-4350 1100 [ -4300 1150 ] PLine
-4300 1150 [ -4300 1750 ] PLine
-4300 1750 [ -4350 1800 ] PLine
-4350 1800 [ -4350 2025 ] PLine
-4350 2025 [ -4300 2075 ] PLine
-4300 2075 [ -4300 2625 ] PLine
-2300 2450 [ -2300 2150 ] PLine
-2300 2150 [ -2250 2100 ] PLine
-2450 1400 [ -2450 1525 ] PLine
-2450 1525 [ -2400 1575 ] PLine
-2400 1575 [ -2400 1875 ] PLine
-2400 1875 [ -2250 1875 ] PLine
-2250 1875 [ -2250 2100 ] PLine
-6350 1925 [ -6350 1050 ] PLine
-2650 2100 [ -2650 1925 ] PLine
-2900 1925 [ -2950 1875 ] PLine
-2950 1875 [ -2950 1800 ] PLine
-2925 2600 [ -2900 2575 ] PLine
-2900 2575 [ -2900 2050 ] PLine
-2900 2050 [ -2850 2025 ] PLine
-2850 2025 [ -2850 1875 ] PLine
-2850 1875 [ -2900 1850 ] PLine
-2900 1850 [ -2900 1725 ] PLine
-2900 1725 [ -3050 1725 ] PLine
-3050 1725 [ -3050 1400 ] PLine
-950 1700 [ -900 1650 ] PLine
-900 1650 [ -900 1300 ] PLine
-2850 1275 [ -2850 1400 ] PLine
-3550 800 [ -3550 1050 ] PLine
-3950 2800 [ -3900 2750 ] PLine
-3900 2750 [ -3900 2550 ] PLine
-3125 2525 [ -3100 2500 ] PLine
-3100 2500 [ -3100 1350 ] PLine
-4475 1625 [ -4500 1650 ] PLine
-4500 1650 [ -4500 2700 ] PLine
-4500 2700 [ -4475 2725 ] PLine
-3950 1100 [ -4000 1150 ] PLine
-4000 1150 [ -4000 1625 ] PLine
-4000 1625 [ -4100 1625 ] PLine
-4100 1625 [ -4100 3300 ] PLine
-3750 3300 [ -3750 3700 ] PLine
-3400 1350 [ -3400 2125 ] PLine
-3400 2125 [ -3450 2175 ] PLine
-3450 2250 [ -3450 2175 ] PLine
-3400 1350 [ -3400 1150 ] PLine
-3400 1150 [ -3300 1150 ] PLine
-3300 1150 [ -3250 1100 ] PLine
-3450 2250 [ -3450 2500 ] PLine
-2850 2225 [ -2850 2100 ] PLine
-1150 3700 [ -1100 3650 ] PLine
-1100 3650 [ -1100 2850 ] PLine
-650 2850 [ -600 2850 ] PLine
-600 2850 [ -600 1400 ] PLine
-600 1400 [ -625 1375 ] PLine
-1350 1375 [ -1350 1100 ] PLine
-5750 2875 [ -5750 1550 ] PLine
-3850 2800 [ -3850 3000 ] PLine
-5600 3000 [ -5600 2375 ] PLine
-5600 2375 [ -5650 2325 ] PLine
-5650 2325 [ -5650 1850 ] PLine
-3500 1300 [ -3500 2125 ] PLine
-3500 2125 [ -3550 2175 ] PLine
-3550 2175 [ -3550 2500 ] PLine
-4350 2700 [ -4300 2750 ] PLine
-4300 2750 [ -4300 3100 ] PLine
-4300 3100 [ -4250 3100 ] PLine
-3150 1100 [ -3100 1150 ] PLine
-3100 1150 [ -3000 1150 ] PLine
-3000 1150 [ -3000 1675 ] PLine
-4400 1700 [ -4350 1700 ] PLine
-4400 2275 [ -4350 2325 ] PLine
-4300 3100 [ -4300 3750 ] PLine
-4300 3750 [ -4000 3750 ] PLine
-4000 3750 [ -3950 3700 ] PLine
-4350 2325 [ -4350 2700 ] PLine
-4400 2275 [ -4400 1175 ] PLine
-3300 1225 [ -3300 2875 ] PLine
-3800 3475 [ -3800 2450 ] PLine
-3800 2450 [ -3850 2400 ] PLine
-3850 2400 [ -3850 2100 ] PLine
-1750 3700 [ -1800 3750 ] PLine
-1800 3750 [ -2100 3750 ] PLine
-2100 3750 [ -2100 3475 ] PLine
-2100 3475 [ -2150 3400 ] PLine
-3200 3425 [ -3200 1400 ] PLine
-3200 1400 [ -3150 1400 ] PLine
-2200 50 [ -2200 150 ] PLine
-2200 150 [ -2400 150 ] PLine
-2400 150 [ -2400 1000 ] PLine
-2100 50 [ -2100 1100 ] PLine
-2100 1100 [ -2075 1125 ] PLine
-1200 50 [ -1200 200 ] PLine
-2950 575 [ -2950 800 ] PLine
-3200 50 [ -3200 300 ] PLine
-3200 300 [ -2800 300 ] PLine
-2800 300 [ -2800 550 ] PLine
-2800 550 [ -2750 600 ] PLine
-2750 600 [ -2750 800 ] PLine
-3100 50 [ -3100 250 ] PLine
-3100 250 [ -2700 250 ] PLine
-2700 250 [ -2700 675 ] PLine
-2700 675 [ -2650 725 ] PLine
-2650 725 [ -2650 800 ] PLine
-3000 50 [ -3000 200 ] PLine
-3000 200 [ -2600 200 ] PLine
-2600 200 [ -2600 550 ] PLine
-2600 550 [ -2550 600 ] PLine
-2550 600 [ -2550 800 ] PLine
-2900 50 [ -2900 150 ] PLine
-2900 150 [ -2500 150 ] PLine
-2500 150 [ -2500 550 ] PLine
-2500 550 [ -2450 600 ] PLine
-2450 600 [ -2450 800 ] PLine
-4150 1400 [ -4150 1550 ] PLine
-4150 1550 [ -4200 1600 ] PLine
-4200 1600 [ -4200 2450 ] PLine
-4200 2450 [ -4150 2500 ] PLine
-4050 1100 [ -4150 1200 ] PLine
-4150 1200 [ -4150 1400 ] PLine
-2550 2500 [ -2550 2400 ] PLine
-2450 2800 [ -2450 2675 ] PLine
-2450 2675 [ -2550 2675 ] PLine
-2550 2675 [ -2550 2500 ] PLine
-1850 3700 [ -1800 3650 ] PLine
-1800 3650 [ -1800 2775 ] PLine
-650 2500 [ -650 2300 ] PLine
-650 2300 [ -650 1700 ] PLine
-650 3100 [ -700 3100 ] PLine
-700 3100 [ -700 2550 ] PLine
-700 2550 [ -650 2500 ] PLine
-750 3700 [ -700 3650 ] PLine
-700 3650 [ -700 3100 ] PLine
-850 2500 [ -900 2450 ] PLine
-900 2450 [ -900 2250 ] PLine
-900 2250 [ -850 2200 ] PLine
-850 2200 [ -850 1700 ] PLine
-750 2500 [ -750 2800 ] PLine
-750 2800 [ -800 2850 ] PLine
-800 2850 [ -800 3750 ] PLine
-800 3750 [ -700 3750 ] PLine
-700 3750 [ -650 3700 ] PLine
-850 3700 [ -850 3550 ] PLine
-575 3550 [ -575 1050 ] PLine
-575 1050 [ -600 1050 ] PLine
-3750 800 [ -3800 850 ] PLine
-3800 850 [ -3800 1900 ] PLine
-3800 1900 [ -3700 2000 ] PLine
-3700 2000 [ -3700 2850 ] PLine
-950 3700 [ -950 3575 ] PLine
-2800 3575 [ -2800 2850 ] PLine
-2800 2850 [ -2750 2800 ] PLine
-271 2374 [ -325 2375 ] PLine
-325 2375 [ -400 2375 ] PLine
-400 2375 [ -400 3200 ] PLine
-400 3200 [ -375 3200 ] PLine
-5500 3150 [ -5500 1000 ] PLine
-5500 1000 [ -5600 1000 ] PLine
-5600 1000 [ -5650 950 ] PLine
-2700 3375 [ -2700 2925 ] PLine
-2700 2925 [ -2600 2925 ] PLine
-2600 2925 [ -2600 2775 ] PLine
-2600 2775 [ -2650 2725 ] PLine
-2650 2725 [ -2650 2500 ] PLine
-2650 2500 [ -2625 2500 ] PLine
-2625 2500 [ -2625 2225 ] PLine
-2225 2200 [ -2200 2175 ] PLine
-2200 2175 [ -2200 1225 ] PLine
-2200 1225 [ -2225 1200 ] PLine
-2450 2500 [ -2450 2375 ] PLine
-5600 2225 [ -5600 1300 ] PLine
-5600 1300 [ -5650 1250 ] PLine
-3550 3700 [ -3500 3750 ] PLine
-3500 3750 [ -2500 3750 ] PLine
-2500 3750 [ -2500 3325 ] PLine
-2500 3325 [ -2400 3325 ] PLine
-2400 3325 [ -2400 2850 ] PLine
-2400 2850 [ -2300 2850 ] PLine
-2300 2850 [ -2300 2600 ] PLine
-2300 2600 [ -2450 2600 ] PLine
-2450 2600 [ -2450 2500 ] PLine
-4800 750 [ -4800 1550 ] PLine
-4800 1550 [ -4875 1550 ] PLine
-4875 1550 [ -4875 2200 ] PLine
-4875 2200 [ -4900 2225 ] PLine
-3500 2300 [ -3500 2175 ] PLine
-3500 2175 [ -3450 2125 ] PLine
-3450 2125 [ -3450 2100 ] PLine
-4050 1875 [ -4000 1925 ] PLine
-4000 1925 [ -4000 2450 ] PLine
-4000 2450 [ -3950 2500 ] PLine
-3950 1800 [ -3900 1850 ] PLine
-3900 1850 [ -3900 2450 ] PLine
-3900 2450 [ -3850 2500 ] PLine
-3850 1800 [ -3850 1900 ] PLine
-3850 1900 [ -3800 1950 ] PLine
-3800 1950 [ -3800 2325 ] PLine
-3800 2325 [ -3750 2375 ] PLine
-3750 2375 [ -3750 2500 ] PLine
-3650 2500 [ -3650 2175 ] PLine
-3550 1975 [ -3550 1800 ] PLine
-3900 1050 [ -3900 1675 ] PLine
-3900 1675 [ -4000 1675 ] PLine
-4000 1675 [ -4000 1825 ] PLine
-4000 1825 [ -3950 1875 ] PLine
-3950 1875 [ -3950 2100 ] PLine
-3550 2800 [ -3550 3000 ] PLine
-3550 3000 [ -3600 3050 ] PLine
-3600 3050 [ -3600 3750 ] PLine
-3600 3750 [ -3800 3750 ] PLine
-3800 3750 [ -3850 3700 ] PLine
-4050 2950 [ -4050 2800 ] PLine
-4725 2950 [ -4700 2950 ] PLine
-4700 2950 [ -4700 1400 ] PLine
-4700 1400 [ -4725 1375 ] PLine
-5200 1350 [ -5200 1150 ] PLine
-7250 1150 [ -7250 1250 ] PLine
-2350 1700 [ -2350 1550 ] PLine
-2350 1550 [ -2400 1500 ] PLine
-2400 1500 [ -2400 1225 ] PLine
-4400 2575 [ -4400 3650 ] PLine
-4400 3650 [ -4350 3700 ] PLine
-2850 1100 [ -2850 1150 ] PLine
-2850 1150 [ -2800 1200 ] PLine
-2800 1200 [ -2800 2300 ] PLine
-2800 2300 [ -2850 2350 ] PLine
-2850 2350 [ -2850 2425 ] PLine
-2900 850 [ -2950 900 ] PLine
-2950 900 [ -2950 1100 ] PLine
-2600 1450 [ -2600 1600 ] PLine
-2600 1600 [ -2450 1600 ] PLine
-2450 1600 [ -2450 1800 ] PLine
-7325 2800 [ -7325 2175 ] PLine
-7100 2400 [ -7225 2175 ] PLine
-7225 2175 [ -7525 2175 ] PLine
-7525 2175 [ -7525 2400 ] PLine
-2650 1400 [ -2650 1650 ] PLine
-2650 1650 [ -2600 1700 ] PLine
-2600 1700 [ -2600 2150 ] PLine
-2600 2150 [ -2675 2150 ] PLine
-2675 2150 [ -2675 2425 ] PLine
-2675 2425 [ -2700 2450 ] PLine
-2700 2450 [ -2700 2850 ] PLine
-2700 750 [ -2700 1350 ] PLine
-2700 1350 [ -2650 1400 ] PLine
-3100 400 [ -3100 800 ] PLine
-3100 800 [ -3250 800 ] PLine
-1000 50 [ -950 150 ] PLine
-950 150 [ -950 825 ] PLine
-2800 850 [ -2750 900 ] PLine
-2750 900 [ -2750 1100 ] PLine
-5650 2600 [ -5700 2450 ] PLine
-5100 2375 [ -5100 1600 ] PLine
-5100 1600 [ -5050 1550 ] PLine
-1750 1325 [ -1750 1500 ] PLine
-1750 1500 [ -1700 1550 ] PLine
-1700 1550 [ -1700 2200 ] PLine
-5050 2600 [ -5050 1850 ] PLine
-5050 1850 [ -5000 1800 ] PLine
-5000 1800 [ -5000 1000 ] PLine
-1900 1000 [ -1900 1500 ] PLine
-1900 1500 [ -1850 1500 ] PLine
-750 2125 [ -750 1900 ] PLine
-1850 1900 [ -1850 1825 ] PLine
-1850 1825 [ -1900 1775 ] PLine
-1900 1775 [ -1900 1500 ] PLine
-4800 2950 [ -4750 2900 ] PLine
-4750 2900 [ -4750 2300 ] PLine
-4850 2300 [ -4850 1675 ] PLine
-4850 1675 [ -4750 1675 ] PLine
-4750 1675 [ -4750 1500 ] PLine
-1975 1950 [ -2000 1950 ] PLine
-2000 1950 [ -2000 1550 ] PLine
-2000 1550 [ -1950 1500 ] PLine
-50 3625 [ -50 1900 ] PLine
-50 1900 [ -100 1850 ] PLine
-100 1850 [ -100 1400 ] PLine
-100 1400 [ -125 1375 ] PLine
-4250 2500 [ -4200 2550 ] PLine
-4200 2550 [ -4200 3650 ] PLine
-4200 3650 [ -4150 3700 ] PLine
-2800 950 [ -2800 1150 ] PLine
-2800 1150 [ -2750 1200 ] PLine
-2750 1200 [ -2750 1400 ] PLine
-3650 800 [ -3700 850 ] PLine
-3700 850 [ -3700 1850 ] PLine
-3700 1850 [ -3600 1950 ] PLine
-3600 1950 [ -3600 2950 ] PLine
-6200 2050 [ -6200 2800 ] PLine
-5350 2725 [ -5350 2600 ] PLine
-6200 1500 [ -6200 2050 ] PLine
-6200 2050 [ -6000 2050 ] PLine
-6050 900 [ -6050 1150 ] PLine
-6050 1150 [ -6000 1200 ] PLine
-6000 1200 [ -6000 1500 ] PLine
-5400 1200 [ -5400 1500 ] PLine
-5400 1500 [ -5450 1550 ] PLine
-5450 950 [ -5450 1150 ] PLine
-5450 1150 [ -5400 1200 ] PLine
-2425 3425 [ -2375 3375 ] PLine
-2375 3375 [ -2375 2875 ] PLine
-2375 2875 [ -2200 2875 ] PLine
-2200 2875 [ -2200 2600 ] PLine
-2200 2600 [ -2225 2575 ] PLine
-1150 2500 [ -1150 2425 ] PLine
-1150 2425 [ -1200 2375 ] PLine
-1200 2375 [ -1200 1850 ] PLine
-2250 900 [ -2250 975 ] PLine
-2250 975 [ -2300 1025 ] PLine
-2300 1025 [ -2300 1250 ] PLine
-2300 1250 [ -2250 1300 ] PLine
-2250 1300 [ -2250 1400 ] PLine
-3150 1475 [ -3175 1500 ] PLine
-3175 1500 [ -3175 2875 ] PLine
-3175 2875 [ -3150 2900 ] PLine
-2650 600 [ -2600 650 ] PLine
-2600 650 [ -2600 1350 ] PLine
-2600 1350 [ -2550 1400 ] PLine
-3250 3700 [ -3200 3650 ] PLine
-3200 3650 [ -3100 3650 ] PLine
-3100 3650 [ -3100 2650 ] PLine
-3100 2650 [ -3125 2625 ] PLine
-3300 50 [ -3300 350 ] PLine
-3300 350 [ -2900 350 ] PLine
-2900 350 [ -2900 550 ] PLine
-2900 550 [ -2850 600 ] PLine
-2850 600 [ -2850 800 ] PLine
-1700 400 [ -1900 400 ] PLine
-1900 400 [ -1900 675 ] PLine
-1900 675 [ -1925 700 ] PLine
-1250 1700 [ -1250 1675 ] PLine
-1250 1675 [ -1200 1625 ] PLine
-1200 1625 [ -1200 1350 ] PLine
-5300 775 [ -5300 1725 ] PLine
-6250 1750 [ -6250 2150 ] PLine
-6250 2150 [ -6300 2200 ] PLine
-1250 2500 [ -1250 2425 ] PLine
-1250 2425 [ -1300 2375 ] PLine
-1300 2375 [ -1300 1975 ] PLine
-1300 1975 [ -1250 1925 ] PLine
-1250 1925 [ -1250 1700 ] PLine
-6300 2200 [ -6400 2200 ] PLine
-6400 2200 [ -6400 2800 ] PLine
-125 1275 [ -50 1275 ] PLine
-50 1275 [ -50 1672 ] PLine
0 0 55 /PRndPad SetFlash
-4625 3100 Flash
-4625 2800 Flash
-4625 3500 Flash
-4625 2100 Flash
-4625 1550 Flash
-4450 1550 Flash
-4350 1550 Flash
-4625 800 Flash
-3450 1550 Flash
-3350 1550 Flash
-4625 250 Flash
-4450 250 Flash
-3350 2100 Flash
-3050 2800 Flash
-2850 2925 Flash
-2325 2925 Flash
-450 2590 Flash
-450 900 Flash
-750 900 Flash
-450 300 Flash
-1025 300 Flash
-950 900 Flash
-1950 900 Flash
0 0 55 /PRndPad SetFlash
-1500 200 Flash
-1600 550 Flash
-1000 1250 Flash
0 0 55 /PRndPad SetFlash
-4750 1800 Flash
-5200 1800 Flash
0 0 55 /PRndPad SetFlash
-5150 2675 Flash
0 0 55 /PRndPad SetFlash
-4975 2150 Flash
0 0 55 /PRndPad SetFlash
-5450 3050 Flash
0 0 55 /PRndPad SetFlash
-5700 1050 Flash
0 0 55 /PRndPad SetFlash
-5900 1025 Flash
0 0 55 /PRndPad SetFlash
-4850 1250 Flash
0 0 55 /PRndPad SetFlash
-5400 1600 Flash
0 0 55 /PRndPad SetFlash
-6450 1000 Flash
0 0 55 /PRndPad SetFlash
-6400 1250 Flash
0 0 55 /PRndPad SetFlash
-6500 1100 Flash
-6500 1700 Flash
0 0 55 /PRndPad SetFlash
-4950 2900 Flash
0 0 55 /PRndPad SetFlash
-275 500 Flash
-275 825 Flash
-850 825 Flash
0 0 55 /PRndPad SetFlash
-825 750 Flash
-800 2400 Flash
0 0 55 /PRndPad SetFlash
-1850 3525 Flash
0 0 55 /PRndPad SetFlash
-2075 2825 Flash
0 0 55 /PRndPad SetFlash
-2000 425 Flash
-2000 3350 Flash
0 0 55 /PRndPad SetFlash
-100 3675 Flash
0 0 55 /PRndPad SetFlash
-4900 75 Flash
-4900 3575 Flash
0 0 55 /PRndPad SetFlash
-4700 575 Flash
-4700 3050 Flash
-2300 650 Flash
-3650 3400 Flash
0 0 55 /PRndPad SetFlash
-3050 925 Flash
0 0 55 /PRndPad SetFlash
-2200 225 Flash
-2225 1025 Flash
0 0 55 /PRndPad SetFlash
-1150 2175 Flash
-950 2175 Flash
-950 2425 Flash
0 0 55 /PRndPad SetFlash
-5350 2800 Flash
-1650 2700 Flash
-1550 1600 Flash
-2075 1600 Flash
-2075 2700 Flash
-6075 1775 Flash
-5775 1325 Flash
-750 1600 Flash
-750 1250 Flash
-350 700 Flash
-200 1250 Flash
0 0 55 /PRndPad SetFlash
-1400 750 Flash
0 0 55 /PRndPad SetFlash
-1600 3000 Flash
-3250 3275 Flash
-700 2350 Flash
-700 1650 Flash
-2850 1575 Flash
-2925 1275 Flash
-4100 1275 Flash
0 0 55 /PRndPad SetFlash
-1750 2925 Flash
-950 2900 Flash
-1600 1850 Flash
-1600 1200 Flash
0 0 55 /PRndPad SetFlash
-1850 2975 Flash
-1050 2950 Flash
-1925 1875 Flash
-1000 2100 Flash
-1400 2075 Flash
0 0 55 /PRndPad SetFlash
-1950 3000 Flash
-1950 2800 Flash
-1150 2800 Flash
-2400 2225 Flash
-1800 2250 Flash
-1800 1000 Flash
-1450 1025 Flash
0 0 55 /PRndPad SetFlash
-3000 3150 Flash
-3000 2025 Flash
-1250 2025 Flash
-1000 2025 Flash
-1350 975 Flash
-875 975 Flash
0 0 55 /PRndPad SetFlash
-3400 3200 Flash
-3350 2175 Flash
-1350 2125 Flash
-1100 2125 Flash
0 0 55 /PRndPad SetFlash
-2500 3150 Flash
-2550 1975 Flash
-1500 1450 Flash
0 0 55 /PRndPad SetFlash
-1900 3050 Flash
-2900 3225 Flash
-2750 2200 Flash
-1500 1850 Flash
-1300 1850 Flash
-1300 750 Flash
0 0 55 /PRndPad SetFlash
-4300 2625 Flash
-2300 2450 Flash
0 0 55 /PRndPad SetFlash
-6350 1925 Flash
-6350 1050 Flash
-2650 1925 Flash
-2900 1925 Flash
0 0 55 /PRndPad SetFlash
-2925 2600 Flash
0 0 55 /PRndPad SetFlash
-900 1300 Flash
-2850 1275 Flash
0 0 55 /PRndPad SetFlash
-3550 1050 Flash
0 0 55 /PRndPad SetFlash
-3900 2550 Flash
-3125 2525 Flash
-3100 1350 Flash
-4475 1625 Flash
-4475 2725 Flash
0 0 55 /PRndPad SetFlash
-4100 3300 Flash
-3750 3300 Flash
0 0 55 /PRndPad SetFlash
-3400 1350 Flash
-3450 2250 Flash
-2850 2225 Flash
0 0 55 /PRndPad SetFlash
-1100 2850 Flash
-650 2850 Flash
-625 1375 Flash
-1350 1375 Flash
0 0 55 /PRndPad SetFlash
-5750 2875 Flash
-5750 1550 Flash
0 0 55 /PRndPad SetFlash
-3850 3000 Flash
-5600 3000 Flash
0 0 55 /PRndPad SetFlash
-3500 1300 Flash
0 0 55 /PRndPad SetFlash
-4550 1100 Flash
-4550 500 Flash
-4550 1800 Flash
-4550 950 Flash
-4250 950 Flash
-4550 2500 Flash
-3750 950 Flash
-4550 2900 Flash
-4250 2900 Flash
-4550 3400 Flash
-3450 950 Flash
-3650 950 Flash
-3650 1650 Flash
-3450 1650 Flash
-3350 950 Flash
-3250 1650 Flash
-3350 600 Flash
-3250 600 Flash
-3250 1800 Flash
-3250 2300 Flash
-2950 2300 Flash
-2150 2300 Flash
-2150 2500 Flash
-2150 1800 Flash
-2250 3250 Flash
-2150 3250 Flash
-2150 1100 Flash
-2250 3525 Flash
-2450 3525 Flash
-2050 3525 Flash
-2150 1475 Flash
-2350 1475 Flash
-2150 500 Flash
-2150 600 Flash
-1850 600 Flash
-2150 300 Flash
-1875 300 Flash
-1550 3250 Flash
-1350 3250 Flash
-750 3250 Flash
-525 3250 Flash
-525 2200 Flash
-750 2200 Flash
-525 2698 Flash
-625 500 Flash
0 0 55 /PRndPad SetFlash
-3000 1675 Flash
-4350 1700 Flash
-4400 1175 Flash
0 0 55 /PRndPad SetFlash
-3300 1225 Flash
-3300 2875 Flash
0 0 55 /PRndPad SetFlash
-3800 3475 Flash
0 0 55 /PRndPad SetFlash
-3200 3425 Flash
0 0 55 /PRndPad SetFlash
-2400 1000 Flash
0 0 55 /PRndPad SetFlash
-2075 1125 Flash
0 0 55 /PRndPad SetFlash
-1200 200 Flash
-2950 575 Flash
0 0 55 /PRndPad SetFlash
-2550 2400 Flash
-1800 2775 Flash
0 0 55 /PRndPad SetFlash
-650 2000 Flash
0 0 55 /PRndPad SetFlash
-850 3550 Flash
-575 3550 Flash
-600 1050 Flash
0 0 55 /PRndPad SetFlash
-3700 2850 Flash
-950 3575 Flash
-2800 3575 Flash
0 0 55 /PRndPad SetFlash
-375 3200 Flash
0 0 55 /PRndPad SetFlash
-5500 3150 Flash
-2700 3375 Flash
-2625 2225 Flash
-2225 2200 Flash
-2225 1200 Flash
0 0 55 /PRndPad SetFlash
-2450 2375 Flash
-5600 2225 Flash
0 0 55 /PRndPad SetFlash
-4800 750 Flash
-4900 2225 Flash
-3500 2300 Flash
0 0 55 /PRndPad SetFlash
-4050 1875 Flash
0 0 55 /PRndPad SetFlash
-3650 2175 Flash
-3550 1975 Flash
0 0 55 /PRndPad SetFlash
-3900 1050 Flash
0 0 55 /PRndPad SetFlash
-4050 2950 Flash
-4725 2950 Flash
-4725 1375 Flash
-5200 1350 Flash
-5200 1150 Flash
-7250 1150 Flash
-2350 1700 Flash
-2400 1225 Flash
0 0 55 /PRndPad SetFlash
-4400 2575 Flash
-2850 2425 Flash
0 0 55 /PRndPad SetFlash
-2900 850 Flash
0 0 55 /PRndPad SetFlash
-2600 1450 Flash
0 0 55 /PRndPad SetFlash
-7325 2800 Flash
-7325 2175 Flash
0 0 55 /PRndPad SetFlash
-2700 2850 Flash
-2700 750 Flash
-3100 400 Flash
0 0 55 /PRndPad SetFlash
-950 825 Flash
-2800 850 Flash
0 0 55 /PRndPad SetFlash
-5100 2375 Flash
-1750 1325 Flash
-1700 2200 Flash
0 0 55 /PRndPad SetFlash
-5000 1000 Flash
-1900 1000 Flash
-750 2125 Flash
-750 1900 Flash
-1850 1900 Flash
0 0 55 /PRndPad SetFlash
-4800 2950 Flash
-4850 2300 Flash
-4750 1500 Flash
-1975 1950 Flash
0 0 55 /PRndPad SetFlash
-50 3625 Flash
-125 1375 Flash
0 0 55 /PRndPad SetFlash
-2800 950 Flash
0 0 55 /PRndPad SetFlash
-3600 2950 Flash
0 0 55 /PRndPad SetFlash
-5350 2725 Flash
-6200 1500 Flash
-6050 900 Flash
-6000 1200 Flash
-5400 1200 Flash
0 0 55 /PRndPad SetFlash
-2425 3425 Flash
-2225 2575 Flash
-1200 1850 Flash
0 0 55 /PRndPad SetFlash
-2250 900 Flash
0 0 55 /PRndPad SetFlash
-3150 1475 Flash
-3150 2900 Flash
-2650 600 Flash
0 0 55 /PRndPad SetFlash
-3125 2625 Flash
0 0 55 /PRndPad SetFlash
-1050 400 Flash
-1925 700 Flash
-1200 1350 Flash
-5300 775 Flash
-5300 1725 Flash
-6250 1750 Flash
0 0 55 /PRndPad SetFlash
-125 1275 Flash
-50 1672 Flash
grestore
showpage
