%!PS-Adobe-2.0
%%Title: PADS Postscript Driver Header
%%Creator: Andy Montalvo, 18 Lupine St., Lowell, MA  01851
%%CreationDate: 06/08/90
%%For: CAD Software, Littleton, MA
%%EndComments
%%BeginProcSet: Markers 1.0 0
% marker attributes
/MAttr_Width 1 def
/MAttr_Size  0 def
/MAttr_Type /M1 def
% procedures
/M1 { %def
% draw marker 1: plus
% Stack: - M1 -
    -2 0 rmoveto
    4 0 rlineto
    -2 2 rmoveto
    0 -4 rlineto
} bind def
/M2 { %def
% draw marker 2: cross
% Stack: - M2 -
    -2 -2 rmoveto
    4 4 rlineto
    -4 0 rmoveto
    4 -4 rlineto
} bind def
/M3 { %def
% draw marker 3: square
% Stack: - M3 -
    0 2 rlineto
    2 0 rlineto
    0 -4 rlineto
    -4 0 rlineto
    0 4 rlineto
    2 0 rlineto
} bind def
/M4 { %def
% draw marker 4: diamond
% Stack: - M4 -
    0 2 rlineto
    2 -2 rlineto
    -2 -2 rlineto
    -2 2 rlineto
    2 2 rlineto
} bind def
/M5 { %def
% draw marker 5: hourglass
% Stack: - M5 -
    2 2 rlineto
    -4 0 rlineto
    4 -4 rlineto
    -4 0 rlineto
    2 2 rlineto
} bind def
/M6 { %def
% draw marker 6: bowtie
% Stack: - M6 -
    2 2 rlineto
    0 -4 rlineto
    -4 4 rlineto
    0 -4 rlineto
    2 2 rlineto
} bind def
/M7 { %def
% draw marker 7: small plus (goes with char marker)
% Stack: - M7 -
    -1 0 rmoveto
    2 0 rlineto
    -1 1 rmoveto
    0 -2 rlineto
} bind def
/Marker { %def
% Command from driver: draw marker
% STACK: x y Marker -
    MAttr_Size 0 gt
    {
        gsave
        moveto
        MAttr_Size 4 div dup scale
        MAttr_Type load exec
        4 MAttr_Size div dup scale
        MAttr_Width setlinewidth
        stroke
        grestore
    } if
} def
%%EndProcSet: Markers 1.0 0
%%BeginProcSet: Lib 1.0 0
/sg { %def
% Command from driver: set the gray scale 0 - 100
% STACK: greylevel sg
    100 div dup setgray /glev exch def
} bind def
/Circle { %def
% draw a circle
% STACK: x y radius Circle -
    0 360 arc
} bind def
/RndAper { %def
% select a round aperture
% STACK: - RndAper -
    1 setlinejoin
    1 setlinecap
} bind def
/SqrAper { %def
% select a square aperture
% STACK: - SqrAper -
    0 setlinejoin
    2 setlinecap
} bind def
/Line { %def
% draw a set of connected lines
% STACK: x1 y1 [ x2 y2 ... xn yn ] Line -
    3 1 roll
    moveto
    true
    exch
    % This pushes the x then the y then does lineto
    { exch  { false } { lineto true } ifelse } forall
    pop
} bind def
/Clipto { %def
% set clipping rectangle from 0,0 to new values
% STACK: x y Clipto -
    0 0 moveto
    dup 0 exch lineto
    2 copy lineto
    pop
    0 lineto
    closepath
    clip
    newpath
} bind def
/Clip4 { %def
% set clipping rectangle from xmin,ymin to xmax,ymax
% STACK: xmin ymin xmax ymax Clip4 -
    4 copy pop pop moveto
    4 copy pop exch lineto pop
    2 copy lineto
    exch pop exch pop lineto
    closepath
    clip
    newpath
} bind def
%%EndProcSet: Lib 1.0 0
%%BeginProcSet: Lines 1.0 0
% line attributes %
/LAttr_Width 1 def
% line procedures
/PLine { %def
% Cammand from driver: draw a set of connected lines
% STACK: x1 y1 [ x2 y2 ... xn yn ] PLine -
    Line
    LAttr_Width setlinewidth
    stroke
} bind def % PLine
/Char { %def
% Command from driver: draw a character at the current position
% STACK: type x y stroke_array Char -
%    stroke array -- [ stroke1 stroke2 ... stroken ]
%    stroke -- connected staight lines
%    type = 0 if text  1 if marker
    gsave
    4 1 roll
    translate
    0 eq { TAttr_Width } { MAttr_Width } ifelse setlinewidth
    {
        dup length 2 gt
        {
            dup dup 0 get exch 1 get % get starting point
            3 -1 roll                % put x y before array
            dup length 2 sub 2 exch getinterval % delete first items from array
            Line
            stroke
        }
        {
            aload pop currentlinewidth 2 div Circle fill
        } ifelse
    } forall
    grestore
} bind def % Char
/PArc { %def
% Command from driver: draw an arc
% STACK: x y radius startangle deltaangle Arc -
	 10 div exch 10 div exch
    2 copy pop add
    arc
    LAttr_Width setlinewidth
    stroke
} bind def
/PCircle { %def
% Command from driver: draw an circle
% STACK: x y radius PCircle -
    Circle
    LAttr_Width setlinewidth
    stroke
} bind def
%%EndProcSet: Lines 1.0 0
%%BeginProcSet: Polygon 1.0 0
% polygon attributes %
/PAttr_ExtWidth 1 def
/PAttr_IntWidth 1 def
/PAttr_Grid 1 def
% polygon procedures
/LoopSet { %def
% set up for loop condition
% STACK: start end LoopSet low gridwidth high
    2 copy lt { exch } if
    % make grid line up to absolute coordinates
    PAttr_Grid div truncate PAttr_Grid mul exch
    PAttr_Grid exch
} bind def
/Hatch { %def
% draw cross hatch pattern in current path
% STACK: - Hatch -
    pathbbox
    /ury exch def
    /urx exch def
    /lly exch def
    /llx exch def
    clip
    newpath
    llx urx LoopSet
    { % x loop
        dup lly exch ury moveto lineto
    } for
    lly ury LoopSet
    { % y loop
        llx exch dup urx exch moveto lineto
    } for
    PAttr_IntWidth setlinewidth
    stroke
} bind def
/PPoly { %def
% Command from driver: draw a plygon
% STACK: x1 y1 [ x2 y2 ... xn yn ] PLine -
    Line
    closepath
    gsave
    PAttr_IntWidth PAttr_Grid ge {fill} {Hatch} ifelse
    grestore
    PAttr_ExtWidth setlinewidth
    stroke
} bind def
%%EndProcSet: Polygon 1.0 0
%%BeginProcSet: Text 1.0 0
% text attributes %
/TAttr_Mirr 0 def
/TAttr_Orient 0 def
/TAttr_Width 1 def
% text procedures
/Text { %def
% Command from driver: Draw text
% STACK: x y width string Text -
    gsave
    4 2 roll
    translate
    TAttr_Mirr 0 gt
    {
        -1 1 scale
    } if
    TAttr_Orient rotate
    0 0 moveto
    dup length dup 1 gt
    {
        exch dup stringwidth pop
        4 -1 roll
        exch 2 copy
        lt
        {
            div 1 scale show
        }
        {
            sub
            3 -1 roll 1 sub div
            0 3 -1 roll ashow
        }
        ifelse
    }
    {
        pop
        show
    } ifelse
    grestore
} bind def
%%EndProcSet: Text 1.0 0
%%BeginProcSet: FlashSymbols 1.0 0
% flash symbol attributes %
/FAttr_Type /PRndPad def
/FAttr_Width  0 def
/FAttr_Length 1 def
/FAttr_Orient 0 def
% flash symbol procedures
/PRndPad { %def
% Command from driver: draw an circular pad
% STACK: - PCirclePad -
    FAttr_Width dup scale
    0 0 .5 Circle
    fill
} bind def
/PSqrPad { %def
% Draw an Square pad
% STACK: - PRectPad -
    FAttr_Width dup scale
    .5 .5 moveto
    -.5 .5 lineto
    -.5 -.5 lineto
    .5 -.5 lineto
    closepath
    fill
} bind def
/PRectPad { %def
% Draw an rectangular pad
% STACK: - PRectPad -
    FAttr_Length FAttr_Width scale
    .5 .5 moveto
    -.5 .5 lineto
    -.5 -.5 lineto
    .5 -.5 lineto
    closepath
    fill
} bind def
/POvalPad { %def
% Draw an oval pad
% STACK: - POvalPad -
    FAttr_Width setlinewidth
    FAttr_Length FAttr_Width sub 2 div dup
    neg 0 moveto
    0 lineto
    RndAper
    stroke
} bind def
/Anl { %def
    0 0 .5 Circle
    fill
    FAttr_Length FAttr_Width lt
    { % inner circle
        0 0
        FAttr_Length 0 gt { FAttr_Length FAttr_Width div } { .5 } ifelse
        2 div Circle
        1 setgray
        fill
        glev setgray
    } if
} bind def
/PAnlPad { %def
% Draw an annular pad
% STACK: - PAnlPad -
    FAttr_Width dup scale
    Anl
} bind def
/PRelPad { %def
% Draw an thermal relief pad
% STACK: - PRelPad -
    PAnlPad
    1 setgray
    .17 setlinewidth
    0 setlinecap   % the x
    45 rotate
    .5 0 moveto -.5 0 lineto
    0 .5 moveto  0 -.5 lineto
    stroke
    glev setgray
} bind def
/Flash { %def
% Command from driver: Flash a symbol
% STACK: x y Flash -
    FAttr_Width 0 gt
    {
        gsave
        translate
        FAttr_Orient rotate
        FAttr_Type load exec
        grestore
    } if
} def
%%EndProcSet: FlashSymbols 1.0 0
%%BeginProcSet: SetAttr 1.0 0
/SetLine { %def
% Set the width of the lines
% STACK: linewidth SetLine -
    /LAttr_Width exch def
    RndAper
} bind def
/SetPoly { %def
% Set attribute of polygon
% STACK: external_width internal_grid_width grid_spacing SetPoly -
    /PAttr_Grid exch def
    /PAttr_IntWidth exch def
    /PAttr_ExtWidth exch def
    RndAper
} bind def
/SetFlash { %def
% Set Attributed of flash pad
% STACK: orientation_angle length width aperture_type SetFlash -
    /FAttr_Type exch def
    FAttr_Type /PSqrPad eq FAttr_Type /PRectPad eq or
    { SqrAper } { RndAper } ifelse
    /FAttr_Width exch def
    /FAttr_Length exch def
    /FAttr_Orient exch 10 div def
} bind def
/SetMkr { %def
% Set attributes of markers
% STACK: linewidth size type SetMkr -
    /MAttr_Type exch def
    /MAttr_Size exch def
    /MAttr_Width exch def
    RndAper
} bind def
/SetText1 { %def
% Set attributes of text
% STACK: fontname height orient mirror SetMkr -
    /TAttr_Mirr exch def
    /TAttr_Orient exch 10 div def
    exch findfont exch scalefont setfont
    RndAper
} bind def
/SetText2 { %def
% Set attributes of text
% STACK: linewidth height mirror orient SetMkr -
    /TAttr_Width exch def
    RndAper
} bind def
%%EndProcSet: SetAttr 1.0 0
%%BeginProcSet: Initialize 1.0 0
/Init { %def
% Initialize the driver
% STACK: Init -
    72 1000 div dup scale % Scale to 1/1000 inch
    250 250 translate     % make origin 1/4 inch from bottom left
    1.5 setmiterlimit 1 RndAper                     % set line defaults
    0 setgray                                       % set color default
    /glev 0 def
} def
%%EndProcSet: Initialize 1.0 0
%%EndProlog
/Helvetica findfont 12 scalefont setfont
35 760 moveto
(lr.job - Fri Jul 17 02:19:39 1992) show
gsave
Init
8000 10500 Clipto
5949 9052 translate
90 rotate
1 1 div dup scale
75 sg
50 sg
25 sg
0 sg
10 SetLine
-8000 0 [ -8000 3895 ] PLine
-8000 3895 [ 0 3895 ] PLine
0 3895 [ 0 0 ] PLine
0 0 [ -750 0 ] PLine
-750 0 [ -800 -50 ] PLine
-800 -50 [ -800 -250 ] PLine
-800 -250 [ -850 -300 ] PLine
-850 -300 [ -3950 -300 ] PLine
-3950 -300 [ -4000 -250 ] PLine
-4000 -250 [ -4000 -50 ] PLine
-4000 -50 [ -4050 0 ] PLine
-4050 0 [ -8000 0 ] PLine
10 SetLine
-7805 3900 [ -8005 3900 ] PLine
-8005 3900 [ -8005 3700 ] PLine
10 SetLine
-8000 200 [ -8000 0 ] PLine
-8000 0 [ -7800 0 ] PLine
10 SetLine
-200 0 [ 0 0 ] PLine
0 0 [ 0 200 ] PLine
10 SetLine
-200 3892 [ 0 3892 ] PLine
0 3892 [ 0 3692 ] PLine
10 SetLine
-8000 4150 [ -8000 3950 ] PLine
10 SetLine
-8250 3900 [ -8050 3900 ] PLine
10 SetLine
-8250 0 [ -8050 0 ] PLine
10 SetLine
-8200 3900 [ -8200 2150 ] PLine
10 SetLine
-8200 0 [ -8200 1700 ] PLine
10 SetLine
0 4151 [ 0 3951 ] PLine
10 SetLine
-8000 4100 [ -4050 4100 ] PLine
10 SetLine
-3650 4100 [ 0 4100 ] PLine
10 SetLine
-4000 -325 [ -4000 -556 ] PLine
10 SetLine
-3989 -500 [ -2500 -500 ] PLine
10 SetLine
-2175 -500 [ -800 -500 ] PLine
10 SetLine
-4001 -501 [ -3951 -451 ] PLine
10 SetLine
-4004 -496 [ -3954 -546 ] PLine
10 SetLine
-852 -448 [ -802 -498 ] PLine
10 SetLine
-846 -546 [ -796 -496 ] PLine
10 SetLine
-650 150 [ -650 0 ] PLine
10 SetLine
-600 50 [ -650 0 ] PLine
10 SetLine
-700 50 [ -650 0 ] PLine
10 SetLine
-775 -300 [ -600 -300 ] PLine
10 SetLine
-650 -300 [ -650 -450 ] PLine
10 SetLine
-650 -300 [ -600 -350 ] PLine
10 SetLine
-650 -300 [ -700 -350 ] PLine
10 SetLine
-793 -500 [ -500 -500 ] PLine
10 SetLine
0 -500 [ -225 -500 ] PLine
10 SetLine
0 -500 [ -50 -450 ] PLine
10 SetLine
0 -500 [ -50 -550 ] PLine
10 SetLine
-801 -501 [ -751 -451 ] PLine
10 SetLine
-810 -490 [ -760 -540 ] PLine
10 SetLine
-800 -325 [ -800 -550 ] PLine
10 SetLine
0 -50 [ 0 -550 ] PLine
10 SetLine
0 4100 [ -50 4150 ] PLine
10 SetLine
0 4100 [ -50 4050 ] PLine
10 SetLine
-8000 4100 [ -7950 4150 ] PLine
10 SetLine
-8000 4100 [ -7950 4050 ] PLine
10 SetLine
-8200 3900 [ -8150 3850 ] PLine
10 SetLine
-8200 3900 [ -8250 3850 ] PLine
10 SetLine
-8200 0 [ -8250 50 ] PLine
10 SetLine
-8200 0 [ -8150 50 ] PLine
10 SetLine
-7050 3200 [ -6850 3200 ] PLine
-6850 3200 [ -6850 3100 ] PLine
-6850 3100 [ -7050 3100 ] PLine
-7050 3100 [ -7050 3200 ] PLine
10 SetLine
-7450 2950 [ -7650 2950 ] PLine
-7650 2950 [ -7650 3050 ] PLine
-7650 3050 [ -7450 3050 ] PLine
-7450 3050 [ -7450 2950 ] PLine
10 SetLine
-7450 2800 [ -7650 2800 ] PLine
-7650 2800 [ -7650 2900 ] PLine
-7650 2900 [ -7450 2900 ] PLine
-7450 2900 [ -7450 2800 ] PLine
10 SetLine
-7650 2300 [ -7450 2300 ] PLine
-7450 2300 [ -7450 2200 ] PLine
-7450 2200 [ -7650 2200 ] PLine
-7650 2200 [ -7650 2300 ] PLine
10 SetLine
-7650 2150 [ -7450 2150 ] PLine
-7450 2150 [ -7450 2050 ] PLine
-7450 2050 [ -7650 2050 ] PLine
-7650 2050 [ -7650 2150 ] PLine
10 SetLine
-7050 2300 [ -6850 2300 ] PLine
-6850 2300 [ -6850 2200 ] PLine
-6850 2200 [ -7050 2200 ] PLine
-7050 2200 [ -7050 2300 ] PLine
10 SetLine
-7450 1900 [ -7650 1900 ] PLine
-7650 1900 [ -7650 2000 ] PLine
-7650 2000 [ -7450 2000 ] PLine
-7450 2000 [ -7450 1900 ] PLine
10 SetLine
-7050 2000 [ -6850 2000 ] PLine
-6850 2000 [ -6850 1900 ] PLine
-6850 1900 [ -7050 1900 ] PLine
-7050 1900 [ -7050 2000 ] PLine
10 SetLine
-7400 1150 [ -7700 1150 ] PLine
-7700 1150 [ -7700 1050 ] PLine
-7700 1050 [ -7400 1050 ] PLine
-7400 1050 [ -7400 1150 ] PLine
10 SetLine
-7250 1750 [ -7250 1550 ] PLine
-7250 1550 [ -7350 1550 ] PLine
-7350 1550 [ -7350 1750 ] PLine
-7350 1750 [ -7250 1750 ] PLine
10 SetLine
-7450 1200 [ -7650 1200 ] PLine
-7650 1200 [ -7650 1300 ] PLine
-7650 1300 [ -7450 1300 ] PLine
-7450 1300 [ -7450 1200 ] PLine
10 SetLine
-6550 750 [ -6750 750 ] PLine
-6750 750 [ -6750 850 ] PLine
-6750 850 [ -6550 850 ] PLine
-6550 850 [ -6550 750 ] PLine
10 SetLine
-6950 750 [ -7150 750 ] PLine
-7150 750 [ -7150 850 ] PLine
-7150 850 [ -6950 850 ] PLine
-6950 850 [ -6950 750 ] PLine
10 SetLine
-6200 1150 [ -6200 1350 ] PLine
-6200 1350 [ -6100 1350 ] PLine
-6100 1350 [ -6100 1150 ] PLine
-6100 1150 [ -6200 1150 ] PLine
10 SetLine
-7450 850 [ -7750 850 ] PLine
-7750 850 [ -7750 750 ] PLine
-7750 750 [ -7450 750 ] PLine
-7450 750 [ -7450 850 ] PLine
10 SetLine
-7350 400 [ -7350 600 ] PLine
-7350 600 [ -7250 600 ] PLine
-7250 600 [ -7250 400 ] PLine
-7250 400 [ -7350 400 ] PLine
10 SetLine
-7450 900 [ -7650 900 ] PLine
-7650 900 [ -7650 1000 ] PLine
-7650 1000 [ -7450 1000 ] PLine
-7450 1000 [ -7450 900 ] PLine
10 SetLine
-4900 2650 [ -4900 2850 ] PLine
-4900 2850 [ -4800 2850 ] PLine
-4800 2850 [ -4800 2650 ] PLine
-4800 2650 [ -4900 2650 ] PLine
10 SetLine
-6050 3100 [ -6050 2800 ] PLine
-6050 2800 [ -5950 2800 ] PLine
-5950 2800 [ -5950 3100 ] PLine
-5950 3100 [ -6050 3100 ] PLine
10 SetLine
-6600 450 [ -6400 450 ] PLine
-6400 450 [ -6400 350 ] PLine
-6400 350 [ -6600 350 ] PLine
-6600 350 [ -6600 450 ] PLine
10 SetLine
-6400 550 [ -6600 550 ] PLine
-6600 550 [ -6600 650 ] PLine
-6600 650 [ -6400 650 ] PLine
-6400 650 [ -6400 550 ] PLine
10 SetLine
-5950 850 [ -6250 850 ] PLine
-6250 850 [ -6250 750 ] PLine
-6250 750 [ -5950 750 ] PLine
-5950 750 [ -5950 850 ] PLine
10 SetLine
-5650 500 [ -5650 700 ] PLine
-5650 700 [ -5550 700 ] PLine
-5550 700 [ -5550 500 ] PLine
-5550 500 [ -5650 500 ] PLine
10 SetLine
-5975 900 [ -6175 900 ] PLine
-6175 900 [ -6175 1000 ] PLine
-6175 1000 [ -5975 1000 ] PLine
-5975 1000 [ -5975 900 ] PLine
10 SetLine
-6350 2250 [ -6350 2450 ] PLine
-6350 2450 [ -6250 2450 ] PLine
-6250 2450 [ -6250 2250 ] PLine
-6250 2250 [ -6350 2250 ] PLine
10 SetLine
-6500 2250 [ -6500 2450 ] PLine
-6500 2450 [ -6400 2450 ] PLine
-6400 2450 [ -6400 2250 ] PLine
-6400 2250 [ -6500 2250 ] PLine
10 SetLine
-5800 2250 [ -5800 2550 ] PLine
-5800 2550 [ -5900 2550 ] PLine
-5900 2550 [ -5900 2250 ] PLine
-5900 2250 [ -5800 2250 ] PLine
10 SetLine
-6050 2250 [ -6050 2450 ] PLine
-6050 2450 [ -5950 2450 ] PLine
-5950 2450 [ -5950 2250 ] PLine
-5950 2250 [ -6050 2250 ] PLine
10 SetLine
-5650 2500 [ -5450 2500 ] PLine
-5450 2500 [ -5450 2400 ] PLine
-5450 2400 [ -5650 2400 ] PLine
-5650 2400 [ -5650 2500 ] PLine
10 SetLine
-4900 2400 [ -5100 2400 ] PLine
-5100 2400 [ -5100 2500 ] PLine
-5100 2500 [ -4900 2500 ] PLine
-4900 2500 [ -4900 2400 ] PLine
10 SetLine
-600 750 [ -600 450 ] PLine
-600 450 [ -500 450 ] PLine
-500 450 [ -500 750 ] PLine
-500 750 [ -600 750 ] PLine
10 SetLine
-4500 3150 [ -4500 3350 ] PLine
-4500 3350 [ -4400 3350 ] PLine
-4400 3350 [ -4400 3150 ] PLine
-4400 3150 [ -4500 3150 ] PLine
10 SetLine
-2200 3650 [ -2200 3450 ] PLine
-2200 3450 [ -2300 3450 ] PLine
-2300 3450 [ -2300 3650 ] PLine
-2300 3650 [ -2200 3650 ] PLine
10 SetLine
-1300 3650 [ -1300 3450 ] PLine
-1300 3450 [ -1400 3450 ] PLine
-1400 3450 [ -1400 3650 ] PLine
-1400 3650 [ -1300 3650 ] PLine
10 SetLine
-4400 2750 [ -4400 2550 ] PLine
-4400 2550 [ -4500 2550 ] PLine
-4500 2550 [ -4500 2750 ] PLine
-4500 2750 [ -4400 2750 ] PLine
10 SetLine
-2900 2750 [ -2900 2550 ] PLine
-2900 2550 [ -3000 2550 ] PLine
-3000 2550 [ -3000 2750 ] PLine
-3000 2750 [ -2900 2750 ] PLine
10 SetLine
-4400 2050 [ -4400 1850 ] PLine
-4400 1850 [ -4500 1850 ] PLine
-4500 1850 [ -4500 2050 ] PLine
-4500 2050 [ -4400 2050 ] PLine
10 SetLine
-3000 2050 [ -3000 1850 ] PLine
-3000 1850 [ -3100 1850 ] PLine
-3100 1850 [ -3100 2050 ] PLine
-3100 2050 [ -3000 2050 ] PLine
10 SetLine
-4400 1350 [ -4400 1150 ] PLine
-4400 1150 [ -4500 1150 ] PLine
-4500 1150 [ -4500 1350 ] PLine
-4500 1350 [ -4400 1350 ] PLine
10 SetLine
-3400 1350 [ -3400 1150 ] PLine
-3400 1150 [ -3500 1150 ] PLine
-3500 1150 [ -3500 1350 ] PLine
-3500 1350 [ -3400 1350 ] PLine
10 SetLine
-4400 750 [ -4400 550 ] PLine
-4400 550 [ -4500 550 ] PLine
-4500 550 [ -4500 750 ] PLine
-4500 750 [ -4400 750 ] PLine
10 SetLine
-2000 750 [ -2000 550 ] PLine
-2000 550 [ -2100 550 ] PLine
-2100 550 [ -2100 750 ] PLine
-2100 750 [ -2000 750 ] PLine
10 SetLine
-4800 750 [ -4800 450 ] PLine
-4800 450 [ -4700 450 ] PLine
-4700 450 [ -4700 750 ] PLine
-4700 750 [ -4800 750 ] PLine
10 SetLine
-800 750 [ -800 450 ] PLine
-800 450 [ -700 450 ] PLine
-700 450 [ -700 750 ] PLine
-700 750 [ -800 750 ] PLine
10 SetLine
-4850 3550 [ -4850 3250 ] PLine
-4850 3250 [ -4750 3250 ] PLine
-4750 3250 [ -4750 3550 ] PLine
-4750 3550 [ -4850 3550 ] PLine
10 SetLine
-4800 1350 [ -4800 1050 ] PLine
-4800 1050 [ -4700 1050 ] PLine
-4700 1050 [ -4700 1350 ] PLine
-4700 1350 [ -4800 1350 ] PLine
10 SetLine
-7550 3350 [ -7550 3250 ] PLine
10 SetLine
-7540 3350 [ -7540 3250 ] PLine
10 SetLine
-7400 3300 [ -7350 3300 ] PLine
10 SetLine
-7600 3250 [ -7600 3350 ] PLine
-7600 3350 [ -7400 3350 ] PLine
-7400 3350 [ -7400 3250 ] PLine
-7400 3250 [ -7600 3250 ] PLine
10 SetLine
-7600 3300 [ -7660 3300 ] PLine
10 SetLine
-7560 3350 [ -7560 3250 ] PLine
10 SetLine
-7450 3100 [ -7450 3200 ] PLine
10 SetLine
-7460 3100 [ -7460 3200 ] PLine
10 SetLine
-7600 3150 [ -7650 3150 ] PLine
10 SetLine
-7400 3200 [ -7400 3100 ] PLine
-7400 3100 [ -7600 3100 ] PLine
-7600 3100 [ -7600 3200 ] PLine
-7600 3200 [ -7400 3200 ] PLine
10 SetLine
-7400 3150 [ -7340 3150 ] PLine
10 SetLine
-7440 3100 [ -7440 3200 ] PLine
10 SetLine
-4900 2100 [ -4900 2200 ] PLine
10 SetLine
-4910 2100 [ -4910 2200 ] PLine
10 SetLine
-5050 2150 [ -5100 2150 ] PLine
10 SetLine
-4850 2200 [ -4850 2100 ] PLine
-4850 2100 [ -5050 2100 ] PLine
-5050 2100 [ -5050 2200 ] PLine
-5050 2200 [ -4850 2200 ] PLine
10 SetLine
-4850 2150 [ -4790 2150 ] PLine
10 SetLine
-4890 2100 [ -4890 2200 ] PLine
10 SetLine
-5550 3100 [ -5550 3000 ] PLine
10 SetLine
-5540 3100 [ -5540 3000 ] PLine
10 SetLine
-5400 3050 [ -5350 3050 ] PLine
10 SetLine
-5600 3000 [ -5600 3100 ] PLine
-5600 3100 [ -5400 3100 ] PLine
-5400 3100 [ -5400 3000 ] PLine
-5400 3000 [ -5600 3000 ] PLine
10 SetLine
-5600 3050 [ -5660 3050 ] PLine
10 SetLine
-5560 3100 [ -5560 3000 ] PLine
10 SetLine
-6200 2350 [ -6100 2350 ] PLine
10 SetLine
-6200 2360 [ -6100 2360 ] PLine
10 SetLine
-6150 2500 [ -6150 2550 ] PLine
10 SetLine
-6100 2300 [ -6200 2300 ] PLine
-6200 2300 [ -6200 2500 ] PLine
-6200 2500 [ -6100 2500 ] PLine
-6100 2500 [ -6100 2300 ] PLine
10 SetLine
-6150 2300 [ -6150 2240 ] PLine
10 SetLine
-6200 2340 [ -6100 2340 ] PLine
10 SetLine
-6947 1651 190 PCircle
10 SetLine
-6757 1676 [ -6697 1676 ] PLine
-6697 1676 [ -6697 1611 ] PLine
-6697 1611 [ -6762 1611 ] PLine
10 SetLine
-7300 1000 [ -6500 1000 ] PLine
-6500 1000 [ -6500 1200 ] PLine
-6500 1200 [ -7300 1200 ] PLine
-7300 1200 [ -7300 1125 ] PLine
-7300 1125 [ -7250 1125 ] PLine
-7250 1125 [ -7250 1075 ] PLine
-7250 1075 [ -7300 1075 ] PLine
-7300 1075 [ -7300 1000 ] PLine
10 SetLine
-6950 500 190 PCircle
10 SetLine
-6760 525 [ -6700 525 ] PLine
-6700 525 [ -6700 460 ] PLine
-6700 460 [ -6765 460 ] PLine
10 SetLine
-6500 3075 [ -6500 3675 ] PLine
-6500 3675 [ -6100 3675 ] PLine
-6100 3675 [ -6100 3075 ] PLine
-6100 3075 [ -6500 3075 ] PLine
10 SetLine
-6425 3075 [ -6425 2825 ] PLine
-6425 2825 [ -6375 2825 ] PLine
-6375 2825 [ -6375 3075 ] PLine
10 SetLine
-6225 3075 [ -6225 2825 ] PLine
-6225 2825 [ -6175 2825 ] PLine
-6175 2825 [ -6175 3075 ] PLine
10 SetLine
-6325 3075 [ -6325 2825 ] PLine
-6325 2825 [ -6275 2825 ] PLine
-6275 2825 [ -6275 3075 ] PLine
10 SetLine
-6304 3549 75 PCircle
10 SetLine
-6500 3425 [ -6100 3425 ] PLine
10 SetLine
-6096 501 190 PCircle
10 SetLine
-6121 691 [ -6121 751 ] PLine
-6121 751 [ -6056 751 ] PLine
-6056 751 [ -6056 686 ] PLine
10 SetLine
-5700 1000 [ -4900 1000 ] PLine
-4900 1000 [ -4900 1200 ] PLine
-4900 1200 [ -5700 1200 ] PLine
-5700 1200 [ -5700 1125 ] PLine
-5700 1125 [ -5650 1125 ] PLine
-5650 1125 [ -5650 1075 ] PLine
-5650 1075 [ -5700 1075 ] PLine
-5700 1075 [ -5700 1000 ] PLine
10 SetLine
-5700 2650 [ -5000 2650 ] PLine
-5000 2650 [ -5000 2850 ] PLine
-5000 2850 [ -5700 2850 ] PLine
-5700 2850 [ -5700 2775 ] PLine
-5700 2775 [ -5650 2775 ] PLine
-5650 2775 [ -5650 2725 ] PLine
-5650 2725 [ -5700 2725 ] PLine
-5700 2725 [ -5700 2650 ] PLine
10 SetLine
-5700 1600 [ -4900 1600 ] PLine
-4900 1600 [ -4900 1800 ] PLine
-4900 1800 [ -5700 1800 ] PLine
-5700 1800 [ -5700 1725 ] PLine
-5700 1725 [ -5650 1725 ] PLine
-5650 1725 [ -5650 1675 ] PLine
-5650 1675 [ -5700 1675 ] PLine
-5700 1675 [ -5700 1600 ] PLine
10 SetLine
-4400 3150 [ -2400 3150 ] PLine
-2400 3150 [ -2400 3650 ] PLine
-2400 3650 [ -4400 3650 ] PLine
-4400 3650 [ -4400 3425 ] PLine
-4400 3425 [ -4350 3425 ] PLine
-4350 3425 [ -4350 3375 ] PLine
-4350 3375 [ -4400 3375 ] PLine
-4400 3375 [ -4400 3150 ] PLine
10 SetLine
-3000 1850 [ -2200 1850 ] PLine
-2200 1850 [ -2200 2050 ] PLine
-2200 2050 [ -3000 2050 ] PLine
-3000 2050 [ -3000 1975 ] PLine
-3000 1975 [ -2950 1975 ] PLine
-2950 1975 [ -2950 1925 ] PLine
-2950 1925 [ -3000 1925 ] PLine
-3000 1925 [ -3000 1850 ] PLine
10 SetLine
-4400 1850 [ -3400 1850 ] PLine
-3400 1850 [ -3400 2050 ] PLine
-3400 2050 [ -4400 2050 ] PLine
-4400 2050 [ -4400 1975 ] PLine
-4400 1975 [ -4350 1975 ] PLine
-4350 1975 [ -4350 1925 ] PLine
-4350 1925 [ -4400 1925 ] PLine
-4400 1925 [ -4400 1850 ] PLine
10 SetLine
-4400 2550 [ -3200 2550 ] PLine
-3200 2550 [ -3200 2750 ] PLine
-3200 2750 [ -4400 2750 ] PLine
-4400 2750 [ -4400 2675 ] PLine
-4400 2675 [ -4350 2675 ] PLine
-4350 2675 [ -4350 2625 ] PLine
-4350 2625 [ -4400 2625 ] PLine
-4400 2625 [ -4400 2550 ] PLine
10 SetLine
-2000 1150 [ -600 1150 ] PLine
-600 1150 [ -600 1450 ] PLine
-600 1450 [ -2000 1450 ] PLine
-2000 1450 [ -2000 1325 ] PLine
-2000 1325 [ -1950 1325 ] PLine
-1950 1325 [ -1950 1275 ] PLine
-1950 1275 [ -2000 1275 ] PLine
-2000 1275 [ -2000 1150 ] PLine
10 SetLine
-2000 550 [ -1000 550 ] PLine
-1000 550 [ -1000 750 ] PLine
-1000 750 [ -2000 750 ] PLine
-2000 750 [ -2000 675 ] PLine
-2000 675 [ -1950 675 ] PLine
-1950 675 [ -1950 625 ] PLine
-1950 625 [ -2000 625 ] PLine
-2000 625 [ -2000 550 ] PLine
10 SetLine
-2000 2550 [ -600 2550 ] PLine
-600 2550 [ -600 3050 ] PLine
-600 3050 [ -2000 3050 ] PLine
-2000 3050 [ -2000 2825 ] PLine
-2000 2825 [ -1950 2825 ] PLine
-1950 2825 [ -1950 2775 ] PLine
-1950 2775 [ -2000 2775 ] PLine
-2000 2775 [ -2000 2550 ] PLine
10 SetLine
-2000 1750 [ -600 1750 ] PLine
-600 1750 [ -600 2250 ] PLine
-600 2250 [ -2000 2250 ] PLine
-2000 2250 [ -2000 2025 ] PLine
-2000 2025 [ -1950 2025 ] PLine
-1950 2025 [ -1950 1975 ] PLine
-1950 1975 [ -2000 1975 ] PLine
-2000 1975 [ -2000 1750 ] PLine
10 SetLine
-2900 2550 [ -2200 2550 ] PLine
-2200 2550 [ -2200 2750 ] PLine
-2200 2750 [ -2900 2750 ] PLine
-2900 2750 [ -2900 2675 ] PLine
-2900 2675 [ -2850 2675 ] PLine
-2850 2675 [ -2850 2625 ] PLine
-2850 2625 [ -2900 2625 ] PLine
-2900 2625 [ -2900 2550 ] PLine
10 SetLine
-4400 550 [ -3200 550 ] PLine
-3200 550 [ -3200 750 ] PLine
-3200 750 [ -4400 750 ] PLine
-4400 750 [ -4400 675 ] PLine
-4400 675 [ -4350 675 ] PLine
-4350 675 [ -4350 625 ] PLine
-4350 625 [ -4400 625 ] PLine
-4400 625 [ -4400 550 ] PLine
10 SetLine
-3400 1150 [ -2200 1150 ] PLine
-2200 1150 [ -2200 1350 ] PLine
-2200 1350 [ -3400 1350 ] PLine
-3400 1350 [ -3400 1275 ] PLine
-3400 1275 [ -3350 1275 ] PLine
-3350 1275 [ -3350 1225 ] PLine
-3350 1225 [ -3400 1225 ] PLine
-3400 1225 [ -3400 1150 ] PLine
10 SetLine
-2200 3450 [ -1500 3450 ] PLine
-1500 3450 [ -1500 3650 ] PLine
-1500 3650 [ -2200 3650 ] PLine
-2200 3650 [ -2200 3575 ] PLine
-2200 3575 [ -2150 3575 ] PLine
-2150 3575 [ -2150 3525 ] PLine
-2150 3525 [ -2200 3525 ] PLine
-2200 3525 [ -2200 3450 ] PLine
10 SetLine
-4400 1150 [ -3700 1150 ] PLine
-3700 1150 [ -3700 1350 ] PLine
-3700 1350 [ -4400 1350 ] PLine
-4400 1350 [ -4400 1275 ] PLine
-4400 1275 [ -4350 1275 ] PLine
-4350 1275 [ -4350 1225 ] PLine
-4350 1225 [ -4400 1225 ] PLine
-4400 1225 [ -4400 1150 ] PLine
10 SetLine
-1300 3450 [ -600 3450 ] PLine
-600 3450 [ -600 3650 ] PLine
-600 3650 [ -1300 3650 ] PLine
-1300 3650 [ -1300 3575 ] PLine
-1300 3575 [ -1250 3575 ] PLine
-1250 3575 [ -1250 3525 ] PLine
-1250 3525 [ -1300 3525 ] PLine
-1300 3525 [ -1300 3450 ] PLine
10 SetLine
-7250 3600 100 PCircle
10 SetLine
250 1282 [ 498 1282 ] PLine
498 1282 [ 498 2818 ] PLine
498 2818 [ 250 2818 ] PLine
10 SetLine
150 2818 [ -342 2818 ] PLine
10 SetLine
150 1282 [ -342 1282 ] PLine
10 SetLine
250 992 [ 250 3108 ] PLine
10 SetLine
250 992 [ -342 992 ] PLine
-342 992 [ -342 3108 ] PLine
-342 3108 [ 250 3108 ] PLine
250 3108 [ 250 992 ] PLine
10 SetLine
150 992 [ 150 3108 ] PLine
10 SetLine
-7050 3675 [ -6650 3675 ] PLine
-6650 3675 [ -6650 3275 ] PLine
-6650 3275 [ -7050 3275 ] PLine
-7050 3275 [ -7050 3675 ] PLine
10 SetLine
-7050 2350 [ -7450 2350 ] PLine
-7450 2350 [ -7450 2750 ] PLine
-7450 2750 [ -7050 2750 ] PLine
-7050 2750 [ -7050 2350 ] PLine
10 SetLine
-7475 2350 [ -7875 2350 ] PLine
-7875 2350 [ -7875 2750 ] PLine
-7875 2750 [ -7475 2750 ] PLine
-7475 2750 [ -7475 2350 ] PLine
10 SetLine
-7025 2750 [ -6625 2750 ] PLine
-6625 2750 [ -6625 2350 ] PLine
-6625 2350 [ -7025 2350 ] PLine
-7025 2350 [ -7025 2750 ] PLine
10 SetLine
-7400 1450 [ -7800 1450 ] PLine
-7800 1450 [ -7800 1850 ] PLine
-7800 1850 [ -7400 1850 ] PLine
-7400 1850 [ -7400 1450 ] PLine
10 SetLine
-7400 300 [ -7800 300 ] PLine
-7800 300 [ -7800 700 ] PLine
-7800 700 [ -7400 700 ] PLine
-7400 700 [ -7400 300 ] PLine
10 SetLine
-7599 3595 151 1475 2450 PArc
10 SetLine
-7477 3675 [ -7722 3675 ] PLine
10 SetLine
-7100 2970 [ -7100 3030 ] PLine
-7100 3030 [ -6900 3030 ] PLine
-6900 3030 [ -6900 2970 ] PLine
-6900 2970 [ -7100 2970 ] PLine
10 SetLine
-7100 3000 [ -7160 3000 ] PLine
10 SetLine
-6900 3000 [ -6850 3000 ] PLine
10 SetLine
-7100 2820 [ -7100 2880 ] PLine
-7100 2880 [ -6900 2880 ] PLine
-6900 2880 [ -6900 2820 ] PLine
-6900 2820 [ -7100 2820 ] PLine
10 SetLine
-7100 2850 [ -7160 2850 ] PLine
10 SetLine
-6900 2850 [ -6850 2850 ] PLine
10 SetLine
-7100 2070 [ -7100 2130 ] PLine
-7100 2130 [ -6900 2130 ] PLine
-6900 2130 [ -6900 2070 ] PLine
-6900 2070 [ -7100 2070 ] PLine
10 SetLine
-7100 2100 [ -7160 2100 ] PLine
10 SetLine
-6900 2100 [ -6850 2100 ] PLine
10 SetLine
-6270 1750 [ -6330 1750 ] PLine
-6330 1750 [ -6330 1950 ] PLine
-6330 1950 [ -6270 1950 ] PLine
-6270 1950 [ -6270 1750 ] PLine
10 SetLine
-6300 1750 [ -6300 1690 ] PLine
10 SetLine
-6300 1950 [ -6300 2000 ] PLine
10 SetLine
-6420 1750 [ -6480 1750 ] PLine
-6480 1750 [ -6480 1950 ] PLine
-6480 1950 [ -6420 1950 ] PLine
-6420 1950 [ -6420 1750 ] PLine
10 SetLine
-6450 1750 [ -6450 1690 ] PLine
10 SetLine
-6450 1950 [ -6450 2000 ] PLine
10 SetLine
-5970 1200 [ -6030 1200 ] PLine
-6030 1200 [ -6030 1400 ] PLine
-6030 1400 [ -5970 1400 ] PLine
-5970 1400 [ -5970 1200 ] PLine
10 SetLine
-6000 1200 [ -6000 1140 ] PLine
10 SetLine
-6000 1400 [ -6000 1450 ] PLine
10 SetLine
-6120 1750 [ -6180 1750 ] PLine
-6180 1750 [ -6180 1950 ] PLine
-6180 1950 [ -6120 1950 ] PLine
-6120 1950 [ -6120 1750 ] PLine
10 SetLine
-6150 1750 [ -6150 1690 ] PLine
10 SetLine
-6150 1950 [ -6150 2000 ] PLine
10 SetLine
-4920 3400 [ -4980 3400 ] PLine
-4980 3400 [ -4980 3600 ] PLine
-4980 3600 [ -4920 3600 ] PLine
-4920 3600 [ -4920 3400 ] PLine
10 SetLine
-4950 3400 [ -4950 3340 ] PLine
10 SetLine
-4950 3600 [ -4950 3650 ] PLine
10 SetLine
-6330 1400 [ -6270 1400 ] PLine
-6270 1400 [ -6270 1200 ] PLine
-6270 1200 [ -6330 1200 ] PLine
-6330 1200 [ -6330 1400 ] PLine
10 SetLine
-6300 1400 [ -6300 1460 ] PLine
10 SetLine
-6300 1200 [ -6300 1150 ] PLine
10 SetLine
-4850 2030 [ -4850 1970 ] PLine
-4850 1970 [ -5050 1970 ] PLine
-5050 1970 [ -5050 2030 ] PLine
-5050 2030 [ -4850 2030 ] PLine
10 SetLine
-4850 2000 [ -4790 2000 ] PLine
10 SetLine
-5050 2000 [ -5100 2000 ] PLine
10 SetLine
-5050 2270 [ -5050 2330 ] PLine
-5050 2330 [ -4850 2330 ] PLine
-4850 2330 [ -4850 2270 ] PLine
-4850 2270 [ -5050 2270 ] PLine
10 SetLine
-5050 2300 [ -5110 2300 ] PLine
10 SetLine
-4850 2300 [ -4800 2300 ] PLine
10 SetLine
-5880 2950 [ -5820 2950 ] PLine
-5820 2950 [ -5820 2750 ] PLine
-5820 2750 [ -5880 2750 ] PLine
-5880 2750 [ -5880 2950 ] PLine
10 SetLine
-5850 2950 [ -5850 3010 ] PLine
10 SetLine
-5850 2750 [ -5850 2700 ] PLine
10 SetLine
-5720 450 [ -5780 450 ] PLine
-5780 450 [ -5780 650 ] PLine
-5780 650 [ -5720 650 ] PLine
-5720 650 [ -5720 450 ] PLine
10 SetLine
-5750 450 [ -5750 390 ] PLine
10 SetLine
-5750 650 [ -5750 700 ] PLine
10 SetLine
-5350 795 [ -5350 855 ] PLine
-5350 855 [ -5150 855 ] PLine
-5150 855 [ -5150 795 ] PLine
-5150 795 [ -5350 795 ] PLine
10 SetLine
-5350 825 [ -5410 825 ] PLine
10 SetLine
-5150 825 [ -5100 825 ] PLine
10 SetLine
-6030 1950 [ -5970 1950 ] PLine
-5970 1950 [ -5970 1750 ] PLine
-5970 1750 [ -6030 1750 ] PLine
-6030 1750 [ -6030 1950 ] PLine
10 SetLine
-6000 1950 [ -6000 2010 ] PLine
10 SetLine
-6000 1750 [ -6000 1700 ] PLine
10 SetLine
-5820 1750 [ -5880 1750 ] PLine
-5880 1750 [ -5880 1950 ] PLine
-5880 1950 [ -5820 1950 ] PLine
-5820 1950 [ -5820 1750 ] PLine
10 SetLine
-5850 1750 [ -5850 1690 ] PLine
10 SetLine
-5850 1950 [ -5850 2000 ] PLine
10 SetLine
-5650 1420 [ -5650 1480 ] PLine
-5650 1480 [ -5450 1480 ] PLine
-5450 1480 [ -5450 1420 ] PLine
-5450 1420 [ -5650 1420 ] PLine
10 SetLine
-5650 1450 [ -5710 1450 ] PLine
10 SetLine
-5450 1450 [ -5400 1450 ] PLine
10 SetLine
-4950 1480 [ -4950 1420 ] PLine
-4950 1420 [ -5150 1420 ] PLine
-5150 1420 [ -5150 1480 ] PLine
-5150 1480 [ -4950 1480 ] PLine
10 SetLine
-4950 1450 [ -4890 1450 ] PLine
10 SetLine
-5150 1450 [ -5200 1450 ] PLine
10 SetLine
-5820 1200 [ -5880 1200 ] PLine
-5880 1200 [ -5880 1400 ] PLine
-5880 1400 [ -5820 1400 ] PLine
-5820 1400 [ -5820 1200 ] PLine
10 SetLine
-5850 1200 [ -5850 1140 ] PLine
10 SetLine
-5850 1400 [ -5850 1450 ] PLine
10 SetLine
-5400 2030 [ -5400 1970 ] PLine
-5400 1970 [ -5600 1970 ] PLine
-5600 1970 [ -5600 2030 ] PLine
-5600 2030 [ -5400 2030 ] PLine
10 SetLine
-5400 2000 [ -5340 2000 ] PLine
10 SetLine
-5600 2000 [ -5650 2000 ] PLine
10 SetLine
-5400 2180 [ -5400 2120 ] PLine
-5400 2120 [ -5600 2120 ] PLine
-5600 2120 [ -5600 2180 ] PLine
-5600 2180 [ -5400 2180 ] PLine
10 SetLine
-5400 2150 [ -5340 2150 ] PLine
10 SetLine
-5600 2150 [ -5650 2150 ] PLine
10 SetLine
-5400 2330 [ -5400 2270 ] PLine
-5400 2270 [ -5600 2270 ] PLine
-5600 2270 [ -5600 2330 ] PLine
-5600 2330 [ -5400 2330 ] PLine
10 SetLine
-5400 2300 [ -5340 2300 ] PLine
10 SetLine
-5600 2300 [ -5650 2300 ] PLine
10 SetLine
-4620 3400 [ -4680 3400 ] PLine
-4680 3400 [ -4680 3600 ] PLine
-4680 3600 [ -4620 3600 ] PLine
-4620 3600 [ -4620 3400 ] PLine
10 SetLine
-4650 3400 [ -4650 3340 ] PLine
10 SetLine
-4650 3600 [ -4650 3650 ] PLine
10 SetLine
-380 800 [ -320 800 ] PLine
-320 800 [ -320 600 ] PLine
-320 600 [ -380 600 ] PLine
-380 600 [ -380 800 ] PLine
10 SetLine
-350 800 [ -350 860 ] PLine
10 SetLine
-350 600 [ -350 550 ] PLine
10 SetLine
-170 600 [ -230 600 ] PLine
-230 600 [ -230 800 ] PLine
-230 800 [ -170 800 ] PLine
-170 800 [ -170 600 ] PLine
10 SetLine
-200 600 [ -200 540 ] PLine
10 SetLine
-200 800 [ -200 850 ] PLine
10 SetLine
-320 3500 [ -380 3500 ] PLine
-380 3500 [ -380 3700 ] PLine
-380 3700 [ -320 3700 ] PLine
-320 3700 [ -320 3500 ] PLine
10 SetLine
-350 3500 [ -350 3440 ] PLine
10 SetLine
-350 3700 [ -350 3750 ] PLine
10 SetLine
-2946 701 12 PCircle
10 SetLine
-2950 598 12 PCircle
10 SetLine
-2846 603 12 PCircle
10 SetLine
-2746 602 12 PCircle
10 SetLine
-2650 599 12 PCircle
10 SetLine
-2552 600 12 PCircle
10 SetLine
-2452 599 12 PCircle
10 SetLine
-2348 601 12 PCircle
10 SetLine
-2252 601 12 PCircle
10 SetLine
-2848 701 12 PCircle
10 SetLine
-2744 700 12 PCircle
10 SetLine
-2650 698 12 PCircle
10 SetLine
-2554 698 12 PCircle
10 SetLine
-2452 700 12 PCircle
10 SetLine
-2348 702 12 PCircle
10 SetLine
-2250 700 12 PCircle
10 SetLine
-2940 690 [ -2915 605 ] PLine
10 SetLine
-2840 690 [ -2810 605 ] PLine
10 SetLine
-2735 685 [ -2710 605 ] PLine
10 SetLine
-2645 690 [ -2615 605 ] PLine
10 SetLine
-2545 690 [ -2515 605 ] PLine
10 SetLine
-2340 690 [ -2315 605 ] PLine
10 SetLine
-2245 685 [ -2215 605 ] PLine
10 SetLine
-2445 690 [ -2415 605 ] PLine
10 SetLine
-2936 604 0 PCircle
10 SetLine
-3000 550 [ -2200 550 ] PLine
-2200 550 [ -2200 750 ] PLine
-2200 750 [ -3000 750 ] PLine
-3000 750 [ -3000 550 ] PLine
10 SetLine
-5050 300 [ -5450 300 ] PLine
-5450 300 [ -5450 700 ] PLine
-5450 700 [ -5050 700 ] PLine
-5050 700 [ -5050 300 ] PLine
10 SetLine
-5900 3200 [ -5900 3700 ] PLine
-5900 3700 [ -5100 3700 ] PLine
-5100 3700 [ -5100 3200 ] PLine
-5100 3200 [ -5900 3200 ] PLine
10 SetLine
-250 25 [ -250 425 ] PLine
-250 425 [ 150 425 ] PLine
150 425 [ 150 25 ] PLine
150 25 [ -250 25 ] PLine
10 SetLine
150 425 [ 150 525 ] PLine
150 525 [ 250 525 ] PLine
250 525 [ 250 -75 ] PLine
250 -75 [ 150 -75 ] PLine
150 -75 [ 150 25 ] PLine
10 SetLine
250 425 [ 650 425 ] PLine
650 425 [ 650 25 ] PLine
650 25 [ 250 25 ] PLine
10 SetLine
-250 375 [ -350 375 ] PLine
-350 375 [ -350 75 ] PLine
-350 75 [ -250 75 ] PLine
10 SetLine
-350 250 [ -550 250 ] PLine
-550 250 [ -550 200 ] PLine
-550 200 [ -350 200 ] PLine
10 SetLine
-6050 3275 [ -6050 3475 ] PLine
-6050 3475 [ -5950 3475 ] PLine
-5950 3475 [ -5950 3275 ] PLine
-5950 3275 [ -6050 3275 ] PLine
10 SetLine
-7875 3700 100 PCircle
10 SetLine
-6650 3150 100 PCircle
10 SetLine
-6650 1450 100 PCircle
10 SetLine
-7875 1450 100 PCircle
10 SetText2
0 -6975 3225 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6921 3225 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -7600 3050 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7546 3050 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -7600 2900 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7546 2900 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -7575 2300 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7521 2300 [ [ 29 43 27 34 22 28 15 25 13 25 6 28 2 34 0 43 0 46 2 56 6 62 13 65 15 65 22 62 27 56 29 43 29 28 27 12 22 3 15 0 11 0 4 3 2 9 ] ] Char
10 SetText2
0 -7600 2150 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7546 2150 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -7515 2150 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
10 SetText2
0 -7000 2275 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6946 2275 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -6915 2275 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -7600 2000 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7546 2000 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -7515 2000 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -7000 2000 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6946 2000 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -6915 2000 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -7600 1150 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7546 1150 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -7515 1150 [ [ 29 43 27 34 22 28 15 25 13 25 6 28 2 34 0 43 0 46 2 56 6 62 13 65 15 65 22 62 27 56 29 43 29 28 27 12 22 3 15 0 11 0 4 3 2 9 ] ] Char
10 SetText2
0 -7350 1600 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -7350 1654 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
0 -7350 1685 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
10 SetText2
0 -7600 1300 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7546 1300 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -7494 1300 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
10 SetText2
0 -6725 875 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6671 875 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -6619 875 [ [ 11 65 4 62 2 56 2 50 4 43 9 40 18 37 25 34 29 28 31 21 31 12 29 6 27 3 20 0 11 0 4 3 2 6 0 12 0 21 2 28 6 34 13 37 22 40 27 43 29 50 29 56 27 62 20 65 11 65 ] ] Char
10 SetText2
0 -7125 875 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7071 875 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -7019 875 [ [ 27 56 25 62 18 65 13 65 6 62 2 53 0 37 0 21 2 9 6 3 13 0 15 0 22 3 27 9 29 18 29 21 27 31 22 37 15 40 13 40 6 37 2 31 0 21 ] ] Char
10 SetText2
0 -6225 1225 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -6225 1279 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
0 -6225 1331 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
10 SetText2
0 -7675 850 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7621 850 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -7569 850 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -7350 425 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -7350 479 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
0 -7350 531 [ [ -65 29 -65 6 -37 4 -40 6 -43 13 -43 20 -40 27 -34 31 -25 34 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
10 SetText2
0 -7625 1000 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7571 1000 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -7519 1000 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -4925 2675 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4925 2729 [ [ -65 31 0 9 ] [ -65 0 -65 31 ] ] Char
10 SetText2
0 -6075 2900 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -6075 2954 [ [ -65 29 -65 6 -37 4 -40 6 -43 13 -43 20 -40 27 -34 31 -25 34 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
10 SetText2
0 -6575 450 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6521 450 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -6469 450 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
10 SetText2
0 -6575 650 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6521 650 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -6469 650 [ [ 29 43 27 34 22 28 15 25 13 25 6 28 2 34 0 43 0 46 2 56 6 62 13 65 15 65 22 62 27 56 29 43 29 28 27 12 22 3 15 0 11 0 4 3 2 9 ] ] Char
10 SetText2
0 -5925 850 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -5871 850 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
0 -5819 850 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
10 SetText2
0 -5475 525 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -5475 579 [ [ -65 4 -65 29 -40 15 -40 22 -37 27 -34 29 -25 31 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
0 -5475 631 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
10 SetText2
0 -6150 1000 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6096 1000 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
0 -6044 1000 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -6350 2300 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -6350 2354 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
0 -6350 2385 [ [ -56 27 -62 25 -65 18 -65 13 -62 6 -53 2 -37 0 -21 0 -9 2 -3 6 0 13 0 15 -3 22 -9 27 -18 29 -21 29 -31 27 -37 22 -40 15 -40 13 -37 6 -31 2 -21 0 ] ] Char
10 SetText2
0 -6525 2300 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -6525 2354 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
0 -6525 2385 [ [ -65 29 -65 6 -37 4 -40 6 -43 13 -43 20 -40 27 -34 31 -25 34 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
10 SetText2
0 -5900 2325 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -5900 2379 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
0 -5900 2410 [ [ -65 11 -62 4 -56 2 -50 2 -43 4 -40 9 -37 18 -34 25 -28 29 -21 31 -12 31 -6 29 -3 27 0 20 0 11 -3 4 -6 2 -12 0 -21 0 -28 2 -34 6 -37 13 -40 22 -43 27 -50 29 -56 29 -62 27 -65 20 -65 11 ] ] Char
10 SetText2
0 -6050 2325 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -6050 2379 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
0 -6050 2410 [ [ -65 31 0 9 ] [ -65 0 -65 31 ] ] Char
10 SetText2
0 -5600 2500 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -5546 2500 [ [ 27 56 25 62 18 65 13 65 6 62 2 53 0 37 0 21 2 9 6 3 13 0 15 0 22 3 27 9 29 18 29 21 27 31 22 37 15 40 13 40 6 37 2 31 0 21 ] ] Char
10 SetText2
0 -5050 2500 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -4996 2500 [ [ 11 65 4 62 2 56 2 50 4 43 9 40 18 37 25 34 29 28 31 21 31 12 29 6 27 3 20 0 11 0 4 3 2 6 0 12 0 21 2 28 6 34 13 37 22 40 27 43 29 50 29 56 27 62 20 65 11 65 ] ] Char
10 SetText2
0 -625 525 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -625 579 [ [ -65 22 -21 0 -21 34 ] [ -65 22 0 22 ] ] Char
0 -625 633 [ [ -56 27 -62 25 -65 18 -65 13 -62 6 -53 2 -37 0 -21 0 -9 2 -3 6 0 13 0 15 -3 22 -9 27 -18 29 -21 29 -31 27 -37 22 -40 15 -40 13 -37 6 -31 2 -21 0 ] ] Char
10 SetText2
0 -4525 3175 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4525 3229 [ [ -65 4 -65 29 -40 15 -40 22 -37 27 -34 29 -25 31 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
0 -4525 3281 [ [ -65 22 -21 0 -21 34 ] [ -65 22 0 22 ] ] Char
10 SetText2
0 -2325 3475 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -2325 3529 [ [ -65 4 -65 29 -40 15 -40 22 -37 27 -34 29 -25 31 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
0 -2325 3581 [ [ -65 29 -65 6 -37 4 -40 6 -43 13 -43 20 -40 27 -34 31 -25 34 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
10 SetText2
0 -1425 3475 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -1425 3529 [ [ -65 4 -65 29 -40 15 -40 22 -37 27 -34 29 -25 31 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
0 -1425 3581 [ [ -56 27 -62 25 -65 18 -65 13 -62 6 -53 2 -37 0 -21 0 -9 2 -3 6 0 13 0 15 -3 22 -9 27 -18 29 -21 29 -31 27 -37 22 -40 15 -40 13 -37 6 -31 2 -21 0 ] ] Char
10 SetText2
0 -4525 2575 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4525 2629 [ [ -65 4 -65 29 -40 15 -40 22 -37 27 -34 29 -25 31 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
0 -4525 2681 [ [ -65 31 0 9 ] [ -65 0 -65 31 ] ] Char
10 SetText2
0 -3025 2575 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -3025 2629 [ [ -65 4 -65 29 -40 15 -40 22 -37 27 -34 29 -25 31 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
0 -3025 2681 [ [ -65 11 -62 4 -56 2 -50 2 -43 4 -40 9 -37 18 -34 25 -28 29 -21 31 -12 31 -6 29 -3 27 0 20 0 11 -3 4 -6 2 -12 0 -21 0 -28 2 -34 6 -37 13 -40 22 -43 27 -50 29 -56 29 -62 27 -65 20 -65 11 ] ] Char
10 SetText2
0 -4525 1875 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4525 1929 [ [ -65 4 -65 29 -40 15 -40 22 -37 27 -34 29 -25 31 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
0 -4525 1981 [ [ -43 29 -34 27 -28 22 -25 15 -25 13 -28 6 -34 2 -43 0 -46 0 -56 2 -62 6 -65 13 -65 15 -62 22 -56 27 -43 29 -28 29 -12 27 -3 22 0 15 0 11 -3 4 -9 2 ] ] Char
10 SetText2
0 -3125 1875 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -3125 1929 [ [ -65 22 -21 0 -21 34 ] [ -65 22 0 22 ] ] Char
0 -3125 1983 [ [ -65 13 -62 6 -53 2 -37 0 -28 0 -12 2 -3 6 0 13 0 18 -3 25 -12 29 -28 31 -37 31 -53 29 -62 25 -65 18 -65 13 ] ] Char
10 SetText2
0 -4525 1175 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4525 1229 [ [ -65 22 -21 0 -21 34 ] [ -65 22 0 22 ] ] Char
0 -4525 1283 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
10 SetText2
0 -3525 1175 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -3525 1229 [ [ -65 22 -21 0 -21 34 ] [ -65 22 0 22 ] ] Char
0 -3525 1283 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
10 SetText2
0 -4525 575 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4525 629 [ [ -65 22 -21 0 -21 34 ] [ -65 22 0 22 ] ] Char
0 -4525 683 [ [ -65 4 -65 29 -40 15 -40 22 -37 27 -34 29 -25 31 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
10 SetText2
0 -2125 575 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -2125 629 [ [ -65 22 -21 0 -21 34 ] [ -65 22 0 22 ] ] Char
0 -2125 683 [ [ -65 22 -21 0 -21 34 ] [ -65 22 0 22 ] ] Char
10 SetText2
0 -4825 525 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4825 579 [ [ -65 4 -65 29 -40 15 -40 22 -37 27 -34 29 -25 31 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
0 -4825 631 [ [ -65 4 -65 29 -40 15 -40 22 -37 27 -34 29 -25 31 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
10 SetText2
0 -825 525 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -825 579 [ [ -65 22 -21 0 -21 34 ] [ -65 22 0 22 ] ] Char
0 -825 633 [ [ -65 29 -65 6 -37 4 -40 6 -43 13 -43 20 -40 27 -34 31 -25 34 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
10 SetText2
0 -4875 3375 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4875 3429 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
10 SetText2
0 -4825 1125 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4825 1179 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
0 -4825 1231 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
10 SetText2
0 -7550 3350 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7498 3350 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -7550 3200 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7498 3200 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -5000 2200 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -4948 2200 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -5550 3100 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5498 3100 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -6200 2350 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -6200 2402 [ [ -65 22 -21 0 -21 34 ] [ -65 22 0 22 ] ] Char
10 SetText2
0 -7250 1425 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -7194 1425 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -6975 1300 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -6923 1300 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -6850 250 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -6794 250 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -6350 3700 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -6298 3700 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -6000 250 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -5944 250 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -5375 1300 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -5323 1300 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -5375 2950 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -5319 2950 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -5350 1900 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -5298 1900 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -3450 3750 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -3398 3750 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -2650 2150 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -2598 2150 [ [ 29 43 27 34 22 28 15 25 13 25 6 28 2 34 0 43 0 46 2 56 6 62 13 65 15 65 22 62 27 56 29 43 29 28 27 12 22 3 15 0 11 0 4 3 2 9 ] ] Char
10 SetText2
0 -3900 2150 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -3848 2150 [ [ 11 65 4 62 2 56 2 50 4 43 9 40 18 37 25 34 29 28 31 21 31 12 29 6 27 3 20 0 11 0 4 3 2 6 0 12 0 21 2 28 6 34 13 37 22 40 27 43 29 50 29 56 27 62 20 65 11 65 ] ] Char
10 SetText2
0 -3900 2850 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -3848 2850 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -1325 1550 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -1273 1550 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -1242 1550 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -1650 850 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -1598 850 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -1567 850 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -1375 3150 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -1323 3150 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
10 SetText2
0 -1350 2350 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -1298 2350 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -1267 2350 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
10 SetText2
0 -2625 2850 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -2573 2850 [ [ 27 56 25 62 18 65 13 65 6 62 2 53 0 37 0 21 2 9 6 3 13 0 15 0 22 3 27 9 29 18 29 21 27 31 22 37 15 40 13 40 6 37 2 31 0 21 ] ] Char
10 SetText2
0 -3950 850 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -3898 850 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -3867 850 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -2875 1450 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -2823 1450 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -2792 1450 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -1925 3750 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -1873 3750 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -4100 1450 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -4048 1450 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -4017 1450 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -1025 3750 [ [ 0 65 0 18 2 9 6 3 13 0 18 0 25 3 29 9 31 18 31 65 ] ] Char
0 -973 3750 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -7275 3725 [ [ 22 65 22 15 20 6 18 3 13 0 9 0 4 3 2 6 0 15 0 21 ] ] Char
0 -7232 3725 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -225 3150 [ [ 22 65 22 15 20 6 18 3 13 0 9 0 4 3 2 6 0 15 0 21 ] ] Char
0 -182 3150 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -2700 125 [ [ 22 65 22 15 20 6 18 3 13 0 9 0 4 3 2 6 0 15 0 21 ] ] Char
0 -2657 125 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -2601 125 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -2075 125 [ [ 22 65 22 15 20 6 18 3 13 0 9 0 4 3 2 6 0 15 0 21 ] ] Char
0 -2032 125 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 ] [ 0 34 20 34 27 31 29 28 31 21 31 12 29 6 27 3 20 0 0 0 ] ] Char
0 -1980 125 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -6900 3700 [ [ 0 65 0 0 27 0 ] ] Char
0 -6853 3700 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -7325 2775 [ [ 0 65 0 0 27 0 ] ] Char
0 -7278 2775 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -7750 2775 [ [ 0 65 0 0 27 0 ] ] Char
0 -7703 2775 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -6875 2775 [ [ 0 65 0 0 27 0 ] ] Char
0 -6828 2775 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -7750 1875 [ [ 0 65 0 0 27 0 ] ] Char
0 -7703 1875 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -7650 200 [ [ 0 65 0 0 27 0 ] ] Char
0 -7603 200 [ [ 27 56 25 62 18 65 13 65 6 62 2 53 0 37 0 21 2 9 6 3 13 0 15 0 22 3 27 9 29 18 29 21 27 31 22 37 15 40 13 40 6 37 2 31 0 21 ] ] Char
10 SetText2
0 -7650 3700 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] [ 20 12 34 -6 ] ] Char
0 -7594 3700 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -7050 3050 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -6998 3050 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -7050 2900 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -6998 2900 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -7025 2125 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -6973 2125 [ [ 27 56 25 62 18 65 13 65 6 62 2 53 0 37 0 21 2 9 6 3 13 0 15 0 22 3 27 9 29 18 29 21 27 31 22 37 15 40 13 40 6 37 2 31 0 21 ] ] Char
10 SetText2
0 -6350 1775 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -6350 1827 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
0 -6350 1858 [ [ -65 22 -21 0 -21 34 ] [ -65 22 0 22 ] ] Char
10 SetText2
0 -6500 1775 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -6500 1827 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
0 -6500 1858 [ [ -65 4 -65 29 -40 15 -40 22 -37 27 -34 29 -25 31 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
10 SetText2
0 -6050 1225 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -6050 1277 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
0 -6050 1308 [ [ -65 31 0 9 ] [ -65 0 -65 31 ] ] Char
10 SetText2
0 -6200 1775 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -6200 1827 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
0 -6200 1858 [ [ -56 27 -62 25 -65 18 -65 13 -62 6 -53 2 -37 0 -21 0 -9 2 -3 6 0 13 0 15 -3 22 -9 27 -18 29 -21 29 -31 27 -37 22 -40 15 -40 13 -37 6 -31 2 -21 0 ] ] Char
10 SetText2
0 -5000 3450 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -5000 3502 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
10 SetText2
0 -6350 1225 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -6350 1277 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
0 -6350 1308 [ [ -65 29 -65 6 -37 4 -40 6 -43 13 -43 20 -40 27 -34 31 -25 34 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
10 SetText2
0 -5000 2050 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -4948 2050 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -4917 2050 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -5000 2350 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -4948 2350 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -4917 2350 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -5900 2800 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -5900 2852 [ [ -65 29 -65 6 -37 4 -40 6 -43 13 -43 20 -40 27 -34 31 -25 34 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
10 SetText2
0 -5800 500 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -5800 552 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
0 -5800 604 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
10 SetText2
0 -5325 875 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -5273 875 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -5221 875 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -6050 1775 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -6050 1827 [ [ -65 31 0 9 ] [ -65 0 -65 31 ] ] Char
10 SetText2
0 -5900 1775 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -5900 1827 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
0 -5900 1858 [ [ -65 11 -62 4 -56 2 -50 2 -43 4 -40 9 -37 18 -34 25 -28 29 -21 31 -12 31 -6 29 -3 27 0 20 0 11 -3 4 -6 2 -12 0 -21 0 -28 2 -34 6 -37 13 -40 22 -43 27 -50 29 -56 29 -62 27 -65 20 -65 11 ] ] Char
10 SetText2
0 -5625 1500 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -5573 1500 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -5521 1500 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
10 SetText2
0 -5100 1500 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -5048 1500 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -4996 1500 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -5900 1225 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -5900 1277 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
0 -5900 1308 [ [ -43 29 -34 27 -28 22 -25 15 -25 13 -28 6 -34 2 -43 0 -46 0 -56 2 -62 6 -65 13 -65 15 -62 22 -56 27 -43 29 -28 29 -12 27 -3 22 0 15 0 11 -3 4 -9 2 ] ] Char
10 SetText2
0 -5525 2050 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -5473 2050 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -5442 2050 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
10 SetText2
0 -5525 2200 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -5473 2200 [ [ 29 43 27 34 22 28 15 25 13 25 6 28 2 34 0 43 0 46 2 56 6 62 13 65 15 65 22 62 27 56 29 43 29 28 27 12 22 3 15 0 11 0 4 3 2 9 ] ] Char
10 SetText2
0 -5525 2350 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -5473 2350 [ [ 11 65 4 62 2 56 2 50 4 43 9 40 18 37 25 34 29 28 31 21 31 12 29 6 27 3 20 0 11 0 4 3 2 6 0 12 0 21 2 28 6 34 13 37 22 40 27 43 29 50 29 56 27 62 20 65 11 65 ] ] Char
10 SetText2
0 -4700 3450 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -4700 3502 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
10 SetText2
0 -400 625 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -400 677 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
0 -400 729 [ [ -65 29 -65 6 -37 4 -40 6 -43 13 -43 20 -40 27 -34 31 -25 34 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
10 SetText2
0 -250 625 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -250 677 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
0 -250 729 [ [ -56 27 -62 25 -65 18 -65 13 -62 6 -53 2 -37 0 -21 0 -9 2 -3 6 0 13 0 15 -3 22 -9 27 -18 29 -21 29 -31 27 -37 22 -40 15 -40 13 -37 6 -31 2 -21 0 ] ] Char
10 SetText2
0 -400 3525 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -400 3577 [ [ -50 2 -53 2 -59 4 -62 6 -65 11 -65 20 -62 25 -59 27 -53 29 -46 29 -40 27 -31 22 0 0 0 31 ] ] Char
0 -400 3629 [ [ -65 22 -21 0 -21 34 ] [ -65 22 0 22 ] ] Char
10 SetText2
0 -2650 850 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -2598 850 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -5300 200 [ [ 15 65 15 0 ] [ 0 65 31 65 ] ] Char
0 -5248 200 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -5625 3725 [ [ 0 65 31 0 ] [ 31 65 0 0 ] ] Char
0 -5573 3725 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -550 75 [ [ 22 65 22 15 20 6 18 3 13 0 9 0 4 3 2 6 0 15 0 21 ] ] Char
0 -507 75 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -5975 3500 [ [ -65 0 0 11 ] [ -65 22 0 11 ] [ -65 22 0 34 ] [ -65 45 0 34 ] ] Char
0 -5975 3565 [ [ -53 0 -56 4 -65 11 0 11 ] ] Char
10 SetText2
0 -7925 3500 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -7869 3500 [ [ 0 65 0 0 ] [ 31 65 31 0 ] [ 0 34 31 34 ] ] Char
0 -7817 3500 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -6725 2950 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -6669 2950 [ [ 0 65 0 0 ] [ 31 65 31 0 ] [ 0 34 31 34 ] ] Char
0 -6617 2950 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -6700 1250 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -6644 1250 [ [ 0 65 0 0 ] [ 31 65 31 0 ] [ 0 34 31 34 ] ] Char
0 -6592 1250 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -7925 1250 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -7869 1250 [ [ 0 65 0 0 ] [ 31 65 31 0 ] [ 0 34 31 34 ] ] Char
0 -7817 1250 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -6975 3125 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -6923 3125 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6869 3125 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -6813 3125 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -7600 2950 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7548 2950 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7494 2950 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -7438 2950 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -7600 2800 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7548 2800 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7494 2800 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -7438 2800 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -7575 2200 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7523 2200 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7469 2200 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -7413 2200 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -7600 2050 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7548 2050 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7494 2050 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -7438 2050 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -7000 2175 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -6948 2175 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6894 2175 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -6838 2175 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -7600 1900 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7548 1900 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7494 1900 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -7438 1900 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -7000 1900 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -6948 1900 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6894 1900 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -6838 1900 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -7600 1050 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7548 1050 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7494 1050 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -7438 1050 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
0 -7386 1050 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
10 SetText2
0 -7250 1600 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -7250 1652 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -7250 1706 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -7250 1762 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -7600 1200 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7548 1200 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7494 1200 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -7438 1200 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -6725 775 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -6673 775 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6619 775 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -6563 775 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -7125 775 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7073 775 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7019 775 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -6963 775 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -6125 1225 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -6125 1277 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -6125 1331 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -6125 1387 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -7675 750 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7623 750 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7569 750 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -7513 750 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
0 -7461 750 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
10 SetText2
0 -7250 425 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -7250 477 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -7250 531 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -7250 587 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -7625 900 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7573 900 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7519 900 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -7463 900 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -4825 2675 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -4825 2727 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4825 2781 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -4825 2837 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -5975 2900 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -5975 2952 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -5975 3006 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -5975 3062 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
0 -5975 3114 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
10 SetText2
0 -6575 350 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -6523 350 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6469 350 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -6413 350 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -6575 550 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -6523 550 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6469 550 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -6413 550 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -5925 750 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5873 750 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -5819 750 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -5763 750 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
0 -5711 750 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
10 SetText2
0 -5375 525 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -5375 577 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -5375 631 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -5375 687 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -6150 900 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -6098 900 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6044 900 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -5988 900 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -6250 2300 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -6250 2352 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -6250 2406 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -6250 2462 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -6425 2300 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -6425 2352 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -6425 2406 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -6425 2462 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -5800 2325 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -5800 2377 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -5800 2431 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -5800 2487 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
0 -5800 2539 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
10 SetText2
0 -5950 2325 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -5950 2377 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -5950 2431 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -5950 2487 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -5600 2400 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5548 2400 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -5494 2400 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -5438 2400 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -5050 2400 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -4998 2400 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -4944 2400 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -4888 2400 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
10 SetText2
0 -525 525 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -525 577 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -525 631 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -525 687 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
0 -525 739 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
10 SetText2
0 -4425 3175 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -4425 3227 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4425 3281 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -4425 3337 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -2225 3475 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -2225 3527 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -2225 3581 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -2225 3637 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -1325 3475 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -1325 3527 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -1325 3581 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -1325 3637 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -4425 2575 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -4425 2627 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4425 2681 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -4425 2737 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -2925 2575 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -2925 2627 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -2925 2681 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -2925 2737 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -4425 1875 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -4425 1927 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4425 1981 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -4425 2037 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -3025 1875 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -3025 1927 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -3025 1981 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -3025 2037 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -4425 1175 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -4425 1227 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4425 1281 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -4425 1337 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -3425 1175 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -3425 1227 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -3425 1281 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -3425 1337 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -4425 575 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -4425 627 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4425 681 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -4425 737 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -2025 575 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -2025 627 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -2025 681 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -2025 737 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -4725 525 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -4725 577 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4725 631 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -4725 687 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
0 -4725 739 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
10 SetText2
0 -725 525 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -725 577 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -725 631 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -725 687 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
0 -725 739 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
10 SetText2
0 -4775 3375 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -4775 3427 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4775 3481 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -4775 3537 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
0 -4775 3589 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
10 SetText2
0 -4725 1125 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -4725 1177 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -4725 1231 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -4725 1287 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
0 -4725 1339 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
10 SetText2
0 -7550 3250 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7498 3250 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7446 3250 [ [ 0 65 0 0 ] ] Char
0 -7426 3250 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -7370 3250 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7318 3250 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
10 SetText2
0 -7550 3100 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7498 3100 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7446 3100 [ [ 0 65 0 0 ] ] Char
0 -7426 3100 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -7370 3100 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7318 3100 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
10 SetText2
0 -5000 2100 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -4948 2100 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -4896 2100 [ [ 0 65 0 0 ] ] Char
0 -4876 2100 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -4820 2100 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -4768 2100 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
10 SetText2
0 -5550 3000 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5498 3000 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5446 3000 [ [ 0 65 0 0 ] ] Char
0 -5426 3000 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -5370 3000 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5318 3000 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
10 SetText2
0 -6100 2350 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -6100 2402 [ [ -65 31 0 0 ] [ -65 0 -65 31 ] [ 0 0 0 31 ] ] Char
0 -6100 2454 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -6100 2504 [ [ -65 0 0 0 ] [ -65 0 0 31 ] [ -65 31 0 31 ] ] Char
0 -6100 2556 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -6100 2606 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
10 SetText2
0 -7250 1325 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -7194 1325 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -7140 1325 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -7109 1325 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
0 -7055 1325 [ [ 29 43 27 34 22 28 15 25 13 25 6 28 2 34 0 43 0 46 2 56 6 62 13 65 15 65 22 62 27 56 29 43 29 28 27 12 22 3 15 0 11 0 4 3 2 9 ] ] Char
0 -7005 1325 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -6953 1325 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 34 25 ] [ 22 25 34 25 ] ] Char
10 SetText2
0 -6975 1200 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -6919 1200 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -6867 1200 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 34 25 ] [ 22 25 34 25 ] ] Char
0 -6813 1200 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
0 -6759 1200 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -6707 1200 [ [ 29 43 27 34 22 28 15 25 13 25 6 28 2 34 0 43 0 46 2 56 6 62 13 65 15 65 22 62 27 56 29 43 29 28 27 12 22 3 15 0 11 0 4 3 2 9 ] ] Char
0 -6657 1200 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
10 SetText2
0 -6850 150 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -6794 150 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -6740 150 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -6709 150 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
0 -6655 150 [ [ 29 43 27 34 22 28 15 25 13 25 6 28 2 34 0 43 0 46 2 56 6 62 13 65 15 65 22 62 27 56 29 43 29 28 27 12 22 3 15 0 11 0 4 3 2 9 ] ] Char
0 -6605 150 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -6553 150 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 34 25 ] [ 22 25 34 25 ] ] Char
10 SetText2
0 -6350 3600 [ [ 0 65 0 0 27 0 ] ] Char
0 -6303 3600 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -6247 3600 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
0 -6195 3600 [ [ 11 65 4 62 2 56 2 50 4 43 9 40 18 37 25 34 29 28 31 21 31 12 29 6 27 3 20 0 11 0 4 3 2 6 0 12 0 21 2 28 6 34 13 37 22 40 27 43 29 50 29 56 27 62 20 65 11 65 ] ] Char
0 -6143 3600 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -6091 3600 [ [ 11 65 4 62 2 56 2 50 4 43 9 40 18 37 25 34 29 28 31 21 31 12 29 6 27 3 20 0 11 0 4 3 2 6 0 12 0 21 2 28 6 34 13 37 22 40 27 43 29 50 29 56 27 62 20 65 11 65 ] ] Char
10 SetText2
0 -6000 150 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -5944 150 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -5890 150 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -5859 150 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
0 -5805 150 [ [ 29 43 27 34 22 28 15 25 13 25 6 28 2 34 0 43 0 46 2 56 6 62 13 65 15 65 22 62 27 56 29 43 29 28 27 12 22 3 15 0 11 0 4 3 2 9 ] ] Char
0 -5755 150 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -5703 150 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 34 25 ] [ 22 25 34 25 ] ] Char
10 SetText2
0 -5375 1200 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -5319 1200 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5267 1200 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 34 25 ] [ 22 25 34 25 ] ] Char
0 -5213 1200 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
0 -5159 1200 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -5107 1200 [ [ 29 43 27 34 22 28 15 25 13 25 6 28 2 34 0 43 0 46 2 56 6 62 13 65 15 65 22 62 27 56 29 43 29 28 27 12 22 3 15 0 11 0 4 3 2 9 ] ] Char
0 -5057 1200 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
10 SetText2
0 -5375 2850 [ [ 0 65 0 0 27 0 ] ] Char
0 -5328 2850 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -5272 2850 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
0 -5220 2850 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -5168 2850 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -5350 1800 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -5294 1800 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5242 1800 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 34 25 ] [ 22 25 34 25 ] ] Char
0 -5188 1800 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
0 -5134 1800 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -5082 1800 [ [ 29 43 27 34 22 28 15 25 13 25 6 28 2 34 0 43 0 46 2 56 6 62 13 65 15 65 22 62 27 56 29 43 29 28 27 12 22 3 15 0 11 0 4 3 2 9 ] ] Char
0 -5032 1800 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
10 SetText2
0 -3450 3650 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -3394 3650 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -3338 3650 [ [ 29 43 27 34 22 28 15 25 13 25 6 28 2 34 0 43 0 46 2 56 6 62 13 65 15 65 22 62 27 56 29 43 29 28 27 12 22 3 15 0 11 0 4 3 2 9 ] ] Char
0 -3288 3650 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
0 -3234 3650 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -3203 3650 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
0 -3151 3650 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
10 SetText2
0 -2650 2050 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
0 -2598 2050 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
0 -2544 2050 [ [ 0 65 0 0 27 0 ] ] Char
0 -2497 2050 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -2445 2050 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -2414 2050 [ [ 27 56 25 62 18 65 13 65 6 62 2 53 0 37 0 21 2 9 6 3 13 0 15 0 22 3 27 9 29 18 29 21 27 31 22 37 15 40 13 40 6 37 2 31 0 21 ] ] Char
0 -2364 2050 [ [ 27 56 25 62 18 65 13 65 6 62 2 53 0 37 0 21 2 9 6 3 13 0 15 0 22 3 27 9 29 18 29 21 27 31 22 37 15 40 13 40 6 37 2 31 0 21 ] ] Char
10 SetText2
0 -3900 2050 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
0 -3848 2050 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
0 -3794 2050 [ [ 0 65 0 0 27 0 ] ] Char
0 -3747 2050 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -3695 2050 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -3643 2050 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
0 -3591 2050 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -3900 2750 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
0 -3848 2750 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -3792 2750 [ [ 0 65 0 0 27 0 ] ] Char
0 -3745 2750 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -3693 2750 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -3641 2750 [ [ 0 65 0 0 27 0 ] ] Char
0 -3594 2750 [ [ 11 65 4 62 2 56 2 50 4 43 9 40 18 37 25 34 29 28 31 21 31 12 29 6 27 3 20 0 11 0 4 3 2 6 0 12 0 21 2 28 6 34 13 37 22 40 27 43 29 50 29 56 27 62 20 65 11 65 ] ] Char
10 SetText2
0 -1325 1450 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -1269 1450 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -1217 1450 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -1163 1450 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -1111 1450 [ [ 11 65 4 62 2 56 2 50 4 43 9 40 18 37 25 34 29 28 31 21 31 12 29 6 27 3 20 0 11 0 4 3 2 6 0 12 0 21 2 28 6 34 13 37 22 40 27 43 29 50 29 56 27 62 20 65 11 65 ] ] Char
0 -1059 1450 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -1007 1450 [ [ 29 43 27 34 22 28 15 25 13 25 6 28 2 34 0 43 0 46 2 56 6 62 13 65 15 65 22 62 27 56 29 43 29 28 27 12 22 3 15 0 11 0 4 3 2 9 ] ] Char
10 SetText2
0 -1650 750 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
0 -1598 750 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
0 -1544 750 [ [ 0 65 0 0 27 0 ] ] Char
0 -1497 750 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -1445 750 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -1393 750 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
0 -1339 750 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -1375 3050 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -1319 3050 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -1267 3050 [ [ 27 56 25 62 18 65 13 65 6 62 2 53 0 37 0 21 2 9 6 3 13 0 15 0 22 3 27 9 29 18 29 21 27 31 22 37 15 40 13 40 6 37 2 31 0 21 ] ] Char
0 -1217 3050 [ [ 27 56 25 62 18 65 13 65 6 62 2 53 0 37 0 21 2 9 6 3 13 0 15 0 22 3 27 9 29 18 29 21 27 31 22 37 15 40 13 40 6 37 2 31 0 21 ] ] Char
0 -1167 3050 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
10 SetText2
0 -1350 2250 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -1294 2250 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -1242 2250 [ [ 27 56 25 62 18 65 13 65 6 62 2 53 0 37 0 21 2 9 6 3 13 0 15 0 22 3 27 9 29 18 29 21 27 31 22 37 15 40 13 40 6 37 2 31 0 21 ] ] Char
0 -1192 2250 [ [ 27 56 25 62 18 65 13 65 6 62 2 53 0 37 0 21 2 9 6 3 13 0 15 0 22 3 27 9 29 18 29 21 27 31 22 37 15 40 13 40 6 37 2 31 0 21 ] ] Char
0 -1142 2250 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
10 SetText2
0 -2625 2750 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
0 -2573 2750 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
0 -2519 2750 [ [ 0 65 0 0 27 0 ] ] Char
0 -2472 2750 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -2420 2750 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
0 -2368 2750 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -3950 750 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
0 -3898 750 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -3842 750 [ [ 0 65 0 0 27 0 ] ] Char
0 -3795 750 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -3743 750 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -3691 750 [ [ 0 65 0 0 27 0 ] ] Char
0 -3644 750 [ [ 11 65 4 62 2 56 2 50 4 43 9 40 18 37 25 34 29 28 31 21 31 12 29 6 27 3 20 0 11 0 4 3 2 6 0 12 0 21 2 28 6 34 13 37 22 40 27 43 29 50 29 56 27 62 20 65 11 65 ] ] Char
10 SetText2
0 -2875 1350 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
0 -2823 1350 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -2767 1350 [ [ 0 65 0 0 27 0 ] ] Char
0 -2720 1350 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -2668 1350 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -2616 1350 [ [ 0 65 0 0 27 0 ] ] Char
0 -2569 1350 [ [ 11 65 4 62 2 56 2 50 4 43 9 40 18 37 25 34 29 28 31 21 31 12 29 6 27 3 20 0 11 0 4 3 2 6 0 12 0 21 2 28 6 34 13 37 22 40 27 43 29 50 29 56 27 62 20 65 11 65 ] ] Char
10 SetText2
0 -1925 3650 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
0 -1873 3650 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
0 -1819 3650 [ [ 0 65 0 0 27 0 ] ] Char
0 -1772 3650 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -1720 3650 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -1689 3650 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -1637 3650 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
10 SetText2
0 -4100 1350 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
0 -4048 1350 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
0 -3994 1350 [ [ 0 65 0 0 27 0 ] ] Char
0 -3947 1350 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -3895 1350 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
0 -3843 1350 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -1025 3650 [ [ 31 65 9 0 ] [ 0 65 31 65 ] ] Char
0 -973 3650 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
0 -919 3650 [ [ 0 65 0 0 27 0 ] ] Char
0 -872 3650 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -820 3650 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -768 3650 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -7275 3625 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7223 3625 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 ] [ 0 34 20 34 27 31 29 28 31 21 31 12 29 6 27 3 20 0 0 0 ] ] Char
0 -7171 3625 [ [ 0 65 0 0 ] [ 0 65 31 0 ] [ 31 65 31 0 ] ] Char
0 -7119 3625 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
10 SetText2
0 -225 3050 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -171 3050 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -115 3050 [ [ 0 65 0 0 ] [ 0 65 31 0 ] [ 31 65 31 0 ] ] Char
0 -63 3050 [ [ 0 78 40 -21 ] ] Char
0 -2 3050 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 50 3050 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 ] [ 0 34 20 34 27 31 29 28 31 21 31 12 29 6 27 3 20 0 0 0 ] ] Char
0 102 3050 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 154 3050 [ [ 29 65 6 65 4 37 6 40 13 43 20 43 27 40 31 34 34 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
0 208 3050 [ [ 0 65 0 0 ] [ 31 65 31 0 ] [ 0 34 31 34 ] ] Char
0 260 3050 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] ] Char
10 SetText2
0 -2700 25 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -2646 25 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -2590 25 [ [ 0 65 0 0 ] [ 0 65 31 0 ] [ 31 65 31 0 ] ] Char
0 -2538 25 [ [ 0 78 40 -21 ] ] Char
0 -2477 25 [ [ 0 65 0 0 ] ] Char
0 -2457 25 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -2405 25 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -2349 25 [ [ 0 78 40 -21 ] ] Char
0 -2288 25 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -2238 25 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -2186 25 [ [ 15 65 15 0 ] [ 0 65 31 65 ] ] Char
10 SetText2
0 -2075 25 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -2021 25 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -1965 25 [ [ 0 65 0 0 ] [ 0 65 31 0 ] [ 31 65 31 0 ] ] Char
0 -1913 25 [ [ 0 78 40 -21 ] ] Char
0 -1852 25 [ [ 0 65 0 0 ] ] Char
0 -1832 25 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -1780 25 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -1724 25 [ [ 0 78 40 -21 ] ] Char
0 -1663 25 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -1613 25 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -1561 25 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 ] [ 0 34 20 34 27 31 29 28 31 21 31 12 29 6 27 3 20 0 0 0 ] ] Char
10 SetText2
0 -6900 3600 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -6848 3600 [ [ 0 65 18 0 ] [ 36 65 18 0 ] ] Char
0 -6792 3600 [ [ 0 65 0 0 ] [ 0 65 31 0 ] [ 31 65 31 0 ] ] Char
0 -6740 3600 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
10 SetText2
0 -7325 2675 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7273 2675 [ [ 0 65 18 0 ] [ 36 65 18 0 ] ] Char
0 -7217 2675 [ [ 0 65 0 0 ] [ 0 65 31 0 ] [ 31 65 31 0 ] ] Char
0 -7165 2675 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
10 SetText2
0 -7750 2675 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7698 2675 [ [ 0 65 18 0 ] [ 36 65 18 0 ] ] Char
0 -7642 2675 [ [ 0 65 0 0 ] [ 0 65 31 0 ] [ 31 65 31 0 ] ] Char
0 -7590 2675 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
10 SetText2
0 -6875 2675 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -6823 2675 [ [ 0 65 18 0 ] [ 36 65 18 0 ] ] Char
0 -6767 2675 [ [ 0 65 0 0 ] [ 0 65 31 0 ] [ 31 65 31 0 ] ] Char
0 -6715 2675 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
10 SetText2
0 -7750 1775 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7698 1775 [ [ 0 65 18 0 ] [ 36 65 18 0 ] ] Char
0 -7642 1775 [ [ 0 65 0 0 ] [ 0 65 31 0 ] [ 31 65 31 0 ] ] Char
0 -7590 1775 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
10 SetText2
0 -7650 100 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7598 100 [ [ 0 65 18 0 ] [ 36 65 18 0 ] ] Char
0 -7542 100 [ [ 0 65 0 0 ] [ 0 65 31 0 ] [ 31 65 31 0 ] ] Char
0 -7490 100 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
10 SetText2
0 -7650 3600 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -7594 3600 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
0 -7542 3600 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] ] Char
0 -7492 3600 [ [ 0 53 4 56 11 65 11 0 ] ] Char
0 -7461 3600 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -7409 3600 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -7050 2950 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -6998 2950 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -6946 2950 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -6896 2950 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
10 SetText2
0 -7050 2800 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -6998 2800 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -6946 2800 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -6896 2800 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
10 SetText2
0 -7025 2025 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -6973 2025 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -6921 2025 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -6871 2025 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
10 SetText2
0 -6250 1775 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -6250 1827 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -6250 1879 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -6250 1929 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -6400 1775 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -6400 1827 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -6400 1879 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -6400 1929 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -5950 1225 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -5950 1277 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -5950 1329 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -5950 1379 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -6100 1775 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -6100 1827 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -6100 1879 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -6100 1929 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -4900 3450 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -4900 3502 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -4900 3554 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -4900 3604 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -6250 1225 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -6250 1277 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -6250 1329 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -6250 1379 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -5000 1950 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -4948 1950 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -4896 1950 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -4846 1950 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
10 SetText2
0 -5000 2250 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -4948 2250 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -4896 2250 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -4846 2250 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
10 SetText2
0 -5800 2800 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -5800 2852 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -5800 2904 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -5800 2954 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -5700 500 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -5700 552 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -5700 604 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -5700 654 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -5325 775 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5273 775 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -5221 775 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -5171 775 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
10 SetText2
0 -5950 1775 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -5950 1827 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -5950 1879 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -5950 1929 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -5800 1775 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -5800 1827 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -5800 1879 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -5800 1929 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -5625 1400 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5573 1400 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -5521 1400 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -5471 1400 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
10 SetText2
0 -5100 1400 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5048 1400 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -4996 1400 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -4946 1400 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
10 SetText2
0 -5800 1225 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -5800 1277 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -5800 1329 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -5800 1379 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -5525 1950 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5473 1950 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -5421 1950 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -5371 1950 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
10 SetText2
0 -5525 2100 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5473 2100 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -5421 2100 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -5371 2100 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
10 SetText2
0 -5525 2250 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -5473 2250 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -5421 2250 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -5371 2250 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
10 SetText2
0 -4600 3450 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -4600 3502 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -4600 3554 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -4600 3604 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -300 625 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -300 677 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -300 729 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -300 779 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -150 625 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -150 677 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -150 729 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -150 779 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -300 3525 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -300 3577 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -46 31 -40 29 -37 27 -34 20 -34 0 ] [ -34 15 0 31 ] ] Char
0 -300 3629 [ [ -65 0 0 0 ] [ -65 0 -65 29 ] [ -34 0 -34 18 ] [ 0 0 0 29 ] ] Char
0 -300 3679 [ [ -56 31 -62 27 -65 20 -65 11 -62 4 -56 0 -50 0 -43 2 -40 4 -37 9 -31 22 -28 27 -25 29 -18 31 -9 31 -3 27 0 20 0 11 -3 4 -9 0 ] ] Char
10 SetText2
0 -2650 750 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -2598 750 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -2546 750 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 43 29 37 27 34 20 31 0 31 ] ] Char
0 -2494 750 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -2442 750 [ [ 0 65 11 0 ] [ 22 65 11 0 ] [ 22 65 34 0 ] [ 45 65 34 0 ] ] Char
0 -2377 750 [ [ 27 56 25 62 18 65 13 65 6 62 2 53 0 37 0 21 2 9 6 3 13 0 15 0 22 3 27 9 29 18 29 21 27 31 22 37 15 40 13 40 6 37 2 31 0 21 ] ] Char
10 SetText2
0 -5300 100 [ [ 0 65 31 0 ] [ 31 65 0 0 ] ] Char
0 -5248 100 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] ] Char
0 -5198 100 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -5142 100 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -5090 100 [ [ 22 65 0 21 34 21 ] [ 22 65 22 0 ] ] Char
10 SetText2
0 -5625 3625 [ [ 0 65 18 0 ] [ 36 65 18 0 ] ] Char
0 -5569 3625 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
0 -5515 3625 [ [ 0 65 31 0 ] [ 31 65 0 0 ] ] Char
0 -5463 3625 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -5407 3625 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -550 -25 [ [ 22 65 22 15 20 6 18 3 13 0 9 0 4 3 2 6 0 15 0 21 ] ] Char
0 -507 -25 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 ] [ 0 34 20 34 27 31 29 28 31 21 31 12 29 6 27 3 20 0 0 0 ] ] Char
0 -455 -25 [ [ 0 65 0 0 ] [ 0 65 31 0 ] [ 31 65 31 0 ] ] Char
0 -403 -25 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 ] ] Char
10 SetText2
0 -5875 3500 [ [ -65 0 0 0 ] [ -65 0 -65 15 -62 22 -56 27 -50 29 -40 31 -25 31 -15 29 -9 27 -3 22 0 15 0 0 ] ] Char
0 -5875 3552 [ [ -50 34 -56 31 -62 27 -65 22 -65 13 -62 9 -56 4 -50 2 -40 0 -25 0 -15 2 -9 4 -3 9 0 13 0 22 -3 27 -9 31 -15 34 ] ] Char
0 -5875 3606 [ [ -65 18 0 0 ] [ -65 18 0 36 ] [ -21 6 -21 29 ] ] Char
0 -5875 3662 [ [ -65 0 0 0 ] [ -65 0 -65 20 -62 27 -59 29 -53 31 -43 31 -37 29 -34 27 -31 20 -31 0 ] ] Char
10 SetText2
0 -7925 3400 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -7869 3400 [ [ 15 65 15 0 ] [ 0 65 31 65 ] ] Char
0 -7817 3400 [ [ 0 65 0 0 ] [ 31 65 31 0 ] [ 0 34 31 34 ] ] Char
0 -7765 3400 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -7709 3400 [ [ 0 65 0 0 27 0 ] ] Char
0 -7662 3400 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -7612 3400 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -6725 2850 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -6669 2850 [ [ 15 65 15 0 ] [ 0 65 31 65 ] ] Char
0 -6617 2850 [ [ 0 65 0 0 ] [ 31 65 31 0 ] [ 0 34 31 34 ] ] Char
0 -6565 2850 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -6509 2850 [ [ 0 65 0 0 27 0 ] ] Char
0 -6462 2850 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -6412 2850 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -6700 1150 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -6644 1150 [ [ 15 65 15 0 ] [ 0 65 31 65 ] ] Char
0 -6592 1150 [ [ 0 65 0 0 ] [ 31 65 31 0 ] [ 0 34 31 34 ] ] Char
0 -6540 1150 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -6484 1150 [ [ 0 65 0 0 27 0 ] ] Char
0 -6437 1150 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -6387 1150 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -7925 1150 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -7869 1150 [ [ 15 65 15 0 ] [ 0 65 31 65 ] ] Char
0 -7817 1150 [ [ 0 65 0 0 ] [ 31 65 31 0 ] [ 0 34 31 34 ] ] Char
0 -7765 1150 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -7709 1150 [ [ 0 65 0 0 27 0 ] ] Char
0 -7662 1150 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -7612 1150 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
10 SetText2
0 -8150 1800 [ [ -65 4 -65 29 -40 15 -40 22 -37 27 -34 29 -25 31 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
0 -8150 1852 [ [ -6 2 -3 0 0 2 -3 4 -6 2 ] ] Char
0 -8150 1877 [ [ -43 29 -34 27 -28 22 -25 15 -25 13 -28 6 -34 2 -43 0 -46 0 -56 2 -62 6 -65 13 -65 15 -62 22 -56 27 -43 29 -28 29 -12 27 -3 22 0 15 0 11 -3 4 -9 2 ] ] Char
0 -8150 1927 [ [ -65 13 -62 6 -53 2 -37 0 -28 0 -12 2 -3 6 0 13 0 18 -3 25 -12 29 -28 31 -37 31 -53 29 -62 25 -65 18 -65 13 ] ] Char
0 -8150 1979 [ [ -65 13 -62 6 -53 2 -37 0 -28 0 -12 2 -3 6 0 13 0 18 -3 25 -12 29 -28 31 -37 31 -53 29 -62 25 -65 18 -65 13 ] ] Char
10 SetText2
0 -625 -250 [ [ -6 2 -3 0 0 2 -3 4 -6 2 ] ] Char
0 -625 -225 [ [ -65 4 -65 29 -40 15 -40 22 -37 27 -34 29 -25 31 -18 31 -9 29 -3 25 0 18 0 11 -3 4 -6 2 -12 0 ] ] Char
0 -625 -173 [ [ -65 13 -62 6 -53 2 -37 0 -28 0 -12 2 -3 6 0 13 0 18 -3 25 -12 29 -28 31 -37 31 -53 29 -62 25 -65 18 -65 13 ] ] Char
0 -625 -121 [ [ -65 13 -62 6 -53 2 -37 0 -28 0 -12 2 -3 6 0 13 0 18 -3 25 -12 29 -28 31 -37 31 -53 29 -62 25 -65 18 -65 13 ] ] Char
10 SetText2
0 -4225 4350 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -4169 4350 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -4117 4350 [ [ 15 65 15 0 ] [ 0 65 31 65 ] ] Char
0 -4065 4350 [ [ 0 65 11 0 ] [ 22 65 11 0 ] [ 22 65 34 0 ] [ 45 65 34 0 ] ] Char
0 -4000 4350 [ [ 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 36 25 36 40 34 50 31 56 27 62 22 65 13 65 ] ] Char
0 -3944 4350 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -3892 4350 [ [ 0 65 0 0 ] [ 31 65 0 21 ] [ 11 37 31 0 ] ] Char
0 -3788 4350 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -3736 4350 [ [ 0 65 0 0 ] ] Char
0 -3716 4350 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -3664 4350 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -3562 4350 [ [ 0 53 4 56 11 65 11 0 ] ] Char
10 SetText2
0 -4250 4350 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -4194 4350 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -4142 4350 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -4090 4350 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -4040 4350 [ [ 0 65 0 0 ] [ 0 65 18 0 ] [ 36 65 18 0 ] [ 36 65 36 0 ] ] Char
0 -3984 4350 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 ] [ 0 34 20 34 27 31 29 28 31 21 31 12 29 6 27 3 20 0 0 0 ] ] Char
0 -3932 4350 [ [ 0 65 0 0 27 0 ] ] Char
0 -3885 4350 [ [ 0 65 18 34 18 0 ] [ 36 65 18 34 ] ] Char
0 -3777 4350 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -3725 4350 [ [ 0 65 0 0 ] [ 0 65 20 65 27 62 29 59 31 53 31 46 29 40 27 37 20 34 0 34 ] [ 15 34 31 0 ] ] Char
0 -3673 4350 [ [ 18 65 0 0 ] [ 18 65 36 0 ] [ 6 21 29 21 ] ] Char
0 -3617 4350 [ [ 0 65 11 0 ] [ 22 65 11 0 ] [ 22 65 34 0 ] [ 45 65 34 0 ] ] Char
0 -3552 4350 [ [ 0 65 0 0 ] ] Char
0 -3532 4350 [ [ 0 65 0 0 ] [ 0 65 31 0 ] [ 31 65 31 0 ] ] Char
0 -3480 4350 [ [ 34 50 31 56 27 62 22 65 13 65 9 62 4 56 2 50 0 40 0 25 2 15 4 9 9 3 13 0 22 0 27 3 31 9 34 15 34 25 ] [ 22 25 34 25 ] ] Char
10 SetText2
0 -2450 -525 [ [ 4 65 29 65 15 40 22 40 27 37 29 34 31 25 31 18 29 9 25 3 18 0 11 0 4 3 2 6 0 12 ] ] Char
0 -2398 -525 [ [ 2 6 0 3 2 0 4 3 2 6 ] ] Char
0 -2373 -525 [ [ 2 50 2 53 4 59 6 62 11 65 20 65 25 62 27 59 29 53 29 46 27 40 22 31 0 0 31 0 ] ] Char
0 -2321 -525 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -2269 -525 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
10 SetText2
0 -450 -525 [ [ 2 6 0 3 2 0 4 3 2 6 ] ] Char
0 -425 -525 [ [ 11 65 4 62 2 56 2 50 4 43 9 40 18 37 25 34 29 28 31 21 31 12 29 6 27 3 20 0 11 0 4 3 2 6 0 12 0 21 2 28 6 34 13 37 22 40 27 43 29 50 29 56 27 62 20 65 11 65 ] ] Char
0 -373 -525 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -321 -525 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
10 SetText2
0 -3950 4075 [ [ 11 65 4 62 2 56 2 50 4 43 9 40 18 37 25 34 29 28 31 21 31 12 29 6 27 3 20 0 11 0 4 3 2 6 0 12 0 21 2 28 6 34 13 37 22 40 27 43 29 50 29 56 27 62 20 65 11 65 ] ] Char
0 -3898 4075 [ [ 2 6 0 3 2 0 4 3 2 6 ] ] Char
0 -3873 4075 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -3821 4075 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
0 -3769 4075 [ [ 13 65 6 62 2 53 0 37 0 28 2 12 6 3 13 0 18 0 25 3 29 12 31 28 31 37 29 53 25 62 18 65 13 65 ] ] Char
10 SetText2
0 -7425 100 [ [ 31 56 27 62 20 65 11 65 4 62 0 56 0 50 2 43 4 40 9 37 22 31 27 28 29 25 31 18 31 9 27 3 20 0 11 0 4 3 0 9 ] ] Char
0 -7373 100 [ [ 0 65 0 0 ] ] Char
0 -7353 100 [ [ 0 65 0 0 ] [ 0 65 15 65 22 62 27 56 29 50 31 40 31 25 29 15 27 9 22 3 15 0 0 0 ] ] Char
0 -7301 100 [ [ 0 65 0 0 ] [ 0 65 29 65 ] [ 0 34 18 34 ] [ 0 0 29 0 ] ] Char
0 -7199 100 [ [ 0 53 4 56 11 65 11 0 ] ] Char
grestore
showpage
