/*------------------------------------------------------------------------

      File:  cmdMisc.c
   Project:  Tcl Modules
   Created:  Tue Oct 22 23:45:57 1991
    Author:  John L. Furlani<john.furlani@East.Sun.COM>
  Revision:  1.2
  Last Mod:  20:19:56, 1/19/92

  Description of File:
		
	
	
	
	
	
	
	
------------------------------------------------------------------------*/
/***********************************************************************
* Copyright 1991 by John L. Furlani.  All rights reserved.
* 
* This material was written by John L. Furlani.
*
* Redistribution and use in source and binary forms are permitted
* provided that this entire copyright notice is duplicated in all such
* copies, and that any documentation, announcements, and other
* materials related to such distribution and use acknowledge that the
* software was developed by John Furlani.  No charge, other than an 
* "at-cost" distribution fee, may be charged for copies, derivations, 
* or distributions of this material without the express written 
* consent of the copyright holder.  The name of the author may not
* be used to endorse or promote products derived from this material 
* without specific prior written permission
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
* MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
************************************************************************/
static char SccsId[] = "@(#)cmdMisc.c	1.2\t1/19/92";

#include "global.h"

/*
  The Following code was written by Don Libes, NIST
  It was taken from his tool, 'expect'
  I have edited parts of it...
*/

/*ARGSUSED*/
int
cmdSystem(ClientData clientData, 
	  Tcl_Interp* interp, 
	  int argc, 
	  char* argv[])
{
#define MAX_ARGLIST 10240
	int i;
	char buf[MAX_ARGLIST];
	char *bufp = buf;
	int total_len = 0, arg_len;

	for (i = 1;i<argc;i++) {
		total_len += (1 + (arg_len = strlen(argv[i])));
		if (total_len > MAX_ARGLIST) {
		  Tcl_AppendResult(interp, argv[0], ": args too long (>=", total_len,
				   " chars)", (char *) NULL);
		  return(TCL_ERROR);
		}
		memcpy(bufp,argv[i],arg_len);
		bufp += arg_len;
		/* no need to check bounds, we accted for it earlier */
		memcpy(bufp," ",1);
		bufp += 1;
	}

	/* For Modules, stdout must be directed to stderr so it
	 isn't parsed by the evaluating shell
	 */
	close(1);
	dup(2);


	*(bufp-1) = '\0';
	i = system(buf);

	/* Following the style of Tcl_ExecCmd, we can just return the */
	/* raw result (appropriately shifted and masked) to Tcl */

	sprintf(buf, "%d", i);
	Tcl_SetResult(interp, buf, TCL_VOLATILE);

	return(0xff & (i>>8));
}
