(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Tracer.i3                                             *)
(* Last Modified On Mon Jun 29 11:56:52 PDT 1992 by kalsow     *)

INTERFACE Tracer;

TYPE T = UNTRACED BRANDED "Tracer.T" OBJECT next: T METHODS apply () END;

PROCEDURE Schedule (t: T);
(* schedule 't' to be called during the next 'EmitPending' *)

PROCEDURE Push (t: T);
PROCEDURE Pop (t: T);
(* delimits the region of code that's to be traced by 't'. *)

PROCEDURE EmitPending ();
(* generate all pending trace calls *)

END Tracer.
