(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Emit.i3                                               *)
(* Last Modified On Tue May 12 08:06:45 PDT 1992 by kalsow     *)
(*      Modified On Sat Apr 28 00:28:38 1990 by muller         *)

(* All C preprocessing primitives must be issued between the FlushLine
character and a \n. This is needed to ensure that they start on at the
beginning of a line and are the only material on that line. *)

INTERFACE Emit;
IMPORT String, Variable, Value, Temp, Type;

CONST
  Marker    = '@';
  Indent    = '\001';
  Outdent   = '\002';
  FlushLine = '\003';

TYPE
  Format = TEXT;
  Stream = { TextLiterals, RealLiterals, LongrealLiterals, ExtendedLiterals,
             TypeDecls, ProcHeads, Constants, Code,
             Decls0, Body0, Decls1, Body1,  Decls2, Body2,  Decls3, Body3,
             Decls4, Body4, Decls5, Body5,  Decls6, Body6,  Decls7, Body7,
             TypeFPs, TypeCells, LinkTables,
             LinkHeader, VersionStamps, LinkerTypes };

PROCEDURE Op    (f: Format);
PROCEDURE OpC   (f: Format;  c: CHAR);
PROCEDURE OpQ   (f: Format;  s: String.T);
PROCEDURE OpS   (f: Format;  s: String.T);
PROCEDURE OpSS  (f: Format;  s1, s2: String.T);
PROCEDURE OpSI  (f: Format;  s: String.T;  i: INTEGER);
PROCEDURE OpIS  (f: Format;  i: INTEGER;  s: String.T);
PROCEDURE OpI   (f: Format;  i: INTEGER);
PROCEDURE OpII  (f: Format;  i1, i2: INTEGER);
PROCEDURE OpIII (f: Format;  i1, i2, i3: INTEGER);
PROCEDURE OpL   (f: Format;  label: INTEGER);
PROCEDURE OpV   (f: Format;  v: Variable.T);
PROCEDURE OpR   (f: Format;  r: LONGREAL);
PROCEDURE OpN   (f: Format;  v: Value.T);
PROCEDURE OpH   (f: Format;  h: INTEGER);
PROCEDURE OpHH  (f: Format;  h1, h2: INTEGER);
PROCEDURE OpF   (f: Format;  t: Type.T);
PROCEDURE OpFF  (f: Format;  t1, t2: Type.T);
PROCEDURE OpFT  (f: Format;  t: Type.T;  z: Temp.T);
PROCEDURE OpT   (f: Format;  t: Temp.T);
PROCEDURE OpTT  (f: Format;  t1, t2: Temp.T);
PROCEDURE OpTTT (f: Format;  t1, t2, t3: Temp.T);
PROCEDURE OpTI  (f: Format;  t: Temp.T;  i: INTEGER);
PROCEDURE OpIT  (f: Format;  i: INTEGER;  t: Temp.T);
PROCEDURE OpX   (f: Format;  x: TEXT);
PROCEDURE OpZ   (f: Format;  READONLY ss: String.Stack);
PROCEDURE OpSZ  (f: Format;  s: String.T;  READONLY ss: String.Stack);

PROCEDURE Zero (t: Type.T;  READONLY ss: String.Stack);

PROCEDURE Comment (t: TEXT);

PROCEDURE Switch (s: Stream): Stream;

PROCEDURE PushProcedure (formatted: BOOLEAN := FALSE);
PROCEDURE PopProcedure ();
PROCEDURE SwitchToDecls (): Stream;
PROCEDURE SwitchToBody (): Stream;

PROCEDURE Reset ();
PROCEDURE Finalize ();
PROCEDURE RegisterShutDown (s: Stream;  p: PROCEDURE ());

END Emit.
