/**
 ** MODETEST.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "../include/grx.h"
#include "../include/mousex.h"
#include "../include/grdriver.h"
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <dos.h>

#ifdef __TURBOC__
#define ENV_VAR "GRXDRV"
#endif

#ifdef __GNUC__
#define ENV_VAR "GO32"
#endif

GR_DRIVER_MODE_ENTRY far *ttab,*gtab;
int txt_modes,gra_modes;

void list_modes(void)
{
	char buf[20];
	char tentry[100];
	char gentry[100];
	char *env = getenv(ENV_VAR);
	int  mode;

	if(env != NULL)
	    printf("Value of environment variable \"%s\" is:\n\"%s\"\n\n",ENV_VAR,env);
	printf("%-32s%s\n\n","Available text modes:","Available graphics modes:");
	txt_modes = 0;
	gra_modes = 0;
	while((ttab[txt_modes].width != 0) || (gtab[gra_modes].width != 0)) {
	    tentry[0] = '\0';
	    gentry[0] = '\0';
	    if(ttab[txt_modes].width != 0) {
		mode = ttab[txt_modes].BIOS_mode +
		    (ttab[txt_modes].special << 8);
		sprintf(tentry,
		    "(t%d%s  %3dx%-2d C:%-2d %s",
		    txt_modes+1,
		    ((txt_modes < 9) ? ") " : ")"),
		    ttab[txt_modes].width,
		    ttab[txt_modes].height,
		    ttab[txt_modes].number_of_colors,
		    ((ttab[txt_modes].BIOS_mode == 0xff) ?
			"Disabled" :
			(sprintf(buf,"BIOS:%03xh",mode),buf)
		));
		if(ttab[txt_modes].special) strcat(tentry," *");
		txt_modes++;
	    }
	    if(gtab[gra_modes].width != 0) {
		mode = gtab[gra_modes].BIOS_mode +
		    (gtab[gra_modes].special << 8);
		sprintf(gentry,
		    "(g%d%s  %4dx%-3d C:%-5u %s",
		    gra_modes+1,
		    ((gra_modes < 9) ? ") " : ")"),
		    gtab[gra_modes].width,
		    gtab[gra_modes].height,
		    gtab[gra_modes].number_of_colors,
		    ((gtab[gra_modes].BIOS_mode == 0xff) ?
			"Disabled" :
			(sprintf(buf,"BIOS:%03xh",mode),buf)
		));
		if(gtab[gra_modes].special) strcat(gentry," *");
		gra_modes++;
	    }
	    printf("%-32s%s\n",tentry,gentry);
	}
	printf("\nEnter mode to test or 'Q' to quit: ");
	fflush(stdout);
}

void test_textmode(int mode)
{
	int ii;

	if(mode < 0) return;
	if(mode >= txt_modes) return;
	if(ttab[mode].BIOS_mode == 0xff) return;
	GrSetMode(GR_width_height_text,ttab[mode].width,ttab[mode].height);
	do {
	    printf("\n\nThis is a text mode of width=%d by height=%d\n",
		ttab[mode].width,
		ttab[mode].height
	    );
	    for(ii = 4; ii < 512; ii += 4) printf("%4d",ii);
	    printf("\nPress any key to abort this test...");
	    fflush(stdout);
#ifdef __TURBOC__
	    delay(2000);
#endif
#ifdef __GNUC__
	    sleep(2);
#endif
	} while(!kbhit());
	getkey();
}

#define XP(x)	(int)((((long)(x) * (long)xsize) / 100L) + xpos)
#define YP(y)	(int)((((long)(y) * (long)ysize) / 100L) + ypos)

void drawing(int xpos,int ypos,int xsize,int ysize,int fg,int bg)
{
	int ii;

	if(bg != GrNOCOLOR) {
	    GrFilledBox(xpos,ypos,xpos+xsize-1,ypos+ysize-1,bg);
	}
	GrLine(XP(10),YP(10),XP(40),YP(40),fg);
	GrLine(XP(40),YP(10),XP(10),YP(40),fg);
	GrLine(XP(35),YP(10),XP(65),YP(40),fg);
	GrLine(XP(35),YP(40),XP(65),YP(10),fg);
	GrLine(XP(70),YP(10),XP(90),YP(40),fg);
	GrLine(XP(70),YP(40),XP(90),YP(10),fg);
	for(ii = 0; ii < 5; ii++) {
	    GrBox(XP(70+2*ii),YP(10+3*ii),XP(90-2*ii),YP(40-3*ii),fg);
	}
	GrFilledBox(XP(10),YP(50),XP(60),YP(90),fg);
	GrBox(XP(70),YP(50),XP(90),YP(90),fg);
	for(ii = 0; ii < 100; ii++) {
	    GrPlot(XP((random() % 20) + 70),YP((random() % 40) + 50),fg);
	}
}

void test_graphicsmode(int mode)
{
	char buf[100];

	if(mode < 0) return;
	if(mode >= gra_modes) return;
	if(gtab[mode].BIOS_mode == 0xff) return;
	GrSetMode(GR_width_height_color_graphics,
	    gtab[mode].width,
	    gtab[mode].height,
	    gtab[mode].number_of_colors
	);
	sprintf(buf,
	    "%dx%d graphics with %d colors",
	    GrSizeX(),
	    GrSizeY(),
	    GrNumColors()
	);
	GrClearScreen(GrBlack());
	drawing(0,0,GrSizeX(),GrSizeY()-35,GrWhite(),GrNOCOLOR);
	GrTextXY(0,GrSizeY()-32,buf,GrWhite(),GrNOCOLOR);
	GrTextXY(0,GrSizeY()-16,"Press any key to continue...",GrWhite(),GrNOCOLOR);
	getkey();
}

void main(void)
{
	char reply[80];

	printf("MODETEST: GrSetMode()\n");
	GrSetMode(GR_biggest_text);
	printf("          GrGetDriverModes()\n");
	GrGetDriverModes(&ttab,&gtab);
	printf("MODETEST set up\n");
	if(!ttab || !gtab) {
	    printf("MODETEST will work only with a new format driver\n");
	    exit(0);
	}
	for( ; ; ) {
	    GrSetMode(GR_biggest_text);
	    list_modes();
	    gets(reply);
	    switch(tolower(reply[0])) {
	      case 't':
		test_textmode(atoi(&reply[1]) - 1);
		break;
	      case 'g':
		test_graphicsmode(atoi(&reply[1]) - 1);
		break;
	      case 'q':
		exit(0);
	    }
	}
}

