/*		Case-independent string comparison		HTString.c
**
**	Original version came with listserv implementation.
**	Version TBL Oct 91 replaces one which modified the strings.
**	02-Dec-91 (JFG) Added stralloccopy and stralloccat
**	23 Jan 92 (TBL) Changed strallocc* to 8 char HTSAC* for VM and suchlike
**	 6 Oct 92 (TBL) Moved WWW_TraceFlag in here to be in library
*/
#include"capalloc.h"
#include"capstdio.h"
#include <ctype.h>
#include "HTUtils.h"
#include "tcp.h"

#ifndef RELEASE
PUBLIC int WWW_TraceFlag = 0;	/* Global trace flag for ALL W3 code */
#endif /* RELEASE */

#ifndef VC
#define VC "unknown"
#endif

PUBLIC CONST char * HTLibraryVersion = VC; /* String for help screen etc */

#ifndef VM		/* VM has these already it seems */
	
/*	Strings of any length
**	---------------------
*/
PUBLIC int strcasecomp ARGS2 (CONST char*,a, CONST char *,b)
{
	CONST char *p =a;
	CONST char *q =b;
	for(p=a, q=b; *p && *q; p++, q++) {
	    int diff = TOLOWER(*p) - TOLOWER(*q);
	    if (diff) return diff;
	}
	if (*p) return 1;	/* p was longer than q */
	if (*q) return -1;	/* p was shorter than q */
	return 0;		/* Exact match */
}


/*	With count limit
**	----------------
*/
PUBLIC int strncasecomp ARGS3(CONST char*,a, CONST char *,b, int,n)
{
	CONST char *p =a;
	CONST char *q =b;
	
	for(p=a, q=b;; p++, q++) {
	    int diff;
	    if (p == a+n) return 0;	/*   Match up to n characters */
	    if (!(*p && *q)) return *p - *q;
	    diff = TOLOWER(*p) - TOLOWER(*q);
	    if (diff) return diff;
	}
	/*NOTREACHED*/
}
#endif

extern char *HTSACopy(char **cpp_dest, const char *cp_src)	{
/*
 *	Purpose:	Allocate space for a string, then copy it.
 *	Arguments:	cpp_dest	The destination string.
 *					If cpp_dest points to NULL,
 *					space will be allocated for it.
 *					If cpp_dest does not point to NULL,
 *					what it points to is freed, and
 *					then space is allocated for it.
 *			cp_src		The source string to copy over.
 *	Return Value:	char *	Should be the same as what cpp_dest points
 *				to.
 *	Remarks/Portability/Dependencies/Restrictions:
 *		Space allocated here should be freed by the calling
 *		function.
 *	Revision History:
 *		??-??-??	created
 *		03-28-94	modified for DosLynx
 */

	/*
	 *	Does the destination point to any already allocated mem?
	 *	If so, free it.
	 */
	if(*cpp_dest)	{
		free(*cpp_dest);
	}

	/*
	 *	If the source string is just null, so should the
	 *	destination.
	 */
	if(cp_src == NULL)	{
		*cpp_dest = NULL;
	}
	else	{
		/*
		 *	The source string is not NULL.
		 *	Allocate space for the destination string and
		 *	copy it over.
		 */
		*cpp_dest = (char *)malloc(strlen(cp_src) + 1);
		if(*cpp_dest == NULL)	{
			outofmem(__FILE__, "HTSACopy");
		}
		strcpy(*cpp_dest, cp_src);
	}

	/*
	 *	Return the copy of the source string.
	 */
	return(*cpp_dest);
}

/*	String Allocate and Concatenate
*/
PUBLIC char * HTSACat
  ARGS2 (char **,dest, CONST char *,src)
{
  if (src && *src) {
    if (*dest) {
      int length = strlen (*dest);
      *dest = (char *) realloc (*dest, length + strlen(src) + 1);
      if (*dest == NULL) outofmem(__FILE__, "HTSACat");
      strcpy (*dest + length, src);
    } else {
      *dest = (char *) malloc (strlen(src) + 1);
      if (*dest == NULL) outofmem(__FILE__, "HTSACat");
      strcpy (*dest, src);
    }
  }
  return *dest;
}


/*	Find next Field
**	---------------
**
** On entry,
**	*pstr	points to a string containig white space separated
**		field, optionlly quoted.
**
** On exit,
**	*pstr	has been moved to the first delimiter past the
**		field
**		THE STRING HAS BEEN MUTILATED by a 0 terminator
**
**	returns	a pointer to the first field
*/
PUBLIC char * HTNextField ARGS1(char **, pstr)
{
    char * p = *pstr;
    char * start;			/* start of field */
    
    while(*p && WHITE(*p)) p++;		/* Strip white space */
    if (!*p) {
	*pstr = p;
        return NULL;		/* No first field */
    }
    if (*p == '"') {			/* quoted field */
        p++;
	start = p;
	for(;*p && *p!='"'; p++) {
	    if (*p == '\\' && p[1]) p++;	/* Skip escaped chars */
	}
    } else {
	start = p;
	while(*p && !WHITE(*p)) p++;	/* Skip first field */
    }
    if (*p) *p++ = 0;
    *pstr = p;
    return start;
}
