//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide a view for a URL.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		03-30-94	created
#include"turlview.h"

void TURLView::DoNotDisplay()	{
//	Purpose:	Function will automatically set up the view to
//			not be valid such that the owning window will not
//			attempt to display it.  In such cases, the url is
//			simply not displayable and is probably being saved
//			to disk.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		This function will have to be called at some time during
//		the TURLView constructor is in the calling stack, otherwise
//		the owner will attempt to display the view anyway.
//	Revision History:
//		03-30-94	created

	//	Just set the valid member to false.
	B_valid = False;

	//	Also, this function is only called when a file download is
	//	requested.  Mark this.
	B_download = True;
}