//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TDosLynx
//	Include File:	tdoslynx.h
//	Purpose:	Provide the application for a WWW client.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		02-25-94	created
#include"tdoslynx.h"
#include"trace.h"
#include"globals.h"
#include"gridtext.h"
#include<dos.h>

extern void ReleaseSomeMemory()	{
//	Purpose:	operator new failure correction function.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		This function is registered to be the new handler in the
//		TDosLynx constructor.  This function will be called when the
//		operator new fails to allocate memory.
//		All this function attempts to do is release already used
//		memory that is not being utilized at the moment in order
//		to allow more allocation to take place.  If this is unable
//		to be accomplished, then this function must take action and
//		exit the program;  will be in fact handled by the previous
//		memory handler if one existed before this one was registered.
//		Don't, whatever you do, include capalloc.h from the DosLynx
//		project.  You will cause the memory pools to free, and then
//		reallocate themselves really doing nothing.
//	Revision History:
//		02-25-94	created to enhance DosLynx memory management.
//		03-13-94	Modified to exit the program without further
//				attempting cleanup by sending messages through
//				TurboVision.

	//	Our job, release the first unused unloading HText in our
	//	list and free it.  If none exist, call the old new handler.
	//	If it doesn't exist, terminate the program.
#ifndef RELEASE
	trace("Attempting to find memory to release.");
#endif // RELEASE

	//	Loop through all HText entries.
	HText *HTp_remove;
	signed short int ssi_search;
	for(ssi_search = 0; ssi_search < TNSCp_LoadedHTexts->getCount();
		ssi_search++)	{
		HTp_remove = (HText *)(TNSCp_LoadedHTexts->
			at(ssi_search));
		//	If the HText is being used by a view or is being
		//	loaded, cannot destroy it; continue.
		if(HTp_remove->usi_Views != 0U)
			continue;
		else if(HTp_remove->B_isLoading == True)
			continue;

		//	An open HText found, free it, it's anchors and quit
		//	the loop.
		HText_free(HTp_remove);
		return;
	}

	//	We have reached a point to begin deallocating the really
	//	safe pool.  All other memory at this point should have
	//	been released that possible could have.
	for(register signed short int ssi_counter = Stop_Anchors; ssi_counter
		< RSP_NUM; ssi_counter++)	{
		//	See if we found one to release.
		if(really_safe_pool[ssi_counter] != NULL)	{
			//	Can release.  Do so.
			free(really_safe_pool[ssi_counter]);
			really_safe_pool[ssi_counter] = NULL;
			return;
		}
	}

	//	Modified not to call the old handler, since will simply
	//	terminate the program.  Will try to display a message
	//	and cleanup below.

	//	We have to exit the program in a very ugly way.
	//	Try to tell the user that we are sorry.
	doslynxmessage("All attempts to allocate more memory have failed.");
	doslynxmessage("Program Terminating....");

	//	give the user time to see the message.
	sleep(5);

	//	Exit the application.
	exit(1);
}