source coding.tcl
source env.tcl
source h.tcl
# source ui.tcl
                  puts "ADDITIONAL FILES SOURCED. Trying to connect..."

set irc(SOCK) [socket irc.portal.ru 6665]
fconfigure $irc(SOCK) -buffering line
pack [entry .entry1 -font $env(FONT)] -fill x -expand true
bind .entry1 <KeyPress-Return>  "      \
   puts \$irc(SOCK) \[.entry1 get];         \
   .entry1 selection range 0 end;      \
";
if {[string compare "$env(PLATFORM)" "unix"]==0} {
   bind .entry1 <KeyPress-F8> {
      set env(RUSSIAN) [expr 1-$env(RUSSIAN)];
   }
}
bind .entry1 <KeyPress-F7> {set env(TRANSLIT) [expr 1-$env(TRANSLIT)]; }
bind .entry1 <KeyPress-F1> {%W insert insert "\2"}
bind .entry1 <KeyPress-F2> {%W insert insert "\3"}
bind .entry1 <KeyPress-F3> {%W insert insert "\026"}
bind .entry1 <KeyPress-F4> {%W insert insert "\037"}
bind .entry1 <KeyPress-F6> {%W insert insert "\1"}

bind .entry1 <KeyPress> {
   if {$env(RUSSIAN) && [string compare "$env(PLATFORM)" "unix"]==0} {
      if {[catch {set Russian(%K)}]==0} {%W insert insert $Russian(%K); break}
   }
}
update
update idletasks

                  puts "Connection established. Sending init info..."
puts $irc(SOCK) "NICK $irc(ME)"
puts $irc(SOCK) "USER a b c d"
                  puts "INITIALIZATION completed. Waiting for reply..."
set log [open "irc.log" a+]
set nicklist {};
set nickinfo {};
puts $log [clock format [clock seconds] -format "\n\n======================     %x  %X ===============\n"]
#############################################################################
fileevent $irc(SOCK) readable {
   if [eof $irc(SOCK)] { catch {close $irc(SOCK)}; catch {close $log}; return }
   gets $irc(SOCK) line
   puts $line
   puts $log $line
   regexp {^(:([^ ]+) +)?([^ ]+) *(.*)$} $line full no1 src cmd args
   switch -- [string toupper $cmd] {
   NOTICE -
   PRIVMSG {
      regexp {^([^!]+)!([^@]+)@(.*)$} $src full nick user host
      regexp {^([^ ]+) +:(.*)$} $args full to what
      PRIVMSG $nick $to $what
   }
   NICK {
      regexp {^([^!]+)!([^@]+)@(.*)$} $src full nick user host
      regexp {:([^ ]+)} $args full new
      NICK $nick $new
   }
   PART {
      regexp {([^ ]+) +:(.*)} $args full channel nick
      PART $channel $nick
   }
   QUIT {
      set reason NOTHING
      regexp {^([^!]+)!([^@]+)@(.*)$} $src full nick user host
      regexp {:(.*)} $args full reason
      QUIT $nick $reason
   }
   KICK {
      set reason NOTHING
      regexp {^([^!]+)!([^@]+)@(.*)$} $src full nick user host
      regexp {^([^ ]+) +([^ ]+) *(.*)} $args full ch victim reason
      KICK $ch $nick $victim $reason
   }
   JOIN {
#      regexp {^([^!]+)!([^@]+)@(.*)$} $src full nick user host
      regexp {^:(.*)} $args full channel
      JOIN $channel $src
   }
   INVITE {}
   401 {
      regexp { (.*)} $args error; # No such NICK/CHANNEL
      tk_messageBox -icon error -message $error -title "ERROR" -type ok
   }
   433 {
      set irc(ME) $irc(ME2); # NICK already in use
      puts $irc(SOCK) "NICK $irc(ME)"
   }
   TOPIC -
   332 {
      regexp {([^ ]+) :(.*)$} $args full channel topic
      CODE_332 $channel $topic
   }
   353 {
      regexp {([^ ]+) :(.*)$} $args full channel list_half
      set nicklist "$nicklist [string trim $list_half]"
   }
   366 { # END OF NAMES LIST
      CODE_366 $channel $nicklist
      set nicklist {}
   }
   MODE {
      regexp {^([^ ]+) +(.*)$} $args full target mode
      if [regexp {^[&#]} $target] {
         regexp {^([^!]+)} $src full nick
         MODE_CHNL $target $nick $mode
      } else {
         MODE_USER $target $mode
      }
   }
   311 -
   312 -
   313 -
   317 -
   319 -
   314 -
   352 {
      set nickinfo "${nickinfo}$args\n"
   }
   318 -
   369 -
   315 {
      tk_messageBox -icon info -message $nickinfo -title "INFO on NICK" -type ok
      set nickinfo {}
   }
   PING {puts $irc(SOCK) "PONG IRCaman"}
   default {puts "############# Unknown command : $cmd";}
   }
   update
   update idletasks
}
#############################################################################

