/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class RenameCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 1, argv, "oldName newName");
        }
        String oldName = argv[1].toString();
        String newName = argv[2].toString();
        boolean delete = newName.length() == 0;
        Command cmd = (Command)interp.cmdTable.get(oldName);
        if (cmd == null) {
            if (delete) {
                throw new TclException(interp, "can't delete \"" + oldName + "\": command doesn't exist");
            }
            throw new TclException(interp, "can't rename \"" + oldName + "\": command doesn't exist");
        }
        if (interp.cmdTable.get(newName) != null) {
            throw new TclException(interp, "can't rename to \"" + newName + "\": command already exists");
        }
        if (delete) {
            interp.deleteCommand(oldName);
        } else {
            interp.cmdTable.remove(oldName);
            interp.cmdTable.put(newName, cmd);
        }
    }

    RenameCmd() {
    }
}

