/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

class Procedure
implements Command,
CommandWithDispose {
    TclObject[][] argList;
    boolean isVarArgs;
    CharPointer body;
    int body_length;
    String srcFileName;
    int srcLineNumber;

    Procedure(Interp interp, String name, TclObject args, TclObject b, String sFileName, int sLineNumber) throws TclException {
        this.srcFileName = sFileName;
        this.srcLineNumber = sLineNumber;
        int numArgs = TclList.getLength(interp, args);
        this.argList = new TclObject[numArgs][2];
        int i = 0;
        while (i < numArgs) {
            TclObject argSpec = TclList.index(interp, args, i);
            int specLen = TclList.getLength(interp, argSpec);
            if (specLen == 0) {
                throw new TclException(interp, "procedure \"" + name + "\" has argument with no name");
            }
            if (specLen > 2) {
                throw new TclException(interp, "too many fields in argument specifier \"" + argSpec + "\"");
            }
            this.argList[i][0] = TclList.index(interp, argSpec, 0);
            this.argList[i][0].preserve();
            if (specLen == 2) {
                this.argList[i][1] = TclList.index(interp, argSpec, 1);
                this.argList[i][1].preserve();
            } else {
                this.argList[i][1] = null;
            }
            ++i;
        }
        this.isVarArgs = numArgs > 0 && this.argList[numArgs - 1][0].toString().equals("args");
        this.body = new CharPointer(b.toString());
        this.body_length = this.body.length();
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        CallFrame frame = interp.newCallFrame(this, argv);
        interp.pushDebugStack(this.srcFileName, this.srcLineNumber);
        try {
            try {
                Parser.eval2(interp, this.body.array, this.body.index, this.body_length, 0);
            }
            catch (TclException e) {
                int code = e.getCompletionCode();
                if (code == 2) {
                    int realCode = interp.updateReturnInfo();
                    if (realCode != 0) {
                        e.setCompletionCode(realCode);
                        throw e;
                    }
                }
                if (code == 1) {
                    interp.addErrorInfo("\n    (procedure \"" + argv[0] + "\" line " + interp.errorLine + ")");
                    throw e;
                }
                if (code == 3) {
                    throw new TclException(interp, "invoked \"break\" outside of a loop");
                }
                if (code == 4) {
                    throw new TclException(interp, "invoked \"continue\" outside of a loop");
                }
                throw e;
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            interp.popDebugStack();
            if (interp.errInProgress) {
                frame.dispose();
                interp.errInProgress = true;
            } else {
                frame.dispose();
            }
            throw throwable;
        }
        interp.popDebugStack();
        if (interp.errInProgress) {
            frame.dispose();
            interp.errInProgress = true;
        } else {
            frame.dispose();
        }
    }

    public void disposeCmd() {
        this.body = null;
        int i = 0;
        while (i < this.argList.length) {
            this.argList[i][0].release();
            this.argList[i][0] = null;
            if (this.argList[i][1] != null) {
                this.argList[i][1].release();
                this.argList[i][1] = null;
            }
            ++i;
        }
        this.argList = null;
    }
}

