/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Extension;
import tcl.lang.Interp;
import tcl.lang.TclClassLoader;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class JavaLoadCmd
implements Command {
    private static final String[] validOpts = new String[]{"-classpath"};

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        Object var11_12;
        Class pkgClass;
        String packageName;
        TclObject classpath;
        Extension pkg = null;
        boolean validLoad = false;
        if (argv.length != 2 && argv.length != 4) {
            throw new TclNumArgsException(interp, 1, argv, "?-classpath arg? packageName");
        }
        if (argv.length == 4) {
            TclIndex.get(interp, argv[1], validOpts, "switch", 0);
            classpath = argv[2];
            packageName = argv[3].toString();
        } else {
            classpath = null;
            packageName = argv[1].toString();
        }
        String errorMsg = "load \"" + packageName + "\" failed: ";
        if (packageName.endsWith(".class")) {
            packageName = packageName.substring(0, packageName.lastIndexOf(".class"));
        }
        TclClassLoader tclClassLoader = new TclClassLoader(interp, classpath);
        try {
            try {
                validLoad = false;
                pkgClass = tclClassLoader.loadClass(packageName, true);
                validLoad = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new TclException(interp, "package \"" + packageName + "\" not found");
            }
            catch (ClassFormatError classFormatError) {
                throw new TclException(interp, String.valueOf(errorMsg) + "use the fully qualified package name");
            }
            catch (SecurityException e) {
                throw new TclException(interp, String.valueOf(errorMsg) + e);
            }
            var11_12 = null;
            if (!validLoad) {
                tclClassLoader.removeCache(packageName);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!validLoad) {
                tclClassLoader.removeCache(packageName);
            }
            throw throwable;
        }
        try {
            try {
                validLoad = false;
                pkg = (Extension)pkgClass.newInstance();
                pkg.init(interp);
                validLoad = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TclException(interp, String.valueOf(errorMsg) + "class or initializer is not accessible");
            }
            catch (InstantiationException instantiationException) {
                throw new TclException(interp, String.valueOf(errorMsg) + "object instantiation failure");
            }
            catch (ClassCastException classCastException) {
                throw new TclException(interp, String.valueOf(errorMsg) + "not a subclass of tcl.lang.Extension");
            }
            catch (Exception e) {
                throw new TclException(interp, String.valueOf(errorMsg) + "can't find class \"" + e.getMessage() + "\"");
            }
            var11_12 = null;
            if (!validLoad) {
                tclClassLoader.removeCache(packageName);
            }
        }
        catch (Throwable throwable) {
            var11_12 = null;
            if (!validLoad) {
                tclClassLoader.removeCache(packageName);
            }
            throw throwable;
        }
    }

    JavaLoadCmd() {
    }
}

