/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Extension;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclString;

class BlendExtension
extends Extension {
    public void init(Interp interp) throws TclException {
        Extension.loadOnDemand(interp, "java::bind", "tcl.lang.JavaBindCmd");
        Extension.loadOnDemand(interp, "java::call", "tcl.lang.JavaCallCmd");
        Extension.loadOnDemand(interp, "java::cast", "tcl.lang.JavaCastCmd");
        Extension.loadOnDemand(interp, "java::defineclass", "tcl.lang.JavaDefineClassCmd");
        Extension.loadOnDemand(interp, "java::event", "tcl.lang.JavaEventCmd");
        Extension.loadOnDemand(interp, "java::field", "tcl.lang.JavaFieldCmd");
        Extension.loadOnDemand(interp, "java::getinterp", "tcl.lang.JavaGetInterpCmd");
        Extension.loadOnDemand(interp, "java::info", "tcl.lang.JavaInfoCmd");
        Extension.loadOnDemand(interp, "java::instanceof", "tcl.lang.JavaInstanceofCmd");
        Extension.loadOnDemand(interp, "java::isnull", "tcl.lang.JavaIsNullCmd");
        Extension.loadOnDemand(interp, "java::load", "tcl.lang.JavaLoadCmd");
        Extension.loadOnDemand(interp, "java::new", "tcl.lang.JavaNewCmd");
        Extension.loadOnDemand(interp, "java::null", "tcl.lang.JavaNullCmd");
        Extension.loadOnDemand(interp, "java::prop", "tcl.lang.JavaPropCmd");
        Extension.loadOnDemand(interp, "java::throw", "tcl.lang.JavaThrowCmd");
        String version = "1.1";
        String patchLevel = String.valueOf(version) + ".1";
        interp.evalResource("/tcl/lang/library/java/javalock.tcl");
        interp.setVar("java::jdkVersion", TclString.newInstance(System.getProperty("java.version")), 1);
        interp.setVar("java::patchLevel", TclString.newInstance(patchLevel), 1);
        interp.eval("namespace eval ::java namespace export bind call defineclass event field getinterp instanceof lock new null prop throw unlock");
        interp.eval("package provide java " + patchLevel);
    }

    BlendExtension() {
    }
}

